/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.steam;

import net.puppygames.steam.ISteamAPI;
import net.puppygames.steam.ISteamApps;
import net.puppygames.steam.ISteamFriends;
import net.puppygames.steam.ISteamMatchmaking;
import net.puppygames.steam.ISteamMatchmakingServers;
import net.puppygames.steam.ISteamNetworking;
import net.puppygames.steam.ISteamRemoteStorage;
import net.puppygames.steam.ISteamUser;
import net.puppygames.steam.ISteamUserStats;
import net.puppygames.steam.ISteamUtils;
import net.puppygames.steam.SteamApps;
import net.puppygames.steam.SteamException;
import net.puppygames.steam.SteamFriends;
import net.puppygames.steam.SteamMatchmaking;
import net.puppygames.steam.SteamMatchmakingServers;
import net.puppygames.steam.SteamNetworking;
import net.puppygames.steam.SteamRemoteStorage;
import net.puppygames.steam.SteamUser;
import net.puppygames.steam.SteamUserStats;
import net.puppygames.steam.SteamUtils;

class SteamAPI
implements ISteamAPI {
    private static final boolean DEBUG = Boolean.getBoolean("net.puppygames.steam.Steam.DEBUG");
    private static final String LIBRARY_NAME = "steampuppy";
    private boolean created;
    private boolean inited;
    private int appID;
    private SteamUser user;
    private SteamFriends friends;
    private SteamUtils utils;
    private SteamMatchmaking matchmaking;
    private SteamUserStats userStats;
    private SteamApps apps;
    private SteamNetworking networking;
    private SteamMatchmakingServers matchmakingServers;
    private SteamRemoteStorage remoteStorage;

    static void log(String msg) {
        if (DEBUG) {
            System.out.println(msg);
        }
    }

    public void create() {
        if (this.created) {
            SteamAPI.log("Steampuppy already created");
            return;
        }
        SteamAPI.log("Loading Steampuppy natives");
        try {
            System.loadLibrary("steam_api");
            System.loadLibrary(LIBRARY_NAME);
        }
        catch (UnsatisfiedLinkError e) {
            try {
                System.loadLibrary("steam_api64");
                System.loadLibrary("steampuppy64");
            }
            catch (UnsatisfiedLinkError e2) {
                throw new SteamException("Can't load native libraries");
            }
        }
        SteamAPI.log("Loaded Steampuppy natives");
        this.created = true;
    }

    public void init(int appID) {
        if (!this.created) {
            this.create();
        }
        if (this.inited) {
            SteamAPI.log("Steampuppy already inited");
            return;
        }
        this.checkInited();
        this.appID = appID;
        if (!this.isSteamRunning()) {
            throw new SteamException("Steam is not running!");
        }
        if (!SteamAPI.SteamAPI_Init()) {
            throw new SteamException("Native init failed");
        }
        long ptr = SteamAPI.SteamUser();
        this.user = ptr == 0L ? null : new SteamUser(ptr);
        ptr = SteamAPI.SteamUserStats();
        this.userStats = ptr == 0L ? null : new SteamUserStats(ptr);
        ptr = SteamAPI.SteamFriends();
        this.friends = ptr == 0L ? null : new SteamFriends(ptr);
        ptr = SteamAPI.SteamApps();
        this.apps = ptr == 0L ? null : new SteamApps(ptr);
        ptr = SteamAPI.SteamUtils();
        this.utils = ptr == 0L ? null : new SteamUtils(ptr);
        ptr = SteamAPI.SteamRemoteStorage();
        this.remoteStorage = ptr == 0L ? null : new SteamRemoteStorage(ptr);
        this.inited = true;
    }

    public int getAppID() {
        return this.appID;
    }

    public void shutdown() {
        if (!this.created) {
            SteamAPI.log("Steampuppy not inited");
            return;
        }
        if (!this.inited) {
            SteamAPI.log("Steampuppy not connected");
            return;
        }
        if (this.friends != null) {
            this.friends.cleanup();
            this.friends = null;
        }
        if (this.utils != null) {
            this.utils.cleanup();
            this.utils = null;
        }
        if (this.matchmaking != null) {
            this.matchmaking.cleanup();
            this.matchmaking = null;
        }
        if (this.userStats != null) {
            this.userStats.cleanup();
            this.userStats = null;
        }
        if (this.apps != null) {
            this.apps.cleanup();
            this.apps = null;
        }
        if (this.networking != null) {
            this.networking.cleanup();
            this.networking = null;
        }
        if (this.matchmakingServers != null) {
            this.matchmakingServers.cleanup();
            this.matchmakingServers = null;
        }
        if (this.remoteStorage != null) {
            this.remoteStorage.cleanup();
            this.remoteStorage = null;
        }
        if (this.user != null) {
            this.user.cleanup();
            this.user = null;
        }
        this.inited = false;
        SteamAPI.log("Shutting down Steam API");
        SteamAPI.SteamAPI_Shutdown();
        SteamAPI.log("Shut down Steam API");
    }

    public static void destroy() {
    }

    public void tick() {
        this.checkInited();
        SteamAPI.SteamAPI_RunCallbacks();
    }

    private void checkInited() {
        if (!this.created) {
            throw new RuntimeException("Steam is not initialised");
        }
    }

    private void checkConnected() {
        if (!this.inited) {
            throw new RuntimeException("Steam is not connected");
        }
    }

    public boolean isSteamRunning() {
        this.checkInited();
        return SteamAPI.SteamAPI_IsSteamRunning();
    }

    public ISteamUser getUser() {
        this.checkConnected();
        return this.user;
    }

    public ISteamFriends getFriends() {
        this.checkConnected();
        return this.friends;
    }

    public ISteamUtils getUtils() {
        this.checkConnected();
        return this.utils;
    }

    public ISteamMatchmaking getMatchmaking() {
        this.checkConnected();
        return this.matchmaking;
    }

    public ISteamUserStats getUserStats() {
        this.checkConnected();
        return this.userStats;
    }

    public ISteamApps getApps() {
        this.checkConnected();
        return this.apps;
    }

    public ISteamNetworking getNetworking() {
        this.checkConnected();
        return this.networking;
    }

    public ISteamMatchmakingServers getMatchmakingServers() {
        this.checkConnected();
        return this.matchmakingServers;
    }

    public ISteamRemoteStorage getRemoteStorage() {
        this.checkConnected();
        return this.remoteStorage;
    }

    private static native void SteamAPI_RunCallbacks();

    private static native boolean SteamAPI_Init();

    private static native void SteamAPI_Shutdown();

    private static native boolean SteamAPI_IsSteamRunning();

    private static native long SteamClient();

    private static native long SteamUser();

    private static native long SteamFriends();

    private static native long SteamUtils();

    private static native long SteamMatchmaking();

    private static native long SteamUserStats();

    private static native long SteamApps();

    private static native long SteamNetworking();

    private static native long SteamMatchmakingServers();

    private static native long SteamRemoteStorage();
}

