/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.steam;

import net.puppygames.steam.AppID;
import net.puppygames.steam.ISteamApps;
import net.puppygames.steam.NativeAppsListener;
import net.puppygames.steam.SteamException;
import net.puppygames.steam.SteamObject;
import net.puppygames.steam.Utils;
import net.puppygames.steam.apps.AppsListener;
import net.puppygames.steam.apps.DLCData;
import net.puppygames.steam.apps.RegisterActivationCodeResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SteamApps
extends SteamObject<AppsListener>
implements ISteamApps {
    SteamApps(long ptr) {
        super(ptr);
    }

    @Override
    protected Object createCallbackAdapter() {
        return new NativeAppsListener(){

            public void ioError(String handler) {
                for (AppsListener listener : SteamApps.this.getListeners()) {
                    listener.ioError(handler);
                }
            }

            public void onRegisterActivationCodeResponse(int result, int packageRegistered) {
                RegisterActivationCodeResult result_ = (RegisterActivationCodeResult)Utils.find((int)result, (Enum[])RegisterActivationCodeResult.values());
                for (AppsListener listener : SteamApps.this.getListeners()) {
                    listener.onRegisterActivationCodeResponse(result_, packageRegistered);
                }
            }

            public void onDLCInstalled(int appID) {
                AppID appID_ = new AppID(appID);
                for (AppsListener listener : SteamApps.this.getListeners()) {
                    listener.onDLCInstalled(appID_);
                }
            }
        };
    }

    @Override
    protected native long createNativeCallbackAdapter(Object var1);

    @Override
    protected native void removeNativeCallbackAdapter(long var1);

    public boolean isSubscribed() {
        this.checkConnected();
        return this.BIsSubscribed();
    }

    public boolean isLowViolence() {
        this.checkConnected();
        return this.BIsLowViolence();
    }

    public boolean isCybercafe() {
        this.checkConnected();
        return this.BIsCybercafe();
    }

    public boolean isVACBanned() {
        this.checkConnected();
        return this.BIsVACBanned();
    }

    public String getCurrentGameLanguage() {
        this.checkConnected();
        return this.GetCurrentGameLanguage();
    }

    public String getAvailableGameLanguages() {
        this.checkConnected();
        return this.GetAvailableGameLanguages();
    }

    public boolean isSubscribedApp(AppID appID) {
        this.checkConnected();
        return this.BIsSubscribedApp(appID.getAppID());
    }

    public boolean isDLCInstalled(AppID appID) {
        this.checkConnected();
        return this.BIsDlcInstalled(appID.getAppID());
    }

    public int getEarliestPurchaseUnixTime(AppID nAppID) {
        this.checkConnected();
        return this.GetEarliestPurchaseUnixTime(nAppID.getAppID());
    }

    public boolean isSubscribedFromFreeWeekend() {
        this.checkConnected();
        return this.BIsSubscribedFromFreeWeekend();
    }

    public int getDLCCount() {
        this.checkConnected();
        return this.GetDLCCount();
    }

    public DLCData getDLCDataByIndex(int iDLC) {
        this.checkConnected();
        int[] appID = new int[1];
        boolean[] available = new boolean[1];
        String[] name = new String[1];
        if (!this.BGetDLCDataByIndex(iDLC, appID, available, name)) {
            throw new SteamException();
        }
        return new DLCData(new AppID(appID[0]), available[0], name[0]);
    }

    public void installDLC(AppID nAppID) {
        this.checkConnected();
        this.InstallDLC(nAppID.getAppID());
    }

    public void uninstallDLC(AppID nAppID) {
        this.checkConnected();
        this.UninstallDLC(nAppID.getAppID());
    }

    private native boolean BIsSubscribed();

    private native boolean BIsLowViolence();

    private native boolean BIsCybercafe();

    private native boolean BIsVACBanned();

    private native String GetCurrentGameLanguage();

    private native String GetAvailableGameLanguages();

    private native boolean BIsSubscribedApp(int var1);

    private native boolean BIsDlcInstalled(int var1);

    private native int GetEarliestPurchaseUnixTime(int var1);

    private native boolean BIsSubscribedFromFreeWeekend();

    private native int GetDLCCount();

    private native boolean BGetDLCDataByIndex(int var1, int[] var2, boolean[] var3, String[] var4);

    private native void InstallDLC(int var1);

    private native void UninstallDLC(int var1);
}

