/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.steam;

import java.net.URL;
import java.util.EnumSet;
import net.puppygames.steam.ActivateGameOverlay;
import net.puppygames.steam.ActivateGameOverlayToUser;
import net.puppygames.steam.AppID;
import net.puppygames.steam.ChatEntryType;
import net.puppygames.steam.ChatRoomEnterResponse;
import net.puppygames.steam.ClanActivityCounts;
import net.puppygames.steam.ClanChatMessage;
import net.puppygames.steam.FriendMessage;
import net.puppygames.steam.ISteamFriends;
import net.puppygames.steam.NativeFriendsListener;
import net.puppygames.steam.Result;
import net.puppygames.steam.SteamException;
import net.puppygames.steam.SteamID;
import net.puppygames.steam.SteamObject;
import net.puppygames.steam.Utils;
import net.puppygames.steam.friends.FriendFlags;
import net.puppygames.steam.friends.FriendGameInfo;
import net.puppygames.steam.friends.FriendRelationship;
import net.puppygames.steam.friends.FriendsListener;
import net.puppygames.steam.friends.PersonaChange;
import net.puppygames.steam.friends.PersonaState;
import net.puppygames.steam.friends.UserRestriction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SteamFriends
extends SteamObject<FriendsListener>
implements ISteamFriends {
    SteamFriends(long ptr) {
        super(ptr);
    }

    @Override
    protected Object createCallbackAdapter() {
        return new NativeFriendsListener(){

            public void ioError(String handler) {
                for (FriendsListener listener : SteamFriends.this.getListeners()) {
                    listener.ioError(handler);
                }
            }

            public void onPersonaStateChange(long steamID, int changeFlags) {
                SteamID steamID_ = new SteamID(steamID);
                EnumSet changeFlags_ = Utils.fromFlags((int)changeFlags, PersonaChange.class, (Enum[])PersonaChange.values());
                for (FriendsListener listener : SteamFriends.this.getListeners()) {
                    listener.onPersonaStateChange(steamID_, changeFlags_);
                }
            }

            public void onOverlayActivated(boolean active) {
                for (FriendsListener listener : SteamFriends.this.getListeners()) {
                    listener.onOverlayActivated(active);
                }
            }

            public void onGameServerChangeRequested(String server, String password) {
                for (FriendsListener listener : SteamFriends.this.getListeners()) {
                    listener.onGameServerChangeRequested(server, password);
                }
            }

            public void onGameLobbyJoinRequested(long steamIDlobby, long steamIDfriend) {
                SteamID lobby = new SteamID(steamIDlobby);
                SteamID friend = new SteamID(steamIDfriend);
                for (FriendsListener listener : SteamFriends.this.getListeners()) {
                    listener.onGameLobbyJoinRequested(lobby, friend);
                }
            }

            public void onAvatarImageLoaded(long steamID, int image, int width, int height) {
                SteamID steamID_ = new SteamID(steamID);
                for (FriendsListener listener : SteamFriends.this.getListeners()) {
                    listener.onAvatarImageLoaded(steamID_, image, width, height);
                }
            }

            public void onClanOfficerListResponse(long steamIDClan, int officers, boolean success) {
                SteamID clan = new SteamID(steamIDClan);
                for (FriendsListener listener : SteamFriends.this.getListeners()) {
                    listener.onClanOfficerListResponse(clan, officers, success);
                }
            }

            public void onFriendRichPresenceUpdate(long steamIDFriend, int appID) {
                SteamID friend = new SteamID(steamIDFriend);
                AppID appID_ = new AppID(appID);
                for (FriendsListener listener : SteamFriends.this.getListeners()) {
                    listener.onFriendRichPresenceUpdate(friend, appID_);
                }
            }

            public void onGameRichPresenceJoinRequested(long steamIDFriend, String connectKey) {
                SteamID friend = new SteamID(steamIDFriend);
                for (FriendsListener listener : SteamFriends.this.getListeners()) {
                    listener.onGameRichPresenceJoinRequested(friend, connectKey);
                }
            }

            public void onGameConnectedClanChatMsg(long clanChat, long user, int messageID) {
                SteamID clanChat_ = new SteamID(clanChat);
                SteamID user_ = new SteamID(user);
                for (FriendsListener listener : SteamFriends.this.getListeners()) {
                    listener.onGameConnectedClanChatMsg(clanChat_, user_, messageID);
                }
            }

            public void onGameConnectedChatJoin(long clanChat, long user) {
                SteamID clanChat_ = new SteamID(clanChat);
                SteamID user_ = new SteamID(user);
                for (FriendsListener listener : SteamFriends.this.getListeners()) {
                    listener.onGameConnectedChatJoin(clanChat_, user_);
                }
            }

            public void onGameConnectedChatLeave(long clanChat, long user, boolean kicked, boolean dropped) {
                SteamID clanChat_ = new SteamID(clanChat);
                SteamID user_ = new SteamID(user);
                for (FriendsListener listener : SteamFriends.this.getListeners()) {
                    listener.onGameConnectedChatLeave(clanChat_, user_, kicked, dropped);
                }
            }

            public void onDownloadClanActivityCountsResult(boolean success) {
                for (FriendsListener listener : SteamFriends.this.getListeners()) {
                    listener.onDownloadClanActivityCountsResult(success);
                }
            }

            public void onJoinClanChatRoomCompletionResult(long clanChat, int response) {
                SteamID clanChat_ = new SteamID(clanChat);
                ChatRoomEnterResponse response_ = (ChatRoomEnterResponse)Utils.find((int)response, (Enum[])ChatRoomEnterResponse.values());
                for (FriendsListener listener : SteamFriends.this.getListeners()) {
                    listener.onJoinClanChatRoomCompletionResult(clanChat_, response_);
                }
            }

            public void onGameConnectedFriendChatMsg(long user, int messageID) {
                SteamID user_ = new SteamID(user);
                for (FriendsListener listener : SteamFriends.this.getListeners()) {
                    listener.onGameConnectedFriendChatMsg(user_, messageID);
                }
            }

            public void onFriendsGetFollowerCount(int result, long steamID, int count) {
                Result result_ = (Result)Utils.find((int)result, (Enum[])Result.values());
                SteamID steamID_ = new SteamID(steamID);
                for (FriendsListener listener : SteamFriends.this.getListeners()) {
                    listener.onFriendsGetFollowerCount(result_, steamID_, count);
                }
            }

            public void onFriendsIsFollowing(int result, long steamID, boolean isFollowing) {
                Result result_ = (Result)Utils.find((int)result, (Enum[])Result.values());
                SteamID steamID_ = new SteamID(steamID);
                for (FriendsListener listener : SteamFriends.this.getListeners()) {
                    listener.onFriendsIsFollowing(result_, steamID_, isFollowing);
                }
            }

            public void onFriendsEnumerateFollowingList(int result, long[] steamIDs, int totalResultCount) {
                Result result_ = (Result)Utils.find((int)result, (Enum[])Result.values());
                SteamID[] steamIDs_ = new SteamID[steamIDs.length];
                int i = 0;
                while (i < steamIDs.length) {
                    steamIDs_[i] = new SteamID(steamIDs[i]);
                    ++i;
                }
                for (FriendsListener listener : SteamFriends.this.getListeners()) {
                    listener.onFriendsEnumerateFollowingList(result_, steamIDs_, totalResultCount);
                }
            }
        };
    }

    @Override
    protected native long createNativeCallbackAdapter(Object var1);

    @Override
    protected native void removeNativeCallbackAdapter(long var1);

    public String getPersonaName() {
        this.checkConnected();
        return this.GetPersonaName();
    }

    public void setPersonaName(String pchPersonaName) {
        this.checkConnected();
        this.SetPersonaName(pchPersonaName);
    }

    public PersonaState getPersonaState() {
        this.checkConnected();
        return (PersonaState)Utils.find((int)this.GetPersonaState(), (Enum[])PersonaState.values());
    }

    public int getFriendCount(EnumSet<FriendFlags> friendFlags) {
        this.checkConnected();
        int iFriendFlags = 0;
        for (FriendFlags ff : friendFlags) {
            iFriendFlags |= ff.getValue();
        }
        return this.GetFriendCount(iFriendFlags);
    }

    public SteamID getFriendByIndex(int iFriend, EnumSet<FriendFlags> friendFlags) {
        this.checkConnected();
        return new SteamID(this.GetFriendByIndex(iFriend, Utils.toIntFlags(friendFlags)));
    }

    public FriendRelationship getFriendRelationship(SteamID steamIDFriend) {
        this.checkConnected();
        return (FriendRelationship)Utils.find((int)this.GetFriendRelationship(steamIDFriend.getSteamID()), (Enum[])FriendRelationship.values());
    }

    public PersonaState getFriendPersonaState(SteamID steamIDFriend) {
        this.checkConnected();
        return (PersonaState)Utils.find((int)this.GetFriendPersonaState(steamIDFriend.getSteamID()), (Enum[])PersonaState.values());
    }

    public String getFriendPersonaName(SteamID steamIDFriend) {
        this.checkConnected();
        return this.GetFriendPersonaName(steamIDFriend.getSteamID());
    }

    public FriendGameInfo getFriendGamePlayed(SteamID steamIDFriend) {
        this.checkConnected();
        FriendGameInfo[] ret = new FriendGameInfo[1];
        this.GetFriendGamePlayed(steamIDFriend.getSteamID(), ret);
        return ret[0];
    }

    public String getFriendPersonaNameHistory(SteamID steamIDFriend, int iPersonaName) {
        this.checkConnected();
        return this.GetFriendPersonaNameHistory(steamIDFriend.getSteamID(), iPersonaName);
    }

    public boolean hasFriend(SteamID steamIDFriend, EnumSet<FriendFlags> friendFlags) {
        this.checkConnected();
        return this.HasFriend(steamIDFriend.getSteamID(), Utils.toIntFlags(friendFlags));
    }

    public int getClanCount() {
        this.checkConnected();
        return this.GetClanCount();
    }

    public SteamID getClanByIndex(int iClan) {
        this.checkConnected();
        return new SteamID(this.GetClanByIndex(iClan));
    }

    public String getClanName(SteamID steamIDClan) {
        this.checkConnected();
        return this.GetClanName(steamIDClan.getSteamID());
    }

    public String getClanTag(SteamID steamIDClan) {
        this.checkConnected();
        return this.GetClanTag(steamIDClan.getSteamID());
    }

    public ClanActivityCounts getClanActivityCounts(SteamID steamIDClan) {
        this.checkConnected();
        int[] online = new int[1];
        int[] ingame = new int[1];
        int[] chatting = new int[1];
        if (this.GetClanActivityCounts(steamIDClan.getSteamID(), online, ingame, chatting)) {
            return new ClanActivityCounts(online[0], ingame[0], chatting[0]);
        }
        return null;
    }

    public void downloadClanActivityCounts(SteamID[] psteamIDClans) {
        this.checkConnected();
        long[] clans = new long[psteamIDClans.length];
        int i = 0;
        while (i < psteamIDClans.length) {
            clans[i] = psteamIDClans[i].getSteamID();
            ++i;
        }
        this.DownloadClanActivityCounts(clans);
    }

    public int getFriendCountFromSource(SteamID steamIDSource) {
        this.checkConnected();
        return this.GetFriendCountFromSource(steamIDSource.getSteamID());
    }

    public SteamID getFriendFromSourceByIndex(SteamID steamIDSource, int iFriend) {
        this.checkConnected();
        return new SteamID(this.GetFriendFromSourceByIndex(steamIDSource.getSteamID(), iFriend));
    }

    public boolean isUserInSource(SteamID steamIDUser, SteamID steamIDSource) {
        this.checkConnected();
        return this.IsUserInSource(steamIDUser.getSteamID(), steamIDSource.getSteamID());
    }

    public void setInGameVoiceSpeaking(SteamID steamIDUser, boolean bSpeaking) {
        this.checkConnected();
        this.SetInGameVoiceSpeaking(steamIDUser.getSteamID(), bSpeaking);
    }

    public void activateGameOverlay(ActivateGameOverlay pchDialog) {
        this.checkConnected();
        this.ActivateGameOverlay(pchDialog.getValue());
    }

    public void activateGameOverlayToUser(ActivateGameOverlayToUser pchDialog, SteamID steamID) {
        this.checkConnected();
        this.ActivateGameOverlayToUser(pchDialog.getValue(), steamID.getSteamID());
    }

    public void activateGameOverlayToWebPage(URL pchURL) {
        this.checkConnected();
        this.ActivateGameOverlayToWebPage(pchURL.toString());
    }

    public void activateGameOverlayToStore(AppID nAppID) {
        this.checkConnected();
        this.ActivateGameOverlayToStore(nAppID.getAppID());
    }

    public void setPlayedWith(SteamID steamIDUserPlayedWith) {
        this.checkConnected();
        this.SetPlayedWith(steamIDUserPlayedWith.getSteamID());
    }

    public void activateGameOverlayInviteDialog(SteamID steamIDLobby) {
        this.checkConnected();
        this.ActivateGameOverlayInviteDialog(steamIDLobby.getSteamID());
    }

    public int getSmallFriendAvatar(SteamID steamIDFriend) {
        this.checkConnected();
        return this.GetSmallFriendAvatar(steamIDFriend.getSteamID());
    }

    public int getMediumFriendAvatar(SteamID steamIDFriend) {
        this.checkConnected();
        return this.GetMediumFriendAvatar(steamIDFriend.getSteamID());
    }

    public int getLargeFriendAvatar(SteamID steamIDFriend) {
        this.checkConnected();
        return this.GetLargeFriendAvatar(steamIDFriend.getSteamID());
    }

    public boolean requestUserInformation(SteamID steamIDUser, boolean bRequireNameOnly) {
        this.checkConnected();
        return this.RequestUserInformation(steamIDUser.getSteamID(), bRequireNameOnly);
    }

    public void requestClanOfficerList(SteamID steamIDClan) {
        this.checkConnected();
        this.RequestClanOfficerList(steamIDClan.getSteamID());
    }

    public SteamID getClanOwner(SteamID steamIDClan) {
        this.checkConnected();
        return new SteamID(this.GetClanOwner(steamIDClan.getSteamID()));
    }

    public int getClanOfficerCount(SteamID steamIDClan) {
        this.checkConnected();
        return this.GetClanOfficerCount(steamIDClan.getSteamID());
    }

    public SteamID getClanOfficerByIndex(SteamID steamIDClan, int iOfficer) {
        this.checkConnected();
        return new SteamID(this.GetClanOfficerByIndex(steamIDClan.getSteamID(), iOfficer));
    }

    public EnumSet<UserRestriction> getUserRestrictions() {
        this.checkConnected();
        return Utils.fromFlags((int)this.GetUserRestrictions(), UserRestriction.class, (Enum[])UserRestriction.values());
    }

    public boolean setRichPresence(String pchKey, String pchValue) {
        this.checkConnected();
        return this.SetRichPresence(pchKey, pchValue);
    }

    public void clearRichPresence() {
        this.checkConnected();
        this.ClearRichPresence();
    }

    public String getFriendRichPresence(SteamID steamIDFriend, String pchKey) {
        this.checkConnected();
        return this.GetFriendRichPresence(steamIDFriend.getSteamID(), pchKey);
    }

    public int getFriendRichPresenceKeyCount(SteamID steamIDFriend) {
        this.checkConnected();
        return this.GetFriendRichPresenceKeyCount(steamIDFriend.getSteamID());
    }

    public String getFriendRichPresenceKeyByIndex(SteamID steamIDFriend, int iKey) {
        this.checkConnected();
        return this.GetFriendRichPresenceKeyByIndex(steamIDFriend.getSteamID(), iKey);
    }

    public void requestFriendRichPresence(SteamID steamIDFriend) {
        this.checkConnected();
        this.RequestFriendRichPresence(steamIDFriend.getSteamID());
    }

    public boolean inviteUserToGame(SteamID steamIDFriend, String pchConnectString) {
        this.checkConnected();
        return this.InviteUserToGame(steamIDFriend.getSteamID(), pchConnectString);
    }

    public int getCoplayFriendCount() {
        this.checkConnected();
        return this.GetCoplayFriendCount();
    }

    public SteamID getCoplayFriend(int iCoplayFriend) {
        this.checkConnected();
        return new SteamID(this.GetCoplayFriend(iCoplayFriend));
    }

    public int getFriendCoplayTime(SteamID steamIDFriend) {
        this.checkConnected();
        return this.GetFriendCoplayTime(steamIDFriend.getSteamID());
    }

    public AppID getFriendCoplayGame(SteamID steamIDFriend) {
        this.checkConnected();
        return new AppID(this.GetFriendCoplayGame(steamIDFriend.getSteamID()));
    }

    public void joinClanChatRoom(SteamID steamIDClan) {
        this.checkConnected();
        this.JoinClanChatRoom(steamIDClan.getSteamID());
    }

    public boolean leaveClanChatRoom(SteamID steamIDClan) {
        this.checkConnected();
        return this.LeaveClanChatRoom(steamIDClan.getSteamID());
    }

    public int getClanChatMemberCount(SteamID steamIDClan) {
        this.checkConnected();
        return this.GetClanChatMemberCount(steamIDClan.getSteamID());
    }

    public SteamID getChatMemberByIndex(SteamID steamIDClan, int iUser) {
        this.checkConnected();
        return new SteamID(this.GetChatMemberByIndex(steamIDClan.getSteamID(), iUser));
    }

    public boolean sendClanChatMessage(SteamID steamIDClanChat, String pchText) {
        this.checkConnected();
        return this.SendClanChatMessage(steamIDClanChat.getSteamID(), pchText);
    }

    public ClanChatMessage getClanChatMessage(SteamID steamIDClanChat, int iMessage) {
        this.checkConnected();
        String[] prgchText = new String[1];
        int[] chatEntryType = new int[1];
        long[] steamID = new long[1];
        int ret = this.GetClanChatMessage(steamIDClanChat.getSteamID(), iMessage, prgchText, chatEntryType, steamID);
        if (ret > 0) {
            return new ClanChatMessage(prgchText[0], (ChatEntryType)Utils.find((int)chatEntryType[0], (Enum[])ChatEntryType.values()), new SteamID(steamID[0]));
        }
        throw new SteamException("Got " + ret + " from GetClanChatMessage");
    }

    public boolean isClanChatAdmin(SteamID steamIDClanChat, SteamID steamIDUser) {
        this.checkConnected();
        return this.IsClanChatAdmin(steamIDClanChat.getSteamID(), steamIDUser.getSteamID());
    }

    public boolean isClanChatWindowOpenInSteam(SteamID steamIDClanChat) {
        this.checkConnected();
        return this.IsClanChatWindowOpenInSteam(steamIDClanChat.getSteamID());
    }

    public boolean openClanChatWindowInSteam(SteamID steamIDClanChat) {
        this.checkConnected();
        return this.OpenClanChatWindowInSteam(steamIDClanChat.getSteamID());
    }

    public boolean closeClanChatWindowInSteam(SteamID steamIDClanChat) {
        this.checkConnected();
        return this.CloseClanChatWindowInSteam(steamIDClanChat.getSteamID());
    }

    public boolean setListenForFriendsMessages(boolean bInterceptEnabled) {
        this.checkConnected();
        return this.SetListenForFriendsMessages(bInterceptEnabled);
    }

    public boolean replyToFriendMessage(SteamID steamIDFriend, String pchMsgToSend) {
        this.checkConnected();
        return this.ReplyToFriendMessage(steamIDFriend.getSteamID(), pchMsgToSend);
    }

    public FriendMessage getFriendMessage(SteamID steamIDFriend, int iMessageID) {
        this.checkConnected();
        String[] pvData = new String[1];
        int[] chatEntryType = new int[1];
        int ret = this.GetFriendMessage(steamIDFriend.getSteamID(), iMessageID, pvData, chatEntryType);
        if (ret > 0) {
            return new FriendMessage(pvData[0], (ChatEntryType)Utils.find((int)chatEntryType[0], (Enum[])ChatEntryType.values()));
        }
        throw new SteamException("Got " + ret + " from GetFriendMessage");
    }

    public void getFollowerCount(SteamID steamID) {
        this.checkConnected();
        this.GetFollowerCount(steamID.getSteamID());
    }

    public void isFollowing(SteamID steamID) {
        this.checkConnected();
        this.IsFollowing(steamID.getSteamID());
    }

    public void enumerateFollowingList(int unStartIndex) {
        this.checkConnected();
        this.EnumerateFollowingList(unStartIndex);
    }

    private native String GetPersonaName();

    private native void SetPersonaName(String var1);

    private native int GetPersonaState();

    private native int GetFriendCount(int var1);

    private native long GetFriendByIndex(int var1, int var2);

    private native int GetFriendRelationship(long var1);

    private native int GetFriendPersonaState(long var1);

    private native String GetFriendPersonaName(long var1);

    private native boolean GetFriendGamePlayed(long var1, FriendGameInfo[] var3);

    private native String GetFriendPersonaNameHistory(long var1, int var3);

    private native boolean HasFriend(long var1, int var3);

    private native int GetClanCount();

    private native long GetClanByIndex(int var1);

    private native String GetClanName(long var1);

    private native String GetClanTag(long var1);

    private native boolean GetClanActivityCounts(long var1, int[] var3, int[] var4, int[] var5);

    private native void DownloadClanActivityCounts(long[] var1);

    private native int GetFriendCountFromSource(long var1);

    private native long GetFriendFromSourceByIndex(long var1, int var3);

    private native boolean IsUserInSource(long var1, long var3);

    private native void SetInGameVoiceSpeaking(long var1, boolean var3);

    private native void ActivateGameOverlay(String var1);

    private native void ActivateGameOverlayToUser(String var1, long var2);

    private native void ActivateGameOverlayToWebPage(String var1);

    private native void ActivateGameOverlayToStore(int var1);

    private native void SetPlayedWith(long var1);

    private native void ActivateGameOverlayInviteDialog(long var1);

    private native int GetSmallFriendAvatar(long var1);

    private native int GetMediumFriendAvatar(long var1);

    private native int GetLargeFriendAvatar(long var1);

    private native boolean RequestUserInformation(long var1, boolean var3);

    private native void RequestClanOfficerList(long var1);

    private native long GetClanOwner(long var1);

    private native int GetClanOfficerCount(long var1);

    private native long GetClanOfficerByIndex(long var1, int var3);

    private native int GetUserRestrictions();

    private native boolean SetRichPresence(String var1, String var2);

    private native void ClearRichPresence();

    private native String GetFriendRichPresence(long var1, String var3);

    private native int GetFriendRichPresenceKeyCount(long var1);

    private native String GetFriendRichPresenceKeyByIndex(long var1, int var3);

    private native void RequestFriendRichPresence(long var1);

    private native boolean InviteUserToGame(long var1, String var3);

    private native int GetCoplayFriendCount();

    private native long GetCoplayFriend(int var1);

    private native int GetFriendCoplayTime(long var1);

    private native int GetFriendCoplayGame(long var1);

    private native void JoinClanChatRoom(long var1);

    private native boolean LeaveClanChatRoom(long var1);

    private native int GetClanChatMemberCount(long var1);

    private native long GetChatMemberByIndex(long var1, int var3);

    private native boolean SendClanChatMessage(long var1, String var3);

    private native int GetClanChatMessage(long var1, int var3, String[] var4, int[] var5, long[] var6);

    private native boolean IsClanChatAdmin(long var1, long var3);

    private native boolean IsClanChatWindowOpenInSteam(long var1);

    private native boolean OpenClanChatWindowInSteam(long var1);

    private native boolean CloseClanChatWindowInSteam(long var1);

    private native boolean SetListenForFriendsMessages(boolean var1);

    private native boolean ReplyToFriendMessage(long var1, String var3);

    private native int GetFriendMessage(long var1, int var3, String[] var4, int[] var5);

    private native void GetFollowerCount(long var1);

    private native void IsFollowing(long var1);

    private native void EnumerateFollowingList(int var1);
}

