/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.steam;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.puppygames.steam.ISteamObject;
import net.puppygames.steam.Steam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SteamObject<T>
implements ISteamObject<T> {
    private long ptr;
    private boolean connected = true;
    private long nativeAdapter;
    private Object javaAdapter;
    private List<T> listeners;

    SteamObject(long ptr) {
        this.ptr = ptr;
        Steam.log((String)("Created " + this));
    }

    private long getNativeAdapter() {
        return this.nativeAdapter;
    }

    final void cleanup() {
        if (!this.connected) {
            return;
        }
        this.ptr = 0L;
        this.connected = false;
        this.clearListeners();
        Steam.log((String)("Disconnected " + this));
    }

    protected final void checkConnected() {
        if (!this.connected) {
            throw new IllegalStateException();
        }
    }

    public final long getPointer() {
        return this.ptr;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[0x" + Long.toHexString(this.ptr) + "]";
    }

    public final int hashCode() {
        return (int)this.ptr;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SteamObject other = (SteamObject)obj;
        return this.ptr == other.ptr;
    }

    public final void addListener(T listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList<T>();
            this.javaAdapter = this.createCallbackAdapter();
            this.nativeAdapter = this.createNativeCallbackAdapter(this.javaAdapter);
        } else {
            this.listeners.remove(listener);
        }
        this.listeners.add(listener);
    }

    public final void removeListener(T listener) {
        if (listener == null || this.listeners == null) {
            return;
        }
        if (this.listeners.remove(listener) && this.listeners.size() == 0) {
            this.listeners = null;
            this.removeNativeCallbackAdapter(this.nativeAdapter);
            this.javaAdapter = null;
            this.nativeAdapter = 0L;
        }
    }

    public final void clearListeners() {
        this.listeners = null;
        this.removeNativeCallbackAdapter(this.nativeAdapter);
        this.javaAdapter = null;
        this.nativeAdapter = 0L;
    }

    final List<T> getListeners() {
        return this.listeners;
    }

    protected abstract Object createCallbackAdapter();

    protected abstract long createNativeCallbackAdapter(Object var1);

    protected abstract void removeNativeCallbackAdapter(long var1);
}

