/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.steam;

import java.nio.ByteBuffer;
import net.puppygames.steam.AppID;
import net.puppygames.steam.ISteamRemoteStorage;
import net.puppygames.steam.NativeRemoteStorageListener;
import net.puppygames.steam.Result;
import net.puppygames.steam.SteamException;
import net.puppygames.steam.SteamID;
import net.puppygames.steam.SteamObject;
import net.puppygames.steam.UGCHandle;
import net.puppygames.steam.Utils;
import net.puppygames.steam.remotestorage.FileNameAndSize;
import net.puppygames.steam.remotestorage.Quota;
import net.puppygames.steam.remotestorage.RemoteStorageListener;
import net.puppygames.steam.remotestorage.RemoteStoragePlatform;
import net.puppygames.steam.remotestorage.UGCDetails;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SteamRemoteStorage
extends SteamObject<RemoteStorageListener>
implements ISteamRemoteStorage {
    SteamRemoteStorage(long ptr) {
        super(ptr);
    }

    @Override
    protected Object createCallbackAdapter() {
        return new NativeRemoteStorageListener(){

            public void ioError(String handler) {
                for (RemoteStorageListener listener : SteamRemoteStorage.this.getListeners()) {
                    listener.ioError(handler);
                }
            }

            public void onRemoteStorageFileShareResult(int result, long file) {
                Result result_ = (Result)Utils.find((int)result, (Enum[])Result.values());
                UGCHandle file_ = new UGCHandle(file);
                for (RemoteStorageListener listener : SteamRemoteStorage.this.getListeners()) {
                    listener.onRemoteStorageFileShareResult(result_, file_);
                }
            }

            public void onRemoteStorageDownloadUGCResult(int result, long file, int appID, int sizeInBytes, String fileName, long steamIDOwner) {
                Result result_ = (Result)Utils.find((int)result, (Enum[])Result.values());
                AppID appID_ = new AppID(appID);
                UGCHandle file_ = new UGCHandle(file);
                SteamID steamIDOwner_ = new SteamID(steamIDOwner);
                for (RemoteStorageListener listener : SteamRemoteStorage.this.getListeners()) {
                    listener.onRemoteStorageDownloadUGCResult(result_, file_, appID_, sizeInBytes, fileName, steamIDOwner_);
                }
            }

            public void onRemoteStorageConflictResolution(int appID, int result) {
                AppID appID_ = new AppID(appID);
                Result result_ = (Result)Utils.find((int)result, (Enum[])Result.values());
                for (RemoteStorageListener listener : SteamRemoteStorage.this.getListeners()) {
                    listener.onRemoteStorageConflictResolution(appID_, result_);
                }
            }

            public void onRemoteStorageAppSyncedServer(int appID, int result, int numUploads) {
                AppID appID_ = new AppID(appID);
                Result result_ = (Result)Utils.find((int)result, (Enum[])Result.values());
                for (RemoteStorageListener listener : SteamRemoteStorage.this.getListeners()) {
                    listener.onRemoteStorageAppSyncedServer(appID_, result_, numUploads);
                }
            }

            public void onRemoteStorageAppSyncedClient(int appID, int result, int numDownloads) {
                AppID appID_ = new AppID(appID);
                Result result_ = (Result)Utils.find((int)result, (Enum[])Result.values());
                for (RemoteStorageListener listener : SteamRemoteStorage.this.getListeners()) {
                    listener.onRemoteStorageAppSyncedClient(appID_, result_, numDownloads);
                }
            }

            public void onRemoteStorageAppSyncStatusCheck(int appID, int result) {
                AppID appID_ = new AppID(appID);
                Result result_ = (Result)Utils.find((int)result, (Enum[])Result.values());
                for (RemoteStorageListener listener : SteamRemoteStorage.this.getListeners()) {
                    listener.onRemoteStorageAppSyncStatusCheck(appID_, result_);
                }
            }

            public void onRemoteStorageAppSyncProgress(String currentFile, int appID, int bytesTransferredThisChunk, double appPercentComplete, boolean uploading) {
                AppID appID_ = new AppID(appID);
                for (RemoteStorageListener listener : SteamRemoteStorage.this.getListeners()) {
                    listener.onRemoteStorageAppSyncProgress(currentFile, appID_, bytesTransferredThisChunk, appPercentComplete, uploading);
                }
            }
        };
    }

    @Override
    protected native long createNativeCallbackAdapter(Object var1);

    @Override
    protected native void removeNativeCallbackAdapter(long var1);

    public void fileWrite(String pchFile, ByteBuffer pvData) {
        this.checkConnected();
        if (pchFile == null) {
            throw new IllegalArgumentException("pchFile may not be null");
        }
        if (!pvData.isDirect()) {
            throw new IllegalArgumentException("Buffer must be direct");
        }
        if (!this.FileWrite(pchFile, pvData, pvData.position(), pvData.limit())) {
            throw new SteamException();
        }
    }

    public int fileRead(String pchFile, ByteBuffer pvData) {
        this.checkConnected();
        if (pchFile == null) {
            throw new IllegalArgumentException("pchFile may not be null");
        }
        if (!pvData.isDirect()) {
            throw new IllegalArgumentException("Buffer must be direct");
        }
        return this.FileRead(pchFile, pvData, pvData.position(), pvData.limit());
    }

    public void fileShare(String pchFile) {
        this.checkConnected();
        if (pchFile == null) {
            throw new IllegalArgumentException("pchFile may not be null");
        }
        this.FileShare(pchFile);
    }

    public void setSyncPlatforms(String pchFile, RemoteStoragePlatform eRemoteStoragePlatform) {
        this.checkConnected();
        if (pchFile == null) {
            throw new IllegalArgumentException("pchFile may not be null");
        }
        if (!this.SetSyncPlatforms(pchFile, eRemoteStoragePlatform.getValue())) {
            throw new SteamException();
        }
    }

    public RemoteStoragePlatform getSyncPlatforms(String pchFile) {
        this.checkConnected();
        if (pchFile == null) {
            throw new IllegalArgumentException("pchFile may not be null");
        }
        return (RemoteStoragePlatform)Utils.find((int)this.GetSyncPlatforms(pchFile), (Enum[])RemoteStoragePlatform.values());
    }

    public FileNameAndSize getFileNameAndSize(int iFile) {
        this.checkConnected();
        int[] size = new int[1];
        String name = this.GetFileNameAndSize(iFile, size);
        return new FileNameAndSize(name, (long)size[0]);
    }

    public Quota getQuota() {
        this.checkConnected();
        int[] totalBytes = new int[1];
        int[] availableBytes = new int[1];
        if (!this.GetQuota(totalBytes, availableBytes)) {
            throw new SteamException();
        }
        return new Quota(totalBytes[0], availableBytes[0]);
    }

    public void ugcDownload(UGCHandle hContent) {
        this.checkConnected();
        this.UGCDownload(hContent.getHandle());
    }

    public UGCDetails getUGCDetails(UGCHandle hContent) {
        this.checkConnected();
        long[] appID = new long[1];
        String[] name = new String[1];
        int[] fileSizeInBytes = new int[1];
        long[] steamIDOwner = new long[1];
        if (!this.GetUGCDetails(hContent.getHandle(), appID, name, fileSizeInBytes, steamIDOwner)) {
            throw new SteamException();
        }
        return new UGCDetails(appID[0], name[0], fileSizeInBytes[0], steamIDOwner[0]);
    }

    public int ugcRead(UGCHandle hContent, ByteBuffer pvData) {
        this.checkConnected();
        return this.UGCRead(hContent.getHandle(), pvData, pvData.position(), pvData.limit());
    }

    public UGCHandle getCachedUGCHandle(int iCachedContent) {
        this.checkConnected();
        return new UGCHandle(this.GetCachedUGCHandle(iCachedContent));
    }

    public boolean fileForget(String pchFile) {
        this.checkConnected();
        return this.FileForget(pchFile);
    }

    public boolean fileDelete(String pchFile) {
        this.checkConnected();
        return this.FileDelete(pchFile);
    }

    public boolean fileExists(String pchFile) {
        this.checkConnected();
        return this.FileExists(pchFile);
    }

    public boolean filePersisted(String pchFile) {
        this.checkConnected();
        return this.FilePersisted(pchFile);
    }

    public int getFileCount() {
        this.checkConnected();
        return this.GetFileCount();
    }

    public int getFileSize(String pchFile) {
        this.checkConnected();
        return this.GetFileSize(pchFile);
    }

    public long getFileTimestamp(String pchFile) {
        this.checkConnected();
        return this.GetFileTimestamp(pchFile);
    }

    public boolean isCloudEnabledForAccount() {
        this.checkConnected();
        return this.IsCloudEnabledForAccount();
    }

    public boolean isCloudEnabledForApp() {
        this.checkConnected();
        return this.IsCloudEnabledForApp();
    }

    public void setCloudEnabledForApp(boolean bEnabled) {
        this.checkConnected();
        this.SetCloudEnabledForApp(bEnabled);
    }

    public int getCachedUGCCount() {
        this.checkConnected();
        return this.GetCachedUGCCount();
    }

    private native boolean FileWrite(String var1, ByteBuffer var2, int var3, int var4);

    private native int FileRead(String var1, ByteBuffer var2, int var3, int var4);

    private native void FileShare(String var1);

    private native boolean SetSyncPlatforms(String var1, int var2);

    private native int GetSyncPlatforms(String var1);

    private native String GetFileNameAndSize(int var1, int[] var2);

    private native boolean GetQuota(int[] var1, int[] var2);

    private native void UGCDownload(long var1);

    private native boolean GetUGCDetails(long var1, long[] var3, String[] var4, int[] var5, long[] var6);

    private native int UGCRead(long var1, ByteBuffer var3, int var4, int var5);

    private native long GetCachedUGCHandle(int var1);

    private native boolean FileForget(String var1);

    private native boolean FileDelete(String var1);

    private native boolean FileExists(String var1);

    private native boolean FilePersisted(String var1);

    private native int GetFileCount();

    private native int GetFileSize(String var1);

    private native long GetFileTimestamp(String var1);

    private native boolean IsCloudEnabledForAccount();

    private native boolean IsCloudEnabledForApp();

    private native void SetCloudEnabledForApp(boolean var1);

    private native int GetCachedUGCCount();
}

