/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.steam;

import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import net.puppygames.steam.AppID;
import net.puppygames.steam.AuthSessionResponse;
import net.puppygames.steam.AuthTicket;
import net.puppygames.steam.BeginAuthSessionResult;
import net.puppygames.steam.FailureType;
import net.puppygames.steam.ISteamUser;
import net.puppygames.steam.NativeUserListener;
import net.puppygames.steam.Result;
import net.puppygames.steam.SteamException;
import net.puppygames.steam.SteamID;
import net.puppygames.steam.SteamObject;
import net.puppygames.steam.UserHasLicenseForAppResult;
import net.puppygames.steam.Utils;
import net.puppygames.steam.VoiceResult;
import net.puppygames.steam.user.AvailableVoice;
import net.puppygames.steam.user.UserListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SteamUser
extends SteamObject<UserListener>
implements ISteamUser {
    SteamUser(long ptr) {
        super(ptr);
    }

    @Override
    protected NativeUserListener createCallbackAdapter() {
        return new NativeUserListener(){

            public void ioError(String handler) {
                for (UserListener listener : SteamUser.this.getListeners()) {
                    listener.ioError(handler);
                }
            }

            public void onValidateAuthTicketResponse(long steamID, int authSessionResponse) {
                SteamID steamID_ = new SteamID(steamID);
                AuthSessionResponse authSessionResponse_ = (AuthSessionResponse)Utils.find((int)authSessionResponse, (Enum[])AuthSessionResponse.values());
                for (UserListener listener : SteamUser.this.getListeners()) {
                    listener.onValidateAuthTicketResponse(steamID_, authSessionResponse_);
                }
            }

            public void onSteamServersDisconnected(int result) {
                Result result_ = (Result)Utils.find((int)result, (Enum[])Result.values());
                for (UserListener listener : SteamUser.this.getListeners()) {
                    listener.onSteamServersDisconnected(result_);
                }
            }

            public void onSteamServersConnected() {
                for (UserListener listener : SteamUser.this.getListeners()) {
                    listener.onSteamServersConnected();
                }
            }

            public void onSteamServerConnectFailure(int result) {
                Result result_ = (Result)Utils.find((int)result, (Enum[])Result.values());
                for (UserListener listener : SteamUser.this.getListeners()) {
                    listener.onSteamServerConnectFailure(result_);
                }
            }

            public void onMicroTxnAuthorizationResponse(int appID, long orderID, boolean authorized) {
                AppID appID_ = new AppID(appID);
                for (UserListener listener : SteamUser.this.getListeners()) {
                    listener.onMicroTxnAuthorizationResponse(appID_, orderID, authorized);
                }
            }

            public void onIPCFailure(int failureType) {
                FailureType failureType_ = (FailureType)Utils.find((int)failureType, (Enum[])FailureType.values());
                for (UserListener listener : SteamUser.this.getListeners()) {
                    listener.onIPCFailure(failureType_);
                }
            }

            public void onEncryptedAppTicketResponse(int result) {
                Result result_ = (Result)Utils.find((int)result, (Enum[])Result.values());
                for (UserListener listener : SteamUser.this.getListeners()) {
                    listener.onEncryptedAppTicketResponse(result_);
                }
            }

            public void onClientGameServerDeny(int appID, int gameServerIP, int gameServerPort, boolean secure, int reason) throws UnknownHostException {
                AppID appID_ = new AppID(appID);
                InetSocketAddress gameServerIP_ = new InetSocketAddress(Utils.toInetAddress((int)gameServerIP), gameServerPort);
                for (UserListener listener : SteamUser.this.getListeners()) {
                    listener.onClientGameServerDeny(appID_, gameServerIP_, secure, reason);
                }
            }
        };
    }

    @Override
    protected native long createNativeCallbackAdapter(Object var1);

    @Override
    protected native void removeNativeCallbackAdapter(long var1);

    public boolean isLoggedOn() {
        this.checkConnected();
        return this.isLoggedOn();
    }

    public SteamID getSteamID() {
        this.checkConnected();
        return new SteamID(this.GetSteamID());
    }

    public void initiateGameConnection(ByteBuffer pAuthBlob, SteamID steamIDGameServer, InetSocketAddress socketAddress, boolean bSecure) {
        this.checkConnected();
        if (!pAuthBlob.isDirect()) {
            throw new IllegalArgumentException("pAuthBlob must be a direct buffer");
        }
        this.InitiateGameConnection(pAuthBlob, pAuthBlob.position(), pAuthBlob.limit(), steamIDGameServer.getSteamID(), Utils.fromInetAddress((Inet4Address)((Inet4Address)socketAddress.getAddress())), socketAddress.getPort(), bSecure);
    }

    public void terminateGameConnection(InetSocketAddress socketAddress) {
        this.checkConnected();
        this.TerminateGameConnection(Utils.fromInetAddress((Inet4Address)((Inet4Address)socketAddress.getAddress())), (short)socketAddress.getPort());
    }

    public String getUserDataFolder() {
        this.checkConnected();
        String[] ret = new String[1];
        if (!this.GetUserDataFolder(ret)) {
            throw new SteamException();
        }
        return ret[0];
    }

    public void startVoiceRecording() {
        this.checkConnected();
        this.StartVoiceRecording();
    }

    public void stopVoiceRecording() {
        this.checkConnected();
        this.StopVoiceRecording();
    }

    public AvailableVoice getAvailableVoice(int nUncompressedVoiceDesiredSampleRate) {
        this.checkConnected();
        int[] compressed = new int[1];
        int[] uncompressed = new int[1];
        int result = this.GetAvailableVoice(compressed, uncompressed, nUncompressedVoiceDesiredSampleRate);
        return new AvailableVoice((VoiceResult)Utils.find((int)result, (Enum[])VoiceResult.values()), compressed[0], uncompressed[0]);
    }

    public VoiceResult getVoice(boolean bWantCompressed, ByteBuffer pDestBuffer, boolean bWantUncompressed, ByteBuffer pUncompressedDestBuffer, int nUncompressedVoiceDesiredSampleRate) {
        this.checkConnected();
        if (!pDestBuffer.isDirect()) {
            throw new IllegalArgumentException("pDestBuffer must be a direct buffer");
        }
        if (!pUncompressedDestBuffer.isDirect()) {
            throw new IllegalArgumentException("pUncompressedDestBuffer must be a direct buffer");
        }
        int[] destBytesWritten = new int[1];
        int[] uncompressedDestBytesWritten = new int[1];
        int result = this.GetVoice(bWantCompressed, pDestBuffer, pDestBuffer.position(), pDestBuffer.limit(), destBytesWritten, bWantUncompressed, pUncompressedDestBuffer, pUncompressedDestBuffer.position(), pUncompressedDestBuffer.limit(), uncompressedDestBytesWritten, nUncompressedVoiceDesiredSampleRate);
        pDestBuffer.limit(pDestBuffer.position() + destBytesWritten[0]);
        pUncompressedDestBuffer.limit(pUncompressedDestBuffer.position() + uncompressedDestBytesWritten[0]);
        return (VoiceResult)Utils.find((int)result, (Enum[])VoiceResult.values());
    }

    public VoiceResult decompressVoice(ByteBuffer pCompressed, ByteBuffer pDestBuffer, int nDesiredSampleRate) {
        this.checkConnected();
        if (!pCompressed.isDirect()) {
            throw new IllegalArgumentException("pCompressed must be a direct buffer");
        }
        if (!pDestBuffer.isDirect()) {
            throw new IllegalArgumentException("pDestBuffer must be a direct buffer");
        }
        int[] bytesWritten = new int[1];
        int result = this.DecompressVoice(pCompressed, pCompressed.position(), pCompressed.limit(), pDestBuffer, pDestBuffer.position(), pDestBuffer.limit(), bytesWritten, nDesiredSampleRate);
        pDestBuffer.limit(bytesWritten[0] + pDestBuffer.position());
        pCompressed.position(pCompressed.limit());
        return (VoiceResult)Utils.find((int)result, (Enum[])VoiceResult.values());
    }

    public int getVoiceOptimalSampleRate() {
        this.checkConnected();
        return this.GetVoiceOptimalSampleRate();
    }

    public AuthTicket getAuthSessionTicket(ByteBuffer pTicket) {
        this.checkConnected();
        if (!pTicket.isDirect()) {
            throw new IllegalArgumentException("pTicket must be a direct buffer");
        }
        int[] pcbTicket = new int[1];
        int ret = this.GetAuthSessionTicket(pTicket, pTicket.position(), pTicket.limit(), pcbTicket);
        pTicket.limit(pTicket.position() + pcbTicket[0]);
        return new AuthTicket(ret);
    }

    public BeginAuthSessionResult beginAuthSession(ByteBuffer pAuthTicket, SteamID steamID) {
        this.checkConnected();
        if (!pAuthTicket.isDirect()) {
            throw new IllegalArgumentException("pAuthTicket must be a direct buffer");
        }
        int ret = this.BeginAuthSession(pAuthTicket, pAuthTicket.position(), pAuthTicket.limit(), steamID.getSteamID());
        return (BeginAuthSessionResult)Utils.find((int)ret, (Enum[])BeginAuthSessionResult.values());
    }

    public void endAuthSession(SteamID steamID) {
        this.checkConnected();
        this.EndAuthSession(steamID.getSteamID());
    }

    public void cancelAuthTicket(AuthTicket hAuthTicket) {
        this.checkConnected();
        this.CancelAuthTicket(hAuthTicket.getAuthTicket());
    }

    public UserHasLicenseForAppResult isUserLicensedForApp(SteamID steamID, AppID appID) {
        this.checkConnected();
        return (UserHasLicenseForAppResult)Utils.find((int)this.UserHasLicenseForApp(steamID.getSteamID(), appID.getAppID()), (Enum[])UserHasLicenseForAppResult.values());
    }

    public boolean isBehindNAT() {
        this.checkConnected();
        return this.isBehindNAT();
    }

    public void advertiseGame(SteamID steamIDGameServer, InetSocketAddress socketAddress) {
        this.checkConnected();
        this.AdvertiseGame(steamIDGameServer.getSteamID(), Utils.fromInetAddress((Inet4Address)((Inet4Address)socketAddress.getAddress())), socketAddress.getPort());
    }

    public void requestEncryptedAppTicket(ByteBuffer pDataToInclude) {
        this.checkConnected();
        if (!pDataToInclude.isDirect()) {
            throw new IllegalArgumentException("pTicket must be a direct buffer");
        }
        this.RequestEncryptedAppTicket(pDataToInclude, pDataToInclude.position(), pDataToInclude.limit());
    }

    public void getEncryptedAppTicket(ByteBuffer pTicket) {
        this.checkConnected();
        if (!pTicket.isDirect()) {
            throw new IllegalArgumentException("pTicket must be a direct buffer");
        }
        int[] pcbTicket = new int[1];
        if (!this.GetEncryptedAppTicket(pTicket, pTicket.position(), pTicket.limit(), pcbTicket)) {
            throw new SteamException();
        }
        pTicket.limit(pTicket.position() + pcbTicket[0]);
    }

    private native boolean BLoggedOn();

    private native long GetSteamID();

    private native int InitiateGameConnection(ByteBuffer var1, int var2, int var3, long var4, int var6, int var7, boolean var8);

    private native void TerminateGameConnection(int var1, int var2);

    private native boolean GetUserDataFolder(String[] var1);

    private native void StartVoiceRecording();

    private native void StopVoiceRecording();

    private native int GetAvailableVoice(int[] var1, int[] var2, int var3);

    private native int GetVoice(boolean var1, ByteBuffer var2, int var3, int var4, int[] var5, boolean var6, ByteBuffer var7, int var8, int var9, int[] var10, int var11);

    private native int DecompressVoice(ByteBuffer var1, int var2, int var3, ByteBuffer var4, int var5, int var6, int[] var7, int var8);

    private native int GetVoiceOptimalSampleRate();

    private native int GetAuthSessionTicket(ByteBuffer var1, int var2, int var3, int[] var4);

    private native int BeginAuthSession(ByteBuffer var1, int var2, int var3, long var4);

    private native void EndAuthSession(long var1);

    private native void CancelAuthTicket(int var1);

    private native int UserHasLicenseForApp(long var1, int var3);

    private native boolean BIsBehindNAT();

    private native void AdvertiseGame(long var1, int var3, int var4);

    private native void RequestEncryptedAppTicket(ByteBuffer var1, int var2, int var3);

    private native boolean GetEncryptedAppTicket(ByteBuffer var1, int var2, int var3, int[] var4);
}

