/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.steam;

import java.nio.DoubleBuffer;
import java.nio.LongBuffer;
import java.util.LinkedList;
import net.puppygames.steam.GameID;
import net.puppygames.steam.ISteamUserStats;
import net.puppygames.steam.NativeUserStatsListener;
import net.puppygames.steam.Result;
import net.puppygames.steam.SteamException;
import net.puppygames.steam.SteamID;
import net.puppygames.steam.SteamLeaderboard;
import net.puppygames.steam.SteamLeaderboardEntries;
import net.puppygames.steam.SteamObject;
import net.puppygames.steam.UGCHandle;
import net.puppygames.steam.Utils;
import net.puppygames.steam.userstats.AchievementAndUnlockTime;
import net.puppygames.steam.userstats.DownloadedLeaderboardEntry;
import net.puppygames.steam.userstats.LeaderboardDataRequest;
import net.puppygames.steam.userstats.LeaderboardDisplayType;
import net.puppygames.steam.userstats.LeaderboardEntry;
import net.puppygames.steam.userstats.LeaderboardSortMethod;
import net.puppygames.steam.userstats.LeaderboardUploadScoreMethod;
import net.puppygames.steam.userstats.MostAchievedAchievement;
import net.puppygames.steam.userstats.UserStatsListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SteamUserStats
extends SteamObject<UserStatsListener>
implements ISteamUserStats {
    SteamUserStats(long ptr) {
        super(ptr);
    }

    @Override
    protected final native long createNativeCallbackAdapter(Object var1);

    @Override
    protected final native void removeNativeCallbackAdapter(long var1);

    @Override
    protected Object createCallbackAdapter() {
        return new NativeUserStatsListener(){

            public void ioError(String handler) {
                for (UserStatsListener listener : SteamUserStats.this.getListeners()) {
                    listener.ioError(handler);
                }
            }

            public void onUserStatsUnloaded(long steamIDUser) {
                SteamID steamIDUser_ = new SteamID(steamIDUser);
                for (UserStatsListener listener : SteamUserStats.this.getListeners()) {
                    listener.onUserStatsUnloaded(steamIDUser_);
                }
            }

            public void onUserStatsStored(long gameID, int result) {
                GameID gameID_ = new GameID(gameID);
                Result result_ = (Result)Utils.find((int)result, (Enum[])Result.values());
                for (UserStatsListener listener : SteamUserStats.this.getListeners()) {
                    listener.onUserStatsStored(gameID_, result_);
                }
            }

            public void onUserStatsReceived(long gameID, int result, long steamIDUser) {
                GameID gameID_ = new GameID(gameID);
                Result result_ = (Result)Utils.find((int)result, (Enum[])Result.values());
                SteamID steamIDUser_ = new SteamID(steamIDUser);
                for (UserStatsListener listener : SteamUserStats.this.getListeners()) {
                    listener.onUserStatsReceived(gameID_, result_, steamIDUser_);
                }
            }

            public void onUserAchievementStored(long gameID, boolean groupAchievement, String achievement, int curProgress, int maxProgress) {
                GameID gameID_ = new GameID(gameID);
                for (UserStatsListener listener : SteamUserStats.this.getListeners()) {
                    listener.onUserAchievementStored(gameID_, groupAchievement, achievement, curProgress, maxProgress);
                }
            }

            public void onUserAchievementIconFetched(long gameID, String achievementName, boolean achieved, int iconHandle) {
                GameID gameID_ = new GameID(gameID);
                for (UserStatsListener listener : SteamUserStats.this.getListeners()) {
                    listener.onUserAchievementIconFetched(gameID_, achievementName, achieved, iconHandle);
                }
            }

            public void onNumberOfCurrentPlayers(boolean success, int players) {
                for (UserStatsListener listener : SteamUserStats.this.getListeners()) {
                    listener.onNumberOfCurrentPlayers(success, players);
                }
            }

            public void onLeaderboardUGCSet(int result, long steamLeaderboard) {
                Result result_ = (Result)Utils.find((int)result, (Enum[])Result.values());
                SteamLeaderboard steamLeaderboard_ = new SteamLeaderboard(steamLeaderboard);
                for (UserStatsListener listener : SteamUserStats.this.getListeners()) {
                    listener.onLeaderboardUGCSet(result_, steamLeaderboard_);
                }
            }

            public void onLeaderboardScoresDownloaded(long steamLeaderboard, long steamLeaderboardEntries, int entryCount) {
                SteamLeaderboard steamLeaderboard_ = new SteamLeaderboard(steamLeaderboard);
                SteamLeaderboardEntries steamLeaderboardEntries_ = new SteamLeaderboardEntries(steamLeaderboardEntries);
                for (UserStatsListener listener : SteamUserStats.this.getListeners()) {
                    listener.onLeaderboardScoresDownloaded(steamLeaderboard_, steamLeaderboardEntries_, entryCount);
                }
            }

            public void onLeaderboardScoreUploaded(boolean success, long steamLeaderboard, int score, boolean scoreChanged, int globalRankNew, int globalRankPrevious) {
                SteamLeaderboard steamLeaderboard_ = new SteamLeaderboard(steamLeaderboard);
                for (UserStatsListener listener : SteamUserStats.this.getListeners()) {
                    listener.onLeaderboardScoreUploaded(success, steamLeaderboard_, score, scoreChanged, globalRankNew, globalRankPrevious);
                }
            }

            public void onLeaderboardFindResult(long steamLeaderboard, boolean leaderboardFound) {
                SteamLeaderboard steamLeaderboard_ = new SteamLeaderboard(steamLeaderboard);
                for (UserStatsListener listener : SteamUserStats.this.getListeners()) {
                    listener.onLeaderboardFindResult(steamLeaderboard_, leaderboardFound);
                }
            }

            public void onGlobalStatsReceived(long gameID, int result) {
                GameID gameID_ = new GameID(gameID);
                Result result_ = (Result)Utils.find((int)result, (Enum[])Result.values());
                for (UserStatsListener listener : SteamUserStats.this.getListeners()) {
                    listener.onGlobalStatsReceived(gameID_, result_);
                }
            }

            public void onGlobalAchievementPercentagesReady(long gameID, int result) {
                GameID gameID_ = new GameID(gameID);
                Result result_ = (Result)Utils.find((int)result, (Enum[])Result.values());
                for (UserStatsListener listener : SteamUserStats.this.getListeners()) {
                    listener.onGlobalAchievementPercentagesReady(gameID_, result_);
                }
            }
        };
    }

    public void requestCurrentStats() {
        this.checkConnected();
        if (!this.RequestCurrentStats()) {
            throw new SteamException();
        }
    }

    public int getStati(String name) {
        this.checkConnected();
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        int[] ret = new int[1];
        if (!this.GetStat(name, ret)) {
            throw new SteamException();
        }
        return ret[0];
    }

    public float getStatf(String name) {
        this.checkConnected();
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        float[] ret = new float[1];
        if (!this.GetStat(name, ret)) {
            throw new SteamException();
        }
        return ret[0];
    }

    public void setStat(String name, int data) {
        this.checkConnected();
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (!this.SetStat(name, data)) {
            throw new SteamException();
        }
    }

    public void setStat(String name, float data) {
        this.checkConnected();
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (!this.SetStat(name, data)) {
            throw new SteamException();
        }
    }

    public void updateAvgRateStat(String name, float countThisSession, double sessionLength) {
        this.checkConnected();
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (!this.UpdateAvgRateStat(name, countThisSession, sessionLength)) {
            throw new SteamException();
        }
    }

    public boolean isAchieved(String name) {
        this.checkConnected();
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        boolean[] ret = new boolean[1];
        if (!this.GetAchievement(name, ret)) {
            throw new SteamException();
        }
        return ret[0];
    }

    public void setAchievement(String name) {
        this.checkConnected();
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (!this.SetAchievement(name)) {
            throw new SteamException();
        }
    }

    public void clearAchievement(String name) {
        this.checkConnected();
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (!this.ClearAchievement(name)) {
            throw new SteamException();
        }
    }

    public AchievementAndUnlockTime getAchievementAndUnlockTime(String name) {
        this.checkConnected();
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        boolean[] achieved = new boolean[1];
        int[] unlockTime = new int[1];
        if (!this.GetAchievementAndUnlockTime(name, achieved, unlockTime)) {
            throw new SteamException();
        }
        return new AchievementAndUnlockTime(achieved[0], unlockTime[0]);
    }

    public void storeStats() {
        this.checkConnected();
        if (!this.StoreStats()) {
            throw new SteamException();
        }
    }

    public int getAchievementIcon(String name) {
        this.checkConnected();
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return this.GetAchievementIcon(name);
    }

    public String getAchievementDisplayAttribute(String name, String key) {
        this.checkConnected();
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        return this.GetAchievementDisplayAttribute(name, key);
    }

    public void indicateAchievementProgress(String name, int nCurProgress, int nMaxProgress) {
        this.checkConnected();
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (!this.IndicateAchievementProgress(name, nCurProgress, nMaxProgress)) {
            throw new SteamException();
        }
    }

    public void requestUserStats(SteamID steamIDUser) {
        this.checkConnected();
        this.RequestUserStats(steamIDUser.getSteamID());
    }

    public int getUserStati(SteamID steamIDUser, String name) {
        this.checkConnected();
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        int[] data = new int[1];
        if (!this.GetUserStat(steamIDUser.getSteamID(), name, data)) {
            throw new SteamException();
        }
        return data[0];
    }

    public float getUserStatf(SteamID steamIDUser, String name) {
        this.checkConnected();
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        float[] data = new float[1];
        if (!this.GetUserStat(steamIDUser.getSteamID(), name, data)) {
            throw new SteamException();
        }
        return data[0];
    }

    public boolean getUserAchievement(SteamID steamIDUser, String name, boolean[] pbAchieved) {
        this.checkConnected();
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        boolean[] data = new boolean[1];
        if (!this.GetUserAchievement(steamIDUser.getSteamID(), name, data)) {
            throw new SteamException();
        }
        return data[0];
    }

    public AchievementAndUnlockTime getUserAchievementAndUnlockTime(SteamID steamIDUser, String name) {
        this.checkConnected();
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        boolean[] achieved = new boolean[1];
        int[] unlockTime = new int[1];
        if (!this.GetUserAchievementAndUnlockTime(steamIDUser.getSteamID(), name, achieved, unlockTime)) {
            throw new SteamException();
        }
        return new AchievementAndUnlockTime(achieved[0], unlockTime[0]);
    }

    public void resetAllStats(boolean bAchievementsToo) {
        this.checkConnected();
        if (!this.ResetAllStats(bAchievementsToo)) {
            throw new SteamException();
        }
    }

    public void findOrCreateLeaderboard(String leaderboardName, LeaderboardSortMethod eLeaderboardSortMethod, LeaderboardDisplayType eLeaderboardDisplayType) {
        this.checkConnected();
        if (leaderboardName == null) {
            throw new IllegalArgumentException("leaderboardName cannot be null");
        }
        this.FindOrCreateLeaderboard(leaderboardName, eLeaderboardSortMethod.getValue(), eLeaderboardDisplayType.getValue());
    }

    public void findLeaderboard(String leaderboardName) {
        this.checkConnected();
        if (leaderboardName == null) {
            throw new IllegalArgumentException("leaderboardName cannot be null");
        }
        this.FindLeaderboard(leaderboardName);
    }

    public String getLeaderboardName(SteamLeaderboard hSteamLeaderboard) {
        this.checkConnected();
        return this.GetLeaderboardName(hSteamLeaderboard.getHandle());
    }

    public int getLeaderboardEntryCount(SteamLeaderboard hSteamLeaderboard) {
        this.checkConnected();
        return this.GetLeaderboardEntryCount(hSteamLeaderboard.getHandle());
    }

    public int getLeaderboardSortMethod(SteamLeaderboard hSteamLeaderboard) {
        this.checkConnected();
        return this.GetLeaderboardSortMethod(hSteamLeaderboard.getHandle());
    }

    public int getLeaderboardDisplayType(SteamLeaderboard hSteamLeaderboard) {
        this.checkConnected();
        return this.GetLeaderboardDisplayType(hSteamLeaderboard.getHandle());
    }

    public void downloadLeaderboardEntries(SteamLeaderboard hSteamLeaderboard, LeaderboardDataRequest eLeaderboardDataRequest, int nRangeStart, int nRangeEnd) {
        this.checkConnected();
        this.DownloadLeaderboardEntries(hSteamLeaderboard.getHandle(), eLeaderboardDataRequest.getValue(), nRangeStart, nRangeEnd);
    }

    public void downloadLeaderboardEntriesForUsers(SteamLeaderboard hSteamLeaderboard, SteamID[] prgUsers) {
        this.checkConnected();
        long[] users = new long[prgUsers.length];
        int i = 0;
        while (i < prgUsers.length) {
            users[i] = prgUsers[i].getSteamID();
            ++i;
        }
        this.DownloadLeaderboardEntriesForUsers(hSteamLeaderboard.getHandle(), users, users.length);
    }

    public DownloadedLeaderboardEntry getDownloadedLeaderboardEntry(SteamLeaderboardEntries hSteamLeaderboardEntries, int index, int maxDetails) {
        this.checkConnected();
        int[] details = new int[maxDetails];
        LeaderboardEntry[] leaderboardEntry = new LeaderboardEntry[1];
        if (!this.GetDownloadedLeaderboardEntry(hSteamLeaderboardEntries.getHandle(), index, leaderboardEntry, details, details.length)) {
            throw new SteamException();
        }
        return new DownloadedLeaderboardEntry(leaderboardEntry[0], details);
    }

    public void uploadLeaderboardScore(SteamLeaderboard hSteamLeaderboard, LeaderboardUploadScoreMethod eLeaderboardUploadScoreMethod, int nScore, int[] pScoreDetails) {
        this.checkConnected();
        this.UploadLeaderboardScore(hSteamLeaderboard.getHandle(), eLeaderboardUploadScoreMethod.getValue(), nScore, pScoreDetails, pScoreDetails.length);
    }

    public void attachLeaderboardUGC(SteamLeaderboard hSteamLeaderboard, UGCHandle hUGC) {
        this.checkConnected();
        this.AttachLeaderboardUGC(hSteamLeaderboard.getHandle(), hUGC.getHandle());
    }

    public void getNumberOfCurrentPlayers() {
        this.checkConnected();
        this.GetNumberOfCurrentPlayers();
    }

    public void requestGlobalAchievementPercentages() {
        this.checkConnected();
        this.RequestGlobalAchievementPercentages();
    }

    public MostAchievedAchievement[] getMostAchievedAchievements() {
        this.checkConnected();
        String[] name = new String[1];
        float[] percent = new float[1];
        boolean[] achieved = new boolean[1];
        int idx = this.GetMostAchievedAchievementInfo(name, percent, achieved);
        if (idx == -1) {
            return new MostAchievedAchievement[0];
        }
        LinkedList<MostAchievedAchievement> list = new LinkedList<MostAchievedAchievement>();
        list.add(new MostAchievedAchievement(name[0], percent[0], achieved[0]));
        while (idx != -1) {
            if ((idx = this.GetNextMostAchievedAchievementInfo(idx, name, percent, achieved)) == -1) continue;
            list.add(new MostAchievedAchievement(name[0], percent[0], achieved[0]));
        }
        MostAchievedAchievement[] ret = new MostAchievedAchievement[list.size()];
        list.toArray(ret);
        return ret;
    }

    public float getAchievementAchievedPercent(String name) {
        this.checkConnected();
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        float[] percent = new float[1];
        if (!this.GetAchievementAchievedPercent(name, percent)) {
            throw new SteamException();
        }
        return percent[0];
    }

    public void requestGlobalStats(int nHistoryDays) {
        this.checkConnected();
        this.RequestGlobalStats(nHistoryDays);
    }

    public long getGlobalStatl(String statName) {
        this.checkConnected();
        if (statName == null) {
            throw new IllegalArgumentException("statName cannot be null");
        }
        long[] data = new long[1];
        if (!this.GetGlobalStat(statName, data)) {
            throw new SteamException();
        }
        return data[0];
    }

    public double getGlobalStatd(String statName) {
        this.checkConnected();
        if (statName == null) {
            throw new IllegalArgumentException("statName cannot be null");
        }
        double[] data = new double[1];
        if (!this.GetGlobalStat(statName, data)) {
            throw new SteamException();
        }
        return data[0];
    }

    public int getGlobalStatHistory(String statName, LongBuffer pData) {
        this.checkConnected();
        if (statName == null) {
            throw new IllegalArgumentException("statName cannot be null");
        }
        if (!pData.isDirect()) {
            throw new IllegalArgumentException("pData must be a direct buffer");
        }
        int position = pData.position();
        int limit = pData.limit();
        return this.GetGlobalStatHistory(statName, pData, position, limit);
    }

    public int getGlobalStatHistory(String statName, DoubleBuffer pData) {
        this.checkConnected();
        if (statName == null) {
            throw new IllegalArgumentException("statName cannot be null");
        }
        if (!pData.isDirect()) {
            throw new IllegalArgumentException("pData must be a direct buffer");
        }
        int position = pData.position();
        int limit = pData.limit();
        return this.GetGlobalStatHistory(statName, pData, position, limit);
    }

    private native boolean RequestCurrentStats();

    private native boolean GetStat(String var1, int[] var2);

    private native boolean GetStat(String var1, float[] var2);

    private native boolean SetStat(String var1, int var2);

    private native boolean SetStat(String var1, float var2);

    private native boolean UpdateAvgRateStat(String var1, float var2, double var3);

    private native boolean GetAchievement(String var1, boolean[] var2);

    private native boolean SetAchievement(String var1);

    private native boolean ClearAchievement(String var1);

    private native boolean GetAchievementAndUnlockTime(String var1, boolean[] var2, int[] var3);

    private native boolean StoreStats();

    private native int GetAchievementIcon(String var1);

    private native String GetAchievementDisplayAttribute(String var1, String var2);

    private native boolean IndicateAchievementProgress(String var1, int var2, int var3);

    private native void RequestUserStats(long var1);

    private native boolean GetUserStat(long var1, String var3, int[] var4);

    private native boolean GetUserStat(long var1, String var3, float[] var4);

    private native boolean GetUserAchievement(long var1, String var3, boolean[] var4);

    private native boolean GetUserAchievementAndUnlockTime(long var1, String var3, boolean[] var4, int[] var5);

    private native boolean ResetAllStats(boolean var1);

    private native void FindOrCreateLeaderboard(String var1, int var2, int var3);

    private native void FindLeaderboard(String var1);

    private native String GetLeaderboardName(long var1);

    private native int GetLeaderboardEntryCount(long var1);

    private native int GetLeaderboardSortMethod(long var1);

    private native int GetLeaderboardDisplayType(long var1);

    private native void DownloadLeaderboardEntries(long var1, int var3, int var4, int var5);

    private native void DownloadLeaderboardEntriesForUsers(long var1, long[] var3, int var4);

    private native boolean GetDownloadedLeaderboardEntry(long var1, int var3, LeaderboardEntry[] var4, int[] var5, int var6);

    private native void UploadLeaderboardScore(long var1, int var3, int var4, int[] var5, int var6);

    private native void AttachLeaderboardUGC(long var1, long var3);

    private native void GetNumberOfCurrentPlayers();

    private native void RequestGlobalAchievementPercentages();

    private native int GetMostAchievedAchievementInfo(String[] var1, float[] var2, boolean[] var3);

    private native int GetNextMostAchievedAchievementInfo(int var1, String[] var2, float[] var3, boolean[] var4);

    private native boolean GetAchievementAchievedPercent(String var1, float[] var2);

    private native void RequestGlobalStats(int var1);

    private native boolean GetGlobalStat(String var1, double[] var2);

    private native boolean GetGlobalStat(String var1, long[] var2);

    private native int GetGlobalStatHistory(String var1, LongBuffer var2, int var3, int var4);

    private native int GetGlobalStatHistory(String var1, DoubleBuffer var2, int var3, int var4);
}

