/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.steam;

import java.nio.ByteBuffer;
import net.puppygames.steam.AppID;
import net.puppygames.steam.ISteamUtils;
import net.puppygames.steam.NativeUtilsListener;
import net.puppygames.steam.NotificationPosition;
import net.puppygames.steam.SteamObject;
import net.puppygames.steam.Universe;
import net.puppygames.steam.Utils;
import net.puppygames.steam.utils.CheckFileSignature;
import net.puppygames.steam.utils.UtilsListener;
import org.lwjgl.util.Dimension;
import org.lwjgl.util.ReadableDimension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SteamUtils
extends SteamObject<UtilsListener>
implements ISteamUtils {
    SteamUtils(long ptr) {
        super(ptr);
    }

    @Override
    protected Object createCallbackAdapter() {
        return new NativeUtilsListener(){

            public void ioError(String handler) {
                for (UtilsListener listener : SteamUtils.this.getListeners()) {
                    listener.ioError(handler);
                }
            }

            public void onSteamShutdown() {
                for (UtilsListener listener : SteamUtils.this.getListeners()) {
                    listener.onSteamShutdown();
                }
            }

            public void onSteamAPICallCompleted(long call) {
                for (UtilsListener listener : SteamUtils.this.getListeners()) {
                    listener.onSteamAPICallCompleted(call);
                }
            }

            public void onLowBatteryPower(int minutesBatteryLeft) {
                for (UtilsListener listener : SteamUtils.this.getListeners()) {
                    listener.onLowBatteryPower(minutesBatteryLeft);
                }
            }

            public void onIPCountry() {
                for (UtilsListener listener : SteamUtils.this.getListeners()) {
                    listener.onIPCountry();
                }
            }

            public void onCheckFileSignature(int result) {
                CheckFileSignature result_ = (CheckFileSignature)Utils.find((int)result, (Enum[])CheckFileSignature.values());
                for (UtilsListener listener : SteamUtils.this.getListeners()) {
                    listener.onCheckFileSignature(result_);
                }
            }
        };
    }

    @Override
    protected native long createNativeCallbackAdapter(Object var1);

    @Override
    protected native void removeNativeCallbackAdapter(long var1);

    public int getSecondsSinceAppActive() {
        this.checkConnected();
        return this.GetSecondsSinceAppActive();
    }

    public int getSecondsSinceComputerActive() {
        this.checkConnected();
        return this.GetSecondsSinceComputerActive();
    }

    public Universe getConnectedUniverse() {
        this.checkConnected();
        return (Universe)Utils.find((int)this.GetConnectedUniverse(), (Enum[])Universe.values());
    }

    public int getServerRealTime() {
        this.checkConnected();
        return this.GetServerRealTime();
    }

    public String getIPCountry() {
        this.checkConnected();
        return this.GetIPCountry();
    }

    public ReadableDimension getImageSize(int iImage) {
        this.checkConnected();
        int[] width = new int[1];
        int[] height = new int[1];
        if (this.GetImageSize(iImage, width, height)) {
            return new Dimension(width[0], height[0]);
        }
        return null;
    }

    public boolean getImageRGBA(int iImage, ByteBuffer data) {
        this.checkConnected();
        if (!data.isDirect()) {
            throw new IllegalArgumentException("data must be a direct buffer");
        }
        return this.GetImageRGBA(iImage, data, data.position(), data.limit());
    }

    public int getCurrentBatteryPower() {
        this.checkConnected();
        return this.GetCurrentBatteryPower();
    }

    public AppID getAppID() {
        this.checkConnected();
        return new AppID(this.GetAppID());
    }

    public void setOverlayNotificationPosition(NotificationPosition eNotificationPosition) {
        this.checkConnected();
        this.SetOverlayNotificationPosition(eNotificationPosition.getValue());
    }

    public int getIPCCallCount() {
        this.checkConnected();
        return this.GetIPCCallCount();
    }

    public boolean isOverlayEnabled() {
        this.checkConnected();
        return this.IsOverlayEnabled();
    }

    private native int GetSecondsSinceAppActive();

    private native int GetSecondsSinceComputerActive();

    private native int GetConnectedUniverse();

    private native int GetServerRealTime();

    private native String GetIPCountry();

    private native boolean GetImageSize(int var1, int[] var2, int[] var3);

    private native boolean GetImageRGBA(int var1, ByteBuffer var2, int var3, int var4);

    private native int GetCurrentBatteryPower();

    private native int GetAppID();

    private native void SetOverlayNotificationPosition(int var1);

    private native int GetIPCCallCount();

    private native boolean IsOverlayEnabled();
}

