/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.newdawn.slick.Color;
import org.newdawn.slick.Font;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.opengl.renderer.Renderer;
import org.newdawn.slick.opengl.renderer.SGL;
import org.newdawn.slick.util.Log;
import org.newdawn.slick.util.ResourceLoader;

public class AngelCodeFont
implements Font {
    private static SGL GL = Renderer.get();
    private static final int DISPLAY_LIST_CACHE_SIZE = 200;
    private static final int MAX_CHAR = 255;
    private boolean displayListCaching = true;
    private Image fontImage;
    private Glyph[] chars;
    private int lineHeight;
    private int baseDisplayListID = -1;
    private int eldestDisplayListID;
    private DisplayList eldestDisplayList;
    private boolean singleCase = false;
    private short ascent;
    private short descent;
    private short leading;
    private final LinkedHashMap displayLists = new LinkedHashMap(200, 1.0f, true){

        protected boolean removeEldestEntry(Map.Entry eldest) {
            AngelCodeFont.this.eldestDisplayList = (DisplayList)eldest.getValue();
            AngelCodeFont.this.eldestDisplayListID = ((AngelCodeFont)AngelCodeFont.this).eldestDisplayList.id;
            return false;
        }
    };

    public AngelCodeFont(String fntFile, Image image) throws SlickException {
        this.fontImage = image;
        this.parseFnt(ResourceLoader.getResourceAsStream(fntFile));
    }

    public AngelCodeFont(String fntFile, String imgFile) throws SlickException {
        this.fontImage = new Image(imgFile);
        this.parseFnt(ResourceLoader.getResourceAsStream(fntFile));
    }

    public AngelCodeFont(String fntFile, Image image, boolean caching) throws SlickException {
        this.fontImage = image;
        this.displayListCaching = caching;
        this.parseFnt(ResourceLoader.getResourceAsStream(fntFile));
    }

    public AngelCodeFont(String fntFile, String imgFile, boolean caching) throws SlickException {
        this.fontImage = new Image(imgFile);
        this.displayListCaching = caching;
        this.parseFnt(ResourceLoader.getResourceAsStream(fntFile));
    }

    public AngelCodeFont(String name, InputStream fntFile, InputStream imgFile) throws SlickException {
        this.fontImage = new Image(imgFile, name, false);
        this.parseFnt(fntFile);
    }

    public AngelCodeFont(String name, InputStream fntFile, InputStream imgFile, boolean caching) throws SlickException {
        this.fontImage = new Image(imgFile, name, false);
        this.displayListCaching = caching;
        this.parseFnt(fntFile);
    }

    private void parseFnt(InputStream fntFile) throws SlickException {
        if (this.displayListCaching) {
            this.baseDisplayListID = GL.glGenLists(200);
            if (this.baseDisplayListID == 0) {
                this.displayListCaching = false;
            }
        }
        try {
            short first;
            BufferedReader in = new BufferedReader(new InputStreamReader(fntFile));
            String info = in.readLine();
            String common = in.readLine();
            this.ascent = this.parseMetric(common, "base=");
            this.descent = this.parseMetric(common, "descent=");
            this.leading = this.parseMetric(common, "leading=");
            String page = in.readLine();
            HashMap<Short, ArrayList<Short>> kerning = new HashMap<Short, ArrayList<Short>>(64);
            ArrayList<Glyph> charDefs = new ArrayList<Glyph>(255);
            int maxChar = 0;
            boolean done = false;
            while (!done) {
                Glyph glyph;
                String line = in.readLine();
                if (line == null) {
                    done = true;
                    continue;
                }
                if (!line.startsWith("chars c") && line.startsWith("char") && (glyph = this.parseChar(line)) != null) {
                    maxChar = Math.max(maxChar, glyph.id);
                    charDefs.add(glyph);
                }
                if (line.startsWith("kernings c") || !line.startsWith("kerning")) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(line, " =");
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                first = Short.parseShort(stringTokenizer.nextToken());
                stringTokenizer.nextToken();
                int second = Integer.parseInt(stringTokenizer.nextToken());
                stringTokenizer.nextToken();
                int offset = Integer.parseInt(stringTokenizer.nextToken());
                ArrayList<Short> values = (ArrayList<Short>)kerning.get(first);
                if (values == null) {
                    values = new ArrayList<Short>();
                    kerning.put(first, values);
                }
                values.add((short)(offset << 8 | second));
            }
            this.chars = new Glyph[maxChar + 1];
            Iterator<Object> i$ = charDefs.iterator();
            while (i$.hasNext()) {
                Glyph glyph;
                this.chars[glyph.id] = glyph = (Glyph)i$.next();
            }
            for (Map.Entry entry : kerning.entrySet()) {
                first = (Short)entry.getKey();
                List valueList = (List)entry.getValue();
                short[] valueArray = new short[valueList.size()];
                for (int i = 0; i < valueList.size(); ++i) {
                    valueArray[i] = (Short)valueList.get(i);
                }
                this.chars[first].kerning = valueArray;
            }
        }
        catch (IOException e) {
            Log.error(e);
            throw new SlickException("Failed to parse font file: " + fntFile);
        }
    }

    public Image getImage() {
        return this.fontImage;
    }

    public void setSingleCase(boolean enabled) {
        this.singleCase = enabled;
    }

    public boolean isSingleCase() {
        return this.singleCase;
    }

    private short parseMetric(String str, String sub) {
        int ind = str.indexOf(sub);
        if (ind != -1) {
            String subStr;
            return Short.parseShort(subStr.substring(0, (ind = (subStr = str.substring(ind + sub.length())).indexOf(32)) != -1 ? ind : subStr.length()));
        }
        return -1;
    }

    private Glyph parseChar(String line) throws SlickException {
        StringTokenizer tokens = new StringTokenizer(line, " =");
        tokens.nextToken();
        tokens.nextToken();
        short id = Short.parseShort(tokens.nextToken());
        if (id < 0) {
            return null;
        }
        if (id > 255) {
            throw new SlickException("Invalid character '" + id + "': SpriteFont does not support characters above " + 255);
        }
        tokens.nextToken();
        short x = Short.parseShort(tokens.nextToken());
        tokens.nextToken();
        short y = Short.parseShort(tokens.nextToken());
        tokens.nextToken();
        short width = Short.parseShort(tokens.nextToken());
        tokens.nextToken();
        short height = Short.parseShort(tokens.nextToken());
        tokens.nextToken();
        short xoffset = Short.parseShort(tokens.nextToken());
        tokens.nextToken();
        short yoffset = Short.parseShort(tokens.nextToken());
        tokens.nextToken();
        short xadvance = Short.parseShort(tokens.nextToken());
        if (id != 32) {
            this.lineHeight = Math.max(height + yoffset, this.lineHeight);
        }
        Image img = this.fontImage.getSubImage(x, y, width, height);
        return new Glyph(id, x, y, width, height, xoffset, yoffset, xadvance, img);
    }

    @Override
    public void drawString(float x, float y, CharSequence text) {
        this.drawString(x, y, text, Color.white);
    }

    @Override
    public void drawString(float x, float y, CharSequence text, Color col) {
        this.drawString(x, y, text, col, 0, text.length() - 1);
    }

    @Override
    public void drawString(float x, float y, CharSequence text, Color col, int startIndex, int endIndex) {
        this.fontImage.bind();
        col.bind();
        GL.glTranslatef(x, y, 0.0f);
        if (this.displayListCaching && startIndex == 0 && endIndex == text.length() - 1) {
            DisplayList displayList = (DisplayList)this.displayLists.get(text);
            if (displayList != null) {
                GL.glCallList(displayList.id);
            } else {
                displayList = new DisplayList();
                displayList.text = text;
                int displayListCount = this.displayLists.size();
                if (displayListCount < 200) {
                    displayList.id = this.baseDisplayListID + displayListCount;
                } else {
                    displayList.id = this.eldestDisplayListID;
                    this.displayLists.remove(this.eldestDisplayList.text);
                }
                this.displayLists.put(text, displayList);
                GL.glNewList(displayList.id, 4865);
                this.render(text, startIndex, endIndex);
                GL.glEndList();
            }
        } else {
            this.render(text, startIndex, endIndex);
        }
        GL.glTranslatef(-x, -y, 0.0f);
    }

    private void render(CharSequence text, int start, int end) {
        GL.glBegin(7);
        int x = 0;
        int y = 0;
        Glyph lastCharDef = null;
        for (int i = 0; i < text.length(); ++i) {
            char id = text.charAt(i);
            if (id == '\n') {
                x = 0;
                y += this.getLineHeight();
                continue;
            }
            Glyph charDef = this.getGlyph(id);
            if (charDef == null) continue;
            x = lastCharDef != null ? (x += lastCharDef.getKerning(id)) : (x -= charDef.xoffset);
            lastCharDef = charDef;
            if (i >= start && i <= end) {
                charDef.image.drawEmbedded(x + charDef.xoffset, y + charDef.yoffset, charDef.width, charDef.height);
            }
            x += charDef.xadvance;
        }
        GL.glEnd();
    }

    public int getYOffset(String text) {
        DisplayList displayList = null;
        if (this.displayListCaching && (displayList = (DisplayList)this.displayLists.get(text)) != null && displayList.yOffset != null) {
            return displayList.yOffset.intValue();
        }
        int stopIndex = text.indexOf(10);
        if (stopIndex == -1) {
            stopIndex = text.length();
        }
        int minYOffset = 10000;
        for (int i = 0; i < stopIndex; ++i) {
            Glyph charDef = this.getGlyph(text.charAt(i));
            if (charDef == null) continue;
            minYOffset = Math.min(charDef.yoffset, minYOffset);
        }
        if (displayList != null) {
            displayList.yOffset = new Short((short)minYOffset);
        }
        return minYOffset;
    }

    @Override
    public int getHeight(CharSequence text) {
        DisplayList displayList = null;
        if (this.displayListCaching && (displayList = (DisplayList)this.displayLists.get(text)) != null && displayList.height != null) {
            return displayList.height.intValue();
        }
        int lines = 0;
        int maxHeight = 0;
        for (int i = 0; i < text.length(); ++i) {
            Glyph charDef;
            char id = text.charAt(i);
            if (id == '\n') {
                ++lines;
                maxHeight = 0;
                continue;
            }
            if (id == ' ' || (charDef = this.getGlyph(id)) == null) continue;
            maxHeight = Math.max(charDef.height + charDef.yoffset, maxHeight);
        }
        maxHeight += lines * this.getLineHeight();
        if (displayList != null) {
            displayList.height = new Short((short)maxHeight);
        }
        return maxHeight;
    }

    @Override
    public int getWidth(CharSequence text) {
        DisplayList displayList = null;
        if (this.displayListCaching && (displayList = (DisplayList)this.displayLists.get(text)) != null && displayList.width != null) {
            return displayList.width.intValue();
        }
        int maxWidth = 0;
        int width = 0;
        Glyph lastCharDef = null;
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            char id = text.charAt(i);
            if (id == '\n') {
                width = 0;
                continue;
            }
            Glyph charDef = this.getGlyph(id);
            if (charDef == null) continue;
            if (lastCharDef != null) {
                width += lastCharDef.getKerning(id);
            }
            lastCharDef = charDef;
            width = i < n - 1 || charDef.width == 0 ? (width += charDef.xadvance) : (width += charDef.width + charDef.xoffset);
            maxWidth = Math.max(maxWidth, width);
        }
        if (displayList != null) {
            displayList.width = new Short((short)maxWidth);
        }
        return maxWidth;
    }

    @Override
    public int getLineHeight() {
        return this.lineHeight;
    }

    public int getDescent() {
        return this.descent;
    }

    public int getAscent() {
        return this.ascent;
    }

    public Glyph getGlyph(char c) {
        Glyph g;
        Glyph glyph = g = c < '\u0000' || c >= this.chars.length ? null : this.chars[c];
        if (g != null) {
            return g;
        }
        if (g == null && this.singleCase) {
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            } else if (c >= 'a' && c <= 'z') {
                c = (char)(c - 32);
            }
        }
        return c < '\u0000' || c >= this.chars.length ? null : this.chars[c];
    }

    private static class DisplayList {
        int id;
        Short yOffset;
        Short width;
        Short height;
        CharSequence text;

        private DisplayList() {
        }
    }

    public static class Glyph {
        public final short id;
        public final short x;
        public final short y;
        public final short width;
        public final short height;
        public final short xoffset;
        public final short yoffset;
        public final short xadvance;
        public final Image image;
        protected short dlIndex;
        protected short[] kerning;

        protected Glyph(short id, short x, short y, short width, short height, short xoffset, short yoffset, short xadvance, Image image) {
            this.id = id;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.xoffset = xoffset;
            this.yoffset = yoffset;
            this.xadvance = xadvance;
            this.image = image;
        }

        public String toString() {
            return "[CharDef id=" + this.id + " x=" + this.x + " y=" + this.y + "]";
        }

        public int getKerning(int otherCodePoint) {
            if (this.kerning == null) {
                return 0;
            }
            int low = 0;
            int high = this.kerning.length - 1;
            while (low <= high) {
                int midIndex = low + high >>> 1;
                short value = this.kerning[midIndex];
                int foundCodePoint = value & 0xFF;
                if (foundCodePoint < otherCodePoint) {
                    low = midIndex + 1;
                    continue;
                }
                if (foundCodePoint > otherCodePoint) {
                    high = midIndex - 1;
                    continue;
                }
                return value >> 8;
            }
            return 0;
        }
    }
}

