/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.opengl;

import java.nio.ByteBuffer;

public interface ImageData {
    public Format getFormat();

    public int getWidth();

    public int getHeight();

    public int getTexWidth();

    public int getTexHeight();

    public ByteBuffer getImageBufferData();

    public static enum Format {
        RGB(3, 24, false, 6407),
        BGRA(4, 32, true, 32993),
        RGBA(4, 32, true, 6408),
        ALPHA(1, 8, true, 6406),
        GRAY(1, 8, false, 6409),
        GRAYALPHA(2, 16, true, 6410);

        private final boolean alpha;
        private final int bitdepth;
        private final int components;
        private final int OGLtype;

        private Format(int comp, int depth, boolean hasAlpha, int openGL) {
            this.components = comp;
            this.bitdepth = depth;
            this.alpha = hasAlpha;
            this.OGLtype = openGL;
        }

        public boolean hasAlpha() {
            return this.alpha;
        }

        public int getBitPerPixel() {
            return this.bitdepth;
        }

        public int getBitPerColor() {
            return this.bitdepth / this.components;
        }

        public int getColorComponents() {
            return this.components;
        }

        public int getOGLType() {
            return this.OGLtype;
        }
    }
}

