/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.opengl.shader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.ARBVertexShader;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;
import org.newdawn.slick.Color;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.util.Log;
import org.newdawn.slick.util.ResourceLoader;

public class ShaderProgram {
    public static final int VERTEX_SHADER = 35633;
    public static final int FRAGMENT_SHADER = 35632;
    private static boolean strict = true;
    protected int program;
    protected String log = "";
    protected HashMap<String, Integer> uniforms = new HashMap();
    protected HashMap<String, Integer> attributes = new HashMap();
    protected String vertShaderSource;
    protected String fragShaderSource;
    protected int vert;
    protected int frag;
    private FloatBuffer buf4;
    private IntBuffer ibuf4;

    public static boolean isSupported() {
        ContextCapabilities c = GLContext.getCapabilities();
        return c.GL_ARB_shader_objects && c.GL_ARB_vertex_shader && c.GL_ARB_fragment_shader;
    }

    public static void setStrictMode(boolean enabled) {
        strict = enabled;
    }

    public static boolean isStrictMode() {
        return strict;
    }

    public static void unbindAll() {
        ARBShaderObjects.glUseProgramObjectARB((int)0);
    }

    public static ShaderProgram loadProgram(String vertFile, String fragFile) throws SlickException {
        return new ShaderProgram(ShaderProgram.readFile(vertFile), ShaderProgram.readFile(fragFile));
    }

    public static String readFile(String ref) throws SlickException {
        InputStream in = ResourceLoader.getResourceAsStream(ref);
        try {
            return ShaderProgram.readFile(in);
        }
        catch (SlickException e) {
            throw new SlickException("could not load source file: " + ref);
        }
    }

    public static String readFile(InputStream in) throws SlickException {
        try {
            int cnt;
            StringBuffer sBuffer = new StringBuffer();
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            char[] buffer = new char[1024];
            while ((cnt = br.read(buffer, 0, buffer.length)) > -1) {
                sBuffer.append(buffer, 0, cnt);
            }
            br.close();
            return sBuffer.toString();
        }
        catch (IOException e) {
            throw new SlickException("could not load source file");
        }
    }

    public ShaderProgram(String vertexShaderSource, String fragShaderSource) throws SlickException {
        if (vertexShaderSource == null || fragShaderSource == null) {
            throw new IllegalArgumentException("shader source must be non-null");
        }
        if (!ShaderProgram.isSupported()) {
            throw new SlickException("no shader support found; driver does not support extension GL_ARB_shader_objects");
        }
        this.vertShaderSource = vertexShaderSource;
        this.fragShaderSource = fragShaderSource;
        this.vert = this.compileShader(35633, vertexShaderSource);
        this.frag = this.compileShader(35632, fragShaderSource);
        this.program = this.createProgram();
        try {
            this.linkProgram();
        }
        catch (SlickException e) {
            this.release();
            throw e;
        }
        if (this.log != null && this.log.length() != 0) {
            Log.warn("GLSL Info: " + this.log);
        }
    }

    protected ShaderProgram() {
    }

    protected int createProgram() throws SlickException {
        if (!ShaderProgram.isSupported()) {
            throw new SlickException("no shader support found; driver does not support extension GL_ARB_shader_objects");
        }
        int program = ARBShaderObjects.glCreateProgramObjectARB();
        if (program == 0) {
            throw new SlickException("could not create program; check ShaderProgram.isSupported()");
        }
        return program;
    }

    private String shaderTypeString(int type) {
        if (type == 35632) {
            return "FRAGMENT_SHADER";
        }
        if (type == 35633) {
            return "VERTEX_SHADER";
        }
        if (type == 36313) {
            return "GEOMETRY_SHADER";
        }
        return "shader";
    }

    protected int compileShader(int type, String source) throws SlickException {
        int shader = ARBShaderObjects.glCreateShaderObjectARB((int)type);
        if (shader == 0) {
            throw new SlickException("could not create shader object; check ShaderProgram.isSupported()");
        }
        ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)source);
        ARBShaderObjects.glCompileShaderARB((int)shader);
        int comp = ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35713);
        int len = ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35716);
        String t = this.shaderTypeString(type);
        String err = ARBShaderObjects.glGetInfoLogARB((int)shader, (int)len);
        if (err != null && err.length() != 0) {
            this.log = this.log + t + " compile log:\n" + err + "\n";
        }
        if (comp == 0) {
            throw new SlickException(this.log);
        }
        return shader;
    }

    protected void attachShaders() {
        ARBShaderObjects.glAttachObjectARB((int)this.getID(), (int)this.vert);
        ARBShaderObjects.glAttachObjectARB((int)this.getID(), (int)this.frag);
    }

    protected void linkProgram() throws SlickException {
        if (!this.valid()) {
            throw new SlickException("trying to link an invalid (i.e. released) program");
        }
        this.uniforms.clear();
        this.attributes.clear();
        this.attachShaders();
        ARBShaderObjects.glLinkProgramARB((int)this.program);
        int comp = ARBShaderObjects.glGetObjectParameteriARB((int)this.program, (int)35714);
        int len = ARBShaderObjects.glGetObjectParameteriARB((int)this.program, (int)35716);
        String err = ARBShaderObjects.glGetInfoLogARB((int)this.program, (int)len);
        if (err != null && err.length() != 0) {
            this.log = err + "\n" + this.log;
        }
        if (this.log != null) {
            this.log = this.log.trim();
        }
        if (comp == 0) {
            throw new SlickException(this.log);
        }
        this.fetchUniforms();
        this.fetchAttributes();
    }

    public String getLog() {
        return this.log;
    }

    public void bind() {
        if (!this.valid()) {
            throw new IllegalStateException("trying to enable a program that is not valid");
        }
        ARBShaderObjects.glUseProgramObjectARB((int)this.program);
    }

    public void unbind() {
        ShaderProgram.unbindAll();
    }

    public void releaseShaders() {
        this.unbind();
        if (this.vert != 0) {
            ARBShaderObjects.glDetachObjectARB((int)this.getID(), (int)this.vert);
            ARBShaderObjects.glDeleteObjectARB((int)this.vert);
            this.vert = 0;
        }
        if (this.frag != 0) {
            ARBShaderObjects.glDetachObjectARB((int)this.getID(), (int)this.frag);
            ARBShaderObjects.glDeleteObjectARB((int)this.frag);
            this.frag = 0;
        }
    }

    public void release() {
        if (this.program != 0) {
            this.unbind();
            this.releaseShaders();
            ARBShaderObjects.glDeleteObjectARB((int)this.program);
            this.program = 0;
        }
    }

    public int getVertexShaderID() {
        return this.vert;
    }

    public int getFragmentShaderID() {
        return this.frag;
    }

    public String getVertexShaderSource() {
        return this.vertShaderSource;
    }

    public String getFragmentShaderSource() {
        return this.fragShaderSource;
    }

    public int getID() {
        return this.program;
    }

    public boolean valid() {
        return this.program != 0;
    }

    private void fetchUniforms() {
        int len = ARBShaderObjects.glGetObjectParameteriARB((int)this.program, (int)35718);
        int strLen = ARBShaderObjects.glGetObjectParameteriARB((int)this.program, (int)35719);
        for (int i = 0; i < len; ++i) {
            String name = ARBShaderObjects.glGetActiveUniformARB((int)this.program, (int)i, (int)strLen);
            int id = ARBShaderObjects.glGetUniformLocationARB((int)this.program, (CharSequence)name);
            this.uniforms.put(name, id);
        }
    }

    private void fetchAttributes() {
        int len = ARBShaderObjects.glGetObjectParameteriARB((int)this.program, (int)35721);
        int strLen = ARBShaderObjects.glGetObjectParameteriARB((int)this.program, (int)35722);
        for (int i = 0; i < len; ++i) {
            String name = ARBVertexShader.glGetActiveAttribARB((int)this.program, (int)i, (int)strLen);
            int id = ARBVertexShader.glGetAttribLocationARB((int)this.program, (CharSequence)name);
            this.attributes.put(name, id);
        }
    }

    public int getUniformID(String name) {
        int location;
        Integer locI = this.uniforms.get(name);
        int n = location = locI == null ? -1 : locI;
        if (location != -1) {
            return location;
        }
        location = ARBShaderObjects.glGetUniformLocationARB((int)this.program, (CharSequence)name);
        if (location == -1 && strict) {
            throw new IllegalArgumentException("no active uniform by name '" + name + "' (disable strict compiling to suppress warnings)");
        }
        this.uniforms.put(name, location);
        return location;
    }

    public int getAttributeID(String name) {
        int location = this.attributes.get(name);
        if (location != -1) {
            return location;
        }
        location = ARBVertexShader.glGetAttribLocationARB((int)this.program, (CharSequence)name);
        if (location == -1 && strict) {
            throw new IllegalArgumentException("no active attribute by name '" + name + "'");
        }
        this.attributes.put(name, location);
        return location;
    }

    public String[] getAttributes() {
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    public String[] getUniformNames() {
        return this.uniforms.keySet().toArray(new String[this.uniforms.size()]);
    }

    public boolean enableVertexAttribute(String name) {
        int id = this.getAttributeID(name);
        if (id == -1) {
            return false;
        }
        ARBVertexShader.glEnableVertexAttribArrayARB((int)id);
        return true;
    }

    public boolean disableVertexAttribute(String name) {
        int id = this.getAttributeID(name);
        if (id == -1) {
            return false;
        }
        ARBVertexShader.glDisableVertexAttribArrayARB((int)id);
        return true;
    }

    public void setUniform4f(String name, Color color) {
        this.setUniform4f(name, color.r, color.g, color.b, color.a);
    }

    public void setUniform2f(String name, Vector2f vec) {
        this.setUniform2f(name, vec.x, vec.y);
    }

    private FloatBuffer uniformf(String name) {
        if (this.buf4 == null) {
            this.buf4 = BufferUtils.createFloatBuffer((int)4);
        }
        this.buf4.clear();
        this.getUniform(name, this.buf4);
        return this.buf4;
    }

    private IntBuffer uniformi(String name) {
        if (this.ibuf4 == null) {
            this.ibuf4 = BufferUtils.createIntBuffer((int)4);
        }
        this.ibuf4.clear();
        this.getUniform(name, this.ibuf4);
        return this.ibuf4;
    }

    public int getUniform1i(String name) {
        return this.uniformi(name).get(0);
    }

    public int[] getUniform2i(String name) {
        IntBuffer buf = this.uniformi(name);
        return new int[]{buf.get(0), buf.get(1)};
    }

    public int[] getUniform3i(String name) {
        IntBuffer buf = this.uniformi(name);
        return new int[]{buf.get(0), buf.get(1), buf.get(2)};
    }

    public int[] getUniform4i(String name) {
        IntBuffer buf = this.uniformi(name);
        return new int[]{buf.get(0), buf.get(1), buf.get(2), buf.get(3)};
    }

    public float getUniform1f(String name) {
        return this.uniformf(name).get(0);
    }

    public float[] getUniform2f(String name) {
        FloatBuffer buf = this.uniformf(name);
        return new float[]{buf.get(0), buf.get(1)};
    }

    public float[] getUniform3f(String name) {
        FloatBuffer buf = this.uniformf(name);
        return new float[]{buf.get(0), buf.get(1), buf.get(2)};
    }

    public float[] getUniform4f(String name) {
        FloatBuffer buf = this.uniformf(name);
        return new float[]{buf.get(0), buf.get(1), buf.get(2), buf.get(3)};
    }

    public boolean getUniform(String name, FloatBuffer buf) {
        int id = this.getUniformID(name);
        if (id == -1) {
            return false;
        }
        ARBShaderObjects.glGetUniformARB((int)this.program, (int)id, (FloatBuffer)buf);
        return true;
    }

    public boolean getUniform(String name, IntBuffer buf) {
        int id = this.getUniformID(name);
        if (id == -1) {
            return false;
        }
        ARBShaderObjects.glGetUniformARB((int)this.program, (int)id, (IntBuffer)buf);
        return true;
    }

    public boolean hasUniform(String name) {
        return this.uniforms.containsKey(name);
    }

    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public void setUniform1f(String name, float f) {
        int id = this.getUniformID(name);
        if (id == -1) {
            return;
        }
        ARBShaderObjects.glUniform1fARB((int)id, (float)f);
    }

    public void setUniform1i(String name, int i) {
        int id = this.getUniformID(name);
        if (id == -1) {
            return;
        }
        ARBShaderObjects.glUniform1iARB((int)id, (int)i);
    }

    public void setUniform2f(String name, float a, float b) {
        int id = this.getUniformID(name);
        if (id == -1) {
            return;
        }
        ARBShaderObjects.glUniform2fARB((int)id, (float)a, (float)b);
    }

    public void setUniform3f(String name, float a, float b, float c) {
        int id = this.getUniformID(name);
        if (id == -1) {
            return;
        }
        ARBShaderObjects.glUniform3fARB((int)id, (float)a, (float)b, (float)c);
    }

    public void setUniform4f(String name, float a, float b, float c, float d) {
        int id = this.getUniformID(name);
        if (id == -1) {
            return;
        }
        ARBShaderObjects.glUniform4fARB((int)id, (float)a, (float)b, (float)c, (float)d);
    }

    public void setUniform2i(String name, int a, int b) {
        int id = this.getUniformID(name);
        if (id == -1) {
            return;
        }
        ARBShaderObjects.glUniform2iARB((int)id, (int)a, (int)b);
    }

    public void setUniform3i(String name, int a, int b, int c) {
        int id = this.getUniformID(name);
        if (id == -1) {
            return;
        }
        ARBShaderObjects.glUniform3iARB((int)id, (int)a, (int)b, (int)c);
    }

    public void setUniform4i(String name, int a, int b, int c, int d) {
        int id = this.getUniformID(name);
        if (id == -1) {
            return;
        }
        ARBShaderObjects.glUniform4iARB((int)id, (int)a, (int)b, (int)c, (int)d);
    }

    public void setMatrix2(String name, boolean transpose, FloatBuffer buf) {
        int id = this.getUniformID(name);
        if (id == -1) {
            return;
        }
        ARBShaderObjects.glUniformMatrix2ARB((int)id, (boolean)transpose, (FloatBuffer)buf);
    }

    public void setMatrix3(String name, boolean transpose, FloatBuffer buf) {
        int id = this.getUniformID(name);
        if (id == -1) {
            return;
        }
        ARBShaderObjects.glUniformMatrix3ARB((int)id, (boolean)transpose, (FloatBuffer)buf);
    }

    public void setMatrix4(String name, boolean transpose, FloatBuffer buf) {
        int id = this.getUniformID(name);
        if (id == -1) {
            return;
        }
        ARBShaderObjects.glUniformMatrix4ARB((int)id, (boolean)transpose, (FloatBuffer)buf);
    }
}

