/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tests;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import org.newdawn.slick.BasicGame;
import org.newdawn.slick.CanvasGameContainer;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;

public class CanvasSizeTest
extends BasicGame {
    private Image image;

    public CanvasSizeTest() {
        super("Test");
    }

    @Override
    public void init(GameContainer container) throws SlickException {
        System.out.println(container.getWidth() + ", " + container.getHeight());
        container.getGraphics().setBackground(Color.gray);
        this.image = new Image("testdata/logo.png");
    }

    @Override
    public void render(GameContainer container, Graphics g) throws SlickException {
        this.image.draw((float)container.getWidth() / 2.0f - (float)this.image.getWidth() / 2.0f, (float)container.getHeight() / 2.0f - (float)this.image.getHeight() / 2.0f);
    }

    @Override
    public void update(GameContainer container, int delta) throws SlickException {
    }

    public static void main(String[] argv) {
        try {
            CanvasSizeTest game = new CanvasSizeTest();
            final CanvasGameContainer container = new CanvasGameContainer(game);
            final JFrame frame = new JFrame(game.getTitle());
            frame.setDefaultCloseOperation(3);
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    frame.setVisible(false);
                    container.getContainer().exit();
                }
            });
            frame.getContentPane().setBackground(java.awt.Color.black);
            container.setSize(800, 600);
            frame.getContentPane().add(container);
            frame.pack();
            frame.setResizable(true);
            frame.setLocationRelativeTo(null);
            container.requestFocusInWindow();
            frame.setVisible(true);
            container.start();
        }
        catch (SlickException ex) {
            ex.printStackTrace();
        }
    }
}

