/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tests;

import java.io.File;
import org.newdawn.slick.AppGameContainer;
import org.newdawn.slick.BasicGame;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.util.FileSystemLocation;
import org.newdawn.slick.util.ResourceLoader;

public class ImageFormatTest
extends BasicGame {
    private Image rgbaImage;
    private Image rgbImage;
    private Image grayScaleImage;
    private Image grayScaleAlphaImage;
    private int rgbaImageSize;
    private int rgbImageSize;
    private int grayScaleImageSize;
    private int grayScaleAlphaImageSize;

    public ImageFormatTest() {
        super("Image Format Test");
    }

    @Override
    public void init(GameContainer container) throws SlickException {
        try {
            ResourceLoader.addResourceLocation(new FileSystemLocation(new File("./trunk/Slick/")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.rgbaImage = new Image("testdata/logo.png");
        this.rgbImage = new Image("testdata/logo_rgb.png");
        this.grayScaleImage = new Image("testdata/logo_luminance.png");
        this.grayScaleAlphaImage = new Image("testdata/logo_luminance_alpha.png");
        this.rgbaImageSize = this.rgbaImage.getTexture().getTextureData().length;
        this.rgbImageSize = this.rgbImage.getTexture().getTextureData().length;
        this.grayScaleImageSize = this.grayScaleImage.getTexture().getTextureData().length;
        this.grayScaleAlphaImageSize = this.grayScaleAlphaImage.getTexture().getTextureData().length;
    }

    @Override
    public void update(GameContainer container, int delta) throws SlickException {
    }

    @Override
    public void render(GameContainer container, Graphics g) throws SlickException {
        int effectiveWidth = container.getWidth() - this.rgbaImage.getWidth();
        int effectiveHeight = container.getHeight() - this.rgbaImage.getHeight();
        int xStep = effectiveWidth / 4;
        int yStep = effectiveHeight / 4;
        g.clear();
        g.setColor(Color.blue);
        g.fillRect(0.0f, 0.0f, 800.0f, 600.0f);
        g.setColor(Color.orange);
        int posX = xStep / 2;
        int posY = yStep / 2;
        g.drawImage(this.rgbaImage, posX, posY);
        g.drawString(Integer.toString(this.rgbaImageSize) + " Bytes", posX, posY - 15);
        g.drawImage(this.rgbImage, posX += xStep, posY += yStep);
        g.drawString(Integer.toString(this.rgbImageSize) + " Bytes", posX, posY - 15);
        g.drawImage(this.grayScaleAlphaImage, posX += xStep, posY += yStep);
        g.drawString(Integer.toString(this.grayScaleAlphaImageSize) + " Bytes", posX, posY - 15);
        g.drawImage(this.grayScaleImage, posX += xStep, posY += yStep);
        g.drawString(Integer.toString(this.grayScaleImageSize) + " Bytes", posX, posY - 15);
    }

    public static void main(String[] argv) {
        boolean sharedContextTest = false;
        try {
            AppGameContainer container = new AppGameContainer(new ImageFormatTest());
            container.setDisplayMode(800, 600, false);
            container.start();
        }
        catch (SlickException e) {
            e.printStackTrace();
        }
    }
}

