/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tests;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.newdawn.slick.AppGameContainer;
import org.newdawn.slick.BasicGame;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.Input;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.opengl.ImageData;
import org.newdawn.slick.opengl.ImageDataFactory;
import org.newdawn.slick.opengl.InternalTextureLoader;
import org.newdawn.slick.opengl.LoadableImageData;
import org.newdawn.slick.opengl.TextureImpl;
import org.newdawn.slick.util.Log;
import org.newdawn.slick.util.ResourceLoader;

public class MipmapTest
extends BasicGame {
    Image image;
    Image mippedImage;
    float scale = 1.0f;
    boolean supported = false;

    public static void main(String[] args) throws SlickException {
        new AppGameContainer(new MipmapTest(), 800, 600, false).start();
    }

    public MipmapTest() {
        super("TestClass");
    }

    @Override
    public void init(GameContainer c) throws SlickException {
        this.supported = InternalTextureLoader.isGenerateMipmapSupported();
        String ref = "testdata/hiero.png";
        this.image = new Image(ref);
        this.mippedImage = this.supported ? this.createMipmapImage(ref) : this.image;
    }

    private Image createMipmapImage(String ref) throws SlickException {
        try {
            InputStream in = ResourceLoader.getResourceAsStream(ref);
            LoadableImageData imageData = ImageDataFactory.getImageDataFor(ref);
            ByteBuffer buf = imageData.loadImage(new BufferedInputStream(in), false, null);
            ImageData.Format fmt = imageData.getFormat();
            int minFilter = 9987;
            int magFilter = 9729;
            TextureImpl tex = InternalTextureLoader.get().createTexture(imageData, buf, ref, 3553, minFilter, magFilter, true, fmt);
            return new Image(tex);
        }
        catch (IOException e) {
            Log.error("error loading image", e);
            throw new SlickException("error loading image " + e.getMessage());
        }
    }

    @Override
    public void render(GameContainer c, Graphics g) throws SlickException {
        if (!this.supported) {
            g.drawString("Your OpenGL version does not support automatic mipmap generation", 10.0f, 25.0f);
        } else {
            g.drawString("Left = no mipmapping, right = automatically generated mipmaps", 10.0f, 25.0f);
        }
        this.image.draw(10.0f, 80.0f, this.scale);
        this.mippedImage.draw((float)this.image.getWidth() * this.scale + 25.0f, 80.0f, this.scale);
    }

    @Override
    public void update(GameContainer c, int delta) throws SlickException {
        Input in = c.getInput();
        if (in.isKeyDown(200)) {
            this.scale = Math.min(2.0f, this.scale + 0.001f);
        } else if (in.isKeyDown(208)) {
            this.scale = Math.max(0.01f, this.scale - 0.001f);
        }
    }
}

