/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tests;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import org.newdawn.slick.AppGameContainer;
import org.newdawn.slick.BasicGame;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.opengl.InternalTextureLoader;
import org.newdawn.slick.opengl.Texture;

public class URLImageTest
extends BasicGame {
    Texture tex;
    int texWidth;
    int texHeight;
    Image img;
    ByteBuffer buffer;

    public static void main(String[] args) throws SlickException {
        new AppGameContainer(new URLImageTest(), 800, 600, false).start();
    }

    public URLImageTest() {
        super("TestClass");
    }

    @Override
    public void init(GameContainer c) throws SlickException {
    }

    @Override
    public void render(GameContainer c, Graphics g) throws SlickException {
        if (this.img != null) {
            this.img.draw(50.0f, 50.0f);
        }
        g.drawString("Press SPACE to load image from URL", 10.0f, 25.0f);
    }

    @Override
    public void update(GameContainer c, int delta) throws SlickException {
        if (c.getInput().isKeyPressed(57)) {
            try {
                String ref = "http://upload.wikimedia.org/wikipedia/commons/6/63/Wikipedia-logo.png";
                URL u = new URL(ref);
                InputStream is = u.openStream();
                BufferedInputStream in = new BufferedInputStream(is);
                in.mark(is.available());
                if (this.img != null) {
                    this.img.destroy();
                }
                this.tex = InternalTextureLoader.get().getTexture(is, ".png", false, 9728);
                is.close();
                this.img = new Image(this.tex);
            }
            catch (Exception e) {
                if (this.img != null) {
                    this.img.destroy();
                }
                this.img = null;
                e.printStackTrace();
            }
        }
    }
}

