/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tests.shader;

import org.lwjgl.Sys;
import org.newdawn.slick.AppGameContainer;
import org.newdawn.slick.BasicGame;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.opengl.shader.ShaderProgram;

public class ShaderLesson1
extends BasicGame {
    private ShaderProgram program;
    private boolean shaderWorks = false;

    public static void main(String[] args) throws SlickException {
        new AppGameContainer(new ShaderLesson1(), 800, 600, false).start();
    }

    public ShaderLesson1() {
        super("Shader Lesson 1");
    }

    @Override
    public void init(GameContainer container) throws SlickException {
        if (!ShaderProgram.isSupported()) {
            Sys.alert((String)"Error", (String)"Your graphics card doesn't support OpenGL shaders.");
            container.exit();
            return;
        }
        try {
            String VERT = "testdata/shaders/pass.vert";
            String FRAG = "testdata/shaders/lesson1.frag";
            this.program = ShaderProgram.loadProgram("testdata/shaders/pass.vert", "testdata/shaders/lesson1.frag");
            this.shaderWorks = true;
        }
        catch (SlickException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void render(GameContainer container, Graphics g) throws SlickException {
        if (this.shaderWorks) {
            this.program.bind();
        }
        g.fillRect(220.0f, 200.0f, 50.0f, 50.0f);
        if (this.shaderWorks) {
            this.program.unbind();
        }
        String txt = this.shaderWorks ? "Shader works!" : "Shader did not compile, check log";
        g.drawString(txt, 10.0f, 25.0f);
    }

    @Override
    public void update(GameContainer container, int delta) throws SlickException {
    }
}

