/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tiled;

import java.util.Properties;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.geom.Polygon;
import org.newdawn.slick.tiled.TileSet;
import org.newdawn.slick.tiled.TiledMapPlus;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GroupObject {
    public int index;
    public String name = "";
    public String type = "";
    public int x = 0;
    public int y = 0;
    public int width = 0;
    public int height = 0;
    String image;
    public Properties props;
    public int gid = -1;
    TiledMapPlus map;
    ObjectType objectType;
    Polygon points;

    public GroupObject(Element element) throws SlickException {
        NodeList properties;
        if (element.getAttribute("gid") != "") {
            this.gid = Integer.parseInt(element.getAttribute("gid"));
            this.objectType = ObjectType.IMAGE;
        }
        this.objectType = element.getElementsByTagName("polyline").item(0) != null ? ObjectType.POLYLINE : (element.getElementsByTagName("polygon").item(0) != null ? ObjectType.POLYGON : ObjectType.RECTANGLE);
        if (this.objectType == ObjectType.IMAGE) {
            if (element.getAttribute("width") != "") {
                this.width = Integer.parseInt(element.getAttribute("width"));
            }
            if (element.getAttribute("height") != "") {
                this.height = Integer.parseInt(element.getAttribute("height"));
            }
            if (element.getAttribute("name") != "") {
                this.name = element.getAttribute("name");
            }
            if (element.getAttribute("type") != "") {
                this.type = element.getAttribute("type");
            }
        } else if (this.objectType == ObjectType.POLYGON || this.objectType == ObjectType.POLYLINE) {
            String[] pointsFormatted;
            this.name = element.getAttribute("name");
            Element polyLine = this.objectType == ObjectType.POLYGON ? (Element)element.getElementsByTagName("polygon").item(0) : (Element)element.getElementsByTagName("polyline").item(0);
            String pointsUnformatted = polyLine.getAttribute("points");
            for (String pointS : pointsFormatted = pointsUnformatted.split(" ")) {
                String[] pointArray = pointS.split(",");
                float pointX = Float.parseFloat(pointArray[0]);
                float pointY = Float.parseFloat(pointArray[1]);
                this.points.addPoint(pointX, pointY);
            }
        } else if (this.objectType == ObjectType.RECTANGLE) {
            this.objectType = ObjectType.RECTANGLE;
            this.width = Integer.parseInt(element.getAttribute("width"));
            this.height = Integer.parseInt(element.getAttribute("height"));
            this.name = element.getAttribute("name");
            this.type = element.getAttribute("type");
        }
        this.x = Integer.parseInt(element.getAttribute("x"));
        this.y = Integer.parseInt(element.getAttribute("y"));
        Element propsElement = (Element)element.getElementsByTagName("properties").item(0);
        if (propsElement != null && (properties = propsElement.getElementsByTagName("property")) != null) {
            this.props = new Properties();
            for (int p = 0; p < properties.getLength(); ++p) {
                Element propElement = (Element)properties.item(p);
                String name = propElement.getAttribute("name");
                String value = propElement.getAttribute("value");
                this.props.setProperty(name, value);
            }
        }
    }

    public GroupObject(Element element, TiledMapPlus map) throws SlickException {
        NodeList properties;
        this.map = map;
        if (element.getAttribute("gid") != "") {
            this.gid = Integer.parseInt(element.getAttribute("gid"));
            this.objectType = ObjectType.IMAGE;
        }
        if (this.objectType == ObjectType.IMAGE) {
            if (element.getAttribute("width") != "") {
                this.width = Integer.parseInt(element.getAttribute("width"));
            }
            if (element.getAttribute("height") != "") {
                this.height = Integer.parseInt(element.getAttribute("height"));
            }
            if (element.getAttribute("name") != "") {
                this.name = element.getAttribute("name");
            }
            if (element.getAttribute("type") != "") {
                this.type = element.getAttribute("type");
            }
        } else if (this.objectType == ObjectType.RECTANGLE) {
            this.width = Integer.parseInt(element.getAttribute("width"));
            this.height = Integer.parseInt(element.getAttribute("height"));
            this.name = element.getAttribute("name");
            this.type = element.getAttribute("type");
        } else if (this.objectType == ObjectType.POLYGON) {
            String[] pointsFormatted;
            this.name = element.getAttribute("name");
            Element polyLine = (Element)element.getElementsByTagName("polyline").item(0);
            String pointsUnformatted = polyLine.getAttribute("points");
            for (String pointS : pointsFormatted = pointsUnformatted.split(" ")) {
                String[] pointArray = pointS.split(",");
                float pointX = Float.parseFloat(pointArray[0]);
                float pointY = Float.parseFloat(pointArray[1]);
                this.points.addPoint(pointX, pointY);
            }
        }
        this.x = Integer.parseInt(element.getAttribute("x"));
        this.y = Integer.parseInt(element.getAttribute("y"));
        Element propsElement = (Element)element.getElementsByTagName("properties").item(0);
        if (propsElement != null && (properties = propsElement.getElementsByTagName("property")) != null) {
            this.props = new Properties();
            for (int p = 0; p < properties.getLength(); ++p) {
                Element propElement = (Element)properties.item(p);
                String name = propElement.getAttribute("name");
                String value = propElement.getAttribute("value");
                this.props.setProperty(name, value);
            }
        }
    }

    public void putProperty(String propertyKey, String propertyValue) {
        this.props.put(propertyKey, propertyValue);
    }

    public void removeProperty(String propertyKey) {
        this.props.remove(propertyKey);
    }

    public Image getImage() throws SlickException {
        if (this.objectType != ObjectType.IMAGE) {
            throw new SlickException("Object isn't an image object");
        }
        if (this.map == null) {
            throw new SlickException("Object doesn't belong to a map of type TiledMapPlus");
        }
        TileSet tileset = this.map.getTileSetByGID(this.gid);
        int tilesetTileID = this.gid - tileset.firstGID;
        return tileset.tiles.getSubImage(tileset.getTileX(tilesetTileID), tileset.getTileY(tilesetTileID), tileset.tileWidth, tileset.tileHeight);
    }

    public static enum ObjectType {
        IMAGE,
        RECTANGLE,
        POLYGON,
        POLYLINE;

    }
}

