/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tiled;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.tiled.Base64;
import org.newdawn.slick.tiled.GroupObject;
import org.newdawn.slick.tiled.Layer;
import org.newdawn.slick.tiled.ObjectGroup;
import org.newdawn.slick.tiled.Tile;
import org.newdawn.slick.tiled.TileSet;
import org.newdawn.slick.tiled.TiledMap;
import org.newdawn.slick.util.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TiledMapPlus
extends TiledMap {
    private HashMap<String, Integer> objectGroupNameToOffset = new HashMap();
    private HashMap<String, Integer> layerNameToIDMap = new HashMap();
    private HashMap<String, Integer> tilesetNameToIDMap = new HashMap();

    public TiledMapPlus(String ref) throws SlickException {
        this(ref, true);
    }

    public TiledMapPlus(String ref, boolean loadTileSets) throws SlickException {
        super(ref, loadTileSets);
        this.processNameToObjectMap();
        this.processLayerMap();
        this.processTilesetMap();
    }

    public TiledMapPlus(String ref, String tileSetsLocation) throws SlickException {
        super(ref, tileSetsLocation);
        this.processNameToObjectMap();
        this.processLayerMap();
        this.processTilesetMap();
    }

    public TiledMapPlus(InputStream in) throws SlickException {
        super(in);
        this.processNameToObjectMap();
        this.processLayerMap();
        this.processTilesetMap();
    }

    public TiledMapPlus(InputStream in, String tileSetsLocation) throws SlickException {
        super(in, tileSetsLocation);
        this.processNameToObjectMap();
        this.processLayerMap();
        this.processTilesetMap();
    }

    private void processNameToObjectMap() {
        for (int i = 0; i < this.getObjectGroupCount(); ++i) {
            ObjectGroup g = (ObjectGroup)this.objectGroups.get(i);
            this.objectGroupNameToOffset.put(g.name, i);
            HashMap<String, Integer> nameToObjectMap = new HashMap<String, Integer>();
            for (int ib = 0; ib < this.getObjectCount(i); ++ib) {
                nameToObjectMap.put(this.getObjectName(i, ib), ib);
            }
            g.setObjectNameMapping(nameToObjectMap);
        }
    }

    private void processLayerMap() {
        for (int l = 0; l < this.layers.size(); ++l) {
            Layer layer = (Layer)this.layers.get(l);
            this.layerNameToIDMap.put(layer.name, l);
        }
    }

    private void processTilesetMap() {
        for (int t = 0; t < this.getTileSetCount(); ++t) {
            TileSet tileSet = this.getTileSet(t);
            this.tilesetNameToIDMap.put(tileSet.name, t);
        }
    }

    public Layer getLayer(String layerName) {
        int layerID = this.layerNameToIDMap.get(layerName);
        return (Layer)this.layers.get(layerID);
    }

    public ObjectGroup getObjectGroup(String groupName) {
        return (ObjectGroup)this.objectGroups.get(this.objectGroupNameToOffset.get(groupName));
    }

    public ArrayList<ObjectGroup> getObjectGroups() {
        return this.objectGroups;
    }

    public ArrayList<Tile> getAllTilesFromAllLayers(String tilesetName) {
        ArrayList<Tile> tiles = new ArrayList<Tile>();
        int tilesetID = this.tilesetNameToIDMap.get(tilesetName);
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                for (int l = 0; l < this.getLayerCount(); ++l) {
                    Layer layer = (Layer)this.layers.get(l);
                    if (layer.data[x][y][0] != tilesetID) continue;
                    Tile t = new Tile(x, y, layer.name, layer.data[x][y][2], tilesetName);
                    tiles.add(t);
                }
            }
        }
        return tiles;
    }

    public void write(OutputStream o) throws SlickException {
        try {
            int i;
            DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element map = doc.createElement("map");
            map.setAttribute("version", "1.0");
            if (this.orientation == 1) {
                map.setAttribute("orientation", "orthogonal");
            } else if (this.orientation == 2) {
                map.setAttribute("orientation", "isometric");
            }
            map.setAttribute("tilewidth", "" + this.tileWidth);
            map.setAttribute("tileheight", "" + this.tileHeight);
            map.setAttribute("width", "" + this.width);
            map.setAttribute("height", "" + this.height);
            doc.appendChild(map);
            for (i = 0; i < this.tileSets.size(); ++i) {
                TileSet tilesetData = (TileSet)this.tileSets.get(i);
                Element tileset = doc.createElement("tileset");
                tileset.setAttribute("firstgid", "" + tilesetData.firstGID);
                tileset.setAttribute("name", tilesetData.name);
                tileset.setAttribute("tilewidth", "" + tilesetData.tileWidth);
                tileset.setAttribute("tileheight", "" + tilesetData.tileHeight);
                tileset.setAttribute("spacing", "" + tilesetData.tileSpacing);
                tileset.setAttribute("margin", "" + tilesetData.tileMargin);
                Element image = doc.createElement("image");
                String imagePath = tilesetData.imageref.replaceFirst(this.getTilesLocation() + "/", "");
                image.setAttribute("source", imagePath);
                image.setAttribute("width", "" + tilesetData.tiles.getWidth());
                image.setAttribute("height", "" + tilesetData.tiles.getHeight());
                tileset.appendChild(image);
                int tileCount = tilesetData.tiles.getHorizontalCount() * tilesetData.tiles.getVerticalCount();
                Element tilesetProperties = doc.createElement("properties");
                Properties tilesetPropertiesData = tilesetData.tilesetProperties;
                if (tilesetProperties != null) {
                    Enumeration<?> propertyEnum = tilesetPropertiesData.propertyNames();
                    while (propertyEnum.hasMoreElements()) {
                        String key = (String)propertyEnum.nextElement();
                        Element tileProperty = doc.createElement("property");
                        tileProperty.setAttribute("name", key);
                        tileProperty.setAttribute("value", tilesetPropertiesData.getProperty(key));
                        tilesetProperties.appendChild(tileProperty);
                    }
                    tileset.appendChild(tilesetProperties);
                }
                if (tileCount == 1) {
                    ++tileCount;
                }
                for (int tileI = 0; tileI < tileCount; ++tileI) {
                    Properties tileProperties = tilesetData.getProperties(tileI);
                    if (tileProperties == null) continue;
                    Element tile = doc.createElement("tile");
                    int tileID = tileI - tilesetData.firstGID;
                    tile.setAttribute("id", "" + tileID);
                    Element tileProps = doc.createElement("properties");
                    Enumeration<?> propertyEnum = tilesetData.getProperties(tileI).propertyNames();
                    while (propertyEnum.hasMoreElements()) {
                        String key = (String)propertyEnum.nextElement();
                        Element tileProperty = doc.createElement("property");
                        tileProperty.setAttribute("name", key);
                        tileProperty.setAttribute("value", tileProperties.getProperty(key));
                        tileProps.appendChild(tileProperty);
                    }
                    tile.appendChild(tileProps);
                    tileset.appendChild(tile);
                }
                map.appendChild(tileset);
            }
            for (i = 0; i < this.layers.size(); ++i) {
                Element layer = doc.createElement("layer");
                Layer layerData = (Layer)this.layers.get(i);
                layer.setAttribute("name", layerData.name);
                layer.setAttribute("width", "" + layerData.width);
                layer.setAttribute("height", "" + layerData.height);
                layer.setAttribute("opacity", "" + layerData.opacity);
                if (layerData.visible) {
                    layer.setAttribute("visible", "1");
                } else {
                    layer.setAttribute("visible", "0");
                }
                Element data = doc.createElement("data");
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                for (int tileY = 0; tileY < layerData.height; ++tileY) {
                    for (int tileX = 0; tileX < layerData.width; ++tileX) {
                        int tileGID = layerData.data[tileX][tileY][2];
                        os.write(tileGID);
                        os.write(tileGID << 8);
                        os.write(tileGID << 16);
                        os.write(tileGID << 24);
                    }
                }
                os.flush();
                String compressedData = Base64.encodeBytes(os.toByteArray(), 11);
                data.appendChild(doc.createTextNode(compressedData));
                data.setAttribute("encoding", "base64");
                data.setAttribute("compression", "gzip");
                layer.appendChild(data);
                map.appendChild(layer);
            }
            for (int objectGroupI = 0; objectGroupI < this.objectGroups.size(); ++objectGroupI) {
                Element objectGroup = doc.createElement("objectgroup");
                ObjectGroup objectGroupData = (ObjectGroup)this.objectGroups.get(objectGroupI);
                objectGroup.setAttribute("color", "white");
                objectGroup.setAttribute("name", objectGroupData.name);
                objectGroup.setAttribute("width", "" + objectGroupData.width);
                objectGroup.setAttribute("height", "" + objectGroupData.height);
                objectGroup.setAttribute("opacity", "" + objectGroupData.opacity);
                if (objectGroupData.visible) {
                    objectGroup.setAttribute("visible", "1");
                } else {
                    objectGroup.setAttribute("visible", "0");
                }
                objectGroup.setAttribute("color", "#" + Float.toHexString(objectGroupData.color.r) + Float.toHexString(objectGroupData.color.g) + Float.toHexString(objectGroupData.color.b));
                for (int groupObjectI = 0; groupObjectI < objectGroupData.objects.size(); ++groupObjectI) {
                    Element object = doc.createElement("object");
                    GroupObject groupObject = objectGroupData.objects.get(groupObjectI);
                    object.setAttribute("x", "" + groupObject.x);
                    object.setAttribute("y", "" + groupObject.y);
                    switch (groupObject.objectType) {
                        case IMAGE: {
                            object.setAttribute("gid", "" + groupObject.gid);
                            break;
                        }
                        case RECTANGLE: {
                            object.setAttribute("name", groupObject.name);
                            object.setAttribute("type", groupObject.type);
                            object.setAttribute("width", "" + groupObject.width);
                            object.setAttribute("height", "" + groupObject.height);
                            break;
                        }
                        case POLYGON: {
                            Element polygon = doc.createElement("polygon");
                            String polygonPoints = "";
                            for (int polygonPointIndex = 0; polygonPointIndex < groupObject.points.getPointCount() - 1; ++polygonPointIndex) {
                                polygonPoints = polygonPoints + groupObject.points.getPoint(polygonPointIndex)[0] + "," + groupObject.points.getPoint(polygonPointIndex)[1] + " ";
                            }
                            polygonPoints.trim();
                            polygon.setAttribute("points", polygonPoints);
                            break;
                        }
                        case POLYLINE: {
                            Element polyline = doc.createElement("polyline");
                            String polylinePoints = "";
                            for (int polyLinePointIndex = 0; polyLinePointIndex < groupObject.points.getPointCount() - 1; ++polyLinePointIndex) {
                                polylinePoints = polylinePoints + groupObject.points.getPoint(polyLinePointIndex)[0] + "," + groupObject.points.getPoint(polyLinePointIndex)[1] + " ";
                            }
                            polylinePoints.trim();
                            polyline.setAttribute("points", polylinePoints);
                        }
                    }
                    if (groupObject.props != null) {
                        Element objectProps = doc.createElement("properties");
                        Enumeration<?> propertyEnum = groupObject.props.propertyNames();
                        while (propertyEnum.hasMoreElements()) {
                            String key = (String)propertyEnum.nextElement();
                            Element objectProperty = doc.createElement("property");
                            objectProperty.setAttribute("name", key);
                            objectProperty.setAttribute("value", groupObject.props.getProperty(key));
                            objectProps.appendChild(objectProperty);
                        }
                        object.appendChild(objectProps);
                    }
                    objectGroup.appendChild(object);
                }
                map.appendChild(objectGroup);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(o);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            Log.error(e);
            throw new SlickException("Failed to write tiledmap", e);
        }
    }

    public ArrayList<Layer> getLayers() {
        return this.layers;
    }

    public ArrayList<TileSet> getTilesets() {
        return this.tileSets;
    }

    public Image getVisibleTile(int x, int y) throws SlickException {
        Image visibleTileImage = null;
        for (int l = this.getLayerCount() - 1; l > -1; --l) {
            if (visibleTileImage != null) continue;
            visibleTileImage = this.getTileImage(x, y, l);
        }
        if (visibleTileImage == null) {
            throw new SlickException("Tile doesn't have a tileset!");
        }
        return visibleTileImage;
    }

    public int getTilesetID(String tilesetName) {
        int tilesetID = this.tilesetNameToIDMap.get(tilesetName);
        return tilesetID;
    }

    public int getLayerID(String layerName) {
        int layerID = this.layerNameToIDMap.get(layerName);
        return layerID;
    }
}

