section.begin
   Name = EventSettings
   Code : struct.begin
      [*] = ;var elmHnd : Integer = GetIntValueByName('ElementHandle');
      [*] = ;var press : String = GetValueByName('Press');
      [*] = ;var status : String = GetValueByName('Status');
      [*] = ;var tag : Integer = GetIntValueByName('Tag');
      [*] = ;
      [*] = ;const currentstatename = 'EventSettings';
      [*] = ;var elmname, showstate, eventstate : String;
      [*] = ;_misc_GetGUIShowEventStateNames(currentstatename, elmname, showstate, eventstate);
      [*] = ;
      [*] = ;const cTagTabVideo = 102;
      [*] = ;const cTagTabSound = 103;
      [*] = ;const cTagTabControl = 104;
      [*] = ;const cTagTabKeyBinding = 105;
      [*] = ;const cTagAccept = 90;
      [*] = ;const cTagCancel = 91;
      [*] = ;const cTagDefault = 92;
      [*] = ;
      [*] = ;const cProjOptionsPreset = 'Preset';
      [*] = ;const cProjOptionsPresetLow = 'guiSetLow';
      [*] = ;const cProjOptionsPresetMedium = 'guiSetMedium';
      [*] = ;const cProjOptionsPresetHigh = 'guiSetHigh';
      [*] = ;const cProjOptionsPresetUltra = 'guiSetUltra';
      [*] = ;const cProjOptionsPresetCustom = 'guiSetCustom';
      [*] = ;const cProjOptionsResolution = 'Resolution';
      [*] = ;const cProjOptionsAntiAliasing = 'AntiAliasing';
      [*] = ;const cProjOptionsFXAAEnable = 'FXAAEnable';
      [*] = ;const cProjOptionsSSAOEnable = 'SSAOEnable';
      [*] = ;const cProjOptionsHDRType = 'HDRType';
      [*] = ;const cProjOptionsVSyncMode = 'VSyncMode';
      [*] = ;const cProjOptionsShadowMap = 'ShadowMap';
      [*] = ;const cProjOptionsShadowEnabled = 'ShadowMapEnabled';
      [*] = ;const cProjOptionsTextureQuality = 'DDSDetailLevel';
      [*] = ;const cProjOptionsTextureFilter = 'TextureFilteringQuality';
      [*] = ;const cProjOptionsShaderType = 'ShaderType';
      [*] = ;const cProjOptionsWaterReflection = 'WaterReflection';
      [*] = ;const cProjOptionsLightChange = 'lightchange';
      [*] = ;const cProjOptionsDisplayMode = 'DisplayMode';
      [*] = ;
      [*] = ;const cResourceOptionsLanguage = 'LocaleTableFileName';
      [*] = ;const cResourceOptionsDisplayMode = 'DisplayMode';
      [*] = ;
      [*] = ;const cGameOptionsGameSpeed = 'igamespeed';
      [*] = ;const cGameOptionsWheelSpeed = 'wheelspeed';
      [*] = ;const cGameOptionsMouseScrollSpeed = 'mousescrollspeed';
      [*] = ;const cGameOptionsKeyScrollSpeed = 'keyscrollspeed';
      [*] = ;const cGameOptionsMiddleMouseScrollSpeed = 'middlemousescrollspeed';
      [*] = ;const cGameOptionsClampingMouse = 'bclipmouse';
      [*] = ;
      [*] = ;const cGameOptionsMute = 'sndmute';
      [*] = ;const cGameOptionsMaster = 'sndmaster';
      [*] = ;const cGameOptionsMusic = 'sndmusic';
      [*] = ;const cGameOptionsAmbient = 'sndambient';
      [*] = ;const cGameOptionsFx = 'sndfx';
      [*] = ;const cGameOptionsInterface = 'sndinterface';
      [*] = ;
      [*] = ;const cGameOptionsAutosave = 'bautosave';
      [*] = ;const cGameOptionsBrushUnderUnit = 'bbrushunderunit';
      [*] = ;const cGameOptionsSearchEnemyInFront = 'bsearchenemyinfront';
      [*] = ;const cGameOptionsInfiniteOnLeftClick = 'binfiniteonleftclick';
      [*] = ;const cGameOptionsSelectAllUnitsOnZ = 'bselectallunitsonz';
      [*] = ;const cGameOptionsCenterSquadPos = 'bcenterfirstrow';
      [*] = ;
      [*] = ;var cTextResolutionChangeIsEngineHead : String = 'gui|settings.text.resoultionchange';
      [*] = ;var cTextResolutionChangeIsEngine : String = 'gui|settings.text.cannotchangeresolutionineditor';
      [*] = ;var cTextResolutionChangeNotFullScreenHead : String = 'gui|settings.text.resoultionchange';
      [*] = ;var cTextResolutionChangeNotFullScreen : String = 'gui|settings.text.cannotchangeresolutionnofullscreen';
      [*] = ;var cTextOk : String = 'gui|btn.ok';
      [*] = ;
      [*] = ;var pConfig : Integer = ParserSelectByKey('Config');
      [*] = ;if (pConfig=0) then
      [*] = ;begin
      [*] = ;   pConfig := ParserCreate('Config');
      [*] = ;   ParserLoadFromFile('.\data\resources\config.res');
      [*] = ;end;
      [*] = ;
      [*] = ;function ModifySliderValueByMouseCoord(elmSlider : Integer) : Float;
      [*] = ;begin
      [*] = ;   Result := 0;
      [*] = ;   var elmSliderBtn : Integer = GetGUIElementIndexByNameParent('sliderbtn', elmSlider);
      [*] = ;   if (elmSliderBtn=0) then
      [*] = ;   elmSliderBtn := elmSlider;
      [*] = ;   var btnwidth : Integer = GetGUIElementWidth(elmSliderBtn);
      [*] = ;   var x, y : Integer;
      [*] = ;   GUIInvalidateParentPositions(elmSlider);
      [*] = ;   GetGUIElementAlignPosition(elmSlider, x, y);
      [*] = ;   var sliderWidth : Integer = GetGUIElementWidth(elmSlider)-22;
      [*] = ;   var sliderXOffset : Integer = 3;
      [*] = ;   var minPosX : Integer = x+sliderXOffset;
      [*] = ;   var maxPosX : Integer = minPosX+sliderWidth;
      [*] = ;   var mX, my : Integer;
      [*] = ;   GetGUICurrentMouseCoord(mX, mY);
      [*] = ;   mX := mx-btnwidth div 2;
      [*] = ;   mX := mX-gint_gui_sliderdragx;
      [*] = ;   var value : Float;
      [*] = ;   if mX<=minPosX then
      [*] = ;   value := 0
      [*] = ;   else
      [*] = ;   if mX>=maxPosX then
      [*] = ;   value := 1
      [*] = ;   else
      [*] = ;   value := ((mX-minPosX)/(maxPosX-minPosX));
      [*] = ;   SetGUIElementPositionX(elmSliderBtn, sliderXOffset+round(value*sliderWidth));
      [*] = ;   Result := value;
      [*] = ;end;
      [*] = ;
      [*] = ;procedure SetupVideoPreset(pConfig : Integer; value : String);
      [*] = ;begin
      [*] = ;   if (pConfig<>0) then
      [*] = ;   begin
      [*] = ;      var pEngine : Integer = ParserSelectByHandleByKey(pConfig, 'engine');
      [*] = ;      if (pEngine<>0) then
      [*] = ;      begin
      [*] = ;         var pEngineConfigs : Integer = ParserSelectByHandleByKey(pEngine, 'config');
      [*] = ;         if (pEngineConfigs<>0) then
      [*] = ;         begin
      [*] = ;            var pEngineConfig : Integer = ParserSelectByHandleByIndex(pEngineConfigs, ParserFindChildIndexByEqualChildKey('Name', value));
      [*] = ;            if (pEngineConfig<>0) then
      [*] = ;            begin
      [*] = ;               var pGui : Integer = ParserSelectByHandleByKey(pEngineConfig, 'Gui');
      [*] = ;               if (pGui<>0) then
      [*] = ;               begin
      [*] = ;                  var pOnClick : Integer = ParserSelectByHandleByKey(pGui, 'OnClick');
      [*] = ;                  if (pOnClick<>0) then
      [*] = ;                  begin
      [*] = ;                     gSettingsTmp.video.ssao := StrToBool(ParserGetValueByKeyByHandle(pOnClick, cProjOptionsSSAOEnable));
      [*] = ;                     gSettingsTmp.video.fxaa := StrToBool(ParserGetValueByKeyByHandle(pOnClick, cProjOptionsFXAAEnable));
      [*] = ;                     gSettingsTmp.video.shadowmap := ParserGetValueByKeyByHandle(pOnClick, cProjOptionsShadowMap);
      [*] = ;
      [*] = ;                     gSettingsTmp.video.hdrtype := ParserGetValueByKeyByHandle(pOnClick, cProjOptionsHDRType);
      [*] = ;                     gSettingsTmp.video.shadertype := ParserGetValueByKeyByHandle(pOnClick, cProjOptionsShaderType);
      [*] = ;                     gSettingsTmp.video.antialiasing := ParserGetValueByKeyByHandle(pOnClick, cProjOptionsAntiAliasing);
      [*] = ;                     gSettingsTmp.video.texturefilter := ParserGetValueByKeyByHandle(pOnClick, cProjOptionsTextureFilter);
      [*] = ;                     gSettingsTmp.video.texturequality := ParserGetValueByKeyByHandle(pOnClick, cProjOptionsTextureQuality);
      [*] = ;                     gSettingsTmp.video.waterreflection := ParserGetValueByKeyByHandle(pOnClick, cProjOptionsWaterReflection);
      [*] = ;                     gSettingsTmp.video.shadowenabled := ParserGetBoolValueByKeyByHandle(pOnClick, cProjOptionsShadowEnabled);
      [*] = ;                     var bSettingsLowest : Boolean;
      [*] = ;                     var iSettingsLowest : Integer = ParserGetIntValueByKeyByHandle(pOnClick, 'settingslowest');
      [*] = ;                     if (iSettingsLowest=-1) then
      [*] = ;                     bSettingsLowest := True
      [*] = ;                     else
      [*] = ;                     bSettingsLowest := False;
      [*] = ;
      [*] = ;                     if (GetProjectOptionAsString(cProjOptionsAntiAliasing)<>gSettingsTmp.video.antialiasing)
      [*] = ;                     or (GetProjectOptionAsString(cProjOptionsTextureFilter)<>gSettingsTmp.video.texturefilter)
      [*] = ;                     or (GetProjectOptionAsString(cProjOptionsTextureQuality)<>gSettingsTmp.video.texturequality)
      [*] = ;                     or (GetProjectOptionAsString(cProjOptionsShaderType)<>gSettingsTmp.video.shadertype)
      [*] = ;                     or (GetProjectOptionAsString(cProjOptionsWaterReflection)<>gSettingsTmp.video.waterreflection)
      [*] = ;                     or (GetProjectOptionAsBoolean(cProjOptionsShadowEnabled)<>gSettingsTmp.video.shadowenabled) then
      [*] = ;                     begin
      [*] = ;                        CadencerProgress;
      [*] = ;                        ViewerBufferRender;
      [*] = ;                     end;
      [*] = ;
      [*] = ;                     if (GetProjectOptionAsString(cProjOptionsAntiAliasing)<>gSettingsTmp.video.antialiasing) then
      [*] = ;                     SetProjectOptionAsString(cProjOptionsAntiAliasing, gSettingsTmp.video.antialiasing);
      [*] = ;                     if (GetProjectOptionAsString(cProjOptionsTextureFilter)<>gSettingsTmp.video.texturefilter) then
      [*] = ;                     SetProjectOptionAsString(cProjOptionsTextureFilter, gSettingsTmp.video.texturefilter);
      [*] = ;                     if (GetProjectOptionAsString(cProjOptionsTextureQuality)<>gSettingsTmp.video.texturequality) then
      [*] = ;                     SetProjectOptionAsString(cProjOptionsTextureQuality, gSettingsTmp.video.texturequality);
      [*] = ;                     if (GetProjectOptionAsString(cProjOptionsShaderType)<>gSettingsTmp.video.shadertype) then
      [*] = ;                     SetProjectOptionAsString(cProjOptionsShaderType, gSettingsTmp.video.shadertype);
      [*] = ;                     if (GetProjectOptionAsString(cProjOptionsWaterReflection)<>gSettingsTmp.video.waterreflection) then
      [*] = ;                     SetProjectOptionAsString(cProjOptionsWaterReflection, gSettingsTmp.video.waterreflection);
      [*] = ;                     if (GetProjectOptionAsBoolean(cProjOptionsFXAAEnable)<>gSettingsTmp.video.fxaa) then
      [*] = ;                     SetProjectOptionAsBoolean(cProjOptionsFXAAEnable, gSettingsTmp.video.fxaa);
      [*] = ;                     if (GetProjectOptionAsBoolean(cProjOptionsSSAOEnable)<>gSettingsTmp.video.ssao) then
      [*] = ;                     SetProjectOptionAsBoolean(cProjOptionsSSAOEnable, gSettingsTmp.video.ssao);
      [*] = ;                     if (GetProjectOptionAsBoolean(cProjOptionsShadowEnabled)<>gSettingsTmp.video.shadowenabled) then
      [*] = ;                     SetProjectOptionAsBoolean(cProjOptionsShadowEnabled, gSettingsTmp.video.shadowenabled);
      [*] = ;
      [*] = ;                     if (GetProjectOptionAsInteger(cProjOptionsShadowMap)<>StrToInt(gSettingsTmp.video.shadowmap)) then
      [*] = ;                     SetShadowMapSize(StrToInt(gSettingsTmp.video.shadowmap));
      [*] = ;                  end;
      [*] = ;               end;
      [*] = ;            end;
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;   end;
      [*] = ;end;
      [*] = ;
      [*] = ;procedure RecalcPreset();
      [*] = ;begin
      [*] = ;   var presetIndex : Integer;
      [*] = ;   _gui_FindCurrentVideoPreset(pConfig, gSettingsTmp.video.preset, presetIndex);
      [*] = ;
      [*] = ;   var elmListBoxHandle : Integer = GetGUIElementIndexByNameParent(elmname+'.col2.back.'+cProjOptionsPreset, _gui_GetTop);
      [*] = ;   if (gSettingsTmp.video.preset=cProjOptionsPresetCustom) then
      [*] = ;   begin
      [*] = ;      var valueCount : Integer = 4;
      [*] = ;      if (GetGUIListBoxItemsCount(elmListBoxHandle)<valueCount) then
      [*] = ;      begin
      [*] = ;         var text : String = GetLocaleTableListItemByID(gc_loc_tools, 'CFG.VALUE.WRMCUSTOM');
      [*] = ;         GUIListBoxAddItem(elmListBoxHandle, text, valueCount-1);
      [*] = ;         SetGUIListBoxVisibleRows(elmListBoxHandle, valueCount);
      [*] = ;         var iTmpHandle : Integer = GetGUIComboBoxListBoxHandle(elmListBoxHandle);
      [*] = ;         SetGUIElementHeight(iTmpHandle, (GetGUIElementFontHeight(GetGUIElementFont(iTmpHandle))+2)*valueCount+19);
      [*] = ;         SetGUIElementLogicHeight(iTmpHandle, GetGUIElementHeight(iTmpHandle));
      [*] = ;      end;
      [*] = ;      SetGUIListBoxItemIndexSilent(elmListBoxHandle, presetIndex);
      [*] = ;   end
      [*] = ;   else
      [*] = ;   begin
      [*] = ;      var valueCount : Integer = 3;
      [*] = ;      if (GetGUIListBoxItemsCount(elmListBoxHandle)>valueCount) then
      [*] = ;      begin
      [*] = ;         SetGUIListBoxItemIndexSilent(elmListBoxHandle, 0);
      [*] = ;         GUIListBoxDeleteItem(elmListBoxHandle, valueCount);
      [*] = ;         SetGUIListBoxVisibleRows(elmListBoxHandle, valueCount);
      [*] = ;         var iTmpHandle : Integer = GetGUIComboBoxListBoxHandle(elmListBoxHandle);
      [*] = ;         SetGUIElementHeight(iTmpHandle, (GetGUIElementFontHeight(GetGUIElementFont(iTmpHandle))+2)*valueCount+19);
      [*] = ;         SetGUIElementLogicHeight(iTmpHandle, GetGUIElementHeight(iTmpHandle));
      [*] = ;      end;
      [*] = ;      SetGUIListBoxItemIndexSilent(elmListBoxHandle, presetIndex);
      [*] = ;   end;
      [*] = ;end;
      [*] = ;
      [*] = ;var name : String = GetGUIElementNameByIndex(elmHnd);
      [*] = ;var elmSlider : Integer;
      [*] = ;if (gint_gui_sliderhnd<>0) then
      [*] = ;elmSlider := gint_gui_sliderhnd
      [*] = ;else
      [*] = ;if (name='sliderline') then
      [*] = ;elmSlider := elmHnd
      [*] = ;else
      [*] = ;if (name='sliderbtn') then
      [*] = ;elmSlider := GetGUIElementParentByIndex(elmHnd);
      [*] = ;
      [*] = ;var sliderID : String = GetGUIElementStringTag(elmSlider);
      [*] = ;
      [*] = ;if (name='sliderline') or (name='sliderbtn') then
      [*] = ;begin
      [*] = ;   if (status='geMouseDown') then
      [*] = ;   gint_gui_sliderhnd := elmSlider;
      [*] = ;end;
      [*] = ;
      [*] = ;if (gint_gui_sliderhnd<>0) or ((press='d') and (elmName='sliderline')) then
      [*] = ;begin
      [*] = ;   var value : Float = ModifySliderValueByMouseCoord(elmSlider);
      [*] = ;
      [*] = ;   case sliderID of
      [*] = ;      cGameOptionsMaster : begin
      [*] = ;         if (gProfileTmp.sndmaster<>value) then
      [*] = ;         begin
      [*] = ;            gProfileTmp.sndmaster := value;
      [*] = ;            SetProjectOptionAsFloat('Sound.Master', gProfileTmp.sndmaster);
      [*] = ;            gSoundManager.bprocess := not ((gProfileTmp.sndmute>0) or (gProfileTmp.sndmaster=0) or (gProfileTmp.sndfx=0));
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;      cGameOptionsMusic : begin
      [*] = ;         if (gProfileTmp.sndmusic<>value) then
      [*] = ;         begin
      [*] = ;            gProfileTmp.sndmusic := value;
      [*] = ;            SetProjectOptionAsFloat('svgMusic', gProfileTmp.sndmusic);
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;      cGameOptionsAmbient : begin
      [*] = ;         if (gProfileTmp.sndambient<>value) then
      [*] = ;         begin
      [*] = ;            gProfileTmp.sndambient := value;
      [*] = ;            SetProjectOptionAsFloat('svgAmbient', gProfileTmp.sndambient);
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;      cGameOptionsFx : begin
      [*] = ;         if (gProfileTmp.sndfx<>value) then
      [*] = ;         begin
      [*] = ;            gProfileTmp.sndfx := value;
      [*] = ;            SetProjectOptionAsFloat('svgSFX', gProfileTmp.sndfx);
      [*] = ;            gSoundManager.bprocess := not ((gProfileTmp.sndmute>0) or (gProfileTmp.sndmaster=0) or (gProfileTmp.sndfx=0));
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;      cGameOptionsInterface : begin
      [*] = ;         if (gProfileTmp.sndinterface<>value) then
      [*] = ;         begin
      [*] = ;            gProfileTmp.sndinterface := value;
      [*] = ;            SetProjectOptionAsFloat('svgInterface', gProfileTmp.sndinterface);
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;      cGameOptionsMouseScrollSpeed : gProfileTmp.mousescrollspeed := value;
      [*] = ;      cGameOptionsKeyScrollSpeed : gProfileTmp.keyscrollspeed := value;
      [*] = ;      cGameOptionsWheelSpeed : gProfileTmp.wheelspeed := value;
      [*] = ;      cGameOptionsMiddleMouseScrollSpeed : gProfileTmp.middlemousescrollspeed := value;
      [*] = ;   end;
      [*] = ;end;
      [*] = ;
      [*] = ;var config : String = GetGUIElementNameByIndex(elmHnd);
      [*] = ;var stringTag : String = GetGUIElementStringTag(elmHnd);
      [*] = ;// checkboxes that switch ProjectOption
      [*] = ;if (press='c') and ((config=cProjOptionsVSyncMode) or (config=cProjOptionsShadowEnabled) or (config=cProjOptionsSSAOEnable) or (config=cProjOptionsFXAAEnable)) then
      [*] = ;begin
      [*] = ;   var delimiterStringCount : Integer = GetDelimiterStringCount(stringTag, gc_gui_DelimiterChar, gc_gui_QuoteChar);
      [*] = ;   var value0, value1, newValue : String = '';
      [*] = ;   if (IsDelimiterCharExists(stringTag, gc_gui_DelimiterChar)) and (delimiterStringCount>=2) then
      [*] = ;   begin
      [*] = ;      value0 := GetDelimiterStringByIndex(stringTag, gc_gui_DelimiterChar, gc_gui_QuoteChar, 0);
      [*] = ;      value1 := GetDelimiterStringByIndex(stringTag, gc_gui_DelimiterChar, gc_gui_QuoteChar, 1);
      [*] = ;   end;
      [*] = ;   case config of
      [*] = ;      cProjOptionsVSyncMode : begin
      [*] = ;         var bChecked : Boolean = (not GetGUIElementChecked(elmHnd));
      [*] = ;         if (bChecked) then
      [*] = ;         newValue := value1
      [*] = ;         else
      [*] = ;         newValue := value0;
      [*] = ;         gSettingsTmp.video.vsyncmode := newValue;
      [*] = ;         SetGUIElementChecked(elmHnd, bChecked);
      [*] = ;         SetProjectOptionAsString(cProjOptionsVSyncMode, newValue);
      [*] = ;      end;
      [*] = ;      cProjOptionsShadowEnabled : begin
      [*] = ;         var bChecked : Boolean = (not GetGUIElementChecked(elmHnd));
      [*] = ;         gSettingsTmp.video.shadowenabled := bChecked;
      [*] = ;         SetGUIElementChecked(elmHnd, bChecked);
      [*] = ;         SetProjectOptionAsBoolean(cProjOptionsShadowEnabled, bChecked);
      [*] = ;         RecalcPreset();
      [*] = ;      end;
      [*] = ;      cProjOptionsSSAOEnable : begin
      [*] = ;         var bChecked : Boolean = (not GetGUIElementChecked(elmHnd));
      [*] = ;         gSettingsTmp.video.ssao := bChecked;
      [*] = ;         SetGUIElementChecked(elmHnd, bChecked);
      [*] = ;         SetProjectOptionAsBoolean(cProjOptionsSSAOEnable, bChecked);
      [*] = ;         RecalcPreset();
      [*] = ;      end;
      [*] = ;      cProjOptionsFXAAEnable : begin
      [*] = ;         var bChecked : Boolean = (not GetGUIElementChecked(elmHnd));
      [*] = ;         gSettingsTmp.video.fxaa := bChecked;
      [*] = ;         SetGUIElementChecked(elmHnd, bChecked);
      [*] = ;         SetProjectOptionAsBoolean(cProjOptionsFXAAEnable, bChecked);
      [*] = ;         RecalcPreset();
      [*] = ;      end;
      [*] = ;   end;
      [*] = ;end
      [*] = ;else
      [*] = ;// comboboxes
      [*] = ;if (status='select') and (press<>'d') then
      [*] = ;begin
      [*] = ;   if (config=cProjOptionsResolution) then
      [*] = ;   begin
      [*] = ;      // Video resolution
      [*] = ;      var elmListBoxHandle : Integer = GetGUIElementIndexByNameParent('Settings.col2.back.'+cProjOptionsResolution, _gui_GetTop);
      [*] = ;      var bchanged : Boolean;
      [*] = ;      var i : Integer = GetGUIListBoxItemTag(elmListBoxHandle, GetGUIListBoxItemIndex(elmListBoxHandle));
      [*] = ;      if (i > 0) and (i <> GetCurrentResolutionMode) then
      [*] = ;      begin
      [*] = ;         if (not IsEngine) then
      [*] = ;         _gui_ShowModalMessage(cTextResolutionChangeIsEngineHead, cTextResolutionChangeIsEngine,cTextOk, '', gc_gui_event_tagClose, 0)
      [*] = ;         else
      [*] = ;         if ((GetDisplayMode <> 'dmWindow') and (GetDisplayMode <> 'dmWindowFullScreen')) then
      [*] = ;         begin
      [*] = ;            gint_gui_revertresolutiontimer := GetCurrentTime;
      [*] = ;            gint_gui_changeresolutionmode := GetCurrentResolutionMode;
      [*] = ;            gint_gui_changeresolutionstage := 2;
      [*] = ;            SetFullScreenMode(i);
      [*] = ;            NeedRestartGUI;
      [*] = ;         end
      [*] = ;         else
      [*] = ;         _gui_ShowModalMessage(cTextResolutionChangeNotFullScreenHead, cTextResolutionChangeNotFullScreen, cTextOk, '', gc_gui_event_tagClose, 0);
      [*] = ;      end;
      [*] = ;   end;
      [*] = ;   if (stringTag<>'') then
      [*] = ;   begin
      [*] = ;      if (config<>cProjOptionsResolution) and (config<>cProjOptionsShadowEnabled) then
      [*] = ;      begin
      [*] = ;         var delimiterStringCount : Integer = GetDelimiterStringCount(stringTag, gc_gui_DelimiterChar, gc_gui_QuoteChar);
      [*] = ;         var value : String;
      [*] = ;         var ind : Integer = GetGUIListBoxItemIndex(elmHnd);
      [*] = ;         if (IsDelimiterCharExists(stringTag, gc_gui_DelimiterChar)) and (delimiterStringCount>=(ind-1)) then
      [*] = ;         value := GetDelimiterStringByIndex(stringTag, gc_gui_DelimiterChar, gc_gui_QuoteChar, ind);
      [*] = ;         case config of
      [*] = ;            cProjOptionsShadowMap : begin
      [*] = ;               gSettingsTmp.video.shadowmap := value;
      [*] = ;               SetShadowMapSize(StrToInt(gSettingsTmp.video.shadowmap));
      [*] = ;               RecalcPreset();
      [*] = ;            end;
      [*] = ;            cProjOptionsLightChange : begin
      [*] = ;               gSettingsTmp.video.lightpreset := StrToInt(value);
      [*] = ;               var tmp : Integer = gSettings.video.lightpreset;
      [*] = ;               gSettings.video.lightpreset := gSettingsTmp.video.lightpreset;
      [*] = ;               if (gSettingsTmp.video.lightpreset>2) then
      [*] = ;               SetMapFloatValue('LightTime', 0);
      [*] = ;               ExecuteState('DoBlendLighting');
      [*] = ;               gSettings.video.lightpreset := tmp;
      [*] = ;            end;
      [*] = ;            cProjOptionsPreset : begin
      [*] = ;               if (gSettingsTmp.video.preset<>value) then
      [*] = ;               begin
      [*] = ;                  gSettingsTmp.video.preset := value;
      [*] = ;                  SetupVideoPreset(pConfig, gSettingsTmp.video.preset);
      [*] = ;                  ExecuteState(showstate);
      [*] = ;               end;
      [*] = ;            end;
      [*] = ;            cProjOptionsAntiAliasing : begin
      [*] = ;               gSettingsTmp.video.antialiasing := value;
      [*] = ;               SetProjectOptionAsString(cProjOptionsAntiAliasing, value);
      [*] = ;               RecalcPreset();
      [*] = ;            end;
      [*] = ;            cProjOptionsTextureFilter : begin
      [*] = ;               gSettingsTmp.video.texturefilter := value;
      [*] = ;               SetProjectOptionAsString(cProjOptionsTextureFilter, value);
      [*] = ;               RecalcPreset();
      [*] = ;            end;
      [*] = ;            cProjOptionsTextureQuality : begin
      [*] = ;               gSettingsTmp.video.texturequality := value;
      [*] = ;               SetProjectOptionAsString(cProjOptionsTextureQuality, value);
      [*] = ;               RecalcPreset();
      [*] = ;            end;
      [*] = ;            cProjOptionsShaderType : begin
      [*] = ;               gSettingsTmp.video.shadertype := value;
      [*] = ;               SetProjectOptionAsString(cProjOptionsShaderType, value);
      [*] = ;               RecalcPreset();
      [*] = ;            end;
      [*] = ;            cProjOptionsWaterReflection : begin
      [*] = ;               gSettingsTmp.video.waterreflection := value;
      [*] = ;               SetProjectOptionAsString(cProjOptionsWaterReflection, value);
      [*] = ;               RecalcPreset();
      [*] = ;            end;
      [*] = ;            cGameOptionsGameSpeed : begin
      [*] = ;               gProfileTmp.igamespeed := _misc_ClampInt(StrToInt(value), 0, gc_settings_gamespeed_count-1);
      [*] = ;               if (_control_GetGameSpeedMode<>gProfileTmp.igamespeed) then
      [*] = ;               _control_SetGameSpeedByMode(gProfileTmp.igamespeed, True);
      [*] = ;            end;
      [*] = ;            cProjOptionsDisplayMode : begin
      [*] = ;               if _profile_SetDisplayMode(value, True, False) then
      [*] = ;               begin
      [*] = ;                  gProfileTmp.displaymode := value;
      [*] = ;                  gint_gui_changeresolutionstage := 1;
      [*] = ;                  NeedRestartGUI;
      [*] = ;               end;
      [*] = ;            end;
      [*] = ;            cResourceOptionsLanguage : begin
      [*] = ;               if (value<>gProfileTmp.lang) then
      [*] = ;               begin
      [*] = ;                  gProfileTmp.lang := value;
      [*] = ;                  var locale : String;
      [*] = ;                  _profile_ConvertConfigValueToLocale(gProfileTmp.lang, locale);
      [*] = ;                  _profile_SetLocale(locale, True, False);
      [*] = ;
      [*] = ;                  if (gScenario.bexists) then
      [*] = ;                  begin
      [*] = ;                     var scenarioname : String = StrReplace(gScenario.settings.filename, '.map', '');
      [*] = ;                     var localepath : String = '.\data\locale\'+locale+'\missions\';
      [*] = ;                     var filename : String = GetCurrentMapFileName;
      [*] = ;                     var path : String = ExtractFilePath(filename);
      [*] = ;                     var langfilepath : String = localepath+scenarioname+'.lng';;
      [*] = ;                     var langtable : String = gScenario.settings.langtable;
      [*] = ;                     var ind : Integer = IndexOfLocaleTableList(langtable);
      [*] = ;                     if (ind>=0) then
      [*] = ;                     DeleteLocaleTableList(ind);
      [*] = ;                     if (IsFileExists(langfilepath)) then
      [*] = ;                     AddLocaleTableList(langtable, langfilepath)
      [*] = ;                     else
      [*] = ;                     begin
      [*] = ;                        langfilepath := path+scenarioname+'.lng';
      [*] = ;                        if (IsFileExists(langfilepath)) then
      [*] = ;                        AddLocaleTableList(langtable, langfilepath)
      [*] = ;                     end;
      [*] = ;                  end;
      [*] = ;
      [*] = ;                  gint_gui_changeresolutionstage := 1; // do move back to settings
      [*] = ;                  NeedRestartGUI;
      [*] = ;               end;
      [*] = ;            end;
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;   end;
      [*] = ;end
      [*] = ;else
      [*] = ;if (press='c') and (gint_gui_sliderhnd=0) then
      [*] = ;begin
      [*] = ;   case config of
      [*] = ;      cGameOptionsClampingMouse : begin
      [*] = ;         Log('ClampingMouse to screen work only in fullscreen or in IsEngine');
      [*] = ;         var bChecked : Boolean = (not GetGUIElementChecked(elmHnd));
      [*] = ;         gProfileTmp.bclipmouse := bChecked;
      [*] = ;         SetClipCursor(gProfileTmp.bclipmouse and IsEngine and (gInterface.gamemode<>gc_gamemode_mainmenu));
      [*] = ;         SetGUIElementChecked(elmHnd, bChecked);
      [*] = ;      end;
      [*] = ;      cGameOptionsMute : begin
      [*] = ;         var bChecked : Boolean = (not GetGUIElementChecked(elmHnd));
      [*] = ;         if (bChecked) then
      [*] = ;         gProfileTmp.sndmute := 1
      [*] = ;         else
      [*] = ;         gProfileTmp.sndmute := 0;
      [*] = ;         SetSoundManagerMuteMode('svgInterface', (gProfileTmp.sndmute=1));
      [*] = ;         SetSoundManagerMuteMode('svgAmbient', (gProfileTmp.sndmute=1));
      [*] = ;         SetSoundManagerMuteMode('svgMusic', (gProfileTmp.sndmute=1));
      [*] = ;         SetSoundManagerMuteMode('svgSFX', (gProfileTmp.sndmute=1));
      [*] = ;         SetSoundManagerMuteMode('svgVoice', (gProfileTmp.sndmute=1));
      [*] = ;         SetGUIElementChecked(elmHnd, bChecked);
      [*] = ;         gSoundManager.bprocess := not ((gProfileTmp.sndmute>0) or (gProfileTmp.sndmaster=0) or (gProfileTmp.sndfx=0));
      [*] = ;      end;
      [*] = ;      cGameOptionsAutosave : begin
      [*] = ;         var bChecked : Boolean = (not GetGUIElementChecked(elmHnd));
      [*] = ;         gProfileTmp.bautosave := bChecked;
      [*] = ;         SetGUIElementChecked(elmHnd, bChecked);
      [*] = ;      end;
      [*] = ;      cGameOptionsBrushUnderUnit : begin
      [*] = ;         var bChecked : Boolean = (not GetGUIElementChecked(elmHnd));
      [*] = ;         gProfileTmp.bbrushunderunit := bChecked;
      [*] = ;         var size, dirx, diry, dirz: Float; var texs: Integer;
      [*] = ;         var bscale, bvisible : Boolean;
      [*] = ;         GetHighlightRenderSettings(size, dirx, diry, dirz, texs, bscale, bvisible);
      [*] = ;         SetHighlightRenderSettings(size, dirx, diry, dirz, texs, bscale, gProfileTmp.bbrushunderunit);
      [*] = ;         SetGUIElementChecked(elmHnd, bChecked);
      [*] = ;      end;
      [*] = ;      cGameOptionsSearchEnemyInFront : begin
      [*] = ;         var bChecked : Boolean = (not GetGUIElementChecked(elmHnd));
      [*] = ;         gProfileTmp.bsearchenemyinfront := bChecked;
      [*] = ;         SetGUIElementChecked(elmHnd, bChecked);
      [*] = ;      end;
      [*] = ;      cGameOptionsInfiniteOnLeftClick : begin
      [*] = ;         var bChecked : Boolean = (not GetGUIElementChecked(elmHnd));
      [*] = ;         gProfileTmp.binfiniteonleftclick := bChecked;
      [*] = ;         SetGUIElementChecked(elmHnd, bChecked);
      [*] = ;      end;
      [*] = ;      cGameOptionsSelectAllUnitsOnZ : begin
      [*] = ;         var bChecked : Boolean = (not GetGUIElementChecked(elmHnd));
      [*] = ;         gProfileTmp.bselectallunitsonz := bChecked;
      [*] = ;         SetGUIElementChecked(elmHnd, bChecked);
      [*] = ;      end;
      [*] = ;      cGameOptionsCenterSquadPos : begin
      [*] = ;         var bChecked : Boolean = (not GetGUIElementChecked(elmHnd));
      [*] = ;         gProfileTmp.bcenterfirstrow := bChecked;
      [*] = ;         SetGUIElementChecked(elmHnd, bChecked);
      [*] = ;         SLogicFrmRotateSetAlignPosition(not gProfileTmp.bcenterfirstrow);
      [*] = ;      end;
      [*] = ;   end;
      [*] = ;   case tag of
      [*] = ;      gc_gui_event_tagShow : ExecuteState(showstate);
      [*] = ;      gc_gui_event_tagHide : begin
      [*] = ;         _gui_SetGUIElementVisibleByName(elmname, False);
      [*] = ;      end;
      [*] = ;      gc_gui_event_tagClose : begin
      [*] = ;         _gui_SetGUIElementVisibleByName(elmname, False);
      [*] = ;      end;
      [*] = ;      cTagAccept, gc_gui_hotkey_btnEnter, cTagCancel, gc_gui_hotkey_btnEscape : begin
      [*] = ;         gint_gui_sliderhnd := 0;
      [*] = ;         case tag of
      [*] = ;            cTagAccept, gc_gui_hotkey_btnEnter : begin
      [*] = ;               if (gProfileTmp.lang<>gProfile.lang) then
      [*] = ;               _profile_SetLocale(gProfileTmp.lang, False, True);
      [*] = ;               gProfile := gProfileTmp;
      [*] = ;               gSettings := gSettingsTmp;
      [*] = ;               _profile_SaveUserProfile;
      [*] = ;            end;
      [*] = ;            cTagCancel, gc_gui_hotkey_btnEscape : begin
      [*] = ;               gProfileTmp := gProfile;
      [*] = ;               gSettingsTmp := gSettings;
      [*] = ;            end;
      [*] = ;         end;
      [*] = ;         _gui_SetGUIElementVisibleByName(elmname, False);
      [*] = ;         if (gInterface.gamemode<>gc_gamemode_mainmenu) then
      [*] = ;         gint_gui_changeresolutionstage := 4
      [*] = ;         else
      [*] = ;         gint_gui_changeresolutionstage := 0;
      [*] = ;
      [*] = ;         var size, dirx, diry, dirz: Float; var texs: Integer;
      [*] = ;         var bscale, bvisible : Boolean;
      [*] = ;         GetHighlightRenderSettings(size, dirx, diry, dirz, texs, bscale, bvisible);
      [*] = ;         SetHighlightRenderSettings(size, dirx, diry, dirz, texs, bscale, gProfile.bbrushunderunit);
      [*] = ;         var bNeedRestartGUI : Boolean = (GetDisplayMode<>gProfile.displaymode);
      [*] = ;         if not _profile_SetDisplayMode(gProfile.displaymode, (GetDisplayMode<>gProfile.displaymode), True) then
      [*] = ;         bNeedRestartGUI := False;
      [*] = ;         SetProjectOptionAsFloat('Sound.Master', gProfile.sndmaster);
      [*] = ;         SetProjectOptionAsFloat('svgMusic', gProfile.sndmusic);
      [*] = ;         SetProjectOptionAsFloat('svgAmbient', gProfile.sndambient);
      [*] = ;         SetProjectOptionAsFloat('svgSFX', gProfile.sndfx);
      [*] = ;         SetProjectOptionAsFloat('svgInterface', gProfile.sndinterface);
      [*] = ;         gSoundManager.bprocess := not ((gProfile.sndmute>0) or (gProfile.sndmaster=0) or (gProfile.sndfx=0));
      [*] = ;
      [*] = ;         SetSoundManagerMuteMode('svgInterface', (gProfile.sndmute=1));
      [*] = ;         SetSoundManagerMuteMode('svgAmbient', (gProfile.sndmute=1));
      [*] = ;         SetSoundManagerMuteMode('svgMusic', (gProfile.sndmute=1));
      [*] = ;         SetSoundManagerMuteMode('svgSFX', (gProfile.sndmute=1));
      [*] = ;         SetSoundManagerMuteMode('svgVoice', (gProfile.sndmute=1));
      [*] = ;
      [*] = ;         SetProjectOptionAsBoolean(cProjOptionsFXAAEnable, gSettings.video.fxaa);
      [*] = ;         SetProjectOptionAsBoolean(cProjOptionsSSAOEnable, gSettings.video.ssao);
      [*] = ;         SetProjectOptionAsString(cProjOptionsAntiAliasing, gSettings.video.antialiasing);
      [*] = ;         SetProjectOptionAsString(cProjOptionsVSyncMode, gSettings.video.vsyncmode);
      [*] = ;         SetProjectOptionAsBoolean(cProjOptionsShadowEnabled, gSettings.video.shadowenabled);
      [*] = ;         SetProjectOptionAsString(cProjOptionsTextureFilter, gSettings.video.texturefilter);
      [*] = ;         SetProjectOptionAsString(cProjOptionsTextureQuality, gSettings.video.texturequality);
      [*] = ;         SetProjectOptionAsString(cProjOptionsShaderType, gSettings.video.shadertype);
      [*] = ;         SetProjectOptionAsString(cProjOptionsWaterReflection, gSettings.video.waterreflection);
      [*] = ;         SetShadowMapSize(StrToInt(gSettings.video.shadowmap));
      [*] = ;         SLogicFrmRotateSetAlignPosition(not gProfile.bcenterfirstrow);
      [*] = ;         if (_control_GetGameSpeedMode<>gProfile.igamespeed) then
      [*] = ;         _control_SetGameSpeedByMode(gProfile.igamespeed, True);
      [*] = ;         SetClipCursor(gProfile.bclipmouse and IsEngine and (gInterface.gamemode<>gc_gamemode_mainmenu));
      [*] = ;
      [*] = ;         var pConfig : Integer = ParserSelectByKey('Config');
      [*] = ;         if (pConfig<>0) then
      [*] = ;         ParserFreeByHandle(pConfig);
      [*] = ;
      [*] = ;         var elmParent : Integer = GetGUIElementIndexByNameParent('Menu', _gui_GetTop);
      [*] = ;         if (elmParent<>0) and _gui_GetGUIElementVisibleInherited(elmParent) then
      [*] = ;         begin
      [*] = ;            var elmMask : Integer = GetGUIElementIndexByNameParent('blackmask', elmParent);
      [*] = ;            if (elmMask<>0) then
      [*] = ;            SetGUIElementVisible(elmMask, True);
      [*] = ;         end;
      [*] = ;
      [*] = ;         if (bNeedRestartGUI) then
      [*] = ;         NeedRestartGUI;
      [*] = ;      end;
      [*] = ;      cTagTabVideo, cTagTabSound, cTagTabControl, cTagTabKeyBinding : begin
      [*] = ;         case tag of
      [*] = ;            cTagTabVideo : gInterface.settings := gc_settings_video;
      [*] = ;            cTagTabSound : gInterface.settings := gc_settings_sound;
      [*] = ;            cTagTabControl : gInterface.settings := gc_settings_control;
      [*] = ;            cTagTabKeyBinding : gInterface.settings := gc_settings_keybinding;
      [*] = ;         end;
      [*] = ;         ExecuteState(showstate);
      [*] = ;      end;
      [*] = ;      cTagDefault : begin
      [*] = ;         gint_gui_sliderhnd := 0;
      [*] = ;         if (gInterface.settings=gc_settings_video) then //video
      [*] = ;         begin
      [*] = ;            gSettingsTmp.video.preset := cProjOptionsPresetHigh; // TODO : HATE : DO AUTODETECT HERE
      [*] = ;            SetupVideoPreset(pConfig, gSettingsTmp.video.preset);
      [*] = ;         end
      [*] = ;         else
      [*] = ;         _profile_SetGameOptionsDefault(gProfileTmp, gInterface.settings);
      [*] = ;
      [*] = ;         gSettingsTmp.video.vsyncmode := 'vsmNoSync';
      [*] = ;         SetProjectOptionAsString(cProjOptionsVSyncMode, gSettingsTmp.video.vsyncmode);
      [*] = ;         SLogicFrmRotateSetAlignPosition(not gProfileTmp.bcenterfirstrow);
      [*] = ;         if (_control_GetGameSpeedMode<>gProfileTmp.igamespeed) then
      [*] = ;         _control_SetGameSpeedByMode(gProfileTmp.igamespeed, True);
      [*] = ;         SetClipCursor(gProfile.bclipmouse and IsEngine and (gInterface.gamemode<>gc_gamemode_mainmenu));
      [*] = ;
      [*] = ;         ExecuteState(showstate);
      [*] = ;
      [*] = ;         SetProjectOptionAsFloat('Sound.Master', gProfileTmp.sndmaster);
      [*] = ;         SetProjectOptionAsFloat('svgMusic', gProfileTmp.sndmusic);
      [*] = ;         SetProjectOptionAsFloat('svgAmbient', gProfileTmp.sndambient);
      [*] = ;         SetProjectOptionAsFloat('svgSFX', gProfileTmp.sndfx);
      [*] = ;         SetProjectOptionAsFloat('svgInterface', gProfileTmp.sndinterface);
      [*] = ;
      [*] = ;         SetSoundManagerMuteMode('svgInterface', (gProfileTmp.sndmute=1));
      [*] = ;         SetSoundManagerMuteMode('svgAmbient', (gProfileTmp.sndmute=1));
      [*] = ;         SetSoundManagerMuteMode('svgMusic', (gProfileTmp.sndmute=1));
      [*] = ;         SetSoundManagerMuteMode('svgSFX', (gProfileTmp.sndmute=1));
      [*] = ;         gSoundManager.bprocess := not ((gProfile.sndmute>0) or (gProfile.sndmaster=0) or (gProfile.sndfx=0));
      [*] = ;      end;
      [*] = ;   end;
      [*] = ;end;
   struct.end
section.end

