section.begin
   Name = OnLanEvent
   Code : struct.begin
      [*] = ;var cAllowDebug : Boolean = True;
      [*] = ;
      [*] = ;procedure LogEvent(msg : String);
      [*] = ;begin
      [*] = ;   if (cAllowDebug) then
      [*] = ;   begin
      [*] = ;      var text : String;
      [*] = ;      text := msg+' gLanEvent='+IntToStr(gLanEvent);
      [*] = ;      if (LanPublicServerGetRegIDFrom<>0) {and (gLanMyID<>LanPublicServerGetRegIDFrom)} then
      [*] = ;      text := text+' regIDFrom='+IntToStr(LanPublicServerGetRegIDFrom);
      [*] = ;      if (LanPublicServerGetRegIDTo<>0) {and (gLanMyID<>LanPublicServerGetRegIDTo)} then
      [*] = ;      text := text+' regIDTo='+IntToStr(LanPublicServerGetRegIDTo);
      [*] = ;
      [*] = ;      var tag : Integer = GetIntValueByName('Tag');
      [*] = ;      var index : Integer = LanGetClientIndexByID(tag);
      [*] = ;
      [*] = ;      if (tag<>0) or (index<>-1) then
      [*] = ;      text := text+' tag='+IntToStr(tag)+' index='+IntToStr(index);
      [*] = ;
      [*] = ;      log(text);
      [*] = ;   end;
      [*] = ;end;
      [*] = ;
      [*] = ;procedure OnTerminateGame;
      [*] = ;begin
      [*] = ;   //gInterface.gamemode := gc_gamemode_mainmenu;
      [*] = ;   gInternetShell.ClearCurrentSession;
      [*] = ;   _gui_SendTagToState('EventCustomGame', gc_gui_event_tagHide);
      [*] = ;   gInternetShell.bshowroom := False;
      [*] = ;   gint_gui_updateclientlist := (1 shl 0);
      [*] = ;   gbool_gui_showinternetshell := True;
      [*] = ;   gbool_gui_setshellchatinputfocused := True;
      [*] = ;   LogEvent('OnTerminateGame');
      [*] = ;end;
      [*] = ;
      [*] = ;procedure OnConnect;
      [*] = ;begin
      [*] = ;   LogEvent('OnConnect');
      [*] = ;   var idTo : Integer = LanPublicServerGetRegIDTo;
      [*] = ;   var idFrom : Integer = LanPublicServerGetRegIDFrom;
      [*] = ;   var tag : Integer = GetIntValueByName('Tag');
      [*] = ;   if (tag=LanMyInfoID) then
      [*] = ;   begin
      [*] = ;      //log('i create server');
      [*] = ;      gbool_gui_updatecurrentsessionname := True;
      [*] = ;      gbool_gui_refreshcurrentsession := True;
      [*] = ;      if (gInternetShell.bshowroom) then
      [*] = ;      gbool_gui_showcustomgame := True;
      [*] = ;   end
      [*] = ;   else
      [*] = ;   if (tag<>LanMyInfoID) then
      [*] = ;   begin
      [*] = ;      //log('I am server and someone joined my room.');
      [*] = ;      // I am server and someone joined my room.
      [*] = ;      gbool_gui_updatecurrentsessionname := True;
      [*] = ;      gbool_gui_refreshcurrentsession := True;
      [*] = ;      if (gInternetShell.bshowroom) then
      [*] = ;      gbool_gui_showcustomgame := True;
      [*] = ;      gbool_gui_senddatasyncparser := True;
      [*] = ;   end;
      [*] = ;end;
      [*] = ;
      [*] = ;procedure DoStartGame;
      [*] = ;begin
      [*] = ;   //Log('DoStartGame');
      [*] = ;   LanSrvSetMapFile(''); // use LoadMapNeeded(''); instead
      [*] = ;   //LanDoStart();
      [*] = ;   //LoadMapNeeded('');
      [*] = ;   ExecuteState('DoNewGame');
      [*] = ;   LanDoStart();
      [*] = ;end;
      [*] = ;
      [*] = ;procedure ParserReceived;
      [*] = ;begin
      [*] = ;   if (GetLanMode<>0) then
      [*] = ;   begin
      [*] = ;      if (cAllowDebug) then
      [*] = ;      Log('ParserReceived : GetLanMode = '+IntToStr(GetLanMode)+' LanGetParserID = '+IntToStr(LanGetParserID));
      [*] = ;      var idFrom : Integer = GetIntValueByName('Tag');
      [*] = ;      var indFrom : Integer = _misc_GetMapPlayerIndexByLanID(idFrom);
      [*] = ;      var pLan : Integer = LanSelectParser;
      [*] = ;      if (GetLanMode>=gc_lanmode_server) then // server
      [*] = ;      begin
      [*] = ;         case (LanGetParserID) of
      [*] = ;            gc_LAN_ROOM_READY : begin
      [*] = ;               if (indFrom>=0) then
      [*] = ;               gMap.players[indFrom].bready := True;
      [*] = ;               gbool_gui_updatecurrentsessionname := True; //_misc_InternetShellUpdateCurrentSessionName(gInternetShell);
      [*] = ;               if (gInternetShell.bshowroom) then
      [*] = ;               gbool_gui_showcustomgame := True; //ExecuteState('ShowCustomGame');
      [*] = ;               gbool_gui_senddatasyncparser := True;
      [*] = ;            end;
      [*] = ;            else
      [*] = ;            ErrorLog('Session:leParser unknown ID = '+IntToStr(LanGetParserID));
      [*] = ;         end;
      [*] = ;      end
      [*] = ;      else
      [*] = ;      if (GetLanMode=gc_lanmode_client) then
      [*] = ;      begin
      [*] = ;         case (LanGetParserID) of
      [*] = ;            gc_LAN_GENERATE : begin
      [*] = ;               StateMachineGlobalVariablesLoadFromParser(pLan, 'gMap', False, False);
      [*] = ;               DoStartGame();
      [*] = ;            end;
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;   end;
      [*] = ;end;
      [*] = ;
      [*] = ;procedure ErrorOccur;
      [*] = ;begin
      [*] = ;   if gConnectIPIndex>=0 then
      [*] = ;   begin
      [*] = ;      //_misc_ConnectIPIndexIncrease;
      [*] = ;      //gInternetShell.prevstate := -1;
      [*] = ;      LanShutdown;
      [*] = ;      //ExecuteState('DoConnectServer');
      [*] = ;      {if (gConnectIPIndex>=1) then
      [*] = ;      exit
      [*] = ;      else
      [*] = ;      begin
      [*] = ;         LanShutdown;
      [*] = ;         _gui_ShowConnectStateMessage(gc_ConnectState_Error);
      [*] = ;      end;}
      [*] = ;   end;
      [*] = ;   LogEvent('ErrorOccur : OnLanEvent');
      [*] = ;end;
      [*] = ;
      [*] = ;procedure CoreVersionFailed;
      [*] = ;begin
      [*] = ;   LogEvent('CoreVersionFailed');
      [*] = ;   _gui_ShowConnectStateMessage(gc_ConnectState_CoreVersionFailed);
      [*] = ;end;
      [*] = ;
      [*] = ;procedure DataVersionFailed;
      [*] = ;begin
      [*] = ;   LogEvent('DataVersionFailed');
      [*] = ;   _gui_ShowConnectStateMessage(gc_ConnectState_DataVersionFailed);
      [*] = ;end;
      [*] = ;
      [*] = ;if (IsLanPublicServerMode) then
      [*] = ;begin
      [*] = ;   //------------------------------------------------------------------------------
      [*] = ;   if (gLanEvent<>leShellMessage) and (cAllowDebug) and ((gLanEvent<>leShellMessage) or (LanPublicServerGetRegIDFrom<>LanPublicServerGetRegIDTo)) then
      [*] = ;   Log('gLanEvent='+IntToStr(gLanEvent)+' RegIDFrom = '+IntToStr(LanPublicServerGetRegIDFrom)+' RegIDTo = '+ IntToStr(LanPublicServerGetRegIDTo)+' tag='+IntToStr(GetIntValueByName('Tag'))+' index='+IntToStr(LanGetClientIndexByID(GetIntValueByName('Tag'))));
      [*] = ;   //------------------------------------------------------------------------------
      [*] = ;   case gLanEvent of
      [*] = ;      leTerminated : OnTerminateGame;
      [*] = ;      leError : begin
      [*] = ;         ErrorOccur;
      [*] = ;      end;
      [*] = ;      leShellCoreVersionFailed : CoreVersionFailed;
      [*] = ;      leShellDataVersionFailed : DataVersionFailed;
      [*] = ;      leShellGetAuth : begin
      [*] = ;         LogEvent('leShellGetAuth');
      [*] = ;         gInternetShell.prevstate := 2;
      [*] = ;         if (gint_gui_connectserverstate=2) then
      [*] = ;         begin
      [*] = ;            gint_gui_connectserverstate := 3;
      [*] = ;            LanPublicServerLogin;
      [*] = ;         end
      [*] = ;         else
      [*] = ;         begin
      [*] = ;            if (False) and (gProfile.netemail<>'') then
      [*] = ;            begin
      [*] = ;               LanSetMyEmail(gProfile.netemail);
      [*] = ;               LanPublicServerUserExist(gProfile.netemail);
      [*] = ;            end
      [*] = ;            else
      [*] = ;            begin
      [*] = ;               gInternetShell.currentsessionid := 0;
      [*] = ;               gInternetShell.selsessionid := 0;
      [*] = ;               gInternetShell.roomdata := '';
      [*] = ;               _gui_ShowConnectStateMessage(gc_ConnectState_Hide);
      [*] = ;               gConnectLoginState := gc_ConnectLoginState_YourEmail;
      [*] = ;               ExecuteState('ShowMultiplayerLogin');
      [*] = ;            end;
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;      leShellValidEmail : begin
      [*] = ;         LogEvent('leShellValidEmail');
      [*] = ;         gInternetShell.prevstate := 3;
      [*] = ;         _gui_ShowConnectStateMessage(gc_ConnectState_Hide);
      [*] = ;         gConnectLoginState := gc_ConnectLoginState_ValidEmail;
      [*] = ;         ExecuteState('ShowMultiplayerLogin');
      [*] = ;      end;
      [*] = ;      leShellInvalidEmail : begin
      [*] = ;         LogEvent('leShellInvalidEmail');
      [*] = ;         _gui_ShowConnectStateMessage(gc_ConnectState_Hide);
      [*] = ;         gConnectLoginState := gc_ConnectLoginState_InvalidEmail;
      [*] = ;         ExecuteState('ShowMultiplayerLogin');
      [*] = ;      end;
      [*] = ;      leShellLogged : begin
      [*] = ;         gInternetShell.prevstate := 4;
      [*] = ;         gLanMyID := LanMyInfoID;
      [*] = ;         LogEvent('leShellLogged');
      [*] = ;         _gui_ShowConnectStateMessage(gc_ConnectState_Connecting);
      [*] = ;         gInternetShell.bauth := True;
      [*] = ;      end;
      [*] = ;      //
      [*] = ;      leShellAuthClientFailed : _gui_ShowConnectStateMessage(gc_ConnectState_InvalidPass);
      [*] = ;      leShellAuthBannedFailed : _gui_ShowConnectStateMessage(gc_ConnectState_AccountBanned);
      [*] = ;      leShellAuthCDKeyFailed : _gui_ShowConnectStateMessage(gc_ConnectState_InvalidKey);
      [*] = ;      //
      [*] = ;      leShellRegClientFailed : _gui_ShowConnectStateMessage(gc_ConnectState_RegClientFailed);
      [*] = ;      leShellRegCDKeyFailed : _gui_ShowConnectStateMessage(gc_ConnectState_RegCDKeyFailed);
      [*] = ;      leShellRegDataFailed : _gui_ShowConnectStateMessage(gc_ConnectState_RegDataFailed);
      [*] = ;      //
      [*] = ;      leShellMessage, leShellSessionMessage : begin
      [*] = ;         var idFrom : Integer = LanPublicServerGetRegIDFrom;
      [*] = ;         var idTo : Integer = LanPublicServerGetRegIDTo;
      [*] = ;         var msg : String = LanPublicServerGetRegMessage;
      [*] = ;         if (msg<>'') then
      [*] = ;         begin
      [*] = ;            case msg of
      [*] = ;               '/clear', '/c' : begin
      [*] = ;                  if (idFrom=LanMyInfoID) then // check if i need this
      [*] = ;                  begin
      [*] = ;                     gInternetShell.ClearChat((gLanEvent=leShellMessage), (gLanEvent=leShellSessionMessage));
      [*] = ;                     _misc_FillChatList(False);
      [*] = ;                  end;
      [*] = ;               end;
      [*] = ;               else
      [*] = ;               begin
      [*] = ;                  const cPurgeSize = 16;
      [*] = ;                  var nickFrom, nickTo : String;
      [*] = ;                  var pclient : Pointer = gInternetShell.clients.GetByLanID(idFrom);
      [*] = ;                  if (pclient<>nil) then
      [*] = ;                  nickFrom := TInternetShellClient(pclient).nick;
      [*] = ;                  pclient := gInternetShell.clients.GetByLanID(idTo);
      [*] = ;                  if (pclient<>nil) then
      [*] = ;                  nickTo := TInternetShellClient(pclient).nick;
      [*] = ;                  var lang : String;
      [*] = ;                  _profile_ConvertConfigValueToLocale(gProfile.lang, lang);
      [*] = ;                  if (gLanEvent=leShellSessionMessage) or ((idTo<>0) and (idFrom<>idTo)) then
      [*] = ;                  begin
      [*] = ;                     if (gInternetShell.roomchatind>gc_gui_maxinternetchatlog-1) then
      [*] = ;                     begin
      [*] = ;                        var i : Integer;
      [*] = ;                        for i:=0 to gc_gui_maxinternetchatlog-cPurgeSize-1 do
      [*] = ;                        gInternetShell.roomchat[i] := gInternetShell.roomchat[i+cPurgeSize];
      [*] = ;                        for i:=gc_gui_maxinternetchatlog-cPurgeSize to gc_gui_maxinternetchatlog-1 do
      [*] = ;                        gInternetShell.roomchat[i] := '';
      [*] = ;                        gInternetShell.roomchatind := gc_gui_maxinternetchatlog-cPurgeSize;
      [*] = ;                     end;
      [*] = ;                     var spacepos : Integer = StrPos(' ', msg);
      [*] = ;                     var firstword : String = SubStr(msg, 1, spacepos);
      [*] = ;                     case firstword of
      [*] = ;                        '/help', '/h' : begin
      [*] = ;                           msg := msg+'/help, /h - to see list of commands'+gc_gui_breakline;
      [*] = ;                           msg := msg+'/w nick - send private message to nick'+gc_gui_breakline;
      [*] = ;                           msg := msg+'/clear, /c - clear chat history'+gc_gui_breakline;
      [*] = ;                        end;
      [*] = ;                     end;
      [*] = ;                     var newmsg : String = IntToStr(idFrom)+'|'+IntToStr(idTo)+'|'+nickFrom+'|'+nickTo+'|'+lang+'|"'+msg+'"';
      [*] = ;                     gInternetShell.roomchat[gInternetShell.roomchatind] := newmsg;
      [*] = ;                     gInternetShell.roomchatind := gInternetShell.roomchatind+1;
      [*] = ;                  end;
      [*] = ;                  if (gLanEvent=leShellMessage) or ((idTo<>0) and (idFrom<>idTo)) then
      [*] = ;                  begin
      [*] = ;                     if (gInternetShell.chatind>gc_gui_maxinternetchatlog-1) then
      [*] = ;                     begin
      [*] = ;                        var i : Integer;
      [*] = ;                        for i:=0 to gc_gui_maxinternetchatlog-cPurgeSize-1 do
      [*] = ;                        gInternetShell.chat[i] := gInternetShell.chat[i+cPurgeSize];
      [*] = ;                        for i:=gc_gui_maxinternetchatlog-cPurgeSize to gc_gui_maxinternetchatlog-1 do
      [*] = ;                        gInternetShell.chat[i] := '';
      [*] = ;                        gInternetShell.chatind := gc_gui_maxinternetchatlog-cPurgeSize;
      [*] = ;                     end;
      [*] = ;                     var spacepos : Integer = StrPos(' ', msg);
      [*] = ;                     var firstword : String = SubStr(msg, 1, spacepos);
      [*] = ;                     case firstword of
      [*] = ;                        '/help', '/h' : begin
      [*] = ;                           msg := msg+'/help, /h - to see list of commands'+gc_gui_breakline;
      [*] = ;                        msg := msg+'/w nick - send private message to nick'+gc_gui_breakline;
      [*] = ;                           msg := msg+'/clear, /c - clear chat history'+gc_gui_breakline;
      [*] = ;                        end;
      [*] = ;                     end;
      [*] = ;                     var newmsg : String = IntToStr(idFrom)+'|'+IntToStr(idTo)+'|'+nickFrom+'|'+nickTo+'|'+lang+'|"'+msg+'"';
      [*] = ;                     gInternetShell.chat[gInternetShell.chatind] := newmsg;
      [*] = ;                     gInternetShell.chatind := gInternetShell.chatind+1;
      [*] = ;                  end;
      [*] = ;                  //gInternetShell.chatkeyscrollind := gInternetShell.chatind;
      [*] = ;                  if (idTo<>0)
      [*] = ;                  or ((gInternetShell.bshowroom) and (gLanEvent=leShellSessionMessage))
      [*] = ;                  or ((not gInternetShell.bshowroom) and (gLanEvent=leShellMessage)) then
      [*] = ;                  _misc_FillChatList(True);
      [*] = ;               end;
      [*] = ;            end;
      [*] = ;         end;
      [*] = ;      end;//AddChatMessage(False, cShellChatList);
      [*] = ;      //leShellSessionMessage : ;//AddChatMessage(True, cShellChatList);
      [*] = ;      //
      [*] = ;      leShellSessionCreate : begin
      [*] = ;         LogEvent('leShellSessionCreate');//CreateSession(cShellShardGamesList);
      [*] = ;         var idFrom : Integer = LanPublicServerGetRegIDFrom;
      [*] = ;         if (idFrom=LanMyInfoID) then
      [*] = ;         begin
      [*] = ;            gint_gui_updatesessionlist := (1 shl 0); // _misc_UpdateSessionList(False, False, False);
      [*] = ;            _gui_SendTagToState('EventInternetShell', gc_gui_event_tagHide);
      [*] = ;            gbool_gui_updatecurrentsessionname := True; // _misc_InternetShellUpdateCurrentSessionName(gInternetShell);
      [*] = ;            gbool_gui_refreshcurrentsession := True; // _misc_InternetShellRefreshCurrentSession(gInternetShell, True);
      [*] = ;            gInternetShell.bshowroom := True;
      [*] = ;            gbool_gui_showcustomgame := True; //ExecuteState('ShowCustomGame');
      [*] = ;            gbool_gui_setshellchatinputfocused := True; // _gui_SetShellChatInputBoxFocused;
      [*] = ;         end
      [*] = ;         else
      [*] = ;         gint_gui_updatesessionlist := (1 shl 0) or (1 shl 1) or (1 shl 3); //UpdateSessionList(True, True, True);
      [*] = ;
      [*] = ;         var pClient : Integer = _parser_ParserTemporary(True);
      [*] = ;         if (LanPublicServerGetClientInfoToParserByClientID(idFrom, pClient)) then
      [*] = ;         begin
      [*] = ;            gInternetShell.clients.AddOrUpdateFromParser(pClient);
      [*] = ;            if (not gInternetShell.bshowroom) then
      [*] = ;            begin
      [*] = ;               //gint_gui_updateclientlist := (1 shl 0);
      [*] = ;               gbool_gui_showinternetshell := True; //ExecuteState('ShowInternetShell');
      [*] = ;            end;
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;      leShellSessionJoin : begin
      [*] = ;         LogEvent('leShellSessionJoin');//JoinSession(cShellShardGamesList, cShellClientsList);
      [*] = ;         var idTo : Integer = LanPublicServerGetRegIDTo;
      [*] = ;         var idFrom : Integer = LanPublicServerGetRegIDFrom;
      [*] = ;         if (idTo=LanMyInfoID) then
      [*] = ;         begin
      [*] = ;            {// I am server and someone joined my room.
      [*] = ;            _misc_InternetShellUpdateCurrentSessionName(gInternetShell);
      [*] = ;            _misc_InternetShellRefreshCurrentSession(gInternetShell, True);
      [*] = ;            gbool_gui_showcustomgame := True;
      [*] = ;
      [*] = ;            var pLan : Integer = _parser_ParserTemporary(True);
      [*] = ;            ParserSetValueByKeyByHandle(pLan, 's', gInternetShell.roomdata);
      [*] = ;            LanPublicServerSendSessionParser(idFrom, gc_LAN_ROOM_SERVER_DATASYNC, pLan);}
      [*] = ;         end
      [*] = ;         else
      [*] = ;         if (idFrom=LanMyInfoID) then
      [*] = ;         begin
      [*] = ;            _misc_UpdateSessionList(True, False, False, False);
      [*] = ;            _gui_SendTagToState('EventInternetShell', gc_gui_event_tagHide);
      [*] = ;            gbool_gui_refreshcurrentsession := True; // _misc_InternetShellRefreshCurrentSession(gInternetShell, True);
      [*] = ;            gInternetShell.bshowroom := True;
      [*] = ;            gbool_gui_showcustomgame := True; //ExecuteState('ShowCustomGame');
      [*] = ;         end
      [*] = ;         else
      [*] = ;         gint_gui_updatesessionlist := (1 shl 0) or (1 shl 1) or (1 shl 3); //_misc_UpdateSessionList(True, False, True);
      [*] = ;
      [*] = ;         var pClient : Integer = _parser_ParserTemporary(True);
      [*] = ;         if (LanPublicServerGetClientInfoToParserByClientID(idFrom, pClient)) then
      [*] = ;         begin
      [*] = ;            gInternetShell.clients.AddOrUpdateFromParser(pClient);
      [*] = ;            if (not gInternetShell.bshowroom) then
      [*] = ;            gint_gui_updateclientlist := (1 shl 0) or (1 shl 1) or (1 shl 3); //ExecuteState('ShowInternetShell');
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;      leShellSessionLeave : begin
      [*] = ;         LogEvent('leShellSessionLeave');//LeaveSession(cShellShardGamesList, cShellClientsList);
      [*] = ;         var idFrom : Integer = LanPublicServerGetRegIDFrom;
      [*] = ;         {if (IsLanReady) then
      [*] = ;         begin
      [*] = ;            var indFrom : Integer = _misc_GetMapPlayerIndexByLanID(idFrom);
      [*] = ;            if (indFrom>=0) then
      [*] = ;            gMap.players[indFrom].bleave := True;
      [*] = ;         end
      [*] = ;         else}
      [*] = ;         begin
      [*] = ;            var idTo : Integer = LanPublicServerGetRegIDTo;
      [*] = ;            if (idTo=LanMyInfoID) and (_net_IsOnline) then
      [*] = ;            begin
      [*] = ;               // i am server and client decided to leave room
      [*] = ;               gbool_gui_updatecurrentsessionname := True;
      [*] = ;               gbool_gui_refreshcurrentsession := True;
      [*] = ;               if (gInternetShell.bshowroom) then
      [*] = ;               gbool_gui_showcustomgame := True;
      [*] = ;               gbool_gui_senddatasyncparser := True;
      [*] = ;            end
      [*] = ;            else
      [*] = ;            if (idFrom=LanMyInfoID) and (_net_IsOnline) then
      [*] = ;            begin
      [*] = ;               gInternetShell.bshowroom := False;
      [*] = ;               gInternetShell.currentsessionid := 0;
      [*] = ;               gInternetShell.roomdata := '';
      [*] = ;               LanTerminateGame;
      [*] = ;               gint_gui_updatesessionlist := (1 shl 0) or (1 shl 1) or (1 shl 3); //_misc_UpdateSessionList(True, False, True);
      [*] = ;               _gui_ShowConnectStateMessage(gc_ConnectState_SessionKick);
      [*] = ;            end
      [*] = ;            else
      [*] = ;            if (idFrom=LanMyInfoID) then
      [*] = ;            begin
      [*] = ;               gInternetShell.bshowroom := False;
      [*] = ;               gInternetShell.currentsessionid := 0;
      [*] = ;               gInternetShell.roomdata := '';
      [*] = ;               gint_gui_updateclientlist := (1 shl 0);
      [*] = ;               gint_gui_updatesessionlist := (1 shl 0); //_misc_UpdateSessionList(False, False, False);
      [*] = ;               _gui_SendTagToState('EventCustomGame', gc_gui_event_tagHide);
      [*] = ;               gbool_gui_showinternetshell := True; //ExecuteState('ShowInternetShell');
      [*] = ;               gbool_gui_setshellchatinputfocused := True; //_gui_SetShellChatInputBoxFocused;
      [*] = ;            end;
      [*] = ;            {else
      [*] = ;            if (idTo=LanMyInfoID) then
      [*] = ;            begin
      [*] = ;               gbool_gui_updatecurrentsessionname := True; // _misc_InternetShellUpdateCurrentSessionName(gInternetShell);
      [*] = ;               gbool_gui_refreshcurrentsession := True; // _misc_InternetShellRefreshCurrentSession(gInternetShell, True);
      [*] = ;               gint_gui_updatesessionlist := (1 shl 0) or (1 shl 1) or (1 shl 2) or (1 shl 3); //_misc_UpdateSessionList(True, True, True);
      [*] = ;            end
      [*] = ;            else
      [*] = ;            if (idTo=gInternetShell.currentsessionid) then
      [*] = ;            begin
      [*] = ;               gbool_gui_updatecurrentsessionname := True; // _misc_InternetShellUpdateCurrentSessionName(gInternetShell);
      [*] = ;               gbool_gui_refreshcurrentsession := True; // _misc_InternetShellRefreshCurrentSession(gInternetShell, True);
      [*] = ;               gint_gui_updatesessionlist := (1 shl 0) or (1 shl 1) or (1 shl 2) or (1 shl 3); //_misc_UpdateSessionList(True, True, True);
      [*] = ;            end
      [*] = ;            else
      [*] = ;            if (idFrom=gInternetShell.selsessionid) then
      [*] = ;            begin
      [*] = ;               gInternetShell.selsessionid := 0;
      [*] = ;               gint_gui_updatesessionlist := (1 shl 0) or (1 shl 1) or (1 shl 2) or (1 shl 3); //_misc_UpdateSessionList(True, True, True);
      [*] = ;            end
      [*] = ;            else
      [*] = ;            gint_gui_updatesessionlist := (1 shl 0) or (1 shl 1) or (1 shl 2) or (1 shl 3); //_misc_UpdateSessionList(True, True, True);}
      [*] = ;
      [*] = ;            var pClient : Integer = _parser_ParserTemporary(True);
      [*] = ;            if (LanPublicServerGetClientInfoToParserByClientID(idFrom, pClient)) then
      [*] = ;            begin
      [*] = ;               gInternetShell.clients.AddOrUpdateFromParser(pClient);
      [*] = ;               gInternetShell.sessions.DeleteByMasterID(idFrom); // new
      [*] = ;               if (not gInternetShell.bshowroom) then
      [*] = ;               begin
      [*] = ;                  gint_gui_updateclientlist := (1 shl 0);
      [*] = ;                  gint_gui_updatesessionlist := (1 shl 0);
      [*] = ;                  gbool_gui_showinternetshell := True; // ExecuteState('ShowInternetShell');
      [*] = ;               end;
      [*] = ;            end;
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;      leShellSessionInfo : begin
      [*] = ;         LogEvent('leShellSessionInfo');//UpdateSession(cShellShardGamesList, cShellClientsList);
      [*] = ;         var idFrom : Integer = LanPublicServerGetRegIDFrom;
      [*] = ;         if (idFrom=LanMyInfoID) then
      [*] = ;         gbool_gui_refreshcurrentsession := True; // _misc_InternetShellRefreshCurrentSession(gInternetShell, True);
      [*] = ;         gint_gui_updatesessionlist := (1 shl 0); // _misc_UpdateSessionList(False, False, False);
      [*] = ;         if (not gInternetShell.bshowroom) then
      [*] = ;         gbool_gui_showinternetshell := true;
      [*] = ;      end;
      [*] = ;      leShellSessionLock : begin
      [*] = ;         LogEvent('leShellSessionLock');
      [*] = ;         var idFrom : Integer = LanPublicServerGetRegIDFrom;
      [*] = ;         var pClient : Integer = _parser_ParserTemporary(True);
      [*] = ;         if (LanPublicServerGetClientInfoToParserByClientID(idFrom, pClient)) then
      [*] = ;         begin
      [*] = ;            gInternetShell.clients.AddOrUpdateFromParser(pClient);
      [*] = ;            gInternetShell.sessions.DeleteByMasterID(idFrom);
      [*] = ;            if (not gInternetShell.bshowroom) then
      [*] = ;            gbool_gui_showinternetshell := True;
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;      leShellSessionClose : begin
      [*] = ;         {LogEvent('leShellSessionClose');
      [*] = ;         var idFrom : Integer = LanPublicServerGetRegIDFrom;
      [*] = ;         var pClient : Integer = _parser_ParserTemporary(True);
      [*] = ;         if (LanPublicServerGetClientInfoToParserByClientID(idFrom, pClient)) then
      [*] = ;         begin
      [*] = ;            gInternetShell.clients.AddOrUpdateFromParser(pClient);
      [*] = ;            gInternetShell.sessions.DeleteByMasterID(idFrom);
      [*] = ;            if (not gInternetShell.bshowroom) then
      [*] = ;            begin
      [*] = ;               gint_gui_updateclientlist := (1 shl 0);
      [*] = ;               gbool_gui_showinternetshell := True; //ExecuteState('ShowInternetShell');
      [*] = ;            end;
      [*] = ;         end;}
      [*] = ;      end;
      [*] = ;      //
      [*] = ;      leShellClientConnected : begin
      [*] = ;         LogEvent('leShellClientConnected');
      [*] = ;         var idFrom : Integer = LanPublicServerGetRegIDFrom;
      [*] = ;         if (idFrom=LanMyInfoID) then
      [*] = ;         begin
      [*] = ;            _gui_SendTagToState('EventMultiplayerLogin', gc_gui_event_tagHide);
      [*] = ;            _gui_ShowConnectStateMessage(gc_ConnectState_Hide);
      [*] = ;
      [*] = ;            gInternetShell.Clear;
      [*] = ;            gInternetShell.lanid := LanMyInfoID;
      [*] = ;
      [*] = ;            //gInternetShell.clients.Clear;
      [*] = ;            var pClients : Integer = _parser_ParserTemporary(True);
      [*] = ;            LanPublicServerClientsToParser(pClients);
      [*] = ;            var i : Integer;
      [*] = ;            for i:=0 to ParserGetCountByHandle(pClients)-1 do
      [*] = ;            begin
      [*] = ;               var pClient : Integer = ParserSelectByHandleByIndex(pClients, i);
      [*] = ;               if pClient<>0 then
      [*] = ;               gInternetShell.clients.AddOrUpdateFromParser(pClient);
      [*] = ;            end;
      [*] = ;
      [*] = ;            //gInternetShell.sessions.Clear;
      [*] = ;            var pSessions : Integer = _parser_ParserTemporary(True);
      [*] = ;            LanPublicServerSessionsToParser(pSessions);
      [*] = ;            gInternetShell.sessions.Clear;
      [*] = ;            for i:=0 to ParserGetCountByHandle(pSessions)-1 do
      [*] = ;            begin
      [*] = ;               var pSession : Integer = ParserSelectByHandleByIndex(pSessions, i);
      [*] = ;               if pSession<>0 then
      [*] = ;               gInternetShell.sessions.AddFromParser(pSession);
      [*] = ;            end;
      [*] = ;
      [*] = ;            gInternetShell.bshowroom := False;
      [*] = ;            gInternetShell.currentpage := gc_internetshell_currentpage_sessions;
      [*] = ;            ExecuteState('ShowInternetShell');
      [*] = ;            _gui_SetShellChatInputBoxFocused;
      [*] = ;            if (gProfileTmp.netemail<>gProfile.netemail) or (gProfile.netpass<>gProfileTmp.netpass) or (gProfile.netcdkey<>gProfileTmp.netcdkey) then
      [*] = ;            begin
      [*] = ;               gProfile.netemail := gProfileTmp.netemail;
      [*] = ;               gProfile.netpass := gProfileTmp.netpass;
      [*] = ;               gProfile.netcdkey := gProfileTmp.netcdkey;
      [*] = ;               _profile_SaveUserProfile;
      [*] = ;            end;
      [*] = ;
      [*] = ;            var txtwelcome : String = gc_font_color_white+GetLocaleTableListItemByID('misc', 'internetshell.welcome')+gc_font_color_default;
      [*] = ;            txtwelcome := StrReplace(txtwelcome, '%datetimenow%', DateTimeNow(''));
      [*] = ;            txtwelcome := StrReplace(txtwelcome, '%getbuildversion%', GetBuildVersion);
      [*] = ;            LanPublicServerSendMessage(idFrom, txtwelcome);
      [*] = ;         end
      [*] = ;         else
      [*] = ;         begin
      [*] = ;            var pClient : Integer = _parser_ParserTemporary(True);
      [*] = ;            if (LanPublicServerGetClientInfoToParserByClientID(idFrom, pClient)) then
      [*] = ;            begin
      [*] = ;               gInternetShell.clients.AddOrUpdateFromParser(pClient);
      [*] = ;               if (not gInternetShell.bshowroom) then
      [*] = ;               gbool_gui_showinternetshell := True; //ExecuteState('ShowInternetShell');
      [*] = ;            end;
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;      leShellClientDisconnected : begin
      [*] = ;         LogEvent('DisconnectClient');
      [*] = ;         var idFrom : Integer = LanPublicServerGetRegIDFrom;
      [*] = ;         if (idFrom<>LanMyInfoID) then
      [*] = ;         begin
      [*] = ;            gInternetShell.clients.RemoveByLanID(idFrom);
      [*] = ;            if (not gInternetShell.bshowroom) then
      [*] = ;            begin
      [*] = ;               gint_gui_updateclientlist := (1 shl 0); //_misc_UpdateSessionList(True, True, True);
      [*] = ;               gint_gui_updatesessionlist := (1 shl 0); //_misc_UpdateSessionList(True, True, True);
      [*] = ;               gbool_gui_showinternetshell := True;
      [*] = ;            end;
      [*] = ;         end;
      [*] = ;         //if (not gInternetShell.bshowroom) then
      [*] = ;         //ExecuteState('ShowInternetShell');
      [*] = ;      end;
      [*] = ;      leShellClientInfo : begin
      [*] = ;         LogEvent('leShellClientInfo');
      [*] = ;      end;
      [*] = ;      leSessionParser : begin
      [*] = ;         procedure SendRoomDataToClients();
      [*] = ;         begin
      [*] = ;            var humancount : Integer;
      [*] = ;            var i : Integer;
      [*] = ;            for i:=0 to gc_MaxPlayerCount-1 do
      [*] = ;            if (gMap.players[i].bexists) and (gMap.players[i].lanid>0) then
      [*] = ;            humancount := humancount+1;
      [*] = ;            if (LanGetClientsCount>1) then
      [*] = ;            begin
      [*] = ;               var pLan : Integer = _parser_ParserTemporary(True);
      [*] = ;               ParserSetValueByKeyByHandle(pLan, 's', gInternetShell.roomdata);
      [*] = ;               LanPublicServerSendSessionParser(0, gc_LAN_ROOM_SERVER_DATASYNC, pLan);
      [*] = ;            end;
      [*] = ;         end;
      [*] = ;
      [*] = ;         if (GetLanMode<>0) then
      [*] = ;         begin
      [*] = ;            var idFrom : Integer = LanPublicServerGetRegIDFrom;
      [*] = ;            var idTo : Integer = LanPublicServerGetRegIDTo;
      [*] = ;            if (idFrom<>LanMyInfoID) then
      [*] = ;            begin
      [*] = ;               LogEvent('leSessionParser ID='+IntToStr(LanGetParserID));
      [*] = ;               var pLan : Integer = LanSelectParser;
      [*] = ;               case (LanGetParserID) of
      [*] = ;                  gc_LAN_ROOM_SERVER_DATASYNC : begin
      [*] = ;                     if (_net_IsClient) then
      [*] = ;                     begin
      [*] = ;                        var newroomdata : String = ParserGetValueByKeyByHandle(pLan, 's');
      [*] = ;                        if (gInternetShell.roomdata<>newroomdata) then
      [*] = ;                        begin
      [*] = ;                           gInternetShell.roomdata := newroomdata;
      [*] = ;                           _misc_InternetShellRefreshCurrentSession(gInternetShell, True);
      [*] = ;                           gbool_gui_showcustomgame := True;
      [*] = ;                        end;
      [*] = ;                     end;
      [*] = ;                  end;
      [*] = ;                  gc_LAN_ROOM_SERVER_DATACHANGE : ;
      [*] = ;                  gc_LAN_ROOM_CLIENT_DATACHANGE : begin
      [*] = ;                     if (_net_IsServer) then
      [*] = ;                     begin
      [*] = ;                        var indFrom : Integer = _misc_GetMapPlayerIndexByLanID(idFrom);
      [*] = ;                        if (indFrom>=0) then
      [*] = ;                        begin
      [*] = ;                           var s : String = ParserGetValueByKeyByHandle(pLan, 's');
      [*] = ;                           if (IsDelimiterCharExists(s, gc_gui_delimiterchar)) then
      [*] = ;                           begin
      [*] = ;                              var s1, s2, s3, s4 : String;
      [*] = ;                              _misc_GetDelimiterString(s, gc_gui_delimiterchar, s1, s2, s3 ,s4);
      [*] = ;                              gMap.players[indFrom].cid := StrToInt(s1);
      [*] = ;                              gMap.players[indFrom].team := StrToInt(s2);
      [*] = ;                              gMap.players[indFrom].color := StrToInt(s3);
      [*] = ;                              gbool_gui_refreshcurrentsession := True;
      [*] = ;                              gbool_gui_updatecurrentsessionname := True; //_misc_InternetShellUpdateCurrentSessionName(gInternetShell);
      [*] = ;                              if (gInternetShell.bshowroom) then
      [*] = ;                              gbool_gui_showcustomgame := True; //ExecuteState('ShowCustomGame');
      [*] = ;                              gbool_gui_senddatasyncparser := True;
      [*] = ;                              //SendRoomDataToClients;
      [*] = ;                           end;
      [*] = ;                        end
      [*] = ;                        else
      [*] = ;                        ErrorLog('gc_LAN_ROOM_CLIENT_DATACHANGE : indFrom='+IntToStr(indFrom));
      [*] = ;                     end;
      [*] = ;                  end;
      [*] = ;                  {gc_LAN_ROOM_CLIENT_LEAVE : begin
      [*] = ;                     if (_net_IsServer) then
      [*] = ;                     begin
      [*] = ;                        var indFrom : Integer = _misc_GetMapPlayerIndexByLanID(idFrom);
      [*] = ;                        if (indFrom>=0) then
      [*] = ;                        begin
      [*] = ;                           gbool_gui_updatecurrentsessionname := True;
      [*] = ;                           gint_gui_updateclientlist := 1 shl 0;
      [*] = ;                           gint_gui_updatesessionlist := 1 shl 0;
      [*] = ;                           if (gInternetShell.bshowroom) then
      [*] = ;                           gbool_gui_showcustomgame := True
      [*] = ;                           else
      [*] = ;                           gbool_gui_showinternetshell := True;
      [*] = ;                        end;
      [*] = ;                        SendRoomDataToClients;
      [*] = ;                     end;
      [*] = ;                  end;}
      [*] = ;                  else
      [*] = ;                  ErrorLog('Session:leParser unknown ID = '+IntToStr(LanGetParserID));
      [*] = ;               end;
      [*] = ;            end;
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;      //
      [*] = ;      // NOTE: recursive in connection cycle : - leShutdown : ExecuteState('SwitchToMenu');
      [*] = ;      //
      [*] = ;      leConnect : OnConnect;
      [*] = ;      leParser : ParserReceived;
      [*] = ;      leServerInfo : begin
      [*] = ;         LogEvent('leServerInfo');
      [*] = ;      end;
      [*] = ;      leShellUpdateTopList : begin
      [*] = ;         // LanPublicServerUpdateTopUsers(20);
      [*] = ;         var pLan : Integer = LanSelectParser;
      [*] = ;         var i : Integer;
      [*] = ;         for i := 0 to ParserGetCountByHandle(pLan)-1 do
      [*] = ;         begin
      [*] = ;            var pItem : Integer = ParserSelectByHandleByIndex(pLan, i);
      [*] = ;            var sLine : String = IntToStr(i+1)+' '+#9;
      [*] = ;            sLine := sLine + ParserGetValueByKeyByHandle(pItem, 'nick')+' '+#9;
      [*] = ;            //sLine := sLine + ParserGetValueByKeyByHandle(pItem, 'country')+' '+#9;
      [*] = ;            sLine := sLine + GetLocaleTableListItemByID('misc', 'inet.rank.'+IntToStr(_misc_GetRankIndex(ParserGetIntValueByKeyByHandle(pItem, 'score'))))+' '+#9;
      [*] = ;            sLine := sLine + ParserGetValueByKeyByHandle(pItem, 'score')+' '+#9;
      [*] = ;            sLine := sLine + ParserGetValueByKeyByHandle(pItem, 'games')+' '+#9;
      [*] = ;            sLine := sLine + ParserGetValueByKeyByHandle(pItem, 'wins')+' '+#9;
      [*] = ;
      [*] = ;            if ParserGetIntValueByKeyByHandle(pItem, 'games') > 0 then
      [*] = ;            sLine := sLine + IntToStr(Round(100*ParserGetIntValueByKeyByHandle(pItem, 'wins')/ParserGetIntValueByKeyByHandle(pItem, 'games')))+ '%'#9
      [*] = ;            else
      [*] = ;            sLine := sLine + '0%'+ #9;
      [*] = ;
      [*] = ;            //GUIListBoxAddItem(iElmHandle, sLine, 0);
      [*] = ;            Log(sLine);
      [*] = ;         end;
      [*] = ;         LogEvent('leShellUpdateTopList');
      [*] = ;      end;
      [*] = ;      //
      [*] = ;      leShutdown : begin
      [*] = ;         LogEvent('leShutdown');
      [*] = ;         if (gstring_gui_connectserver='') then
      [*] = ;         begin
      [*] = ;            if (gInternetShell.prevstate<0) then
      [*] = ;            begin
      [*] = ;               _gui_SendTagToState('EventInternetShell', gc_gui_event_tagHide);
      [*] = ;               _gui_InitShowMainMenu(True);
      [*] = ;            end
      [*] = ;            else
      [*] = ;            if (gInternetShell.bauth) then
      [*] = ;            begin
      [*] = ;               if (gInternetShell.prevstate<5) then
      [*] = ;               _misc_ConnectIPIndexIncrease;
      [*] = ;               _gui_ShowConnectStateMessage(gc_ConnectState_Disconnect);
      [*] = ;               if (gInterface.gamemode=gc_gamemode_mainmenu) then
      [*] = ;               begin
      [*] = ;                  _gui_InitShowMainMenu(True);
      [*] = ;                  _gui_SetGUIElementVisibleByName('MainMenu.col1', False);
      [*] = ;               end;
      [*] = ;            end
      [*] = ;            else
      [*] = ;            if (gint_gui_connectserverstate<>1) then
      [*] = ;            begin
      [*] = ;               _misc_ConnectIPIndexIncrease;
      [*] = ;               _gui_ShowConnectStateMessage(gc_ConnectState_Disconnect);
      [*] = ;            end;
      [*] = ;            gInternetShell.bauth := False;
      [*] = ;            gInternetShell.prevstate := 1;
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;      leClientInfo : LogEvent('leClientInfo');
      [*] = ;      leShellClientUpdateInfo : LogEvent('leShellClientUpdateInfo');
      [*] = ;      leDisconnect : begin
      [*] = ;         LogEvent('leDisconnect');
      [*] = ;         //var idFrom : Integer = LanPublicServerGetRegIDFrom;
      [*] = ;         var idFrom : Integer = GetIntValueByName('Tag');
      [*] = ;
      [*] = ;         if (gInternetShell.selsessionid=idFrom) then
      [*] = ;         gInternetShell.selsessionid := 0;
      [*] = ;
      [*] = ;         if (idFrom<>0) then
      [*] = ;         begin
      [*] = ;            var pClient : Integer = _parser_ParserTemporary(True);
      [*] = ;            if (LanPublicServerGetClientInfoToParserByClientID(idFrom, pClient)) then
      [*] = ;            begin
      [*] = ;               var p : Pointer = gInternetShell.clients.AddOrUpdateFromParser(pClient);
      [*] = ;               // this info is not valid in pClient yet, but it should be like this
      [*] = ;               TInternetShellClient(p).states.bplay := False;
      [*] = ;               TInternetShellClient(p).states.bmaster := False;
      [*] = ;               TInternetShellClient(p).states.bsession := False;
      [*] = ;            end;
      [*] = ;         end;
      [*] = ;         if (not gInternetShell.bshowroom) then
      [*] = ;         gbool_gui_showinternetshell := True;
      [*] = ;      end;
      [*] = ;      else ErrorLog('unhandled lan event=' + IntToStr(gLanEvent));
      [*] = ;   end;
      [*] = ;end
      [*] = ;else
      [*] = ;ErrorLog('OnLanEvent and not IsLanPublicServerMode lanevent='+IntToStr(gLanEvent));
   struct.end
section.end

