section.begin
   Name = ShowSettings
   Code : struct.begin
      [*] = ;function CreateSimpleSlider(const sliderid : String; invalue : Float; parent, hAlign, vAlign : Integer; posX, posY : Integer; var eventState : String; bGetUpdate : Boolean) : Integer;
      [*] = ;begin
      [*] = ;   var nul : String;
      [*] = ;   const cMaterialMiddle = 'slider.line';
      [*] = ;   const cMaterialBtn = 'slider.btn';
      [*] = ;   var value : Float = Clamp(inValue, 0, 1);
      [*] = ;   var sliderWidth : Integer = GetGUITextureWidth(cMaterialMiddle);
      [*] = ;   var btnWidth : Integer = GetGUITextureWidth(cMaterialBtn+'.normal');
      [*] = ;   var btnHeight : Integer = GetGUITextureHeight(cMaterialBtn+'.normal');
      [*] = ;   var elmSlider : Integer = _gui_CreateImageActive('sliderline', parent, gc_gui_material_blank, hAlign, vAlign, posX, posY, sliderWidth, btnHeight-1, 0, eventState, nul, bGetUpdate);
      [*] = ;   SetGUIElementStringTag(elmSlider, sliderID);
      [*] = ;   var elmHnd : Integer = _gui_CreateTileScaleImage(sliderid, elmSlider, cMaterialMiddle, gc_halParentLeft, gc_valParentMiddle, 0, 0, 0, 0, bGetUpdate);
      [*] = ;   var elmBtn : Integer = _gui_CreateButton('sliderbtn', elmSlider, cMaterialBtn, gc_halParentLeft, gc_valParentTop, 0, -1, 0, 0, eventState, nul, 0, bGetUpdate);
      [*] = ;   var sliderXOffset : Integer = 11;
      [*] = ;   SetGUIElementPositionX(elmBtn, (-btnWidth div 2)+sliderXOffset+round(value*(sliderWidth-sliderXOffset*2)));
      [*] = ;   Result := elmSlider;
      [*] = ;end;
      [*] = ;
      [*] = ;procedure GetCheckBoxStringTagWithConfigEngineOption(var stringTag : String; configName, curValue : String; pConfig : Integer; var valueind : Integer; var caption : String);
      [*] = ;begin
      [*] = ;   stringTag := '';
      [*] = ;   caption := configName;
      [*] = ;   if (pConfig<>0) then
      [*] = ;   begin
      [*] = ;      var pEngine : Integer = ParserSelectByHandleByKey(pConfig, 'engine');
      [*] = ;      if (pEngine<>0) then
      [*] = ;      begin
      [*] = ;         var pEngineConfigs : Integer = ParserSelectByHandleByKey(pEngine, 'config');
      [*] = ;         if (pEngineConfigs<>0) then
      [*] = ;         begin
      [*] = ;            var pEngineConfig : Integer = ParserSelectByHandleByIndex(pEngineConfigs, ParserFindChildIndexByEqualChildKey('Name', configName));
      [*] = ;            if (pEngineConfig=0) then
      [*] = ;            begin
      [*] = ;               pEngine := ParserSelectByHandleByKey(pConfig, 'game');
      [*] = ;               if (pEngine<>0) then
      [*] = ;               begin
      [*] = ;                  pEngineConfigs := ParserSelectByHandleByKey(pEngine, 'config');
      [*] = ;                  if (pEngineConfigs<>0) then
      [*] = ;                  pEngineConfig := ParserSelectByHandleByIndex(pEngineConfigs, ParserFindChildIndexByEqualChildKey('Name', configName));
      [*] = ;               end;
      [*] = ;            end;
      [*] = ;            if (pEngineConfig<>0) then
      [*] = ;            begin
      [*] = ;               var pGui : Integer = ParserSelectByHandleByKey(pEngineConfig, 'Gui');
      [*] = ;               if (pGui<>0) then
      [*] = ;               begin
      [*] = ;                  caption := ParserGetValueByKeyByHandle(pGui, 'Caption');
      [*] = ;                  var pValues : Integer = ParserSelectByHandleByKey(pEngineConfig, 'Values');
      [*] = ;                  if (pValues<>0) then
      [*] = ;                  begin
      [*] = ;                     valueind := ParserFindChildIndexByEqualChildKey('value', curValue);
      [*] = ;                     var valueCount : Integer = ParserGetCountByHandle(pValues);
      [*] = ;                     if (valueCount>2) then
      [*] = ;                     ErrorLog('GetCheckBoxStringTagWithConfigEngineOption : valueCount>2');
      [*] = ;                     var i : Integer;
      [*] = ;                     for i:=0 to valueCount-1 do
      [*] = ;                     begin
      [*] = ;                        var pValue : Integer = ParserSelectByHandleByIndex(pValues, i);
      [*] = ;                        var value : String = ParserGetValueByKeyByHandle(pValue, 'value');
      [*] = ;                        if (stringTag<>'') then
      [*] = ;                        stringTag := stringTag+'|'+value
      [*] = ;                        else
      [*] = ;                        stringTag := value;
      [*] = ;                     end;
      [*] = ;                  end;
      [*] = ;               end;
      [*] = ;            end;
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;   end;
      [*] = ;end;
      [*] = ;
      [*] = ;procedure GetConfigEngineOption(configName, curValue : String; pConfig : Integer; var valueind, valuecount : Integer; var caption : String);
      [*] = ;begin
      [*] = ;   caption := configName;
      [*] = ;   if (pConfig<>0) then
      [*] = ;   begin
      [*] = ;      var pEngine : Integer = ParserSelectByHandleByKey(pConfig, 'engine');
      [*] = ;      if (pEngine<>0) then
      [*] = ;      begin
      [*] = ;         var pEngineConfigs : Integer = ParserSelectByHandleByKey(pEngine, 'config');
      [*] = ;         if (pEngineConfigs<>0) then
      [*] = ;         begin
      [*] = ;            var pEngineConfig : Integer = ParserSelectByHandleByIndex(pEngineConfigs, ParserFindChildIndexByEqualChildKey('Name', configName));
      [*] = ;            if (pEngineConfig=0) then
      [*] = ;            begin
      [*] = ;               pEngine := ParserSelectByHandleByKey(pConfig, 'game');
      [*] = ;               if (pEngine<>0) then
      [*] = ;               begin
      [*] = ;                  pEngineConfigs := ParserSelectByHandleByKey(pEngine, 'config');
      [*] = ;                  if (pEngineConfigs<>0) then
      [*] = ;                  pEngineConfig := ParserSelectByHandleByIndex(pEngineConfigs, ParserFindChildIndexByEqualChildKey('Name', configName));
      [*] = ;                  if (pEngineConfig=0) then
      [*] = ;                  begin
      [*] = ;                     var pResources : Integer = ParserSelectByHandleByKey(pConfig, 'resource');
      [*] = ;                     if (pResources<>0) then
      [*] = ;                     begin
      [*] = ;                        var pResourceConfigs : Integer = ParserSelectByHandleByKey(pResources, 'config');
      [*] = ;                        if (pResourceConfigs<>0) then
      [*] = ;                        pEngineConfig := ParserSelectByHandleByIndex(pResourceConfigs, ParserFindChildIndexByEqualChildKey('Name', configName));
      [*] = ;                     end;
      [*] = ;                  end;
      [*] = ;               end;
      [*] = ;            end;
      [*] = ;            if (pEngineConfig<>0) then
      [*] = ;            begin
      [*] = ;               var pGui : Integer = ParserSelectByHandleByKey(pEngineConfig, 'Gui');
      [*] = ;               if (pGui<>0) then
      [*] = ;               begin
      [*] = ;                  caption := ParserGetValueByKeyByHandle(pGui, 'Caption');
      [*] = ;                  var pValues : Integer = ParserSelectByHandleByKey(pEngineConfig, 'Values');
      [*] = ;                  if (pValues<>0) then
      [*] = ;                  begin
      [*] = ;                     valueind := ParserFindChildIndexByEqualChildKey('value', curValue);
      [*] = ;                     valuecount := ParserGetCountByHandle(pValues);
      [*] = ;                  end;
      [*] = ;               end;
      [*] = ;            end;
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;   end;
      [*] = ;end;
      [*] = ;
      [*] = ;procedure FillListBoxWithConfigEngineOption(configName, curValue : String; elmList, pConfig : Integer);
      [*] = ;begin
      [*] = ;   if (pConfig<>0) then
      [*] = ;   begin
      [*] = ;      var pEngine : Integer = ParserSelectByHandleByKey(pConfig, 'engine');
      [*] = ;      if (pEngine<>0) then
      [*] = ;      begin
      [*] = ;         var pEngineConfigs : Integer = ParserSelectByHandleByKey(pEngine, 'config');
      [*] = ;         if (pEngineConfigs<>0) then
      [*] = ;         begin
      [*] = ;            var pEngineConfig : Integer = ParserSelectByHandleByIndex(pEngineConfigs, ParserFindChildIndexByEqualChildKey('Name', configName));
      [*] = ;            if (pEngineConfig=0) then
      [*] = ;            begin
      [*] = ;               pEngine := ParserSelectByHandleByKey(pConfig, 'game');
      [*] = ;               if (pEngine<>0) then
      [*] = ;               begin
      [*] = ;                  pEngineConfigs := ParserSelectByHandleByKey(pEngine, 'config');
      [*] = ;                  if (pEngineConfigs<>0) then
      [*] = ;                  pEngineConfig := ParserSelectByHandleByIndex(pEngineConfigs, ParserFindChildIndexByEqualChildKey('Name', configName));
      [*] = ;                  if (pEngineConfig=0) then
      [*] = ;                  begin
      [*] = ;                     var pResources : Integer = ParserSelectByHandleByKey(pConfig, 'resource');
      [*] = ;                     if (pResources<>0) then
      [*] = ;                     begin
      [*] = ;                        var pResourceConfigs : Integer = ParserSelectByHandleByKey(pResources, 'config');
      [*] = ;                        if (pResourceConfigs<>0) then
      [*] = ;                        pEngineConfig := ParserSelectByHandleByIndex(pResourceConfigs, ParserFindChildIndexByEqualChildKey('Name', configName));
      [*] = ;                     end;
      [*] = ;                  end;
      [*] = ;               end;
      [*] = ;            end;
      [*] = ;            if (pEngineConfig<>0) then
      [*] = ;            begin
      [*] = ;               var pGui : Integer = ParserSelectByHandleByKey(pEngineConfig, 'Gui');
      [*] = ;               if (pGui<>0) then
      [*] = ;               begin
      [*] = ;                  var pValues : Integer = ParserSelectByHandleByKey(pEngineConfig, 'Values');
      [*] = ;                  if (pValues<>0) then
      [*] = ;                  begin
      [*] = ;                     var valueind : Integer = ParserFindChildIndexByEqualChildKey('value', curValue);
      [*] = ;                     var valuecount : Integer = ParserGetCountByHandle(pValues);
      [*] = ;                     var i : Integer;
      [*] = ;                     var stringTag : String;
      [*] = ;                     for i:=0 to valueCount-1 do
      [*] = ;                     begin
      [*] = ;                        var pValue : Integer = ParserSelectByHandleByIndex(pValues, i);
      [*] = ;                        var key : String = ParserGetValueByKeyByHandle(pValue, 'key');
      [*] = ;                        GUIListBoxAddItem(elmList, GetLocaleTableListItemByID('tools', key), i);
      [*] = ;
      [*] = ;                        var value : String = ParserGetValueByKeyByHandle(pValue, 'value');
      [*] = ;                        if (stringTag<>'') then
      [*] = ;                        stringTag := stringTag+'|'+value
      [*] = ;                        else
      [*] = ;                        stringTag := value;
      [*] = ;                     end;
      [*] = ;                     SetGUIElementStringTag(elmList, stringTag);
      [*] = ;                     SetGUIListBoxItemIndexSilent(elmList, valueind);
      [*] = ;                  end;
      [*] = ;               end;
      [*] = ;            end;
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;   end;
      [*] = ;end;
      [*] = ;
      [*] = ;function GetResolutionCount() : Integer;
      [*] = ;begin
      [*] = ;   Result := 0;
      [*] = ;   var pParser : Integer = ParserCreate('tmp');
      [*] = ;   GetAvailableResolutionsToActiveParser(False, 1000, 768);
      [*] = ;   var pParserWide : Integer = ParserCreate('tmpwide');
      [*] = ;   GetAvailableResolutionsToActiveParser(True, 1000, 768);
      [*] = ;   if (ParserGetCountByHandle(pParser)=0) then
      [*] = ;   begin
      [*] = ;      ErrorLog('No available resolutions');
      [*] = ;      GetAvailableResolutionsToActiveParser(False, 512, 512);
      [*] = ;   end;
      [*] = ;   Result := ParserGetCountByHandle(pParser)+ParserGetCountByHandle(pParserWide);
      [*] = ;end;
      [*] = ;
      [*] = ;procedure FillListBoxWithResolutions(elmList : Integer);
      [*] = ;begin
      [*] = ;   var pParser : Integer = ParserCreate('tmp');
      [*] = ;   GetAvailableResolutionsToActiveParser(False, 1000, 760);
      [*] = ;   var pParserWide : Integer = ParserCreate('tmpwide');
      [*] = ;   GetAvailableResolutionsToActiveParser(True, 1000, 760);
      [*] = ;   if (ParserGetCountByHandle(pParser)=0) then
      [*] = ;   begin
      [*] = ;      ErrorLog('No available resolutions');
      [*] = ;      GetAvailableResolutionsToActiveParser(False, 512, 512);
      [*] = ;   end;
      [*] = ;
      [*] = ;   var i : Integer;
      [*] = ;   for i:=0 to ParserGetCountByHandle(pParser)-1 do
      [*] = ;   begin
      [*] = ;      ParserSelectByHandleByIndex(pParser, i);
      [*] = ;      var freq : Integer = ParserGetIntValueByKey('MaxFrequency');
      [*] = ;      if (freq>=60) then
      [*] = ;      begin
      [*] = ;         GUIListBoxAddItem(elmList, ParserGetValueByKey('Width') + ' x ' + ParserGetValueByKey('Height') + ' ' + ParserGetValueByKey('MaxFrequency') + 'Hz', ParserGetIntValueByKey('Index'));
      [*] = ;         if ParserGetBoolValueByKey('Default') then
      [*] = ;         SetGUIListBoxItemIndexSilent(elmList, i);
      [*] = ;      end;
      [*] = ;   end;
      [*] = ;   for i:=0 to ParserGetCountByHandle(pParserWide)-1 do
      [*] = ;   begin
      [*] = ;      ParserSelectByHandleByIndex(pParserWide, i);
      [*] = ;      var freq : Integer = ParserGetIntValueByKey('MaxFrequency');
      [*] = ;      if (freq>=60) then
      [*] = ;      begin
      [*] = ;         GUIListBoxAddItem(elmList, ParserGetValueByKey('Width') + ' x ' + ParserGetValueByKey('Height') + ' ' + ParserGetValueByKey('MaxFrequency') + 'Hz', ParserGetIntValueByKey('Index'));
      [*] = ;         if ParserGetBoolValueByKey('Default') then
      [*] = ;         SetGUIListBoxItemIndexSilent(elmList, ParserGetCountByHandle(pParser)+i);
      [*] = ;      end;
      [*] = ;   end;
      [*] = ;
      [*] = ;   ParserFree('tmp');
      [*] = ;   ParserFree('tmpwide');
      [*] = ;
      [*] = ;   if (GetGUIListBoxItemIndex(elmList)<0) then
      [*] = ;   SetGUIListBoxItemIndexSilent(elmList, 0);
      [*] = ;end;
      [*] = ;
      [*] = ;// _gui_CreateListBox
      [*] = ;//
      [*] = ;function _gui_CreateListBox(const elementName : String; parent : Integer; hAlign, vAlign : Integer; posX, posY, width, height : Integer; textHAlign, textVAlign : Integer; tOffX, tOffY, font : Integer; var eventState : String; bAddScroller, bGetUpdate : Boolean) : Integer;
      [*] = ;begin
      [*] = ;   Result := 0;
      [*] = ;   if (bGetUpdate) and (elementName='') then log('_gui_Create function with bGet flag must have specified elementName, to work properly');
      [*] = ;   if (elementName<>'') and (StrExists(elementName, '.')) then ErrorLog('_gui_Create element name should not have dot char. I this ca.se we are not able to get element handle by name. elmname='+elementName);
      [*] = ;
      [*] = ;   var rfont : String = gUIConst.font[font];
      [*] = ;   if (font=gc_font_none) then
      [*] = ;   rfont := gUIConst.font[gc_font_serif_12];
      [*] = ;   var cMaterialMiddle : String = 'combobox.background.'+IntToStr(floor(1+RandomExt*6));
      [*] = ;   const cMaterialBtn = 'combobox.btn.pressed';
      [*] = ;   const cMaterialListSelected = 'combobox.list.selected';
      [*] = ;   const cMaterialListHover = 'combobox.list.hover';
      [*] = ;   const cMaterialListBackground = 'combobox.list.background';
      [*] = ;   const cMaterialScrollerUp = 'scroller.btn.up';
      [*] = ;   const cMaterialScrollerTile = 'scroller.tile';
      [*] = ;   const cMaterialScrollerDown = 'scroller.btn.down';
      [*] = ;   var rowHeight : Integer = GetGUIElementFontHeight(rfont)+4;
      [*] = ;
      [*] = ;   var iposX : Integer = posX;
      [*] = ;   var iposY : Integer = posY;
      [*] = ;
      [*] = ;   var iwidth : Integer;
      [*] = ;   if (width<>0) then
      [*] = ;   iwidth := width
      [*] = ;   else
      [*] = ;   iwidth := GetGUIElementWidth(parent);
      [*] = ;
      [*] = ;   iwidth := iwidth-GetGUITextureWidth(cMaterialScrollerTile);
      [*] = ;
      [*] = ;   var iheight : Integer;
      [*] = ;   if (height<>0) then
      [*] = ;   iheight := height
      [*] = ;   else
      [*] = ;   iheight := GetGUIElementHeight(parent);
      [*] = ;
      [*] = ;   var color : TColor;
      [*] = ;   var colorhover : TColor;
      [*] = ;   _gui_SetupTColorInteger(255, 220, 170, 255, 0.875, color);
      [*] = ;   _gui_SetupTColorInteger(255, 220, 170, 255, 1, colorhover);
      [*] = ;
      [*] = ;   // - setup combobox
      [*] = ;   if (bGetUpdate) then
      [*] = ;   Result := GetGUIElementIndexByNameParent(elementName, parent);
      [*] = ;
      [*] = ;   if (Result=0) then
      [*] = ;   Result := AddNewElementByClassNameParent(elementName, 'TXGuiListBox', 0, parent);
      [*] = ;   SetGUIElementCursorByName(Result, 'crPress');
      [*] = ;   SetGUIElementPressState(Result, eventState);
      [*] = ;   SetGUIElementFont(Result, rfont);
      [*] = ;   SetGUIElementColor(Result, color.r, color.g, color.b, color.a);
      [*] = ;   SetGUIElementTextAlign(Result, gUIConst.halign[textHAlign], gUIConst.valign[textVAlign], tOffX, tOffY-1);
      [*] = ;   SetGUIElementTextFormatted(Result, True);
      [*] = ;   SetGUIElementAlign(Result, gUIConst.halign[hAlign], gUIConst.valign[vAlign]);
      [*] = ;   SetGUIElementPosition(Result, iposX, iposY);
      [*] = ;   SetGUIElementLogicRect(Result, iwidth, iheight);
      [*] = ;   SetGUIElementRect(Result, iwidth, iheight);
      [*] = ;   SetGUIElementMaterial(Result, gc_gui_material_blank{cMaterialMiddle});
      [*] = ;
      [*] = ;   SetGUIListBoxSelectedMaterialName(Result, cMaterialListSelected); // selected
      [*] = ;   SetGUIListBoxRowHeight(Result, rowHeight);
      [*] = ;   SetGUIListBoxVisibleRows(Result, -1);
      [*] = ;   SetGUIListBoxItemIndexSilent(Result, -1);
      [*] = ;
      [*] = ;   SetGUIListBoxMouseTrack(Result, 3); // 1 - only text change color on hover, 2 - only material appears, 3 - text and material on hover
      [*] = ;   SetGUIListBoxMouseTrackMaterialName(Result, cMaterialListHover); // hover
      [*] = ;   SetGUIListBoxMouseTrackFontColor(Result, colorhover.r, colorhover.g, colorhover.b, colorhover.a);
      [*] = ;
      [*] = ;   if (bAddScroller) then
      [*] = ;   _gui_AddScroller(Result, gc_halParentRightWidth, gc_valParentTop, GetGUITextureWidth(cMaterialScrollerTile), GetGUITextureHeight(cMaterialScrollerUp), GetGUITextureWidth(cMaterialScrollerTile), GetGUIElementHeight(Result), True);
      [*] = ;end;
      [*] = ;
      [*] = ;const bupdate = False;
      [*] = ;const currentstatename = 'ShowSettings';
      [*] = ;var elmname, showstate, eventstate : String;
      [*] = ;_misc_GetGUIShowEventStateNames(currentstatename, elmname, showstate, eventstate);
      [*] = ;
      [*] = ;dbgstatename := showstate;
      [*] = ;
      [*] = ;const cmargin = 6;
      [*] = ;const cmargin1 = cmargin;
      [*] = ;const cmargin2 = cmargin*2;
      [*] = ;const cmargin3 = cmargin*3;
      [*] = ;const cmargin4 = cmargin*4;
      [*] = ;const cmargin5 = cmargin*5;
      [*] = ;const cmargin6 = cmargin*6;
      [*] = ;const cmargin7 = cmargin*7;
      [*] = ;const cmargin8 = cmargin*8;
      [*] = ;
      [*] = ;const cInputBoxWidth = 256;
      [*] = ;const cTextWrapWidth = 300;
      [*] = ;const cMinWidth = 256;
      [*] = ;const cMinHeight = 140;
      [*] = ;
      [*] = ;const cTagTabVideo = 102;
      [*] = ;const cTagTabSound = 103;
      [*] = ;const cTagTabControl = 104;
      [*] = ;const cTagTabKeyBinding = 105;
      [*] = ;const cTagCheckboxShadows = 110;
      [*] = ;const cTagCheckboxAntialiasing = 111;
      [*] = ;const cTagCheckboxVSync = 112;
      [*] = ;const cTagAccept = 90;
      [*] = ;const cTagCancel = 91;
      [*] = ;const cTagDefault = 92;
      [*] = ;{const cTagCheckboxClampingMouse = 113;
      [*] = ;const cTagCheckboxSSAO = 114;
      [*] = ;const cTagCheckboxFXAO = 115;
      [*] = ;const cTagCheckboxMute = 120;}
      [*] = ;
      [*] = ;var cTextHeaderSettings : String = 'gui|settings.text.header';
      [*] = ;var cTextTabVideo : String = 'gui|settings.tab.video';
      [*] = ;var cTextTabSound : String = 'gui|settings.tab.sound';
      [*] = ;var cTextTabControl : String = 'gui|settings.tab.control';
      [*] = ;var cTextTabKeyBinding : String = 'gui|settings.tab.keybinding';
      [*] = ;var cTextScreen : String = 'gui|settings.text.screen';
      [*] = ;var cTextQuality : String = 'gui|settings.text.quality';
      [*] = ;var cTextSoundSettings : String = 'gui|settings.text.soundsettings';
      [*] = ;var cTextControlSettings : String = 'gui|settings.text.control';
      [*] = ;var cTextGameplaySettings : String = 'gui|settings.text.gameplay';
      [*] = ;var cTextKeyBindingSettings : String = 'gui|settings.text.keybinding';
      [*] = ;var cTextPreset : String = 'gui|settings.text.graphicsquality';
      [*] = ;var cTextPresetCustom : String = 'gui|settings.text.presetcustom';
      [*] = ;var cTextResolution : String = 'gui|settings.text.resolution';
      [*] = ;var cTextLightChange : String = 'gui|settings.text.lightpreset';
      [*] = ;var cTextTextureQuality : String = 'gui|settings.text.texturequality';
      [*] = ;var cTextMute : String = 'gui|settings.text.mute';
      [*] = ;var cTextSetDefault : String = gc_loc_tools+'|GUI.SET.DEFAULT.INTERFACE';
      [*] = ;var cTextClampingMouse : String = 'gui|settings.text.clampingmouse';
      [*] = ;var cTextLanguage : String = 'tools|CFG.PROFILE.LANGUAGE';
      [*] = ;var cTextAccept : String = 'tools|CFG.BTN.ACCEPT';
      [*] = ;var cTextCancel : String = 'tools|CFG.BTN.CANCEL';
      [*] = ;
      [*] = ;const cProjOptionsPreset = 'Preset';
      [*] = ;const cProjOptionsPresetLow = 'guiSetLow';
      [*] = ;const cProjOptionsPresetMedium = 'guiSetMedium';
      [*] = ;const cProjOptionsPresetHigh = 'guiSetHigh';
      [*] = ;const cProjOptionsPresetUltra = 'guiSetUltra';
      [*] = ;const cProjOptionsPresetCustom = 'guiSetCustom';
      [*] = ;const cProjOptionsResolution = 'Resolution';
      [*] = ;const cProjOptionsAntiAliasing = 'AntiAliasing';
      [*] = ;const cProjOptionsFXAAEnable = 'FXAAEnable';
      [*] = ;const cProjOptionsSSAOEnable = 'SSAOEnable';
      [*] = ;const cProjOptionsHDRType = 'HDRType';
      [*] = ;const cProjOptionsVSyncMode = 'VSyncMode';
      [*] = ;const cProjOptionsShadowMap = 'ShadowMap';
      [*] = ;const cProjOptionsShadowEnabled = 'ShadowMapEnabled';
      [*] = ;const cProjOptionsTextureQuality = 'DDSDetailLevel';
      [*] = ;const cProjOptionsTextureFilter = 'TextureFilteringQuality';
      [*] = ;const cProjOptionsShaderType = 'ShaderType';
      [*] = ;const cProjOptionsWaterReflection = 'WaterReflection';
      [*] = ;const cProjOptionsLightChange = 'lightchange';
      [*] = ;const cProjOptionsDisplayMode = 'DisplayMode';
      [*] = ;
      [*] = ;const cResourceOptionsLanguage = 'LocaleTableFileName';
      [*] = ;const cResourceOptionsDisplayMode = 'DisplayMode';
      [*] = ;
      [*] = ;const cGameOptionsAutosave = 'bautosave';
      [*] = ;const cGameOptionsGameSpeed = 'igamespeed';
      [*] = ;const cGameOptionsWheelSpeed = 'wheelspeed';
      [*] = ;const cGameOptionsMouseScrollSpeed = 'mousescrollspeed';
      [*] = ;const cGameOptionsKeyScrollSpeed = 'keyscrollspeed';
      [*] = ;const cGameOptionsMiddleMouseScrollSpeed = 'middlemousescrollspeed';
      [*] = ;const cGameOptionsClampingMouse = 'bclipmouse';
      [*] = ;
      [*] = ;const cGameOptionsMute = 'sndmute';
      [*] = ;const cGameOptionsMaster = 'sndmaster';
      [*] = ;const cGameOptionsMusic = 'sndmusic';
      [*] = ;const cGameOptionsAmbient = 'sndambient';
      [*] = ;const cGameOptionsFx = 'sndfx';
      [*] = ;const cGameOptionsInterface = 'sndinterface';
      [*] = ;
      [*] = ;const cGameOptionsBrushUnderUnit = 'bbrushunderunit';
      [*] = ;const cGameOptionsSearchEnemyInFront = 'bsearchenemyinfront';
      [*] = ;const cGameOptionsInfiniteOnLeftClick = 'binfiniteonleftclick';
      [*] = ;const cGameOptionsSelectAllUnitsOnZ = 'bselectallunitsonz';
      [*] = ;const cGameOptionsCenterSquadPos = 'bcenterfirstrow';
      [*] = ;
      [*] = ;var pConfig : Integer = ParserSelectByKey('config');
      [*] = ;if (pConfig=0) then
      [*] = ;begin
      [*] = ;   pConfig := ParserCreate('config');
      [*] = ;   ParserLoadFromFile('.\data\resources\config.res');
      [*] = ;end;
      [*] = ;
      [*] = ;var randkey : Integer = GetRandomKey;
      [*] = ;SetRandomKey(260); // used in combobox render
      [*] = ;
      [*] = ;// variables
      [*] = ;var elmHnd : Integer;
      [*] = ;var nul, text : String;
      [*] = ;var w, h : Integer;
      [*] = ;var maxwidth : Integer = cMinWidth;
      [*] = ;var maxheight : Integer = cMinHeight;
      [*] = ;var color, btncolor, headcolor, tipcolor : TColor;
      [*] = ;_gui_SetupTColorInteger(48, 32, 32, 255, 1, color);
      [*] = ;_gui_SetupTColorInteger(255, 220, 170, 255, 0.9, btncolor);
      [*] = ;_gui_SetupTColorInteger(255, 220, 170, 255, 0.925, headcolor);
      [*] = ;_gui_SetupTColorInteger(255, 220, 170, 255, 0.85, tipcolor);
      [*] = ;
      [*] = ;function ShowText(const elmName : String; elmHnd, parentHnd : Integer; var text : String; font, margin : Integer) : Integer;
      [*] = ;begin
      [*] = ;   var stext : String = GetGUIWrappedTextByFont(gUIConst.font[font], text, cTextWrapWidth);
      [*] = ;   GetGUIElementFontTextRect(gUIConst.font[font], stext, w, h);
      [*] = ;   maxwidth := Max(maxwidth, w);
      [*] = ;   Result := _gui_CreateText(elmName, parentHnd, stext, gc_halParentMiddle, gc_valParentTop, 0, _gui_GetBottomPos(elmHnd)+margin, 0, 0, gc_halLeft, gc_valTop, font, color, bupdate);
      [*] = ;end;
      [*] = ;function ShowInput(const elmName : String; elmHnd, parentHnd : Integer; var descr, text : String; charfilter : String; margin : Integer; bPassword, bEnabled, bFocused : Boolean) : Integer;
      [*] = ;begin
      [*] = ;   const descrfont : Integer = gc_font_serif_15;
      [*] = ;   const inputfont : Integer = gc_font_serif_13;
      [*] = ;   const passwfont : Integer = gc_font_pass_14;
      [*] = ;   var font : Integer;
      [*] = ;   if (bPassword) then
      [*] = ;   font := passwfont
      [*] = ;   else
      [*] = ;   font := inputfont;
      [*] = ;   Result := _gui_CreateInputBox(elmName, parentHnd, text, gc_halParentMiddle, gc_valParentTop, 0, _gui_GetBottomPos(elmHnd)+GetGUIElementFontHeight(gUIConst.font[gc_font_serif_15])+margin, cInputBoxWidth, 64, eventstate, nul, bEnabled, 10, 1, gc_halLeft, gc_valMiddle, font, 1, 1, 1, 1, bupdate);
      [*] = ;   if (bFocused) then
      [*] = ;   begin
      [*] = ;      var tmpHnd : Integer = GetGUIElementIndexByNameParent('text', Result);
      [*] = ;      SetGUIElementFocusedHandle(tmpHnd);
      [*] = ;   end;
      [*] = ;   _gui_CreateText('t2', Result, descr, gc_halParentMiddle, gc_valParentTop, 0, -GetGUIElementFontHeight(gUIConst.font[gc_font_serif_15]), GetGUIElementWidth(Result), 0, gc_halMiddle, gc_valMiddle, descrfont, color, bupdate);
      [*] = ;   if (charfilter<>'') then
      [*] = ;   _gui_InputBoxSetupStrCharFilter(Result, True, charfilter);
      [*] = ;   maxwidth := Max(maxwidth, GetGUIElementWidth(Result));
      [*] = ;end;
      [*] = ;function ShowButton(const elmName : String; elmHnd, parentHnd : Integer; btnMaterial : String; var text : String; margin, tag : Integer; bEnabled : Boolean) : Integer;
      [*] = ;begin
      [*] = ;   var posy : Integer;
      [*] = ;   if (elmHnd<>0) then
      [*] = ;   posy := _gui_GetBottomPos(elmHnd);
      [*] = ;   Result := _gui_CreateButton(elmName, parentHnd, btnMaterial, gc_halParentMiddle, gc_valParentTop, 0, posy+margin, 0, 0, eventstate, nul, tag, bupdate);
      [*] = ;   SetGUIElementEnabled(Result, bEnabled);
      [*] = ;   _gui_CreateText('txtbtn', Result, text, gc_halParentMiddle, gc_valParentMiddle, 0, 0, 0, 0, gc_halLeft, gc_valMiddle, gc_font_serif_15, btncolor, bupdate);
      [*] = ;end;
      [*] = ;
      [*] = ;// consts
      [*] = ;const cBaseOffsetX = 10;
      [*] = ;const cBaseOffsetY = 31;
      [*] = ;const cSliderXOffset = 14;
      [*] = ;const cCheckboxXOffset = 2;
      [*] = ;const cSliderHintYOffset = 27;
      [*] = ;const cSliderHintYPadding = 8;
      [*] = ;const cOffsetY = 56;
      [*] = ;const cOffsetYCheckbox = 32;
      [*] = ;const cOffsetYSlider = 15+cSliderHintYOffset;
      [*] = ;const cOffsetYMargin = 2;
      [*] = ;const cCheckboxTextOffsetX = 28;
      [*] = ;const cCheckboxTextOffsetY = 1;
      [*] = ;const cPaddingW = cmargin+1+4;
      [*] = ;const cPaddingH = cmargin+1+30;
      [*] = ;
      [*] = ;// parent
      [*] = ;const cWidth = 846+100;
      [*] = ;const cHeight = 509+60+13;
      [*] = ;const cBorderOffset = 41;
      [*] = ;const cRealWidth  = cWidth-cBorderOffset;
      [*] = ;const cRealHeight = cHeight-cBorderOffset*2;
      [*] = ;var elmParent : Integer = _gui_CreateParent(elmname, 0, gc_halLeft, gc_valTop, 0, 0, GetViewerWidth, GetViewerHeight, bupdate);
      [*] = ;var elmMask : Integer = _gui_CreateImageActive('blackmask', elmParent, gc_gui_material_black, gc_halParentLeft, gc_valParentTop, 0, 0, GetViewerWidth, GetViewerHeight, 0, '', '', bupdate);
      [*] = ;var elmBackgroundParent : Integer = _gui_CreateParent('backgroundparent', elmParent, gc_halLeft, gc_valTop, 0, 0, GetViewerWidth, GetViewerHeight, bupdate);
      [*] = ;var elmMain : Integer = _gui_CreateParent('main', elmParent, gc_halParentMiddle, gc_valParentMiddle, 0, 10, cRealWidth, cheight-cBorderOffset, bupdate);
      [*] = ;const cTabsOffsetX = -30;
      [*] = ;const cButtonMarginY = 42;
      [*] = ;const cButtonMarginX = 100;
      [*] = ;const cButtonOffsetX = 0;
      [*] = ;var elmCol1 : Integer = _gui_CreateParent('col1', elmParent, gc_halParentMiddle, gc_valParentMiddle, -GetGUIElementWidth(elmMain) div 3, 10-(cButtonMarginY div 2), GetGUIElementWidth(elmMain) div 3-2, GetGUIElementHeight(elmMain)-cButtonMarginY, bupdate);
      [*] = ;var elmCol2 : Integer = _gui_CreateParent('col2', elmParent, gc_halParentMiddle, gc_valParentMiddle, cTabsOffsetX, 10-(cButtonMarginY div 2), GetGUIElementWidth(elmMain) div 3-2, GetGUIElementHeight(elmMain)-cButtonMarginY, bupdate);
      [*] = ;var elmCol3 : Integer = _gui_CreateParent('col3', elmParent, gc_halParentMiddle, gc_valParentMiddle, cTabsOffsetX+GetGUIElementWidth(elmMain) div 3, 10-(cButtonMarginY div 2), GetGUIElementWidth(elmMain) div 3-2, GetGUIElementHeight(elmMain)-cButtonMarginY, bupdate);
      [*] = ;SetGUIElementUserBlend(elmMask, _misc_SwitchFloat(0, 0.35, gInterface.gamemode=gc_gamemode_mainmenu));
      [*] = ;SetGUIElementPressState(elmParent, eventstate);
      [*] = ;SetGUIEventStateOnKeyDown(eventstate);
      [*] = ;
      [*] = ;elmHnd := ShowButton('bvideo', 0, elmCol1, 'btn.medium', cTextTabVideo, 120, cTagTabVideo, True); SetGUIElementChecked(elmHnd, gInterface.settings=gc_settings_video);
      [*] = ;elmHnd := ShowButton('bsound', elmHnd, elmCol1, 'btn.medium', cTextTabSound, cmargin2, cTagTabSound, True); SetGUIElementChecked(elmHnd, gInterface.settings=gc_settings_sound);
      [*] = ;elmHnd := ShowButton('bcontrol', elmHnd, elmCol1, 'btn.medium', cTextTabControl, cmargin2, cTagTabControl, True); SetGUIElementChecked(elmHnd, gInterface.settings=gc_settings_control);
      [*] = ;elmHnd := ShowButton('bkeybinding', elmHnd, elmCol1, 'btn.medium', cTextTabKeyBinding, cmargin2, cTagTabKeyBinding, False); SetGUIElementChecked(elmHnd, gInterface.settings=gc_settings_keybinding);
      [*] = ;SetGUIElementVisible(elmHnd, False);
      [*] = ;
      [*] = ;elmHnd := _gui_CreateButton('baccept', elmMain, 'btn.small', gc_halParentMiddle, gc_valParentBottomHeight, -cButtonMarginX+cButtonOffsetX, -18, 0, 0, eventstate, nul, cTagAccept, bupdate);
      [*] = ;_gui_CreateText('txtbtn', elmHnd, cTextAccept, gc_halParentMiddle, gc_valParentMiddle, 0, 0, 0, 0, gc_halLeft, gc_valMiddle, gc_font_serif_15, btncolor, bupdate);
      [*] = ;elmHnd := _gui_CreateButton('bcancel', elmMain, 'btn.small', gc_halParentMiddle, gc_valParentBottomHeight, cButtonMarginX+cButtonOffsetX, -18, 0, 0, eventstate, nul, cTagCancel, bupdate);
      [*] = ;_gui_CreateText('txtbtn', elmHnd, cTextCancel, gc_halParentMiddle, gc_valParentMiddle, 0, 0, 0, 0, gc_halLeft, gc_valMiddle, gc_font_serif_15, btncolor, bupdate);
      [*] = ;elmHnd := _gui_CreateButton('bsetdefault', elmMain, 'btn.small', gc_halParentMiddle, gc_valParentBottomHeight, -299, -108, 0, 0, eventstate, nul, cTagDefault, bupdate);
      [*] = ;text := cTextSetDefault; _gui_CreateText('txtbtn', elmHnd, text, gc_halParentMiddle, gc_valParentMiddle, 0, 0, 0, 0, gc_halLeft, gc_valMiddle, gc_font_serif_15, btncolor, bupdate);
      [*] = ;
      [*] = ;var skinHeadOffset : Integer = GetGUITextureHeight('skin.header.l')+5;
      [*] = ;var elmCol2Background : Integer = _gui_CreateSkinWindow('back', elmCol2, gc_halParentMiddle, gc_valParentTop, 0, skinHeadOffset+cPaddingH, GetGUIElementWidth(elmCol2)-cPaddingW*2, GetGUIElementHeight(elmCol2)-skinHeadOffset-cPaddingH*2, 1, bupdate);
      [*] = ;var elmCol3Background : Integer = _gui_CreateSkinWindow('back', elmCol3, gc_halParentMiddle, gc_valParentTop, 0, skinHeadOffset+cPaddingH, GetGUIElementWidth(elmCol2)-cPaddingW*2, GetGUIElementHeight(elmCol2)-skinHeadOffset-cPaddingH*2, 1, bupdate);
      [*] = ;var elmCol2HeadHnd : Integer = _gui_CreateSkinHeadWindow('sh_0', elmCol2Background, gc_halParentLeft, gc_valParentTop, 0, -skinHeadOffset, GetGUIElementWidth(elmCol2Background), bupdate);
      [*] = ;elmHnd := _gui_CreateMetalLine('mft_0', elmCol2Background, gc_halParentLeft, gc_valParentTop, -4, -4, GetGUIElementWidth(elmCol2Background)+8, 0, True, bupdate);
      [*] = ;elmHnd := _gui_CreateMetalLine('mft_1', elmCol2Background, gc_halParentLeft, gc_valParentTop, -4, -skinHeadOffset-3, GetGUIElementWidth(elmCol2Background)+8, 0, True, bupdate);
      [*] = ;elmHnd := _gui_CreateMetalLine('mfb_0', elmCol2Background, gc_halParentLeft, gc_valParentBottom, -4, 1, GetGUIElementWidth(elmCol2Background)+8, 0, True, bupdate);
      [*] = ;elmHnd := _gui_CreateMetalLine('mfl_0', elmCol2Background, gc_halParentLeft, gc_valParentTop, -4, -skinHeadOffset-2, 0, GetGUIElementHeight(elmCol2Background)+skinHeadOffset+3, True, bupdate);
      [*] = ;elmHnd := _gui_CreateMetalLine('mfr_1', elmCol2Background, gc_halParentRight, gc_valParentTop, -0, -3, 0, GetGUIElementHeight(elmCol2Background)+4, False, bupdate);
      [*] = ;elmHnd := _gui_CreateMetalLine('mfr_2', elmCol2Background, gc_halParentRight, gc_valParentTop, 3, -skinHeadOffset-3, 0, GetGUIElementHeight(elmCol2Background)+skinHeadOffset+4, True, bupdate);
      [*] = ;var elmCol3HeadHnd : Integer = _gui_CreateSkinHeadWindow('sh_0', elmCol3Background, gc_halParentLeft, gc_valParentTop, 0, -skinHeadOffset, GetGUIElementWidth(elmCol3Background), bupdate);
      [*] = ;elmHnd := _gui_CreateMetalLine('mft_0', elmCol3Background, gc_halParentLeft, gc_valParentTop, -4, -4, GetGUIElementWidth(elmCol3Background)+8, 0, True, bupdate);
      [*] = ;elmHnd := _gui_CreateMetalLine('mft_1', elmCol3Background, gc_halParentLeft, gc_valParentTop, -4, -skinHeadOffset-3, GetGUIElementWidth(elmCol3Background)+8, 0, True, bupdate);
      [*] = ;elmHnd := _gui_CreateMetalLine('mfb_0', elmCol3Background, gc_halParentLeft, gc_valParentBottom, -4, 1, GetGUIElementWidth(elmCol3Background)+8, 0, True, bupdate);
      [*] = ;elmHnd := _gui_CreateMetalLine('mfl_0', elmCol3Background, gc_halParentLeft, gc_valParentTop, -4, -skinHeadOffset-2, 0, GetGUIElementHeight(elmCol3Background)+skinHeadOffset+3, True, bupdate);
      [*] = ;elmHnd := _gui_CreateMetalLine('mfr_1', elmCol3Background, gc_halParentRight, gc_valParentTop, -0, -3, 0, GetGUIElementHeight(elmCol3Background)+4, False, bupdate);
      [*] = ;elmHnd := _gui_CreateMetalLine('mfr_2', elmCol3Background, gc_halParentRight, gc_valParentTop, 3, -skinHeadOffset-3, 0, GetGUIElementHeight(elmCol3Background)+skinHeadOffset+4, True, bupdate);
      [*] = ;
      [*] = ;SetGUIElementUserBlend(elmCol3, _misc_SwitchFloat(1, 0.7, gInterface.settings=gc_settings_sound));
      [*] = ;// vars
      [*] = ;const cCheckboxOffset = 32;
      [*] = ;var elmList, elmCheckbox, elmSlider : Integer;
      [*] = ;var caption, stringTag, hint : String;
      [*] = ;var preset, valueind, valuecount, count : Integer;
      [*] = ;var i : Integer;
      [*] = ;case gInterface.settings of
      [*] = ;   gc_settings_default, gc_settings_video : begin
      [*] = ;      var posX : Integer = cBaseOffsetX;
      [*] = ;      var posY : Integer = cBaseOffsetY;
      [*] = ;
      [*] = ;      // headers
      [*] = ;      _gui_CreateText('thead', elmCol2HeadHnd, cTextScreen, gc_halParentLeft, gc_valParentMiddle, cPaddingW, 2, GetGUIElementWidth(elmCol2HeadHnd), 0, gc_halMiddle, gc_valMiddle, gc_font_serif_13, btncolor, bupdate);
      [*] = ;      _gui_CreateText('thead', elmCol3HeadHnd, cTextQuality, gc_halParentLeft, gc_valParentMiddle, cPaddingW, 2, GetGUIElementWidth(elmCol3HeadHnd), 0, gc_halMiddle, gc_valMiddle, gc_font_serif_13, btncolor, bupdate);
      [*] = ;
      [*] = ;      // preset
      [*] = ;      _gui_FindCurrentVideoPreset(pConfig, gSettings.video.preset, preset);
      [*] = ;      count := _misc_SwitchInt(3, 4, (preset=3));
      [*] = ;      elmList := _gui_CreateComboBox(cProjOptionsPreset, elmCol2Background, count, 0, gc_halParentLeft, gc_valParentTop, posX, posY, 256, gc_halLeft, gc_valMiddle, 5, 0, gc_font_serif_12, True, eventstate, False, bupdate);
      [*] = ;      elmHnd := _gui_CreateText('t', elmList, cTextPreset, gc_halParentLeft, gc_valParentTop, 4, -22, GetGUIElementWidth(elmList), GetGUIElementHeight(elmList), gc_halLeft, gc_valTop, gc_font_serif_12, tipcolor, bupdate);
      [*] = ;      stringTag := cProjOptionsPresetLow+'|'+cProjOptionsPresetMedium+'|'+cProjOptionsPresetHigh+'|'+cProjOptionsPresetUltra+'|'+cProjOptionsPresetCustom;
      [*] = ;      SetGUIElementStringTag(elmList, stringTag);
      [*] = ;      GUIListBoxAddItem(elmList, GetLocaleTableListItemByID('tools', 'GUI.SET.LOW'), 0);
      [*] = ;      GUIListBoxAddItem(elmList, GetLocaleTableListItemByID('tools', 'GUI.SET.MEDIUM'), 1);
      [*] = ;      GUIListBoxAddItem(elmList, GetLocaleTableListItemByID('tools', 'GUI.SET.HIGH'), 2);
      [*] = ;      if (preset=3) then
      [*] = ;      begin
      [*] = ;         _misc_StringToText(cTextPresetCustom, text);
      [*] = ;         GUIListBoxAddItem(elmList, text, 3);
      [*] = ;      end;
      [*] = ;      SetGUIListBoxItemIndexSilent(elmList, preset);
      [*] = ;
      [*] = ;      Log('Editor lags first time when execute command GetAvailableResolutionsToActiveParser');
      [*] = ;      // resolution
      [*] = ;      posY := posY+cOffsetY;
      [*] = ;      elmList := _gui_CreateComboBox(cProjOptionsResolution, elmCol2Background, GetResolutionCount(), 9, gc_halParentLeft, gc_valParentTop, posX, posY, 256, gc_halLeft, gc_valMiddle, 5, 0, gc_font_serif_12, True, eventstate, False, bupdate);
      [*] = ;      elmHnd := _gui_CreateText('t', elmList, cTextResolution, gc_halParentLeft, gc_valParentTop, 4, -22, GetGUIElementWidth(elmList), GetGUIElementHeight(elmList), gc_halLeft, gc_valTop, gc_font_serif_12, tipcolor, bupdate);
      [*] = ;      FillListBoxWithResolutions(elmList);
      [*] = ;
      [*] = ;      // display mode
      [*] = ;      posY := posY+cOffsetY;
      [*] = ;      GetConfigEngineOption(cProjOptionsDisplayMode, gProfileTmp.displaymode, pConfig, valueind, valuecount, caption);
      [*] = ;      text := GetLocaleTableListItemByID(gc_loc_tools, caption);
      [*] = ;      elmList := _gui_CreateComboBox(cProjOptionsDisplayMode, elmCol2Background, valuecount, 0, gc_halParentLeft, gc_valParentTop, posX, posY, 256, gc_halLeft, gc_valMiddle, 5, 0, gc_font_serif_12, True, eventstate, False, bupdate);
      [*] = ;      elmHnd := _gui_CreateText('t', elmList, text, gc_halParentLeft, gc_valParentTop, 4, -22, GetGUIElementWidth(elmList), GetGUIElementHeight(elmList), gc_halLeft, gc_valTop, gc_font_serif_12, tipcolor, bupdate);
      [*] = ;      FillListBoxWithConfigEngineOption(cProjOptionsDisplayMode, gProfileTmp.displaymode, elmList, pConfig);
      [*] = ;
      [*] = ;      // light preset
      [*] = ;      {posY := posY+cOffsetY;
      [*] = ;      elmList := _gui_CreateComboBox(cProjOptionsLightChange, elmCol2Background, 5, 0, gc_halParentLeft, gc_valParentTop, posX, posY, 256, gc_halLeft, gc_valMiddle, 5, 0, gc_font_serif_12, True, eventstate, False, bupdate);
      [*] = ;      GUIListBoxAddItem(elmList, GetLocaleTableListItemByID('misc', 'settings.random'), 0);
      [*] = ;      for i:=1 to 4 do
      [*] = ;      GUIListBoxAddItem(elmList, GetLocaleTableListItemByID('misc', 'settings.lightpreset')+' '+IntToStr(i), i);
      [*] = ;      SetGUIListBoxItemIndexSilent(elmList, gSettingsTmp.video.lightpreset);
      [*] = ;      elmHnd := _gui_CreateText('t', elmList, cTextLightChange, gc_halParentLeft, gc_valParentTop, 4, -22, GetGUIElementWidth(elmList), GetGUIElementHeight(elmList), gc_halLeft, gc_valTop, gc_font_serif_12, tipcolor, bupdate);}
      [*] = ;
      [*] = ;      // margin
      [*] = ;      posY := posY+cOffsetYMargin;
      [*] = ;
      [*] = ;      // v-sync
      [*] = ;      posY := posY+cOffsetYCheckbox;
      [*] = ;      GetCheckBoxStringTagWithConfigEngineOption(stringTag, cProjOptionsVSyncMode, gSettingsTmp.video.vsyncmode, pConfig, valueind, caption);
      [*] = ;      text := GetLocaleTableListItemByID(gc_loc_tools, caption);
      [*] = ;      hint := text;
      [*] = ;      elmCheckbox := _gui_CreateCheckBox(cProjOptionsVSyncMode, elmCol2Background, (valueind=1), gc_halParentLeft, gc_valParentTop, posX+cCheckboxXOffset, posY, eventstate, hint, cTagCheckboxVSync, bUpdate);
      [*] = ;      SetGUIElementHint(elmCheckbox, text);
      [*] = ;      SetGUIElementLogicWidth(elmCheckbox, _gui_GetFontTextWidth(text, gc_font_serif_12)+cCheckboxOffset);
      [*] = ;      SetGUIElementStringTag(elmCheckbox, stringTag);
      [*] = ;      elmHnd := _gui_CreateText('t', elmCheckbox, text, gc_halParentLeft, gc_valParentTop, cCheckboxTextOffsetX, cCheckboxTextOffsetY, GetGUIElementWidth(elmList), GetGUIElementHeight(elmList), gc_halLeft, gc_valTop, gc_font_serif_12, btncolor, bupdate);
      [*] = ;
      [*] = ;      // clamping mouse
      [*] = ;      posY := posY+cOffsetYCheckbox;
      [*] = ;      //GetCheckBoxStringTagWithConfigEngineOption(stringTag, cGameOptionsClampingMouse, BoolToStr(gProfileTmp.bclipmouse), pConfig, valueind, caption);
      [*] = ;      //text := GetLocaleTableListItemByID(gc_loc_tools, caption);
      [*] = ;      text := cTextClampingMouse;
      [*] = ;      hint := text;
      [*] = ;      elmCheckbox := _gui_CreateCheckBox(cGameOptionsClampingMouse, elmCol2Background, gProfileTmp.bclipmouse, gc_halParentLeft, gc_valParentTop, posX+cCheckboxXOffset, posY, eventstate, hint, cTagCheckboxVSync, bUpdate);
      [*] = ;      SetGUIElementHint(elmCheckbox, text);
      [*] = ;      SetGUIElementLogicWidth(elmCheckbox, _gui_GetFontTextWidth(text, gc_font_serif_12)+cCheckboxOffset);
      [*] = ;      SetGUIElementStringTag(elmCheckbox, stringTag);
      [*] = ;      elmHnd := _gui_CreateText('t', elmCheckbox, text, gc_halParentLeft, gc_valParentTop, cCheckboxTextOffsetX, cCheckboxTextOffsetY, GetGUIElementWidth(elmList), GetGUIElementHeight(elmList), gc_halLeft, gc_valTop, gc_font_serif_12, btncolor, bupdate);
      [*] = ;
      [*] = ;      // language
      [*] = ;      posY := posY+8;
      [*] = ;      posY := posY+cOffsetY;
      [*] = ;      GetConfigEngineOption(cResourceOptionsLanguage, gProfileTmp.lang, pConfig, valueind, valuecount, caption);
      [*] = ;      text := GetLocaleTableListItemByID(gc_loc_tools, caption);
      [*] = ;      elmList := _gui_CreateComboBox(cResourceOptionsLanguage, elmCol2Background, valuecount, 0, gc_halParentLeft, gc_valParentTop, posX, posY, 256, gc_halLeft, gc_valMiddle, 5, 0, gc_font_serif_12, True, eventstate, False, bupdate);
      [*] = ;      elmHnd := _gui_CreateText('t', elmList, text, gc_halParentLeft, gc_valParentTop, 4, -22, GetGUIElementWidth(elmList), GetGUIElementHeight(elmList), gc_halLeft, gc_valTop, gc_font_serif_12, tipcolor, bupdate);
      [*] = ;      FillListBoxWithConfigEngineOption(cResourceOptionsLanguage, gProfileTmp.lang, elmList, pConfig);
      [*] = ;
      [*] = ;      // texture quality
      [*] = ;      var totalphys, availphys, totalvirt, availvirt : Integer;
      [*] = ;      GetHardwareRAMInfo(totalphys, availphys, totalvirt, availvirt);
      [*] = ;      var ramGB : Integer = round(totalphys/1024) div 1000;
      [*] = ;      var stringTag : String;
      [*] = ;      valueind := 0;
      [*] = ;      case ramGB of
      [*] = ;         0, 1 : begin
      [*] = ;            valuecount := 1;
      [*] = ;            valueind := 0;
      [*] = ;            stringTag := '2|';
      [*] = ;         end;
      [*] = ;         2, 3 : begin
      [*] = ;            valuecount := 2;
      [*] = ;            case gSettingsTmp.video.texturequality of
      [*] = ;               '0' : valueind := 1;
      [*] = ;               '1' : valueind := 1;
      [*] = ;               '2' : valueind := 0;
      [*] = ;            end;
      [*] = ;            stringTag := '2|1';
      [*] = ;         end
      [*] = ;         else
      [*] = ;         begin
      [*] = ;            valuecount := 3;
      [*] = ;            case gSettingsTmp.video.texturequality of
      [*] = ;               '0' : valueind := 2;
      [*] = ;               '1' : valueind := 1;
      [*] = ;               '2' : valueind := 0;
      [*] = ;            end;
      [*] = ;            stringTag := '2|1|0';
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;      posY := cBaseOffsetY;
      [*] = ;      //GetConfigEngineOption(cProjOptionsTextureQuality, gSettingsTmp.video.texturequality, pConfig, valueind, valuecount, caption);
      [*] = ;      //text := GetLocaleTableListItemByID(gc_loc_tools, caption);
      [*] = ;      text := cTextTextureQuality;
      [*] = ;      elmList := _gui_CreateComboBox(cProjOptionsTextureQuality, elmCol3Background, valuecount, 0, gc_halParentLeft, gc_valParentTop, posX, posY, 256, gc_halLeft, gc_valMiddle, 5, 0, gc_font_serif_12, True, eventstate, False, bupdate);
      [*] = ;      case ramGB of
      [*] = ;         0, 1 : GUIListBoxAddItem(elmList, GetLocaleTableListItemByID('tools', 'GUI.SET.LOW'), 2);
      [*] = ;         2, 3 : begin
      [*] = ;            GUIListBoxAddItem(elmList, GetLocaleTableListItemByID('tools', 'GUI.SET.LOW'), 2);
      [*] = ;            GUIListBoxAddItem(elmList, GetLocaleTableListItemByID('tools', 'GUI.SET.MEDIUM'), 1);
      [*] = ;         end;
      [*] = ;         else
      [*] = ;         begin
      [*] = ;            GUIListBoxAddItem(elmList, GetLocaleTableListItemByID('tools', 'GUI.SET.LOW'), 2);
      [*] = ;            GUIListBoxAddItem(elmList, GetLocaleTableListItemByID('tools', 'GUI.SET.MEDIUM'), 1);
      [*] = ;            GUIListBoxAddItem(elmList, GetLocaleTableListItemByID('tools', 'GUI.SET.HIGH'), 0);
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;      elmHnd := _gui_CreateText('t', elmList, text, gc_halParentLeft, gc_valParentTop, 4, -22, GetGUIElementWidth(elmList), GetGUIElementHeight(elmList), gc_halLeft, gc_valTop, gc_font_serif_12, tipcolor, bupdate);
      [*] = ;      //FillListBoxWithConfigEngineOption(cProjOptionsTextureQuality, gSettingsTmp.video.texturequality, elmList, pConfig);
      [*] = ;      SetGUIElementStringTag(elmList, stringTag);
      [*] = ;      SetGUIListBoxItemIndexSilent(elmList, valueind);
      [*] = ;
      [*] = ;      // texture filter
      [*] = ;      posY := posY+cOffsetY;
      [*] = ;      GetConfigEngineOption(cProjOptionsTextureFilter, gSettingsTmp.video.texturefilter, pConfig, valueind, valuecount, caption);
      [*] = ;      text := GetLocaleTableListItemByID(gc_loc_tools, caption);
      [*] = ;      elmList := _gui_CreateComboBox(cProjOptionsTextureFilter, elmCol3Background, valuecount, 0, gc_halParentLeft, gc_valParentTop, posX, posY, 256, gc_halLeft, gc_valMiddle, 5, 0, gc_font_serif_12, True, eventstate, False, bupdate);
      [*] = ;      elmHnd := _gui_CreateText('t', elmList, text, gc_halParentLeft, gc_valParentTop, 4, -22, GetGUIElementWidth(elmList), GetGUIElementHeight(elmList), gc_halLeft, gc_valTop, gc_font_serif_12, tipcolor, bupdate);
      [*] = ;      FillListBoxWithConfigEngineOption(cProjOptionsTextureFilter, gSettingsTmp.video.texturefilter, elmList, pConfig);
      [*] = ;
      [*] = ;      // shader quality
      [*] = ;      posY := posY+cOffsetY;
      [*] = ;      GetConfigEngineOption(cProjOptionsShaderType, gSettingsTmp.video.shadertype, pConfig, valueind, valuecount, caption);
      [*] = ;      text := GetLocaleTableListItemByID(gc_loc_tools, caption);
      [*] = ;      elmList := _gui_CreateComboBox(cProjOptionsShaderType, elmCol3Background, valuecount, 0, gc_halParentLeft, gc_valParentTop, posX, posY, 256, gc_halLeft, gc_valMiddle, 5, 0, gc_font_serif_12, True, eventstate, False, bupdate);
      [*] = ;      elmHnd := _gui_CreateText('t', elmList, text, gc_halParentLeft, gc_valParentTop, 4, -22, GetGUIElementWidth(elmList), GetGUIElementHeight(elmList), gc_halLeft, gc_valTop, gc_font_serif_12, tipcolor, bupdate);
      [*] = ;      FillListBoxWithConfigEngineOption(cProjOptionsShaderType, gSettingsTmp.video.shadertype, elmList, pConfig);
      [*] = ;
      [*] = ;      // water quality
      [*] = ;      posY := posY+cOffsetY;
      [*] = ;      GetConfigEngineOption(cProjOptionsWaterReflection, gSettingsTmp.video.waterreflection, pConfig, valueind, valuecount, caption);
      [*] = ;      text := GetLocaleTableListItemByID(gc_loc_tools, caption);
      [*] = ;      elmList := _gui_CreateComboBox(cProjOptionsWaterReflection, elmCol3Background, valuecount, 0, gc_halParentLeft, gc_valParentTop, posX, posY, 256, gc_halLeft, gc_valMiddle, 5, 0, gc_font_serif_12, True, eventstate, False, bupdate);
      [*] = ;      elmHnd := _gui_CreateText('t', elmList, text, gc_halParentLeft, gc_valParentTop, 4, -22, GetGUIElementWidth(elmList), GetGUIElementHeight(elmList), gc_halLeft, gc_valTop, gc_font_serif_12, tipcolor, bupdate);
      [*] = ;      FillListBoxWithConfigEngineOption(cProjOptionsWaterReflection, gSettingsTmp.video.waterreflection, elmList, pConfig);
      [*] = ;
      [*] = ;      // shadow map resolution (ComboBox)
      [*] = ;      posY := posY+cOffsetY;
      [*] = ;      GetConfigEngineOption(cProjOptionsShadowMap, gSettingsTmp.video.shadowmap, pConfig, valueind, valuecount, caption);
      [*] = ;      text := GetLocaleTableListItemByID(gc_loc_tools, caption);
      [*] = ;      elmList := _gui_CreateComboBox(cProjOptionsShadowMap, elmCol3Background, valuecount, 0, gc_halParentLeft, gc_valParentTop, posX, posY, 256, gc_halLeft, gc_valMiddle, 5, 0, gc_font_serif_12, True, eventstate, False, bupdate);
      [*] = ;      elmHnd := _gui_CreateText('t', elmList, text, gc_halParentLeft, gc_valParentTop, 4, -22, GetGUIElementWidth(elmList), GetGUIElementHeight(elmList), gc_halLeft, gc_valTop, gc_font_serif_12, tipcolor, bupdate);
      [*] = ;      FillListBoxWithConfigEngineOption(cProjOptionsShadowMap, gSettingsTmp.video.shadowmap, elmList, pConfig);
      [*] = ;
      [*] = ;      // margin
      [*] = ;      posY := posY+cOffsetYMargin;
      [*] = ;
      [*] = ;      // shadow map
      [*] = ;      posY := posY+cOffsetYCheckbox;
      [*] = ;      GetCheckBoxStringTagWithConfigEngineOption(stringTag, cProjOptionsShadowEnabled, BoolToStr(gSettingsTmp.video.shadowenabled), pConfig, valueind, caption);
      [*] = ;      text := GetLocaleTableListItemByID(gc_loc_tools, caption);
      [*] = ;      hint := text;
      [*] = ;      elmCheckbox := _gui_CreateCheckBox(cProjOptionsShadowEnabled, elmCol3Background, (valueind=1), gc_halParentLeft, gc_valParentTop, posX+cCheckboxXOffset, posY, eventstate, hint, cTagCheckboxVSync, bUpdate);
      [*] = ;      SetGUIElementHint(elmCheckbox, text);
      [*] = ;      SetGUIElementLogicWidth(elmCheckbox, _gui_GetFontTextWidth(text, gc_font_serif_12)+cCheckboxOffset);
      [*] = ;      SetGUIElementStringTag(elmCheckbox, stringTag);
      [*] = ;      elmHnd := _gui_CreateText('t', elmCheckbox, text, gc_halParentLeft, gc_valParentTop, cCheckboxTextOffsetX, cCheckboxTextOffsetY, GetGUIElementWidth(elmList), GetGUIElementHeight(elmList), gc_halLeft, gc_valTop, gc_font_serif_12, btncolor, bupdate);
      [*] = ;
      [*] = ;      // SSAO
      [*] = ;      posY := posY+cOffsetYCheckbox;
      [*] = ;      GetCheckBoxStringTagWithConfigEngineOption(stringTag, cProjOptionsSSAOEnable, BoolToStr(gSettingsTmp.video.ssao), pConfig, valueind, caption);
      [*] = ;      text := GetLocaleTableListItemByID(gc_loc_tools, caption);
      [*] = ;      hint := text;
      [*] = ;      elmCheckbox := _gui_CreateCheckBox(cProjOptionsSSAOEnable, elmCol3Background, (valueind=1), gc_halParentLeft, gc_valParentTop, posX+cCheckboxXOffset, posY, eventstate, hint, cTagCheckboxVSync, bUpdate);
      [*] = ;      SetGUIElementHint(elmCheckbox, text);
      [*] = ;      SetGUIElementLogicWidth(elmCheckbox, _gui_GetFontTextWidth(text, gc_font_serif_12)+cCheckboxOffset);
      [*] = ;      SetGUIElementStringTag(elmCheckbox, stringTag);
      [*] = ;      elmHnd := _gui_CreateText('t', elmCheckbox, text, gc_halParentLeft, gc_valParentTop, cCheckboxTextOffsetX, cCheckboxTextOffsetY, GetGUIElementWidth(elmList), GetGUIElementHeight(elmList), gc_halLeft, gc_valTop, gc_font_serif_12, btncolor, bupdate);
      [*] = ;
      [*] = ;      // FXAA
      [*] = ;      posY := posY+cOffsetYCheckbox;
      [*] = ;      GetCheckBoxStringTagWithConfigEngineOption(stringTag, cProjOptionsFXAAEnable, BoolToStr(gSettingsTmp.video.fxaa), pConfig, valueind, caption);
      [*] = ;      text := GetLocaleTableListItemByID(gc_loc_tools, caption);
      [*] = ;      hint := text;
      [*] = ;      elmCheckbox := _gui_CreateCheckBox(cProjOptionsFXAAEnable, elmCol3Background, (valueind=1), gc_halParentLeft, gc_valParentTop, posX+cCheckboxXOffset, posY, eventstate, hint, cTagCheckboxVSync, bUpdate);
      [*] = ;      SetGUIElementHint(elmCheckbox, text);
      [*] = ;      SetGUIElementLogicWidth(elmCheckbox, _gui_GetFontTextWidth(text, gc_font_serif_12)+cCheckboxOffset);
      [*] = ;      SetGUIElementStringTag(elmCheckbox, stringTag);
      [*] = ;      elmHnd := _gui_CreateText('t', elmCheckbox, text, gc_halParentLeft, gc_valParentTop, cCheckboxTextOffsetX, cCheckboxTextOffsetY, GetGUIElementWidth(elmList), GetGUIElementHeight(elmList), gc_halLeft, gc_valTop, gc_font_serif_12, btncolor, bupdate);
      [*] = ;
      [*] = ;      {posY := posY+cOffsetY;
      [*] = ;      GetConfigEngineOption(cProjOptionsAntiAliasing, gSettingsTmp.video.antialiasing, pConfig, valueind, valuecount, caption);
      [*] = ;      elmList := _gui_CreateComboBox('antialiasing', elmCol3Background, 0, 9, gc_halParentLeft, gc_valParentTop, posX, posY, 256, gc_halLeft, gc_valMiddle, 5, 0, gc_font_serif_12, True, eventstate, False, bupdate);
      [*] = ;      elmHnd := _gui_CreateText('t', elmList, caption, gc_halParentLeft, gc_valParentTop, 4, -22, GetGUIElementWidth(elmList), GetGUIElementHeight(elmList), gc_halLeft, gc_valTop, gc_font_serif_12, tipcolor, bupdate);
      [*] = ;      FillListBoxWithConfigEngineOption(cProjOptionsAntiAliasing, gSettingsTmp.video.antialiasing, elmList, pConfig);}
      [*] = ;   end;
      [*] = ;   gc_settings_sound : begin
      [*] = ;      var posX : Integer = cBaseOffsetX;
      [*] = ;      var posY : Integer = cBaseOffsetY-16;
      [*] = ;
      [*] = ;      // headers
      [*] = ;      _gui_CreateText('thead', elmCol2HeadHnd, cTextSoundSettings, gc_halParentLeft, gc_valParentMiddle, cPaddingW, 2, GetGUIElementWidth(elmCol2HeadHnd), 0, gc_halMiddle, gc_valMiddle, gc_font_serif_13, btncolor, bupdate);
      [*] = ;
      [*] = ;      // checkbox
      [*] = ;      elmCheckbox := _gui_CreateCheckBox(cGameOptionsMute, elmCol2Background, (gProfileTmp.sndmute=1), gc_halParentLeft, gc_valParentTop, posX+cCheckboxXOffset, posY, eventstate, nul, cTagCheckboxVSync, bUpdate);
      [*] = ;      SetGUIElementHint(elmCheckbox, text);
      [*] = ;      SetGUIElementLogicWidth(elmCheckbox, _gui_GetFontTextWidth(text, gc_font_serif_12)+cCheckboxOffset);
      [*] = ;      elmHnd := _gui_CreateText('t', elmCheckbox, cTextMute, gc_halParentLeft, gc_valParentTop, cCheckboxTextOffsetX, cCheckboxTextOffsetY, GetGUIElementWidth(elmList), GetGUIElementHeight(elmList), gc_halLeft, gc_valTop, gc_font_serif_12, btncolor, bupdate);
      [*] = ;
      [*] = ;      // sliders
      [*] = ;      posY := posY+cOffsetYCheckbox+cSliderHintYOffset-8;
      [*] = ;      GetConfigEngineOption(cGameOptionsMaster, FloatToStr(gProfileTmp.sndmaster), pConfig, valueind, valuecount, caption);
      [*] = ;      text := GetLocaleTableListItemByID(gc_loc_tools, caption);
      [*] = ;      elmSlider := CreateSimpleSlider(cGameOptionsMaster, gProfileTmp.sndmaster, elmCol2Background, gc_halParentLeft, gc_valParentTop, posX+cSliderXOffset, posY, eventState, bupdate);
      [*] = ;      elmHnd := _gui_CreateText('t', elmSlider, text, gc_halParentLeft, gc_valParentTop, 4-cSliderXOffset, -cSliderHintYOffset+cSliderHintYPadding, GetGUIElementWidth(elmSlider), GetGUIElementHeight(elmSlider), gc_halLeft, gc_valTop, gc_font_serif_12, btncolor, bupdate);
      [*] = ;
      [*] = ;      posY := posY+cOffsetYSlider;
      [*] = ;      GetConfigEngineOption(cGameOptionsMusic, FloatToStr(gProfileTmp.sndmusic), pConfig, valueind, valuecount, caption);
      [*] = ;      text := GetLocaleTableListItemByID(gc_loc_tools, caption);
      [*] = ;      elmSlider := CreateSimpleSlider(cGameOptionsMusic, gProfileTmp.sndmusic, elmCol2Background, gc_halParentLeft, gc_valParentTop, posX+cSliderXOffset, posY, eventState, bupdate);
      [*] = ;      elmHnd := _gui_CreateText('t', elmSlider, text, gc_halParentLeft, gc_valParentTop, 4-cSliderXOffset, -cSliderHintYOffset+cSliderHintYPadding, GetGUIElementWidth(elmSlider), GetGUIElementHeight(elmSlider), gc_halLeft, gc_valTop, gc_font_serif_12, btncolor, bupdate);
      [*] = ;
      [*] = ;      posY := posY+cOffsetYSlider;
      [*] = ;      GetConfigEngineOption(cGameOptionsAmbient, FloatToStr(gProfileTmp.sndambient), pConfig, valueind, valuecount, caption);
      [*] = ;      text := GetLocaleTableListItemByID(gc_loc_tools, caption);
      [*] = ;      elmSlider := CreateSimpleSlider(cGameOptionsAmbient, gProfileTmp.sndambient, elmCol2Background, gc_halParentLeft, gc_valParentTop, posX+cSliderXOffset, posY, eventState, bupdate);
      [*] = ;      elmHnd := _gui_CreateText('t', elmSlider, text, gc_halParentLeft, gc_valParentTop, 4-cSliderXOffset, -cSliderHintYOffset+cSliderHintYPadding, GetGUIElementWidth(elmSlider), GetGUIElementHeight(elmSlider), gc_halLeft, gc_valTop, gc_font_serif_12, btncolor, bupdate);
      [*] = ;
      [*] = ;      posY := posY+cOffsetYSlider;
      [*] = ;      GetConfigEngineOption(cGameOptionsFx, FloatToStr(gProfileTmp.sndfx), pConfig, valueind, valuecount, caption);
      [*] = ;      text := GetLocaleTableListItemByID(gc_loc_tools, caption);
      [*] = ;      elmSlider := CreateSimpleSlider(cGameOptionsFx, gProfileTmp.sndfx, elmCol2Background, gc_halParentLeft, gc_valParentTop, posX+cSliderXOffset, posY, eventState, bupdate);
      [*] = ;      elmHnd := _gui_CreateText('t', elmSlider, text, gc_halParentLeft, gc_valParentTop, 4-cSliderXOffset, -cSliderHintYOffset+cSliderHintYPadding, GetGUIElementWidth(elmSlider), GetGUIElementHeight(elmSlider), gc_halLeft, gc_valTop, gc_font_serif_12, btncolor, bupdate);
      [*] = ;
      [*] = ;      posY := posY+cOffsetYSlider;
      [*] = ;      GetConfigEngineOption(cGameOptionsInterface, FloatToStr(gProfileTmp.sndinterface), pConfig, valueind, valuecount, caption);
      [*] = ;      text := GetLocaleTableListItemByID(gc_loc_tools, caption);
      [*] = ;      elmSlider := CreateSimpleSlider(cGameOptionsInterface, gProfileTmp.sndinterface, elmCol2Background, gc_halParentLeft, gc_valParentTop, posX+cSliderXOffset, posY, eventState, bupdate);
      [*] = ;      elmHnd := _gui_CreateText('t', elmSlider, text, gc_halParentLeft, gc_valParentTop, 4-cSliderXOffset, -cSliderHintYOffset+cSliderHintYPadding, GetGUIElementWidth(elmSlider), GetGUIElementHeight(elmSlider), gc_halLeft, gc_valTop, gc_font_serif_12, btncolor, bupdate);
      [*] = ;   end;
      [*] = ;   gc_settings_control : begin
      [*] = ;      var posX : Integer = cBaseOffsetX;
      [*] = ;      var posY : Integer = cBaseOffsetY-16;
      [*] = ;
      [*] = ;      // headers
      [*] = ;      _gui_CreateText('thead', elmCol2HeadHnd, cTextControlSettings, gc_halParentLeft, gc_valParentMiddle, cPaddingW, 2, GetGUIElementWidth(elmCol2HeadHnd), 0, gc_halMiddle, gc_valMiddle, gc_font_serif_13, btncolor, bupdate);
      [*] = ;      _gui_CreateText('thead', elmCol3HeadHnd, cTextGameplaySettings, gc_halParentLeft, gc_valParentMiddle, cPaddingW, 2, GetGUIElementWidth(elmCol2HeadHnd), 0, gc_halMiddle, gc_valMiddle, gc_font_serif_13, btncolor, bupdate);
      [*] = ;
      [*] = ;      // sliders
      [*] = ;      posY := posY+cSliderHintYOffset;
      [*] = ;      GetConfigEngineOption(cGameOptionsMouseScrollSpeed, IntToStr(gProfileTmp.igamespeed), pConfig, valueind, valuecount, caption);
      [*] = ;      text := GetLocaleTableListItemByID(gc_loc_tools, caption);
      [*] = ;      elmSlider := CreateSimpleSlider('mousescrollspeed', gProfileTmp.mousescrollspeed, elmCol2Background, gc_halParentLeft, gc_valParentTop, posX+cSliderXOffset, posY, eventState, bupdate);
      [*] = ;      elmHnd := _gui_CreateText('t', elmSlider, text, gc_halParentLeft, gc_valParentTop, 4-cSliderXOffset, -cSliderHintYOffset+cSliderHintYPadding, GetGUIElementWidth(elmSlider), GetGUIElementHeight(elmSlider), gc_halLeft, gc_valTop, gc_font_serif_12, btncolor, bupdate);
      [*] = ;
      [*] = ;      posY := posY+cOffsetYSlider;
      [*] = ;      GetConfigEngineOption(cGameOptionsWheelSpeed, IntToStr(gProfileTmp.igamespeed), pConfig, valueind, valuecount, caption);
      [*] = ;      text := GetLocaleTableListItemByID(gc_loc_tools, caption);
      [*] = ;      elmSlider := CreateSimpleSlider('wheelspeed', gProfileTmp.wheelspeed, elmCol2Background, gc_halParentLeft, gc_valParentTop, posX+cSliderXOffset, posY, eventState, bupdate);
      [*] = ;      elmHnd := _gui_CreateText('t', elmSlider, text, gc_halParentLeft, gc_valParentTop, 4-cSliderXOffset, -cSliderHintYOffset+cSliderHintYPadding, GetGUIElementWidth(elmSlider), GetGUIElementHeight(elmSlider), gc_halLeft, gc_valTop, gc_font_serif_12, btncolor, bupdate);
      [*] = ;      posY := posY+cOffsetYSlider;
      [*] = ;      GetConfigEngineOption(cGameOptionsKeyScrollSpeed, IntToStr(gProfileTmp.igamespeed), pConfig, valueind, valuecount, caption);
      [*] = ;      text := GetLocaleTableListItemByID(gc_loc_tools, caption);
      [*] = ;      elmSlider := CreateSimpleSlider('keyscrollspeed', gProfileTmp.keyscrollspeed, elmCol2Background, gc_halParentLeft, gc_valParentTop, posX+cSliderXOffset, posY, eventState, bupdate);
      [*] = ;      elmHnd := _gui_CreateText('t', elmSlider, text, gc_halParentLeft, gc_valParentTop, 4-cSliderXOffset, -cSliderHintYOffset+cSliderHintYPadding, GetGUIElementWidth(elmSlider), GetGUIElementHeight(elmSlider), gc_halLeft, gc_valTop, gc_font_serif_12, btncolor, bupdate);
      [*] = ;
      [*] = ;      posY := posY+cOffsetYSlider;
      [*] = ;      GetConfigEngineOption(cGameOptionsMiddleMouseScrollSpeed, FloatToStr(gProfileTmp.middlemousescrollspeed), pConfig, valueind, valuecount, caption);
      [*] = ;      text := GetLocaleTableListItemByID(gc_loc_tools, caption);
      [*] = ;      elmSlider := CreateSimpleSlider('middlemousescrollspeed', gProfileTmp.middlemousescrollspeed, elmCol2Background, gc_halParentLeft, gc_valParentTop, posX+cSliderXOffset, posY, eventState, bupdate);
      [*] = ;      elmHnd := _gui_CreateText('t', elmSlider, text, gc_halParentLeft, gc_valParentTop, 4-cSliderXOffset, -cSliderHintYOffset+cSliderHintYPadding, GetGUIElementWidth(elmSlider), GetGUIElementHeight(elmSlider), gc_halLeft, gc_valTop, gc_font_serif_12, btncolor, bupdate);
      [*] = ;
      [*] = ;      // game speed
      [*] = ;      posY := cBaseOffsetY;
      [*] = ;      GetConfigEngineOption(cGameOptionsGameSpeed, IntToStr(gProfileTmp.igamespeed), pConfig, valueind, valuecount, caption);
      [*] = ;      text := GetLocaleTableListItemByID(gc_loc_tools, caption);
      [*] = ;      elmList := _gui_CreateComboBox('igamespeed', elmCol3Background, valuecount, 0, gc_halParentLeft, gc_valParentTop, posX, posY, 256, gc_halLeft, gc_valMiddle, 5, 0, gc_font_serif_12, True, eventstate, False, bupdate);
      [*] = ;      elmHnd := _gui_CreateText('t', elmList, text, gc_halParentLeft, gc_valParentTop, 4, -22, GetGUIElementWidth(elmList), GetGUIElementHeight(elmList), gc_halLeft, gc_valTop, gc_font_serif_12, tipcolor, bupdate);
      [*] = ;      FillListBoxWithConfigEngineOption(cGameOptionsGameSpeed, IntToStr(gProfileTmp.igamespeed), elmList, pConfig);
      [*] = ;
      [*] = ;      // margin
      [*] = ;      posY := posY+cOffsetYMargin;
      [*] = ;
      [*] = ;      // autosave
      [*] = ;      posY := posY+cOffsetYCheckbox;
      [*] = ;      GetConfigEngineOption(cGameOptionsAutosave, nul, pConfig, valueind, valuecount, caption);
      [*] = ;      text := GetLocaleTableListItemByID(gc_loc_tools, caption);
      [*] = ;      elmCheckbox := _gui_CreateCheckBox(cGameOptionsAutosave, elmCol3Background, gProfileTmp.bautosave, gc_halParentLeft, gc_valParentTop, posX+cCheckboxXOffset, posY, eventstate, nul, cTagCheckboxVSync, bUpdate);
      [*] = ;      elmHnd := _gui_CreateText('t', elmCheckbox, text, gc_halParentLeft, gc_valParentTop, cCheckboxTextOffsetX, cCheckboxTextOffsetY, GetGUIElementWidth(elmList)-cCheckboxOffset, GetGUIElementHeight(elmList),gc_halLeft, gc_valTop, gc_font_serif_12, btncolor, bupdate);
      [*] = ;      SetGUIElementHint(elmCheckbox, text);
      [*] = ;      SetGUIElementLogicWidth(elmCheckbox, _gui_GetFontTextWidth(text, gc_font_serif_12)+cCheckboxOffset);
      [*] = ;
      [*] = ;      // bbrushunderunit
      [*] = ;      posY := posY+cOffsetYCheckbox;
      [*] = ;      GetConfigEngineOption(cGameOptionsBrushUnderUnit, nul, pConfig, valueind, valuecount, caption);
      [*] = ;      text := GetLocaleTableListItemByID(gc_loc_tools, caption);
      [*] = ;      elmCheckbox := _gui_CreateCheckBox(cGameOptionsBrushUnderUnit, elmCol3Background, gProfileTmp.bbrushunderunit, gc_halParentLeft, gc_valParentTop, posX+cCheckboxXOffset, posY, eventstate, nul, cTagCheckboxVSync, bUpdate);
      [*] = ;      elmHnd := _gui_CreateText('t', elmCheckbox, text, gc_halParentLeft, gc_valParentTop, cCheckboxTextOffsetX, cCheckboxTextOffsetY, GetGUIElementWidth(elmList)-cCheckboxOffset, GetGUIElementHeight(elmList),gc_halLeft, gc_valTop, gc_font_serif_12, btncolor, bupdate);
      [*] = ;      SetGUIElementHint(elmCheckbox, text);
      [*] = ;      SetGUIElementLogicWidth(elmCheckbox, _gui_GetFontTextWidth(text, gc_font_serif_12)+cCheckboxOffset);
      [*] = ;
      [*] = ;      // bsearchenemyinfront
      [*] = ;      posY := posY+cOffsetYCheckbox;
      [*] = ;      GetConfigEngineOption(cGameOptionsSearchEnemyInFront, nul, pConfig, valueind, valuecount, caption);
      [*] = ;      //text := GetLocaleTableListItemByID(gc_loc_tools, caption);
      [*] = ;      text := gc_loc_tools+'|'+caption;
      [*] = ;      elmCheckbox := _gui_CreateCheckBox(cGameOptionsSearchEnemyInFront, elmCol3Background, gProfileTmp.bsearchenemyinfront, gc_halParentLeft, gc_valParentTop, posX+cCheckboxXOffset, posY, eventstate, nul, cTagCheckboxVSync, bUpdate);
      [*] = ;      elmHnd := _gui_CreateText('t', elmCheckbox, text, gc_halParentLeft, gc_valParentTop, cCheckboxTextOffsetX, cCheckboxTextOffsetY, GetGUIElementWidth(elmList)-cCheckboxOffset, GetGUIElementHeight(elmList),gc_halLeft, gc_valTop, gc_font_serif_12, btncolor, bupdate);
      [*] = ;      SetGUIElementHint(elmCheckbox, text);
      [*] = ;      SetGUIElementLogicWidth(elmCheckbox, _gui_GetFontTextWidth(text, gc_font_serif_12)+cCheckboxOffset);
      [*] = ;
      [*] = ;      var textshort : String;
      [*] = ;      // binfiniteonleftclick
      [*] = ;      posY := posY+cOffsetYCheckbox;
      [*] = ;      GetConfigEngineOption(cGameOptionsInfiniteOnLeftClick, nul, pConfig, valueind, valuecount, caption);
      [*] = ;      //text := GetLocaleTableListItemByID(gc_loc_tools, caption);
      [*] = ;      text := gc_loc_tools+'|'+caption;
      [*] = ;      textshort := 'misc|'+caption+'.SHORT';
      [*] = ;      hint := GetLocaleTableListItemByID('misc', caption+'.HINT');
      [*] = ;      if (hint='') then hint := text;
      [*] = ;      elmCheckbox := _gui_CreateCheckBox(cGameOptionsInfiniteOnLeftClick, elmCol3Background, gProfileTmp.binfiniteonleftclick, gc_halParentLeft, gc_valParentTop, posX+cCheckboxXOffset, posY, eventstate, nul, cTagCheckboxVSync, bUpdate);
      [*] = ;      elmHnd := _gui_CreateText('t', elmCheckbox, textshort, gc_halParentLeft, gc_valParentTop, cCheckboxTextOffsetX, cCheckboxTextOffsetY, GetGUIElementWidth(elmList)-cCheckboxOffset, GetGUIElementHeight(elmList), gc_halLeft, gc_valTop, gc_font_serif_12, btncolor, bupdate);
      [*] = ;      SetGUIElementHint(elmCheckbox, hint);
      [*] = ;      SetGUIElementLogicWidth(elmCheckbox, _gui_GetFontTextWidth(text, gc_font_serif_12)+cCheckboxOffset);
      [*] = ;
      [*] = ;      // bselectallunitsonz
      [*] = ;      posY := posY+cOffsetYCheckbox;
      [*] = ;      GetConfigEngineOption(cGameOptionsSelectAllUnitsOnZ, nul, pConfig, valueind, valuecount, caption);
      [*] = ;      //text := GetLocaleTableListItemByID(gc_loc_tools, caption);
      [*] = ;      text := gc_loc_tools+'|'+caption;
      [*] = ;      textshort := 'misc|'+caption+'.SHORT';
      [*] = ;      hint := GetLocaleTableListItemByID('misc', caption+'.HINT');
      [*] = ;      if (hint='') then hint := text;
      [*] = ;      _misc_StringToText(hint, hint);
      [*] = ;      hint := StrReplace(hint, '%zhotkey%', 'Z');
      [*] = ;      elmCheckbox := _gui_CreateCheckBox(cGameOptionsSelectAllUnitsOnZ, elmCol3Background, gProfileTmp.bselectallunitsonz, gc_halParentLeft, gc_valParentTop, posX+cCheckboxXOffset, posY, eventstate, nul, cTagCheckboxVSync, bUpdate);
      [*] = ;      elmHnd := _gui_CreateText('t', elmCheckbox, textshort, gc_halParentLeft, gc_valParentTop, cCheckboxTextOffsetX, cCheckboxTextOffsetY, GetGUIElementWidth(elmList)-cCheckboxOffset, GetGUIElementHeight(elmList), gc_halLeft, gc_valTop, gc_font_serif_12, btncolor, bupdate);
      [*] = ;      SetGUIElementHint(elmCheckbox, hint);
      [*] = ;      SetGUIElementLogicWidth(elmCheckbox, _gui_GetFontTextWidth(text, gc_font_serif_12)+cCheckboxOffset);
      [*] = ;
      [*] = ;      // bcenterfirstrow
      [*] = ;      posY := posY+cOffsetYCheckbox;
      [*] = ;      GetConfigEngineOption(cGameOptionsCenterSquadPos, nul, pConfig, valueind, valuecount, caption);
      [*] = ;      //text := GetLocaleTableListItemByID(gc_loc_tools, caption);
      [*] = ;      text := gc_loc_tools+'|'+caption;
      [*] = ;      textshort := 'misc|'+caption+'.SHORT';
      [*] = ;      hint :=  GetLocaleTableListItemByID('misc', caption+'.HINT');
      [*] = ;      if (hint='') then hint := text;
      [*] = ;      elmCheckbox := _gui_CreateCheckBox(cGameOptionsCenterSquadPos, elmCol3Background, gProfileTmp.bcenterfirstrow, gc_halParentLeft, gc_valParentTop, posX+cCheckboxXOffset, posY, eventstate, nul, cTagCheckboxVSync, bUpdate);
      [*] = ;      elmHnd := _gui_CreateText('t', elmCheckbox, textshort, gc_halParentLeft, gc_valParentTop, cCheckboxTextOffsetX, cCheckboxTextOffsetY, GetGUIElementWidth(elmList)-cCheckboxOffset, GetGUIElementHeight(elmList), gc_halLeft, gc_valTop, gc_font_serif_12, btncolor, bupdate);
      [*] = ;      SetGUIElementHint(elmCheckbox, hint);
      [*] = ;      SetGUIElementLogicWidth(elmCheckbox, _gui_GetFontTextWidth(text, gc_font_serif_12)+cCheckboxOffset);
      [*] = ;   end;
      [*] = ;   gc_settings_keybinding : begin
      [*] = ;   end;
      [*] = ;end;
      [*] = ;
      [*] = ;const cHeadOffset = 22;
      [*] = ;var elmBackground : Integer = _gui_CreateMainWindow('background', elmBackgroundParent, gc_halParentMiddle, gc_valParentMiddle, 0, cHeadOffset div 2, cwidth, cheight, 1, bupdate);
      [*] = ;_gui_CreateButton('bback', elmBackground, 'btn.close', gc_halParentRightWidth, gc_valParentTop, 4, -4, 0, 0, eventstate, nul, gc_gui_event_tagClose, bupdate);
      [*] = ;
      [*] = ;var elmHead : Integer = GetGUIElementIndexByNameParent('head.head', elmBackground);
      [*] = ;elmHnd := _gui_CreateText('thead', elmHead, cTextHeaderSettings, gc_halParentMiddle, gc_valParentMiddle, 9, 3, 0, 28, gc_halMiddle, gc_valMiddle, gc_font_serif_16, headcolor, bupdate);
      [*] = ;
      [*] = ;_gui_InvokeMouseMove;
      [*] = ;gint_gui_sliderhnd := 0;
      [*] = ;SetRandomKey(floor(Abs(randkey))); // if randkey<0 function set key0 to -1 and randomext start to provide negative values
      [*] = ;
      [*] = ;gint_gui_changeresolutionstage := 3;
   struct.end
section.end

