
----------------------------------------------------------------------------------------------------------------------

function hdAddJoint pjoint pjoints =
(
	if pjoint.parent != undefined then hdAddJoint pjoint.parent pjoints
	appendIfUnique pjoints pjoint
)

----------------------------------------------------------------------------------------------------------------------

function hdExportSkin pmesh pfile =
(
	local pskin = undefined
	for i = 1 to pmesh.modifiers.count do
	(
		if classof pmesh.modifiers[i] == Skin then
		(
			pskin = pmesh.modifiers[i]
			break
		)
	)
	
	if pskin != undefined then
	(
		classes = #(BoneGeometry,Biped_Object)
		joints = #()
		alljoints = for obj in objects where findItem classes (classof obj) > 0 collect obj
		for i = 1 to alljoints.count do hdAddJoint alljoints[i] joints

		jnames = #()
			
		format "\tjoints %\n" joints.count to:pfile
		format "\t{\n" to:pfile
		for i = 1 to joints.count do
		(
			obj = joints[i]
			jointName = obj.name
			
			append jnames jointName
			
			format "\t\tjoint %\n" jointName to:pfile
			format "\t\t{\n" to:pfile
			local mat
			if obj.parent != undefined then
			(
				format "\t\t\tparent %;\n" obj.parent.name to:pfile
				mat = obj.transform * inverse obj.parent.transform
			)
			else mat = obj.transform
			format "\t\t\torigin % % %;\n" mat.pos.x mat.pos.z mat.pos.y to:pfile
			format "\t\t\taxis % % % %;\n" mat.rotation.x mat.rotation.z mat.rotation.y -mat.rotation.w to:pfile
			format "\t\t}\n" to:pfile
		)
		format "\t}\n" to:pfile

		skinOps.removeZeroWeights pskin
		
		reindex = #()
		
		numBones = skinOps.getNumberBones pskin
		for i = 1 to numBones do
		(
			boneName = skinOps.getBoneName pskin i 1
			index = (findItem jnames boneName) - 1
			append reindex index
		)
	
		local numWeights = 0
		local numVerts = skinOps.GetNumberVertices pskin
		for i = 1 to numVerts do numWeights += skinOps.GetVertexWeightCount pskin i
		
		format "\tweights %\n" numWeights to:pfile
		format "\t{\n" to:pfile
		for i = 1 to numVerts do
		(
			numWeights = skinOps.GetVertexWeightCount pskin i
			for j = 1 to numWeights do
			(
				boneIndex = skinOps.GetVertexWeightBoneID pskin i j
				boneWeight = skinOps.GetVertexWeight pskin i j
				format "\t\tweight % % %;\n" (i-1) (reindex[boneIndex]) boneWeight to:pfile
			)
		)
		format "\t}\n" to:pfile
	)
)

----------------------------------------------------------------------------------------------------------------------

function hdExportPoly pmesh filename =
(
	progressStart "Exporting Mesh..."
	
	local pfile = createfile filename;
	format "HD_DATA_TXT\t300\n\n" to:pfile
	
	format "mesh\n" to:pfile
	format "{\n" to:pfile
	
	numVerts = polyop.getNumVerts pmesh
	format "\tverts %\n" numVerts to:pfile
	format "\t{\n" to:pfile
	for i = 1 to numVerts do
	(
		pt = polyop.getVert pmesh i
		--pt = pt * pmesh.transform
		format "\t\tvert % % %;\n" pt[1] pt[3] pt[2] to:pfile
	)
	format "\t}\n" to:pfile
	
	progressUpdate 20.0
	
	numUVs = polyop.getNumMapVerts pmesh 1
	format "\tuvs %\n" numUVs to:pfile
	format "\t{\n" to:pfile
	for i = 1 to numUVs do
	(
		pt = polyop.getMapVert pmesh 1 i
		format "\t\tuv % %;\n" pt[1] pt[2] to:pfile
	)
	format "\t}\n" to:pfile
	
	progressUpdate 40.0
	
	numFaces = polyop.getNumFaces pmesh
	
	if pmesh.material == undefined or classof pmesh.material == StandardMaterial then
	(
		format "\tgroups 1\n" to:pfile
		format "\t{\n" to:pfile
		format "\t\tgroup % %\n" "Model" numFaces to:pfile
		format "\t\t{\n" to:pfile
		for i = 1 to numFaces do
		(
			numVerts = polyop.getFaceDeg pmesh i
			verts = polyop.getFaceVerts pmesh i
			uvs = polyop.getMapFace pmesh 1 i
			format "\t\t\tface\n" to:pfile
			format "\t\t\t{\n" to:pfile
			format "\t\t\t\tcount %;\n" numVerts to:pfile
			format "\t\t\t\tverts " to:pfile
			for j = 0 to numVerts-1 do format " %" (verts[numVerts-j]-1) to:pfile
			format ";\n" to:pfile
			format "\t\t\t\tuvs " to:pfile
			for j = 0 to numVerts-1 do format " %" (uvs[numVerts-j]-1) to:pfile
			format ";\n" to:pfile
			
			sg = polyop.getFaceSmoothGroup pmesh i
			format "\t\t\t\tsmoothGroup %;\n" sg to:pfile
			
			format "\t\t\t}\n" to:pfile
		)
		format "\t\t}\n" to:pfile
		format "\t}\n" to:pfile
	)
	else if classof pmesh.material == MultiMaterial then
	(
		local mtl = pmesh.material
		local numGroups = mtl.materialList.count
		format "\tgroups %\n" numGroups to: pfile
		format "\t{\n" to:pfile
		
		for i = 1 to numGroups do
		(
			local faces = #()
			
			for j = 1 to numFaces do
			(
				if polyop.getFaceMatID pmesh j == i then append faces j
			)

			mtlname = mtl.materialList[i].name
			mtlname = substituteString mtlname " " "_"
			mtlname = substituteString mtlname "#" "_"
			
			format "\t\tgroup % %\n" mtlname faces.count to:pfile
			format "\t\t{\n" to:pfile
			for j = 1 to faces.count do
			(
				numVerts = polyop.getFaceDeg pmesh faces[j]
				verts = polyop.getFaceVerts pmesh faces[j]
				uvs = polyop.getMapFace pmesh 1 faces[j]
				format "\t\t\tface\n" to:pfile
				format "\t\t\t{\n" to:pfile
				format "\t\t\t\tcount %;\n" numVerts to:pfile
				format "\t\t\t\tverts " to:pfile
				for k = 1 to numVerts do format " %" (verts[k]-1) to:pfile
				format ";\n" to:pfile
				format "\t\t\t\tuvs " to:pfile
				for k = 1 to numVerts do format " %" (uvs[k]-1) to:pfile
				format ";\n" to:pfile
				
				sg = polyop.getFaceSmoothGroup pmesh faces[j]
				format "\t\t\t\tsmoothGroup %;\n" sg to:pfile
				
				format "\t\t\t}\n" to:pfile
			)
			format "\t\t}\n" to:pfile
		)
		format "\t}\n" to:pfile
	)
	
	progressUpdate 100.0
	progressEnd ()
	
	--      .   ,  !
	hdExportSkin pmesh pfile
	
	format "}\n" to:pfile
	close pfile
	
	displayTempPrompt "Done exporting" 2000
)

----------------------------------------------------------------------------------------------------------------------

function hdExportMesh pmesh filename =
(
	progressStart "Exporting Mesh..."
	
	local pfile = createfile filename;
	format "HD_DATA_TXT\t300\n\n" to:pfile
	
	format "mesh\n" to:pfile
	format "{\n" to:pfile
	
	numVerts = getNumVerts pmesh
	format "\tverts %\n" numVerts to:pfile
	format "\t{\n" to:pfile
	for i = 1 to numVerts do
	(
		pt = getVert pmesh i
		--pt = pt * pmesh.transform
		format "\t\tvert % % %;\n" pt[1] pt[3] pt[2] to:pfile
	)
	format "\t}\n" to:pfile
	
	progressUpdate 20.0
	
	numUVs = getNumTVerts pmesh
	format "\tuvs %\n" numUVs to:pfile
	format "\t{\n" to:pfile
	for i = 1 to numUVs do
	(
		pt = getTVert pmesh i
		format "\t\tuv % %;\n" pt[1] pt[2] to:pfile
	)
	format "\t}\n" to:pfile
	
	progressUpdate 20.0
	
	numFaces = getNumFaces pmesh
	
	if pmesh.material == undefined or classof pmesh.material == StandardMaterial then
	(
		format "\tgroups 1\n" to:pfile
		format "\t{\n" to:pfile
		format "\t\tgroup % %\n" "Model" numFaces to:pfile
		format "\t\t{\n" to:pfile
		for i = 1 to numFaces do
		(
			format "\t\t\tface\n" to:pfile
			format "\t\t\t{\n" to:pfile
			format "\t\t\t\tcount 3;\n" to:pfile
			
			verts = getFace pmesh i
			format ( "\t\t\t\tverts % % %;\n" ) ((int)(verts[ 3 ]-1)) ((int)(verts[ 2 ]-1)) ((int)(verts[ 1 ]-1)) to:pfile;

			uvs = getTVFace pmesh i
			format ( "\t\t\t\tuvs % % %;\n" ) ((int)(uvs[ 3 ]-1)) ((int)(uvs[ 2 ]-1)) ((int)(uvs[ 1 ]-1)) to:pfile;
			
			sg = getFaceSmoothGroup pmesh i
			format "\t\t\t\tsmoothGroup %;\n" sg to:pfile
			
			format "\t\t\t}\n" to:pfile
		)
		format "\t\t}\n" to:pfile
		format "\t}\n" to:pfile
	)
	else if classof pmesh.material == MultiMaterial then
	(
		local mtl = pmesh.material
		local numGroups = mtl.materialList.count
		format "\tgroups %\n" numGroups to: pfile
		format "\t{\n" to:pfile
		
		for i = 1 to numGroups do
		(
			local faces = #()
			
			for j = 1 to numFaces do
			(
				if getFaceMatID pmesh j == i then append faces j
			)
			
			mtlname = mtl.materialList[i].name
			mtlname = substituteString mtlname " " "_"
			mtlname = substituteString mtlname "#" "_"

			format "\t\tgroup % %\n" mtlname faces.count to:pfile
			format "\t\t{\n" to:pfile
			for j = 1 to faces.count do
			(
				format "\t\t\tface\n" to:pfile
				format "\t\t\t{\n" to:pfile
				format "\t\t\t\tcount 3;\n" to:pfile
				
				verts = getFace pmesh faces[j]
				format ( "\t\t\t\tverts % % %;\n" ) ((int)(verts[ 3 ]-1)) ((int)(verts[ 2 ]-1)) ((int)(verts[ 1 ]-1)) to:pfile;

				uvs = getTVFace pmesh faces[j]
				format ( "\t\t\t\tuvs % % %;\n" ) ((int)(uvs[ 3 ]-1)) ((int)(uvs[ 2 ]-1)) ((int)(uvs[ 1 ]-1)) to:pfile;
				
				sg = getFaceSmoothGroup pmesh faces[j]
				format "\t\t\t\tsmoothGroup %;\n" sg to:pfile
				
				format "\t\t\t}\n" to:pfile
			)
			format "\t\t}\n" to:pfile
		)
		format "\t}\n" to:pfile
	)
	
	--      .   ,  !
	progressUpdate 100.0
	progressEnd ()
	
	hdExportSkin pmesh pfile
	
	format "}\n" to:pfile
	close pfile
	
	displayTempPrompt "Done exporting" 2000
)

----------------------------------------------------------------------------------------------------------------------

function hdExportMeshObject pmesh filename =
(
	if classof pmesh == Editable_Mesh then hdExportMesh pmesh filename
	else hdExportPoly pmesh filename
)

----------------------------------------------------------------------------------------------------------------------

function hdDoExportMotion filename joints =
(
	if joints.count != 0 then
	(
		progressStart "Exporting Motion..."
		
		pfile = createfile filename;
		format "HD_DATA_TXT\t300\n\n" to:pfile
		
		format "motion\n" to:pfile
		format "{\n" to:pfile
		
		startFrame = animationRange.start
		endFrame = animationRange.end
		numFrames = (endFrame - startFrame) + 1
		
		format "\tnumTracks %;\n" joints.count to:pfile
		format "\tnumFrames %;\n" ((int)(numFrames)) to:pfile
		format "\tframeRate %;\n" frameRate to:pfile
		
		count = joints.count
		index = 0
		
		for track in joints do
		(
			format "\ttrack %\n" track.name to:pfile
			format "\t{\n" to:pfile
			for f = startFrame to EndFrame do
			(
				at time f
				(
					format "\t\tkey" to:pfile
					if track.parent != undefined then mat = track.transform * inverse track.parent.transform
					else mat = track.transform
					format " % % %" mat.pos.x mat.pos.z mat.pos.y to:pfile
					format " % % % %;\n" mat.rotation.x mat.rotation.z mat.rotation.y -mat.rotation.w to:pfile
				)
			)
			format "\t}\n" to:pfile
			
			index = index + 1
			progress = 80.0 * index / count
			progressUpdate progress
		)
		
	
		numEvents = 0;
		classes = #(Point,Dummy)
		objs = for obj in objects where findItem classes (classof obj) > 0 collect obj
		
		count = objs.count
		index = 0
		
		for obj in objs do
		(
			for i = 1 to numNoteTracks obj do
			(
				note = getNoteTrack obj i;
				for key in note.keys do
				(
					if key.time >= startFrame and key.time <= endFrame then
					(
						format "\tevent % %;\n" key.value ((int)(key.time - startFrame)) to:pfile
						numEvents += 1
					)
				)
			)
			
			index = index + 1
			progress = 80.0 + 20.0 * index / count
			progressUpdate progress
		)
		
		format "\tnumEvents %;\n" ((int)(numEvents)) to:pfile
		
		format "}\n" to:pfile
		
		close pfile
		
		progressEnd ()
		displayTempPrompt "Done exporting" 2000
	)
	else
	(
		MessageBox "No sequence objects found"
	)
)

----------------------------------------------------------------------------------------------------------------------

function hdExportMotion filename =
(
	--classes = #(BoneGeometry,Biped_Object,Dummy,IK_Chain_Object,Point)
	classes = #(BoneGeometry,Biped_Object)
	joints = for obj in objects where findItem classes (classof obj) > 0 collect obj
	
	hdDoExportMotion filename joints;
)

function hdExportMotionSelected filename =
(
	--classes = #(BoneGeometry,Biped_Object,Dummy,IK_Chain_Object,Point)
	classes = #(BoneGeometry,Biped_Object)
	joints = for obj in selection where findItem classes (classof obj) > 0 collect obj
	
	hdDoExportMotion filename joints;
)

----------------------------------------------------------------------------------------------------------------------

function hdDoExportPose filename joints =
(
	if joints.count != 0 then
	(
		progressStart "Exporting Pose..."
		
		pfile = createfile filename;
		format "HD_DATA_TXT\t300\n\n" to:pfile
		
		format "pose\n" to:pfile
		format "{\n" to:pfile
		
		format "\tnumTransforms %;\n" ((int)joints.count) to:pfile
		
		count = joints.count
		index = 0
		
		for track in joints do
		(
			format "\ttransform %" track.name to:pfile
			at time sliderTime
			(
				if track.parent != undefined then mat = track.transform * inverse track.parent.transform
				else mat = track.transform
				format " % % %" mat.pos.x mat.pos.z mat.pos.y to:pfile
				format " % % % %;\n" mat.rotation.x mat.rotation.z mat.rotation.y -mat.rotation.w to:pfile
			)
			
			index = index + 1
			progress = 100.0 * index / count
			progressUpdate progress
		)
		
		format "}\n" to:pfile
		
		close pfile
		
		progressEnd ()
		displayTempPrompt "Done exporting" 2000
	)
	else
	(
		MessageBox "No pose objects found"
	)
)

----------------------------------------------------------------------------------------------------------------------

function hdExportPose filename =
(
	--classes = #(BoneGeometry,Biped_Object,Dummy,IK_Chain_Object,Point)
	classes = #(BoneGeometry,Biped_Object)
	joints = for obj in objects where findItem classes (classof obj) > 0 collect obj
	
	hdDoExportPose filename joints;
)

function hdExportPoseSelected filename =
(
	--classes = #(BoneGeometry,Biped_Object,Dummy,IK_Chain_Object,Point)
	classes = #(BoneGeometry,Biped_Object)
	joints = for obj in selection where findItem classes (classof obj) > 0 collect obj
	
	hdDoExportPose filename joints;
)

----------------------------------------------------------------------------------------------------------------------

function hdDoExportSkeleton filename joints =
(
	if joints.count != 0 then
	(
		progressStart "Exporting Skeleton..."
		
		pfile = createfile filename;
		format "HD_DATA_TXT\t300\n\n" to:pfile
		
		format "skeleton %\n" joints.count to:pfile
		format "{\n" to:pfile
		
		count = joints.count
		index = 0
		
		for joint in joints do
		(
			format "\tbone %\n" joint.name to:pfile
			format "\t{\n" to:pfile
			
			format "\t\twidth %;\n" joint.width to:pfile
			format "\t\theight %;\n" joint.height to:pfile
			format "\t\tlength %;\n" joint.length to:pfile
			
			if joint.parent != undefined then
			(
				--mat = joint.transform * inverse joint.parent.transform
				format "\t\tparent %;\n" joint.parent.name to:pfile
			)
			--else mat = joint.transform
			mat = joint.transform
			format "\t\torigin % % %;\n" mat.pos.x mat.pos.z mat.pos.y to:pfile
			format "\t\taxis % % % %;\n" mat.rotation.x mat.rotation.z mat.rotation.y -mat.rotation.w to:pfile
			
			format "\t}\n" to:pfile
			
			index = index + 1
			progress = 100.0 * index / count
			progressUpdate progress
		)
		
		format "}\n" to:pfile
		
		close pfile
		
		progressEnd ()
		displayTempPrompt "Done exporting" 2000
	)
	else MessageBox "No bones to export"
)

----------------------------------------------------------------------------------------------------------------------

function hdExportSkeleton filename =
(
	classes = #(BoneGeometry)
	joints = for obj in objects where findItem classes (classof obj) > 0 collect obj
	
	hdDoExportSkeleton filename joints;
)

function hdExportSkeletonSelected filename =
(
	classes = #(BoneGeometry)
	joints = for obj in selection where findItem classes (classof obj) > 0 collect obj
	
	hdDoExportSkeleton filename joints;
)

----------------------------------------------------------------------------------------------------------------------

version=maxVersion();if version[1]>=8000 then( -- Check Version of 3DSMAX
rollout dlg "Haydee Exporter" width:200 height:400
(
	--groupBox meshGroup "Export Mesh" pos:[10, 10] width:180 height:100
	button meshExportBtn "Export Mesh (Selected)" pos:[10,20] width:180 height: 20
	button seqExportBtn "Export Motion" pos:[10,45] width:180 height: 20
	button skelExportBtn "Export Skeleton" pos:[10,70] width:180 height: 20
	button poseExportBtn "Export Pose" pos:[10,95] width:180 height: 20
	checkbox selOnly "Selected Only" pos:[10, 129] width: 180 height: 20
	
	on meshExportBtn pressed do
	(
		classes = #(Editable_Poly,PolyMeshObject,Editable_Mesh)
		if selection.count != 1 then MessageBox "Select one object"
		else
		(
			obj = selection[1]
			if classof obj != Editable_Poly and classof obj != PolyMeshObject and classof obj != Editable_Mesh then
			(
				MessageBox "Object not exportable"
			)
			else
			(
				filename = getSaveFileName caption:"Save Haydee Mesh Data" types: "Haydee Mesh Data (*.dmesh)|*.dmesh|"
				if filename != "" and filename != undefined then hdExportMeshObject selection[1] filename
			)
		)
	)
	
	on seqExportBtn pressed do
	(
		filename = getSaveFileName caption:"Save Haydee Motion Data" types: "Haydee Motion Data (*.dmot)|*.dmot|"
		if filename != "" and filename != undefined then 
		(
			if selOnly.checked then hdExportMotionSelected filename;
			else hdExportMotion filename;
		)
	)
	
	on skelExportBtn pressed do
	(
		filename = getSaveFileName caption:"Save Haydee Skeleton Data" types: "Haydee Skeleton Data (*.dskel)|*.dskel|"
		if filename != "" and filename != undefined then 
		(
			if selOnly.checked then hdExportSkeletonSelected filename;
			else hdExportSkeleton filename;
		)
	)
	
	on poseExportBtn pressed do
	(
		filename = getSaveFileName caption:"Save Haydee Pose Data" types: "Haydee Pose Data (*.dpose)|*.dpose|"
		if filename != "" and filename != undefined then 
		(
			if selOnly.checked then hdExportPoseSelected filename;
			else hdExportPose filename;
		)
	)
	
)
createDialog dlg
gc() -- flushes cache, also resets undo. but command needed to help release files (not required to be on)
fclose f
fclose s
clearlistener()
)