unit Unit1;

interface
//IniFiles
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls,shellapi,IniFiles, ComCtrls, Grids, DBGrids, Buttons,
  ExtCtrls, DB, ADODB,DateUtils;
type
  TIDD102 = class(TForm)
    Panel_Left: TPanel;
    Panel11: TPanel;
    BB_PreRoom: TBitBtn;
    BB_NextRoom: TBitBtn;
    DBGrid1: TDBGrid;
    GroupBox2: TGroupBox;
    IDD102_1001: TRadioButton;
    IDD102_1000: TRadioButton;
    IDD102_1016: TCheckBox;
    IDD102_1018: TCheckBox;
    IDD102_1017: TCheckBox;
    Label_RoomCode: TLabel;
    Edit_RoomCode: TEdit;
    Edit_DoorLockCode: TEdit;
    Label_LockCode: TLabel;
    Label_BeginDate: TLabel;
    DTP_Begin_Date: TDateTimePicker;
    Label_BeginTime: TLabel;
    DTP_Begin_Time: TDateTimePicker;
    DTP_End_Time: TDateTimePicker;
    Label_EndTime: TLabel;
    DTP_End_Date: TDateTimePicker;
    Label_EndDate: TLabel;
    btnReadCard: TButton;
    btnCheckInNew: TBitBtn;
    btnCancelCard: TButton;
    BB_Close: TBitBtn;
    Button_OpenPort: TButton;
    GroupBox1: TGroupBox;
    IDD102_1012: TLabel;
    IDD102_1013: TLabel;
    IDD102_1014: TLabel;
    etRoom: TEdit;
    IDD102_1011: TButton;
    etInTime: TEdit;
    etOutTime: TEdit;
    IDD102_1003: TButton;
    IDD102_1005: TButton;
    IDD102_1009: TButton;
    IDD102_1002: TButton;
    ADOQ_RoomLists: TADOQuery;
    DS_RoomLists: TDataSource;
    ADOQ_FormTemp: TADOQuery;
    SpeedButton2: TSpeedButton;
    Edit_ReadCard: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure IDD102_1003Click(Sender: TObject);
    procedure IDD102_1005Click(Sender: TObject); 
    procedure IDD102_1009Click(Sender: TObject);
    procedure IDD102_1002Click(Sender: TObject); 
    procedure IDD102_1011Click(Sender: TObject);
    procedure Button_OpenPortClick(Sender: TObject);
    procedure btnReadCardClick(Sender: TObject);
    procedure btnCancelCardClick(Sender: TObject);
    procedure btnCheckInNewClick(Sender: TObject);
    procedure BB_CloseClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure DBGrid1CellClick(Column: TColumn);
    procedure DBGrid1KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure BB_PreRoomClick(Sender: TObject);
    procedure BB_NextRoomClick(Sender: TObject);
  private
    iRet: LongInt;
    Rom: array[0..64] of char;
    LockSDKDLL: LongWord;
    iDoorType: LongInt;
    Door_Path: string;
    iFlags:LongInt;//Ƭ־20151105
  public
    { Public declarations }

    //
    gl_GuestID:Integer;//ID
    gs_RoomCode:String;//
    gs_Lock_work_role:String;//򿪣ֻܷ
    //
    //
    gs_RoomCode_Lists:String;//б
    gs_BookSendCard:String; //ǷԤ
    gi_BookSendCard_AssignRoomID:Integer;//ŷID
  end;

var
  IDD102: TIDD102;
  MyIniFile:TIniFile;
  g_szLanguagePath: string;//Դ·ļ
  g_szText:string; //ݱʶ szIDѡļмַ
  g_szfrmText:string;//ڱ
implementation
 uses Unit2,dm,SysFrame, pub_Temp_InputPassword;
{$R *.dfm}

//õiniļ·
procedure GetLanguagePath_Ex();
var
  fileNm: string;
  vs    : string;

Begin
 // fileNm :=ExtractFilePath(Paramstr(0))+'Config.ini';
 // myinifile:=Tinifile.Create(fileNm);
  //vs:=myinifile.Readstring('System','Language','Chinese' );
  g_szLanguagePath :=ExtractFilePath(Paramstr(0))+'ToolsLanguage.ini';
end;

///*********************************************************************
 //* :g_LoadString_Ex
 //* ˵:	ݱʶ szIDѡļмַ
// * :	zs
//*********************************************************************/
function g_LoadString_Ex(szID: string):string;
var
  vs    : string;
Begin
  if  g_szLanguagePath='' then
  begin
     GetLanguagePath_Ex();
  end;
  myinifile:=Tinifile.Create(g_szLanguagePath);
   vs:=myinifile.Readstring('String',szID,'Not found' );
   g_LoadString_Ex:=vs;
end;

///*********************************************************************
 //* :g_SetDialogStrings_Ex(frm:TForm)
 //* ˵:	Իʱȡпɵõַ浽ļ
 //			ÿؼöԻIDͿؼIDΨһʶ
 //* ڲ:
 //* frm:TForm -- Ի
 //* : zs
//*********************************************************************/
procedure g_SetDialogStrings_Ex(const Cp : TForm);
var
  szKey : string;
  szText: string;
  I     : integer; 
Begin
     if  g_szLanguagePath='' then
     begin
        GetLanguagePath_Ex();
     end;
     myinifile:=Tinifile.Create(g_szLanguagePath);

     //ڱ
     szKey :=Cp.Name+'_Title';
     szText:=myinifile.Readstring('LockSDKDemo',szKey,'Not found' );
     Cp.Caption :=szText;


     //ؼı
     for I := Cp.ComponentCount-1 downto 0 do
     Begin
       szKey :=Cp.Components[I].Name;// Cp.Name+'_'+Cp.Components[I].Name;
       szText:=myinifile.Readstring('LockSDKDemo',szKey,'Not found' );
       if Cp.Components[I] is TButton  then
           TButton(Cp.Components[I]).Caption :=szText;
       if Cp.Components[I] is TLabel  then
           TLabel(Cp.Components[I]).Caption :=szText;
       if Cp.Components[I] is TRadioButton then
          TRadioButton(Cp.Components[I]).Caption :=szText;

     end;
end;


Procedure CheckErr(Ret: smallint);
var
  MsgStr: String;
  MsgTitle: String;
Begin
  case Ret of
    1:
      MsgStr := g_LoadString_Ex('IDS_STRING_SUCCESS');
    -1:
      MsgStr := g_LoadString_Ex('IDS_STRING_ERROR_NOCARD');
    -2:
      MsgStr := g_LoadString_Ex('IDS_STRING_ERROR_NOREADE');
    -3:
      MsgStr := g_LoadString_Ex('IDS_STRING_ERROR_INVALIDCARD');
    -4:
      MsgStr := g_LoadString_Ex('IDS_STRING_ERROR_CARDTYPE');
    -5:
      MsgStr := g_LoadString_Ex('IDS_STRING_ERROR_READCARD');
    -8:
      MsgStr := g_LoadString_Ex('IDS_STRING_ERROR_INPUT');
    -29:
      MsgStr := g_LoadString_Ex('IDS_STRING_ERROR_REG');
  else
    MsgStr := g_LoadString_Ex('IDS_STRING_ERROR');
  end;
  MsgTitle :=  g_LoadString_Ex('IDS_STRING_MSG');
  Application.MessageBox(Pchar(MsgStr),Pchar(MsgTitle), MB_OK+ MB_ICONINFORMATION);
end;


procedure TIDD102.FormCreate(Sender: TObject);      //ʼֵ
var
  sdllfile: string;
  DateTime: TDateTime;
  Msg: String;
  Msgstr:String;

begin
  Door_Path :=ExtractFilePath(Application.ExeName);
  sdllfile :=Door_Path+'LockSDK.dll';

 // if FileExists(sdllfile) then
 // begin
    LockSDKDLL :=LoadLibrary(PChar(sdllfile));
  //  if LockSDKDLL<=0 then
  //  begin
   //   Msg :=g_LoadString_Ex('IDS_STRING_ERROR_LOADDLL');
   //   MsgStr :=g_LoadString_Ex('IDS_STRING_ERROR_HANDLE');
   //   Application.MessageBox(Pchar(Msg),Pchar(MsgStr),MB_OK);
   // end;
 // end
 // else
  //begin
  //  Msg :=g_LoadString_Ex('IDS_STRING_NOTFOUND');
   // Application.MessageBox(Pchar(sdllfile),Pchar(Msg),MB_OK);
  //end;
  g_SetDialogStrings_Ex(IDD102);
  etRoom.Text :='001.002.00028';
  etInTime.Text :=FormatDateTime('yyyy', Now + 1)+'-'+  FormatDateTime('mm', Now + 1)+'-'+ FormatDateTime('dd', Now);//DateToStr(DateTime);

  etInTime.Text :=etInTime.Text+' '+ FormatDateTime('HH', Now + 1) +':'+   FormatDateTime('MM', Now + 1)+':'+FormatDateTime('SS', Now + 1);
  etOutTime.Text :=FormatDateTime('yyyy', Now + 1)+'-'+  FormatDateTime('mm', Now + 1)+'-'+ FormatDateTime('dd', Now + 1)+' 12:00:00'
end;

procedure TIDD102.IDD102_1003Click(Sender: TObject);     //ס
var
  TP_MakeGuestCardEx:function(sRom:PChar;sRoomNo:PChar;sInTime:PChar;sOutTime:PChar;iFlags:LongInt):LongInt;stdcall;
begin
  iFlags :=0;
  if IDD102_1018.Checked=true then
  begin
    iFlags:=iFlags+1;
  end;
  if IDD102_1016.Checked=false then
  begin
    iFlags:=iFlags+8;
  end;
  if IDD102_1017.Checked=true then
  begin
    iFlags:=iFlags+128;
  end;
  TP_MakeGuestCardEx:=GetProcAddress(LockSDKDLL,'TP_MakeGuestCardEx');
  iRet :=TP_MakeGuestCardEx(Rom,PChar(etRoom.Text),PChar(etInTime.Text),PChar(etOutTime.Text),iFlags);

  CheckErr(iRet);
end;

procedure TIDD102.IDD102_1005Click(Sender: TObject);    //   տ˵ȣ
var
  TP_CancelCard :function(sRom:PChar):LongInt;stdcall;
begin
  TP_CancelCard :=GetProcAddress(LockSDKDLL,'TP_CancelCard');
  iRet :=  TP_CancelCard(Rom);

  CheckErr(iRet);
end;

 

//Ϣ
procedure TIDD102.IDD102_1009Click(Sender: TObject);
var
//ڶ̬char*,ڶʱ  array[0..64] of  Char;
  aRoomNo :array[0..64] of  Char;
  aInTime :array[0..64] of Char;
  aOutTime :array[0..64] of Char;
  strMsg : string;
  MsgTitle: string;
  HexFlags: string;
  //ڶ̬char*ںʱPChar,
  TP_ReadGuestCardEx:function(sRom:PChar;sRoomNo:PChar;sInTime:PChar;sOutTime:PChar;var iFlags:LongInt):LongInt;stdcall;
begin
  TP_ReadGuestCardEx :=GetProcAddress(LockSDKDLL,'TP_ReadGuestCardEx');
  iRet :=TP_ReadGuestCardEx(Rom,aRoomNo,aInTime,aOutTime,iFlags);    //
  if iRet=1 then
  begin
    strMsg :=g_LoadString_Ex('IDS_STRING_CARDNO')+Rom+#13#10+g_LoadString_Ex('IDS_STRING_LOCKNO')+aRoomNo +#13#10;
    strMsg :=strMsg+g_LoadString_Ex('IDS_STRING_INTIME')+aInTime+#13#10 +g_LoadString_Ex('IDS_STRING_OUTTIME')+aOutTime+#13#10;
  // ShowMessage(strMsg);
     MsgTitle :=  g_LoadString_Ex('IDS_STRING_MSG');
     //Ƭ־
    HexFlags:='0x'+IntToHex(iFlags,2);
    strMsg:=strMsg+g_LoadString_Ex('IDS_STRING_FLAGS')+HexFlags+#13#10;

    if (iFlags and 1)<>0 then
    begin
      IDD102_1018.Checked:=true;
      strMsg:=strMsg+g_LoadString_Ex('IDS_STRING_OPEN_BLOCK')+#13#10;
    end
    else
    begin
        IDD102_1018.Checked:=false;
    end;

    if (iFlags and 8)=0 then
    begin
      IDD102_1016.Checked:=true;
       strMsg:=strMsg+g_LoadString_Ex('IDS_STRING_RELACE_OLDCARD')+#13#10;
    end
    else
    begin
        IDD102_1016.Checked:=false;
    end;
    if (iFlags and 128)<>0 then
    begin
      IDD102_1017.Checked:=true;
       strMsg:=strMsg+g_LoadString_Ex('IDS_STRING_CHECKIN_TIME');
    end
    else
    begin
        IDD102_1017.Checked:=false;
    end;
  Application.MessageBox(Pchar(strMsg),Pchar(MsgTitle), MB_OK+ MB_ICONINFORMATION);
 end
 else
 begin
       CheckErr(iRet);
  end;

end;

//ö̬⣬Ӷ
procedure TIDD102.IDD102_1002Click(Sender: TObject);
var
//庯
//ڶ̬int,LongInt
  TP_Configuration:function(iDoorType: LongInt):LongInt;stdcall;
begin
  TP_Configuration :=GetProcAddress(LockSDKDLL,'TP_Configuration');

  //ѡ
  if IDD102_1000.Checked then
  begin
    iDoorType :=4;
  end;
  if IDD102_1001.Checked then
  begin
       iDoorType :=5;
  end;

  //ö̬⣬Ӷ
  iRet :=TP_Configuration(iDoorType);
  if iRet<>1 then
  begin
    CheckErr(iRet);//
    Exit;
  end;

  //ɹסť
  IDD102_1003.Enabled :=True;
  IDD102_1005.Enabled :=True;
  IDD102_1009.Enabled :=True;
  IDD102_1011.Enabled :=True;
   CheckErr(iRet);//

end;




procedure TIDD102.IDD102_1011Click(Sender: TObject);
var 
  DateTime: TDateTime;
begin
  etInTime.Text :=FormatDateTime('yyyy', Now + 1)+'-'+  FormatDateTime('mm', Now + 1)+'-'+ FormatDateTime('dd', Now);//DateToStr(DateTime);

  etInTime.Text :=etInTime.Text+' '+ FormatDateTime('HH', Now + 1) +':'+   FormatDateTime('MM', Now + 1)+':'+FormatDateTime('SS', Now + 1);
end;

procedure TIDD102.Button_OpenPortClick(Sender: TObject);
var
//庯
//ڶ̬int,LongInt
  TP_Configuration:function(iDoorType: LongInt):LongInt;stdcall;
begin
  TP_Configuration :=GetProcAddress(LockSDKDLL,'TP_Configuration');

  //ѡ
  if IDD102_1000.Checked then
  begin
    iDoorType :=4;
  end;
  if IDD102_1001.Checked then
  begin
       iDoorType :=5;
  end;

  //ö̬⣬Ӷ
  iRet :=TP_Configuration(iDoorType);
  if iRet<>1 then
  begin
    CheckErr(iRet);//
    Exit;
  end;

  //ɹסť
  IDD102_1003.Enabled :=True;
  IDD102_1005.Enabled :=True;
  IDD102_1009.Enabled :=True;
  IDD102_1011.Enabled :=True;
   CheckErr(iRet);//

end;

procedure TIDD102.btnReadCardClick(Sender: TObject);
var
//ڶ̬char*,ڶʱ  array[0..64] of  Char;
  aRoomNo :array[0..64] of  Char;
  aInTime :array[0..64] of Char;
  aOutTime :array[0..64] of Char;
  strMsg : string;
  MsgTitle: string;
  HexFlags: string;
  //ڶ̬char*ںʱPChar,
  TP_ReadGuestCardEx:function(sRom:PChar;sRoomNo:PChar;sInTime:PChar;sOutTime:PChar;var iFlags:LongInt):LongInt;stdcall;
begin

//*****************************      ʼ    ************************************************
  TP_ReadGuestCardEx :=GetProcAddress(LockSDKDLL,'TP_ReadGuestCardEx');
  iRet :=TP_ReadGuestCardEx(Rom,aRoomNo,aInTime,aOutTime,iFlags);    //
  if iRet=1 then
  begin
    strMsg :=g_LoadString_Ex('IDS_STRING_CARDNO')+Rom+#13#10+g_LoadString_Ex('IDS_STRING_LOCKNO')+aRoomNo +#13#10;
    strMsg :=strMsg+g_LoadString_Ex('IDS_STRING_INTIME')+aInTime+#13#10 +g_LoadString_Ex('IDS_STRING_OUTTIME')+aOutTime+#13#10;
  // ShowMessage(strMsg);
     MsgTitle :=  g_LoadString_Ex('IDS_STRING_MSG');
     //Ƭ־
    HexFlags:='0x'+IntToHex(iFlags,2);
    strMsg:=strMsg+g_LoadString_Ex('IDS_STRING_FLAGS')+HexFlags+#13#10;

    if (iFlags and 1)<>0 then
    begin
      IDD102_1018.Checked:=true;
      strMsg:=strMsg+g_LoadString_Ex('IDS_STRING_OPEN_BLOCK')+#13#10;
    end
    else
    begin
        IDD102_1018.Checked:=false;
    end;

    if (iFlags and 8)=0 then
    begin
      IDD102_1016.Checked:=true;
       strMsg:=strMsg+g_LoadString_Ex('IDS_STRING_RELACE_OLDCARD')+#13#10;
    end
    else
    begin
        IDD102_1016.Checked:=false;
    end;
    if (iFlags and 128)<>0 then
    begin
      IDD102_1017.Checked:=true;
       strMsg:=strMsg+g_LoadString_Ex('IDS_STRING_CHECKIN_TIME');
    end
    else
    begin
        IDD102_1017.Checked:=false;
    end;
    //
    Edit_ReadCard.Text := strMsg;

    Application.MessageBox(Pchar(strMsg),Pchar(MsgTitle), MB_OK+ MB_ICONINFORMATION);
 end
 else
 begin
       CheckErr(iRet);
  end;
//*****************************          ************************************************

end;

procedure TIDD102.btnCancelCardClick(Sender: TObject);
var
  TP_CancelCard :function(sRom:PChar):LongInt;stdcall;
  //
  ls_sql:String;
begin

  //******************   շж    ʼ   ***************************
  SysFrame.gl_SubSysID := 4;//
  //******************   շж       ***************************

  //---------------------     ʾ¥¥     --------------------------------
  ls_sql := 'select * from v_kf_Room where RoomCode=''' + Trim(Edit_RoomCode.Text) + '''';
  dm.DM_Data.run_query(ADOQ_FormTemp,ls_sql,True);

  If ADOQ_FormTemp.RecordCount <= 0 Then
  BEGIN
      ShowMessage('' + Trim(Edit_RoomCode.Text) + 'ڣ顣');
      Exit;
  END;
  If ADOQ_FormTemp.RecordCount > 0 Then
  BEGIN
      Edit_DoorLockCode.Text := Trim(ADOQ_FormTemp.FieldByName('DoorLockCode').AsString); //
  END;
  //---------------------     ʾ¥¥     --------------------------------


//*****************************      ʼ    ************************************************
  TP_CancelCard :=GetProcAddress(LockSDKDLL,'TP_CancelCard');
  iRet :=  TP_CancelCard(Rom);

  CheckErr(iRet);
  If iRet <> 1 THEN
  BEGIN
      //Exit;//
  END;
//*****************************          ************************************************

      //д־
      //***************************  д־   *****************************************
      ls_sql := 'UPDATE kf_DoorLock_CardList SET '
          + ' CancelShift=''' + Trim(SysFrame.gs_ShiftCode ) + ''','
          + ' CancelManID=' + SysFrame.gs_UserID + ',CancelDT=GETDATE() '
          + ' WHERE CancelManID IS NULL AND RoomCode=''' + Trim(Edit_RoomCode.Text) + '''';
      IF NOT dm.DM_Data.run_query_NoMsg(NIL,ls_sql,False) THEN
      BEGIN
          ShowMessage('ɹ (¼  Ϳ  Ĳ־ʧܣ)');
      END;
      //********************************************************************

      //¼
      ls_sql := 'UPDATE kf_Guests SET Cancel_DoorCard_Count=Cancel_DoorCard_Count + 1 '
          + ' WHERE GuestState=''I'' AND RoomCode=''' + Trim(Edit_RoomCode.Text) + '''';
      If not dm.DM_Data.run_query_NoMsg(NIL,ls_sql,False) then
      begin
          ShowMessage('¼ʧܣ');
      end;

      //дĲ־
      SysFrame.CreateOperateLog('ӿ','עſ','עſ','עſ:' + Edit_RoomCode.Text,'',
              0,'','',0,'','',0,'','','ע:עſ');

  //Application.MessageBox('Clear Card Success','Info',MB_OK);
  Application.MessageBox('ɹ!(Clear Card Success)','ʾ',MB_OK);


end;

procedure TIDD102.btnCheckInNewClick(Sender: TObject);
var
  TP_MakeGuestCardEx:function(sRom:PChar;sRoomNo:PChar;sInTime:PChar;sOutTime:PChar;iFlags:LongInt):LongInt;stdcall;
  //
  ls_sql:String;
  ls_BeginDT,ls_EndDT:String;
begin
//******************   շж    ʼ   ***************************
  SysFrame.gl_SubSysID := 4;//

  //жϴ˷ǲǿշԤŷ
  //ǿշϷǷпշȨ
  ls_sql := 'SELECT * FROM kf_Guests WHERE GuestState=''I'' AND RoomCode='''
         + Trim(Edit_RoomCode.Text) + '''';
  dm.DM_Data.run_query(ADOQ_FormTemp,ls_sql,True);
  If ADOQ_FormTemp.RecordCount <= 0 Then
  BEGIN
      //жǲԤŷ
      ls_sql := 'SELECT * FROM kf_Book_AssignRoom WHERE BookID IN (SELECT BookID FROM kf_Book WHERE BookState=''R'') '
	        + ' AND RoomCode=''' + Trim(Edit_RoomCode.Text) + '''';
      dm.DM_Data.run_query(ADOQ_FormTemp,ls_sql,True);
      If ADOQ_FormTemp.RecordCount <= 0 Then
      BEGIN
          If IsHavePower_SpecialPower(dm.DM_Data.DB_ADOConnection,'ȨԿշſ') <> True THEN
          BEGIN
              ShowMessage('ȨԿշз' + Trim(Edit_RoomCode.Text) + 'ǿշδŷ');
              Exit;
          END;
      END;
  END;
//******************   շж       ***************************



  //---------------------     ʾ¥¥     --------------------------------
  ls_sql := 'select * from v_kf_Room where RoomCode=''' + Trim(Edit_RoomCode.Text) + '''';
  dm.DM_Data.run_query(ADOQ_FormTemp,ls_sql,True);

  If ADOQ_FormTemp.RecordCount <= 0 Then
  BEGIN
      ShowMessage('' + Trim(Edit_RoomCode.Text) + 'ڣ顣');
      Exit;
  END;
  If ADOQ_FormTemp.RecordCount > 0 Then
  BEGIN
      //
      Edit_DoorLockCode.Text := Trim(ADOQ_FormTemp.FieldByName('DoorLockCode').AsString);
      etRoom.Text := Trim(ADOQ_FormTemp.FieldByName('DoorLockCode').AsString);
  END;
  //---------------------     ʾ¥¥     --------------------------------

  //ʼʱ
  DTP_Begin_Date.Time := DTP_Begin_Time.Time ;
  DTP_Begin_Time.Date := DTP_Begin_Date.Date ;
  //ʱ
  DTP_End_Date.Time := DTP_End_Time.Time ;
  DTP_End_Time.Date := DTP_End_Date.Date ;

  //ʼʱ
  ls_BeginDT := formatdatetime('YYYY-MM-DD hh:mm:ss',DTP_Begin_Date.DateTime);
  etInTime.Text := ls_BeginDT;
  //ʧЧʱ
  ls_EndDT := formatdatetime('YYYY-MM-DD hh:mm:ss',DTP_End_Date.DateTime);
  etOutTime.Text := ls_EndDT;

//*****************************      ʼ    ************************************************
  iFlags :=0;
  if IDD102_1018.Checked=true then
  begin
    iFlags:=iFlags+1;
  end;
  if IDD102_1016.Checked=false then
  begin
    iFlags:=iFlags+8;
  end;
  if IDD102_1017.Checked=true then
  begin
    iFlags:=iFlags+128;
  end;
  TP_MakeGuestCardEx:=GetProcAddress(LockSDKDLL,'TP_MakeGuestCardEx');
  iRet :=TP_MakeGuestCardEx(Rom,PChar(etRoom.Text),PChar(etInTime.Text),PChar(etOutTime.Text),iFlags);

  CheckErr(iRet);
  If iRet <> 1 THEN
  BEGIN
      //Exit;//
  END;
//*****************************          ************************************************



  //***************************  д־  ʼ   *****************************************
  ls_sql := 'INSERT INTO kf_DoorLock_CardList (CardCode,RoomCode,BeginDT,EndDT,InputManID,InputDT,SendCardShift,Remark) '
    	  + ' VALUES (''' + Trim(Edit_DoorLockCode.Text) + ''',''' + Trim(Edit_RoomCode.Text)
        + ''',''' + FormatDateTime('yyyy-mm-dd hh:mm:ss',DTP_Begin_Date.DateTime) + ''','''
        + FormatDateTime('yyyy-mm-dd hh:mm:ss',DTP_End_Date.DateTime) + ''','
        + SysFrame.gs_UserID + ',getdate(),''' + SysFrame.gs_ShiftCode + ''',''ס'' )';
  If not dm.DM_Data.run_query_NoMsg(NIL,ls_sql,False) then
  begin
      ShowMessage('д־ʧܣ');
  end;
  //***************************   д־     *****************************************

  //¼
  ls_sql := 'UPDATE kf_Guests SET Send_DoorCard_Count=Send_DoorCard_Count + 1 '
          + ' WHERE GuestState=''I'' AND RoomCode=''' + Trim(Edit_RoomCode.Text) + '''';
  If not dm.DM_Data.run_query_NoMsg(NIL,ls_sql,False) then
  begin
      ShowMessage('¼ʧܣ');
  end;

  //
  ShowMessage('Ϳɹ!');
  //һ
  BB_NextRoom.Click ;


end;

procedure TIDD102.BB_CloseClick(Sender: TObject);
begin
    //
    Close();

end;

procedure TIDD102.FormShow(Sender: TObject);
var
  ls_sql,ls_BeginDT,ls_EndDT:String;
  ls_RoomCode:String;
  ls_SendCard_SortNo:String; //˳
  ls_Default_Depart_Time:String;
  ls_DoorLockCode:String;
  //
  ini:TIniFile;
  //
  ls_XingLong_Server,ls_XingLong_User,ls_XingLong_Password:String;
  //
  ls_AssignRoomID:String;
begin
  //ݿӲ
  ADOQ_FormTemp.Connection := DM.DM_Data.DB_ADOConnection ;
  ADOQ_RoomLists.Connection := DM.DM_Data.DB_ADOConnection ;

//********************     **********************************
  Self.Caption := 'LockSDKӿ(V3.3)';
  //
  BB_PreRoom.Caption := 'һ';
  BB_NextRoom.Caption := 'һ';
  //
  Button_OpenPort.Caption := '򿪶˿';
  btnReadCard.Caption := '';
  btnCheckInNew.Caption := 'Ϳ';
  btnCancelCard.Caption := '';
  BB_Close.Caption := 'ر(&C)';
  //
  Label_RoomCode.Caption := '        ';
  Label_LockCode.Caption := '    ';

  Label_BeginDate.Caption := 'ס';
  Label_BeginTime.Caption := 'סʱ';
  Label_EndDate.Caption := 'ʧЧ';
  Label_EndTime.Caption := 'ʧЧ';
//********************     **********************************


  //   ˿
  ls_sql := 'if NOT exists(select * from syscolumns where id=object_id(''kf_DoorLock_ParaValue'') and name=''LiYong_COMM_Index'') '
      + ' Begin '
      + '    ALTER TABLE kf_DoorLock_ParaValue ADD [LiYong_COMM_Index] int NOT NULL Default 0 '
      + ' End; ';
  dm.DM_Data.run_query(nil,ls_sql,False);


  //--   ˿
  ls_sql := 'if NOT exists(select * from syscolumns where id=object_id(''kf_DoorLock_ParaValue'') and name=''LiYong_CardType_Index'') '
      + ' Begin '
      + '    ALTER TABLE kf_DoorLock_ParaValue ADD [LiYong_CardType_Index] int NOT NULL Default 0 '
      + ' End;';
  dm.DM_Data.run_query(nil,ls_sql,False);


//****************   ȡ  עͶ˿ں   ****************************************
  ls_sql := 'SELECT * FROM kf_DoorLock_ParaValue';
  dm.DM_Data.run_query(ADOQ_FormTemp,ls_sql,True);
  If ADOQ_FormTemp.RecordCount <= 0 Then
  Begin
      ShowMessage('ҵ  ز ļ¼');
  End;
  If ADOQ_FormTemp.RecordCount > 0 Then
  Begin
      //˿ں
      //ComboBox1.ItemIndex := ADOQ_FormTemp.FieldByName('LiYong_COMM_Index').AsInteger;
      //˿ں
      //ComboBox2.ItemIndex := ADOQ_FormTemp.FieldByName('LiYong_CardType_Index').AsInteger;
  End;
//****************************************************************************

  // (1) ȡ 
  ls_sql := 'SELECT * FROM kf_DoorLock_ParaValue';
  dm.DM_Data.run_query(nil,ls_sql,True);
  If dm.DM_Data.ADOQ_temp.RecordCount > 0 Then
  BEGIN
      ls_XingLong_Server := Trim(dm.DM_Data.ADOQ_temp.FieldByName('XingLong_Server').AsString);
      ls_XingLong_User := Trim(dm.DM_Data.ADOQ_temp.FieldByName('XingLong_User').AsString);
      ls_XingLong_Password := Trim(dm.DM_Data.ADOQ_temp.FieldByName('XingLong_Password').AsString);
  END
  ELSE
  BEGIN
      ShowMessage('ûҵ ADEL Ĳ ');
      //
      ls_XingLong_Server := '';
      ls_XingLong_User := '6';
      ls_XingLong_Password := '';
  END;


//****************   ȡ     ****************************************
  ini:=Tinifile.Create(ExtractFilePath(application.ExeName)+'gz.ini');
  try
    //
    gs_RoomCode := ini.ReadString('DoorLock','RoomCode','');//
    //
    Edit_DoorLockCode.Text := ini.ReadString('DoorLock','DoorLockCode','');
    //ID
    gl_GuestID := StrToInt(ini.ReadString('DoorLock','GuestID','0') );//ID

    //ûID(ַ)
    SysFrame.gs_UserID := ini.ReadString('DoorLock','UserID','1');//ԱID
    //û
    SysFrame.gs_UserCode := ini.ReadString('DoorLock','UserCode','');//Ա
    //û
    SysFrame.gs_UserName := ini.ReadString('DoorLock','UserName','');//Ա
    //ûID(ֵ)
    SysFrame.gl_UserID := StrToInt(ini.ReadString('DoorLock','UserID','1') );//ID

    //α
    SysFrame.gs_ShiftCode := ini.ReadString('DoorLock','ShiftCode','2');
    //
    SysFrame.gs_ShiftName := ini.ReadString('DoorLock','ShiftName','δ֪');


    //б
    gs_RoomCode_Lists := ini.ReadString('DoorLock','RoomCode_Lists','');
    //ǷԤ
    gs_BookSendCard := ini.ReadString('DoorLock','BookSendCard','N');
    //ŷID
    ls_AssignRoomID := ini.ReadString('DoorLock','BookSendCard_AssignRoomID','0');
    If Trim(ls_AssignRoomID) = '' THEN
    BEGIN
        ls_AssignRoomID := '0';
    END;
    gi_BookSendCard_AssignRoomID := StrToInt(ls_AssignRoomID)
  Except
    //
    ShowMessage('ȡʧܣӰ췢');
  end;

  try
    ini.Free;
  Except
    //
    ShowMessage('ini.FreeʧܣӰ췢');
  end;
//****************   ȡ     ****************************************

  //ʼ  / ʱ
  DTP_Begin_Date.DateTime := SysFrame.GetServerDateTime(dm.DM_Data.DB_ADOConnection);
  DTP_Begin_Date.DateTime := IncHour(DTP_Begin_Date.DateTime,-1);//˺һСʱ
  DTP_Begin_Time.DateTime := SysFrame.GetServerDateTime(dm.DM_Data.DB_ADOConnection);
  DTP_Begin_Time.DateTime := IncHour(DTP_Begin_Time.DateTime,-1);//˺һСʱ

//-------------------------------------------------------------------------------------
  //ȡ Ĭʱ
  ls_sql := 'SELECT * FROM kf_Sys_Parameter';
  dm.DM_Data.run_query(nil,ls_sql,True);
  If dm.DM_Data.ADOQ_temp.RecordCount > 0 Then
    BEGIN
      ls_Default_Depart_Time := Trim(dm.DM_Data.ADOQ_temp.FieldByName('Default_Depart_Time').AsString);
    END
  ELSE
    BEGIN
      ShowMessage('ϵͳûҵ Ĭʱ ĲĬΪ 12:00:00 ');
      ls_Default_Depart_Time := '12:00:00';
    END;
  //
  IF Length( TRIM(ls_Default_Depart_Time) ) <= 7 Then
  Begin
      ShowMessage('ϵͳȡ Ĭʱ ĲʽԣĬΪ12:00:00 ');
      ls_Default_Depart_Time := '12:00:00';
  END;
//-------------------------------------------------------------------------------------
  Try
      //  / ʱ
        DTP_End_Date.DateTime := SysFrame.GetServerDateTime_NextDay(dm.DM_Data.DB_ADOConnection);
        DTP_End_Date.Time := StrToTime(ls_Default_Depart_Time);
        DTP_End_Time.DateTime := SysFrame.GetServerDateTime_NextDay(dm.DM_Data.DB_ADOConnection);
        DTP_End_Time.Time := StrToTime(ls_Default_Depart_Time);
  EXCEPT
      ShowMessage('ĬϽʱ⡣');
  END;

//----------------------------------------------------------
  //ṩ   
  If gs_RoomCode <> '' Then
  BEGIN
      ls_sql := 'select ( DATEADD(Hour, -1, CheckInDT) ) AS Before_CheckInDT,'
          + ' ISNULL((SELECT TOP 1 DoorLockCode FROM kf_Room WHERE RoomCode=kf_Guests.RoomCode),'''') as DoorLockCode,'
          + ' * from kf_Guests WHERE GuestState=''I'' AND RoomCode=''' + TRIM(gs_RoomCode) + '''' ;
      DM.DM_Data.run_query(ADOQ_FormTemp,ls_sql,True);
      //ShowMessage( 'ls_sql=' + ls_sql ); /////////////////////////////////////////
      If ADOQ_FormTemp.RecordCount > 0 Then
      BEGIN
        ADOQ_FormTemp.First ;
        //
        ls_RoomCode := Trim( ADOQ_FormTemp.fieldByName('RoomCode').AsString ) ;
        ls_DoorLockCode := Trim( ADOQ_FormTemp.fieldByName('DoorLockCode').AsString ) ;

        //ڴڷڣΪʾֵ,Ϊڶ
        IF  ADOQ_FormTemp.fieldByName('DepartDT').AsDateTime > GetServerDateTime(dm.DM_Data.DB_ADOConnection) THEN
        BEGIN
            DTP_End_Date.DateTime := ADOQ_FormTemp.fieldByName('DepartDT').AsDateTime;
            DTP_End_Time.DateTime := ADOQ_FormTemp.fieldByName('DepartDT').AsDateTime;
        END;
      END;
  END;

  //ṩ ʺ  
  If gl_GuestID <> 0 Then
  BEGIN
      ls_sql := 'select ( DATEADD(Hour, -1, CheckInDT) ) AS Before_CheckInDT,'
          + ' ISNULL((SELECT TOP 1 DoorLockCode FROM kf_Room WHERE RoomCode=kf_Guests.RoomCode),'''') as DoorLockCode,'
          + ' * from kf_Guests WHERE GuestState=''I'' AND GuestID=' + IntToStr(gl_GuestID);
      DM.DM_Data.run_query(ADOQ_FormTemp,ls_sql,True);
      //ShowMessage( 'ls_sql=' + ls_sql ); /////////////////////////////////////////
      If ADOQ_FormTemp.RecordCount > 0 Then
      BEGIN
        ADOQ_FormTemp.First ;
        //
        ls_RoomCode := Trim( ADOQ_FormTemp.fieldByName('RoomCode').AsString ) ;
        ls_DoorLockCode := Trim( ADOQ_FormTemp.fieldByName('DoorLockCode').AsString ) ;

        //  / ʱ
        //ڴڷڣΪʾֵΪڶ
        IF  ADOQ_FormTemp.fieldByName('DepartDT').AsDateTime > GetServerDateTime(dm.DM_Data.DB_ADOConnection) THEN
        BEGIN
            DTP_End_Date.DateTime := ADOQ_FormTemp.fieldByName('DepartDT').AsDateTime;
            DTP_End_Time.DateTime := ADOQ_FormTemp.fieldByName('DepartDT').AsDateTime;
        END;
      END;
  END;
//--------------------------------------------------

  //ʾ
  //Ĭȡȫַ
  Edit_RoomCode.text := Trim( gs_RoomCode );






//*********************************************************************************
    // (1) ̬ͼ  ֻĳ
    ls_sql := 'SELECT RoomCode,DoorLockCode,'
        + '''' + FormatDatetime('YYYY-MM-DD hh:mm:ss',DTP_End_Date.DateTime) + ''' AS DepartDT, '
        + '0 AS GuestID,0 AS AssignRoomID '
        + ' FROM kf_Room WHERE RoomCode in (''' + gs_RoomCode_Lists + ''')';
    DM.DM_Data.run_query(ADOQ_RoomLists,ls_sql,True);
    //
    If ADOQ_RoomLists.RecordCount > 0 THEN
    BEGIN
          //
          ADOQ_RoomLists.First ;
          //
          Edit_RoomCode.Text := Trim(ADOQ_RoomLists.FieldByName('RoomCode').AsString);
          Edit_DoorLockCode.Text := Trim(ADOQ_RoomLists.FieldByName('DoorLockCode').AsString);
    END;

   // (2) Ԥ   ԤID0, ŷȡ
   If gs_BookSendCard = 'Y'  Then //Ԥ
   BEGIN
      ls_sql := 'SELECT kf_Book_AssignRoom.RoomCode,kf_Room.DoorLockCode,'
            + ' kf_Book_AssignRoom.CheckOutTime AS DepartDT, '
            + ' 0 AS GuestID,kf_Book_AssignRoom.AssignRoomID '
        + ' FROM kf_Book_AssignRoom '
        + ' LEFT JOIN kf_Room ON kf_Book_AssignRoom.RoomCode=kf_Room.RoomCode '
        + ' WHERE kf_Book_AssignRoom.BookID in (SELECT BookID FROM kf_Book_AssignRoom where AssignRoomID='
                + IntToStr(gi_BookSendCard_AssignRoomID) + ')'
                + ' AND kf_Book_AssignRoom.RoomCode in (''' + gs_RoomCode_Lists + ''')'
        + ' ORDER BY kf_Book_AssignRoom.RoomCode';
      DM.DM_Data.run_query(ADOQ_RoomLists,ls_sql,True);
      //
      If ADOQ_RoomLists.RecordCount > 0 THEN
      BEGIN
          //
          ADOQ_RoomLists.First ;
          //
          Edit_RoomCode.Text := Trim(ADOQ_RoomLists.FieldByName('RoomCode').AsString);
          Edit_DoorLockCode.Text := Trim(ADOQ_RoomLists.FieldByName('DoorLockCode').AsString);
          DTP_End_Date.DateTime := ADOQ_RoomLists.FieldByName('DepartDT').AsDateTime ;
          DTP_End_Time.DateTime := ADOQ_RoomLists.FieldByName('DepartDT').AsDateTime ;
      END;
   END;

   // (3)  ס   
   If (gs_BookSendCard <> 'Y') AND (gl_GuestID <> 0)  Then
   BEGIN
      ls_sql := 'SELECT kf_Guests.RoomCode,kf_Room.DoorLockCode,kf_Guests.DepartDT, '
            + ' kf_Guests.GuestID,0 AS AssignRoomID '
        + ' FROM kf_Guests '
        + ' LEFT JOIN kf_Room ON kf_Guests.RoomCode=kf_Room.RoomCode '
        + ' WHERE kf_Guests.GuestState=''I'' AND kf_Guests.RoomCode <> '''' AND '
          + ' kf_Guests.GroupNo in (SELECT GroupNo FROM kf_Guests where GuestID=' + IntToStr(gl_GuestID) + ')'
          + ' AND kf_Guests.RoomCode in (''' + gs_RoomCode_Lists + ''')'
        + ' ORDER BY kf_Guests.RoomCode';
      DM.DM_Data.run_query(ADOQ_RoomLists,ls_sql,True);
      //
      If ADOQ_RoomLists.RecordCount > 0 THEN
      BEGIN
          //
          ADOQ_RoomLists.First ;
          //
          Edit_RoomCode.Text := Trim(ADOQ_RoomLists.FieldByName('RoomCode').AsString);
          Edit_DoorLockCode.Text := Trim(ADOQ_RoomLists.FieldByName('DoorLockCode').AsString);
          DTP_End_Date.DateTime := ADOQ_RoomLists.FieldByName('DepartDT').AsDateTime ;
          DTP_End_Time.DateTime := ADOQ_RoomLists.FieldByName('DepartDT').AsDateTime ;
      END;
   END;

  //Ĭֵ
  ADOQ_RoomLists.First;
  If ADOQ_RoomLists.RecordCount > 0 THEN
  BEGIN
      Edit_RoomCode.Text := Trim(ADOQ_RoomLists.FieldByName('RoomCode').AsString);
      Edit_DoorLockCode.Text := Trim(ADOQ_RoomLists.FieldByName('DoorLockCode').AsString);
      DTP_End_Date.DateTime := ADOQ_RoomLists.FieldByName('DepartDT').AsDateTime ;
      DTP_End_Time.DateTime := ADOQ_RoomLists.FieldByName('DepartDT').AsDateTime ;

      //ʺ,,ŷID
      gl_GuestID := ADOQ_RoomLists.FieldByName('GuestID').AsInteger;//ID
      gs_RoomCode := Trim(ADOQ_RoomLists.FieldByName('RoomCode').AsString);//
      gi_BookSendCard_AssignRoomID := ADOQ_RoomLists.FieldByName('AssignRoomID').AsInteger ;
  END;

//*********************************************************************************

  //---------------------     ʾ¥¥     --------------------------------
  ls_sql := 'select * from v_kf_Room where RoomCode=''' + Trim(Edit_RoomCode.Text) + '''';
  dm.DM_Data.run_query(ADOQ_FormTemp,ls_sql,True);
  If ADOQ_FormTemp.RecordCount > 0 Then
  BEGIN
      {
      Edit_DoorLockCode.Text := Trim(ADOQ_FormTemp.FieldByName('DoorLockCode').AsString); //
      //
      Edit2.Text := Trim(ADOQ_FormTemp.FieldByName('BuildingCode').AsString); //¥()
      //
      Edit3.Text := Trim(ADOQ_FormTemp.FieldByName('FloorCode').AsString); //¥
      //
      Edit_DoorLockCode.Text := Trim(ADOQ_FormTemp.FieldByName('DoorLockCode').AsString); //
      Edit4.Text := Trim(ADOQ_FormTemp.FieldByName('DoorLockCode').AsString); //
      }
  END;
  //---------------------     ʾ¥¥     --------------------------------

  //ʼʱ
  DTP_Begin_Date.Time := DTP_Begin_Time.Time ;
  DTP_Begin_Time.Date := DTP_Begin_Date.Date ;
  //ʱ
  DTP_End_Date.Time := DTP_End_Time.Time ;
  DTP_End_Time.Date := DTP_End_Date.Date ;

  //ʼʱ
  //edit7.Text:=formatdatetime('YYMMDDHHNNSS',DTP_Begin_Date.DateTime);
  //ʧЧʱ
  //EDIT8.Text:=formatdatetime('YYMMDDHHNNSS',DTP_End_Date.DateTime);















  //򿪴
  Button_OpenPort.Click ;

end;

procedure TIDD102.SpeedButton2Click(Sender: TObject);
var
  ls_sql:String;
begin
    SysFrame.gs_Temp_ForInput_PassWord := '';//֤õʱȫֱΪֻһ¼봰
    Application.CreateForm(TFrm_pub_Temp_InputPassword, Frm_pub_Temp_InputPassword);
    Frm_pub_Temp_InputPassword.ShowModal ;
    IF SysFrame.gs_Temp_ForInput_PassWord <> 'admin8888' Then
    BEGIN
        //
        ShowMessage('벻ԡ');
        Exit;
    END;
  //
  if Application.MessageBox('ȷҪ  ˿ƺ;ƵID   ','ʾ',mb_yesno)=id_no Then
  Begin
      Exit;
  End;
  //
//  ls_sql := 'update kf_DoorLock_ParaValue set '
//      + 'LiYong_COMM_Index =' + IntToStr(ComboBox1.ItemIndex)  + ','
//      + 'LiYong_CardType_Index =' + IntToStr(ComboBox2.ItemIndex);
//  dm.DM_Data.run_query(nil,ls_sql,False);

  //ShowMessage('ls_sql=' + ls_sql);
  //
//  ShowMessage('ɹ');

end;

procedure TIDD102.DBGrid1CellClick(Column: TColumn);
begin
  //
  If ADOQ_RoomLists.RecordCount > 0 THEN
  BEGIN
      Edit_RoomCode.Text := Trim(ADOQ_RoomLists.FieldByName('RoomCode').AsString);
      Edit_DoorLockCode.Text := Trim(ADOQ_RoomLists.FieldByName('DoorLockCode').AsString);
      DTP_End_Date.DateTime := ADOQ_RoomLists.FieldByName('DepartDT').AsDateTime ;
      DTP_End_Time.DateTime := ADOQ_RoomLists.FieldByName('DepartDT').AsDateTime ;

      //ʺ,,ŷID
      gl_GuestID := ADOQ_RoomLists.FieldByName('GuestID').AsInteger;//ID
      gs_RoomCode := Trim(ADOQ_RoomLists.FieldByName('RoomCode').AsString);//
      gi_BookSendCard_AssignRoomID := ADOQ_RoomLists.FieldByName('AssignRoomID').AsInteger ;
  END;

  Try
      //ʼʱ
      DTP_Begin_Date.Time := DTP_Begin_Time.Time ;
      //ʱ
      DTP_End_Date.Time := DTP_End_Time.Time ;
  Except
      ShowMessage('ֹʱ䷢⣮');
  END;

end;

procedure TIDD102.DBGrid1KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin

  //
  If ADOQ_RoomLists.RecordCount <= 0 THEN
  BEGIN
      Exit;
  END;

  //38ϼͷ,40¼ͷ
  If (Key = 38) OR (Key = 40) THEN
  BEGIN
      Edit_RoomCode.Text := Trim(ADOQ_RoomLists.FieldByName('RoomCode').AsString);
      Edit_DoorLockCode.Text := Trim(ADOQ_RoomLists.FieldByName('DoorLockCode').AsString);
      DTP_End_Date.DateTime := ADOQ_RoomLists.FieldByName('DepartDT').AsDateTime ;
      DTP_End_Time.DateTime := ADOQ_RoomLists.FieldByName('DepartDT').AsDateTime ;

      //ʺ,,ŷID
      gl_GuestID := ADOQ_RoomLists.FieldByName('GuestID').AsInteger;//ID
      gs_RoomCode := Trim(ADOQ_RoomLists.FieldByName('RoomCode').AsString);//
      gi_BookSendCard_AssignRoomID := ADOQ_RoomLists.FieldByName('AssignRoomID').AsInteger ;
  END;


  //ʼʱ
  DTP_Begin_Date.Time := DTP_Begin_Time.Time ;
  //ʱ
  DTP_End_Date.Time := DTP_End_Time.Time ;


end;

procedure TIDD102.BB_PreRoomClick(Sender: TObject);
var
  li_min:Integer;//
  ls_Begin,ls_End:String;
begin
  //
  IF  ADOQ_RoomLists.RecordCount <= 0 Then
  Begin
      Exit;
  End;

  Try
      ADOQ_RoomLists.Prior;
  Except
  END;
  //
  If ADOQ_RoomLists.RecordCount > 0 THEN
  BEGIN
      Edit_RoomCode.Text := Trim(ADOQ_RoomLists.FieldByName('RoomCode').AsString);
      Edit_DoorLockCode.Text := Trim(ADOQ_RoomLists.FieldByName('DoorLockCode').AsString);
      DTP_End_Date.DateTime := ADOQ_RoomLists.FieldByName('DepartDT').AsDateTime ;
      DTP_End_Time.DateTime := ADOQ_RoomLists.FieldByName('DepartDT').AsDateTime ;
  END;

  //ʼʱ
  DTP_Begin_Date.Time := DTP_Begin_Time.Time ;
  //ʱ
  DTP_End_Date.Time := DTP_End_Time.Time ;


end;

procedure TIDD102.BB_NextRoomClick(Sender: TObject);
var
  li_max:Integer;//
  ls_Begin,ls_End:String;
begin
  //
  IF  ADOQ_RoomLists.RecordCount <= 0 Then
  Begin
      Exit;
  End;

  //һ¼
  Try
      ADOQ_RoomLists.Next ;
  Except
  End;
  //
  If ADOQ_RoomLists.RecordCount > 0 THEN
  BEGIN
      Edit_RoomCode.Text := Trim(ADOQ_RoomLists.FieldByName('RoomCode').AsString);
      Edit_DoorLockCode.Text := Trim(ADOQ_RoomLists.FieldByName('DoorLockCode').AsString);
      DTP_End_Date.DateTime := ADOQ_RoomLists.FieldByName('DepartDT').AsDateTime ;
      DTP_End_Time.DateTime := ADOQ_RoomLists.FieldByName('DepartDT').AsDateTime ;
  END;

  //ʼʱ
  DTP_Begin_Date.Time := DTP_Begin_Time.Time ;
  //ʱ
  DTP_End_Date.Time := DTP_End_Time.Time ;


end;

end.
