﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.Threading;
 
namespace WindowsApplication1
{
    public partial class Form1 : Form
    {

        public int Port = 1;
        public int Ret;
       // public int[] Rom = new int[8] { 0, 0, 0, 0, 0, 0, 0, 0 };
       public StringBuilder cardstring = new StringBuilder(150);
       // [MarshalAs(UnmanagedType.LPArray)] Byte[] Rom = new Byte[8] { 0, 0, 0, 0, 0, 0, 0, 0 };            //房号

        [DllImport("MFDLL.dll")]
        public static extern int makecard(int CardType, StringBuilder CardData);
        [DllImport("MFDLL.dll")]
        public static extern int decodedata(StringBuilder CardData);
        [DllImport("MFDLL.dll")]
        public static extern int MakeCardOpenPort(int port);
        [DllImport("MFDLL.dll")]
        public static extern int MakeCardClosePort(int port);
        [DllImport("MFDLL.dll")]
        public static extern Boolean InitSoft(string SoftPath);
        [DllImport("MFDLL.dll")]
        public static extern int GetCardNo(StringBuilder CardNo);
        [DllImport("MFDLL.dll")]
        public static extern int CancleCard(StringBuilder CardNo);
        
        public void CheckErr(int ret)
        {
             switch (ret)
            {
                case 1:
                    MessageBox.Show("成功");
                    break;
                case -1:
                    MessageBox.Show("没有检测到有效的卡片");
                    break;
                case -2:
                    MessageBox.Show("没有检测到发卡机");
                    break;
                case -3:
                    MessageBox.Show("这是无效的卡片");
                    break;
                case -4:
                    MessageBox.Show("卡的类型不符");
                    break;
                case -5:
                    MessageBox.Show("卡读写错误");
                    break;
                case -6:
                    MessageBox.Show("串口未打开");
                    break;
                case -7:
                    MessageBox.Show("数据提取完毕");
                    break;
                case -8:
                    MessageBox.Show("系统存取错误");
                    break;
                case -9:
                    MessageBox.Show("不支持该操作命令");
                    break;
                case -10:
                    MessageBox.Show("其他错误");
                    break;

            }              
        }
        
        
        public Form1()
        {
            InitializeComponent();
        }



        private void Form1_Load(object sender, EventArgs e)
        {
            textBox6.Text = DateTime.Now.ToString("yyMMddHHmm")  ;
            textBox7.Text = DateTime.Now.AddDays(1).ToString("yyMMddHHmm");

        }


        private void button1_Click(object sender, EventArgs e)
        {

            string path;

            path = textBox5.Text.Trim() ;
            bool success = InitSoft(path);

            if (success)
            {
                button7.Enabled = true;
                MessageBox.Show("成功");
            }
            else
            {
                MessageBox.Show("失败");
            }

        }



        private void button8_Click(object sender, EventArgs e)
        {
            string data;

            data = "B" + textBox8.Text + "|F" + textBox2.Text + "|R" + textBox1.Text;
            data = data + "|S" + textBox3.Text + "|A0" + "|Y0" + "|C" + textBox4.Text;
            data = data + "|I" + textBox6.Text + "|O" + textBox7.Text;

            cardstring.Append(data) ;
            Ret=makecard(0, cardstring);
            CheckErr(Ret);
            button2.Enabled = true;
        }


        private void radioButton10_CheckedChanged(object sender, EventArgs e)
        {
            Port = 1;
        }

        private void radioButton9_CheckedChanged(object sender, EventArgs e)
        {
            Port = 2;
        }

        private void radioButton8_CheckedChanged(object sender, EventArgs e)
        {
            Port = 3;
        }

        private void radioButton7_CheckedChanged(object sender, EventArgs e)
        {
            Port = 4;
        }

        private void radioButton6_CheckedChanged(object sender, EventArgs e)
        {
            Port = 5;
        }


        private void button7_Click(object sender, EventArgs e)
        {
            Ret = MakeCardOpenPort(Port);
            CheckErr(Ret);

            button9.Enabled = true;
        }

        private void button9_Click(object sender, EventArgs e)
        {
            StringBuilder cardno = new StringBuilder(16);
            Ret = GetCardNo(cardno);
            textBox4.Text = cardno.ToString();
            button8.Enabled = true;
            CheckErr(Ret);
        }

        private void button2_Click(object sender, EventArgs e)
        {
            StringBuilder cardno = new StringBuilder(16);
            cardno.Append( textBox4.Text );
            Ret = CancleCard(cardno);
        }

        private void button3_Click(object sender, EventArgs e)
        {
            StringBuilder cardno = new StringBuilder(100);
            Ret = decodedata(cardno);
            textBox9.Text = cardno.ToString();
            CheckErr(Ret);
        }

        private void statusStrip1_ItemClicked(object sender, ToolStripItemClickedEventArgs e)
        {

        }








    }
}