--ɲܵȡ洢
CREATE PROCEDURE dbo.p_cy_BillPrintGetData_SumBill_1 
  @BillID INT
AS

SELECT * FROM
(
  SELECT BillTableID,ItemCode,ItemName,Unit,D_UnitPrice,D_C,D_C_Name,IsPresent,
    IsPresentLabel=Case When IsPresent=1 Then '()' Else '' End,
    MinInputDT=Min(InputDT),MaxRemark=Case When Remark<>'' Then '('+remark+')' Else '' END,
    Sum(ISNULL(Amount,0)) as Amount,Sum(ISNULL(D_ConsumeMoney,0)) as D_ConsumeMoney,
    Sum(ISNULL(D_ShouldPayMoney,0)) as D_ShouldPayMoney,
    Sum(ISNULL(C_PayMoney,0)) as C_PayMoney
  FROM
  (
     SELECT  
        BillTableID,ItemCode,ItemName,Unit,Amount,D_ConsumeMoney,D_UnitPrice,IsPresent,InputDT,
        D_C,D_C_Name,D_ShouldPayMoney,C_PayMoney,Remark,
        (CASE D_C WHEN 'D' THEN Amount ELSE 0 END) AS D_Amount
     FROM v_cy_BillConsume_AND_BillPayment 
     WHERE BillID=@BillID  AND ItemCode<>'SSWR'
          AND ( (ItemCode<>'ZDXF') OR (ItemCode='ZDXF' AND D_ShouldPayMoney<>0) )
  ) AS Detail
  GROUP BY BillTableID,ItemCode,ItemName,Unit,D_UnitPrice,D_C,D_C_Name,IsPresent,Remark
) AS BBBB
LEFT JOIN v_cy_BillAndTables ON BBBB.BillTableID=v_cy_BillAndTables.BillTableID
ORDER BY BBBB.D_C DESC,BBBB.MinInputDT
GO
