
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/reimu.zip" ),
	Asset( "IMAGE", "images/reimutab.tex"),
        Asset( "ATLAS", "images/reimutab.xml"),
	Asset("IMAGE", "images/inventoryimages/lf.tex"),
	Asset("ATLAS", "images/inventoryimages/lf.xml"),
	Asset("IMAGE", "images/inventoryimages/yyy.tex"),
	Asset("ATLAS", "images/inventoryimages/yyy.xml"),
	Asset("IMAGE", "images/inventoryimages/qmb.tex"),
	Asset("ATLAS", "images/inventoryimages/qmb.xml"),
}

local prefabs = 
{
    "lf",
    "qmb",
    "yyy",
}

local start_inv = { "qmb","lf","lf","lf","lf","lf","lf","lf","lf","lf","lf","yyy",}

local fn = function(inst)
	
	-- choose which sounds this character will play
	inst.soundsname = "wickerbottom"

	-- a minimap icon must be specified
	inst.entity:AddMiniMapEntity()
	inst.MiniMapEntity:SetIcon( "reimu1.tex" )

	-- todo: Add an example special power here.

	inst.components.health.maxhealth = 100
	inst.components.sanity.max = 120

	inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.3)
    	inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.3)
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 1.25)

	inst.components.sanity.neg_aura_mult = 0


	STRINGS.TABS.REIMUTABS = ""
	local reimutab = {str = STRINGS.TABS.REIMUTABS, sort = 999, icon = "reimutab.tex", icon_atlas = "images/reimutab.xml"}
	inst.components.builder:AddRecipeTab(reimutab)

	local lf = Recipe("lf", {Ingredient("papyrus", 1), Ingredient("nitre", 1)}, reimutab, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0}, nil, nil, nil, 3)
	lf.atlas = "images/inventoryimages/lf.xml"
	local qmb = Recipe("qmb", {Ingredient("twigs", 2), Ingredient("rope", 1), Ingredient("papyrus", 1)}, reimutab, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0})
	qmb.atlas = "images/inventoryimages/qmb.xml"
	local yyy = Recipe("yyy", {Ingredient("redgem", 1), Ingredient("nightmarefuel", 2), Ingredient("flint", 4)}, reimutab, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0})
	yyy.atlas = "images/inventoryimages/yyy.xml"
end



-- strings! Any "REIMU" below would have to be replaced by the prefab name of your character.

-- First up, the character select screen lines 
-- note: these are lower-case character name
STRINGS.CHARACTER_TITLES.reimu = "԰Ů"
STRINGS.CHARACTER_NAMES.reimu = ""
STRINGS.CHARACTER_DESCRIPTIONS.reimu = "*ֽý\n*Ůеĵ\n*޾"
STRINGS.CHARACTER_QUOTES.reimu = "\"ʲôط\""

-- You can also add any kind of custom dialogue that you would like. Don't forget to make
-- categores that don't exist yet using = {}
-- note: these are UPPER-CASE charcacter name
STRINGS.CHARACTERS.REIMU = {}

STRINGS.CHARACTERS.REIMU.ANNOUNCE_BOOMERANG  = "ĵС."
STRINGS.CHARACTERS.REIMU.ANNOUNCE_CHARLIE  = "ҿ?"
STRINGS.CHARACTERS.REIMU.ANNOUNCE_CHARLIE_ATTACK = ""

STRINGS.CHARACTERS.REIMU.ANNOUNCE_COLD  = "ŮҲǻ."
STRINGS.CHARACTERS.REIMU.ANNOUNCE_CRAFTING_FAIL  = "ûʮܸ?"
STRINGS.CHARACTERS.REIMU.ANNOUNCE_DUSK = "ؼ."
STRINGS.CHARACTERS.REIMU.ANNOUNCE_HUNGRY  = "ҪԵ㶫."
STRINGS.CHARACTERS.REIMU.ANNOUNCE_HUNT_BEAST_NEARBY = ". "
STRINGS.CHARACTERS.REIMU.ANNOUNCE_HUNT_LOST_TRAIL  = "ȥĶ?"
STRINGS.CHARACTERS.REIMU.ANNOUNCE_INV_FULL  = "װ. "
STRINGS.CHARACTERS.REIMU.ANNOUNCE_KNOCKEDOUT  = "... "
STRINGS.CHARACTERS.REIMU.ANNOUNCE_NODANGERSLEEP  = "ȴ˵."
STRINGS.CHARACTERS.REIMU.ANNOUNCE_NOHUNGERSLEEP  = "ȳԵ㶫ô."
STRINGS.CHARACTERS.REIMU.ANNOUNCE_NODAYSLEEP  = "λ˰."
STRINGS.CHARACTERS.REIMU.ANNOUNCE_NO_TRAP  = "Ǻ. "
STRINGS.CHARACTERS.REIMU.ANNOUNCE_PECKED  = "Ҫ. "
STRINGS.CHARACTERS.REIMU.ANNOUNCE_QUAKE = " S,. "
STRINGS.CHARACTERS.REIMU.ANNOUNCE_RESEARCH  = "ѧ㶫. "
STRINGS.CHARACTERS.REIMU.ANNOUNCE_TORCH_OUT  = "?"
STRINGS.CHARACTERS.REIMU.ANNOUNCE_WORMHOLE  = "Һ."

STRINGS.CHARACTERS.REIMU.ANNOUNCE_EAT = {}
STRINGS.CHARACTERS.REIMU.ANNOUNCE_EAT.GENERIC  = "ѳ."
STRINGS.CHARACTERS.REIMU.ANNOUNCE_EAT.PAINFULL = "Եĺô?"
STRINGS.CHARACTERS.REIMU.ANNOUNCE_EAT.SPOILED = "."
STRINGS.CHARACTERS.REIMU.ANNOUNCE_EAT.STALE  = "Ѿʼ."

STRINGS.CHARACTERS.REIMU.BATTLECRY = {}
STRINGS.CHARACTERS.REIMU.BATTLECRY.GENERIC  = "ɢ!"
STRINGS.CHARACTERS.REIMU.BATTLECRY.PIG = "Ұ."
STRINGS.CHARACTERS.REIMU.BATTLECRY.PREY  = "ΪСҾͲ۸. "
STRINGS.CHARACTERS.REIMU.BATTLECRY.SPIDER  = "֩ɢ!"
STRINGS.CHARACTERS.REIMU.BATTLECRY.SPIDER_WARRIOR  = "ǱȽ鷳һ."
STRINGS.CHARACTERS.REIMU.BATTLECRY.HOUND  = "."
STRINGS.CHARACTERS.REIMU.BATTLECRY.LEIF  = "ô?"

-- Description
STRINGS.CHARACTERS.REIMU.DESCRIBE = {}
STRINGS.CHARACTERS.REIMU.DESCRIBE.ROBIN = "̫ഺҲð."
STRINGS.CHARACTERS.REIMU.DESCRIBE.SLURPER  = "Ҫɢ?"
STRINGS.CHARACTERS.REIMU.DESCRIBE.ORANGEAMULET  = "ҲħɳȽϸȤ."
STRINGS.CHARACTERS.REIMU.DESCRIBE.YELLOWSTAFF  = "ҲħɳȽϸȤ."
STRINGS.CHARACTERS.REIMU.DESCRIBE.YELLOWGEM  = "Ʊʯ,ʮ? "
STRINGS.CHARACTERS.REIMU.DESCRIBE.ORANGEGEM  = "ȱʯ,ʮ?"
STRINGS.CHARACTERS.REIMU.DESCRIBE.STAFFLIGHT  = "û."
STRINGS.CHARACTERS.REIMU.DESCRIBE.ANCIENT_ALTAR  = "𲻺."
STRINGS.CHARACTERS.REIMU.DESCRIBE.CAVE_BANANA  = "һ㽶."
STRINGS.CHARACTERS.REIMU.DESCRIBE.ROCKY  = "ɶ?"
STRINGS.CHARACTERS.REIMU.DESCRIBE.EVERGREEN = "ϣûз˵."


return MakePlayerCharacter("reimu", prefabs, assets, fn, start_inv)
