--◆◆--◆◆--◆◆--◆◆--◆◆--◆◆--◆◆--◆◆--◆◆--◆◆
--◆◆[[Author: JinYering]]
--◆◆[[E-Mail: jin_yering@naver.com]]
--◆◆[[WhaRang The Millennium Fox]]
--◆◆--◆◆--◆◆--◆◆--◆◆--◆◆--◆◆--◆◆--◆◆--◆◆

local Assets =
{
	 Asset("ANIM",			"anim/fox_fish_redgoldfish.zip"),
	 Asset("ANIM",			"anim/fox_fish_redgoldfish01.zip"),
	 Asset("ATLAS",			"images/inventoryimages/redgoldfish.xml"),
	 Asset("ATLAS",			"images/inventoryimages/redgoldfish_cooked.xml"),
}

local prefabs =
{
	 "redgoldfish_cooked",
	 "spoiled_food",
}

local function stopkicking(inst)
	 inst.AnimState:PlayAnimation("dead")
end

local function makeredgoldfish(build)

    local function commonfn()
		local inst = CreateEntity()
		 inst.entity:AddTransform()
		-------------------◆[Tag]
		 inst:AddTag("meat")
		 inst:AddTag("goldfish")
		-------------------◆[AnimState]
		 inst.entity:AddAnimState()
		 inst.AnimState:SetBank("redgoldfish")
		 inst.AnimState:SetBuild("redgoldfish")
		 inst.build = build
		-------------------◆[Edible]
		 inst:AddComponent("bait")
		 inst:AddComponent("edible")
		 inst.components.edible.ismeat = true
		 inst.components.edible.foodtype = "MEAT"
		-------------------◆[Stackable]
		 inst:AddComponent("stackable")
		 inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
		-------------------◆[Perishable]
		 inst:AddComponent("perishable")
		 inst.components.perishable:StartPerishing()
		 inst.components.perishable.onperishreplacement = "spoiled_food"
		-------------------◆[Inspectable]
		 inst:AddComponent("inspectable")
		-------------------◆[Inventory Item]
		 inst:AddComponent("inventoryitem")
		 MakeInventoryPhysics(inst)
		-------------------◆[Tradable]
		 inst:AddComponent("tradable")
		 inst.components.tradable.goldvalue = TUNING.GOLD_VALUES.MEAT
		 inst.data = {}
		-------------------◆
        return inst
    end

    local function rawfn()
	    local inst = commonfn(build)
        inst.AnimState:PlayAnimation("idle", true)
		inst.Transform:SetScale(.7,.7,.7)

		inst.components.edible.healthvalue = 3
		inst.components.edible.hungervalue = 8
		inst.components.perishable:SetPerishTime(TUNING.PERISH_SUPERFAST)
		
		inst.components.inventoryitem.atlasname = "images/inventoryimages/redgoldfish.xml"
        
        inst:AddComponent("cookable")
        inst.components.cookable.product = "redgoldfish_cooked"
        inst:AddComponent("dryable")
        inst.components.dryable:SetProduct("smallmeat_dried")
        inst.components.dryable:SetDryTime(TUNING.DRY_FAST)
        inst:DoTaskInTime(10, stopkicking)
        inst.components.inventoryitem:SetOnPickupFn(function(pickupguy) stopkicking(inst) end)
        inst.OnLoad = function() stopkicking(inst) end
        
        return inst
    end

    local function cookedfn()
	    local inst = commonfn(build)
        inst.AnimState:PlayAnimation("cooked")
		inst.Transform:SetScale(1,1,1)
        
		inst.components.edible.healthvalue = 4
		inst.components.edible.hungervalue = 8
		inst.components.perishable:SetPerishTime(TUNING.PERISH_FAST)
		
		inst.components.inventoryitem.atlasname = "images/inventoryimages/redgoldfish_cooked.xml"

        return inst
    end
    return rawfn, cookedfn
end

local function redgoldfish(name, build)
    local raw, cooked = makeredgoldfish(build)
    return Prefab( "common/inventory/"..name, raw, Assets, prefabs),
        Prefab( "common/inventory/"..name.."_cooked", cooked, Assets)
end

return
		redgoldfish("redgoldfish", "redgoldfish01")