local assets = 
{
	Asset("ANIM", "anim/foxfire.zip"),
}


local function kill_foxfire(inst)
    inst.AnimState:PlayAnimation("level1")
	inst.Transform:SetScale(.4,.4,.4)
    inst:DoTaskInTime(0.6, function() inst.SoundEmitter:PlaySound("dontstarve/common/FireOut") inst:Remove() end)    
end

local function resumestar(inst, time)
    if inst.death then
        inst.death:Cancel()
        inst.death = nil
    end
    inst.death = inst:DoTaskInTime(time, kill_foxfire)
    inst.timeleft = time
end

local function onsave(inst, data)
    data.timealive = inst:GetTimeAlive()
    data.init_time = inst.init_time
end

local function onload(inst, data)
        if data.timealive and data.init_time then
            inst.init_time = data.init_time
            local timeleft = (inst.init_time or 15) - data.timealive
            if timeleft > 0 then
            resumestar(inst, timeleft)
        else
            kill_foxfire(inst)
        end
    end
end

local function fox_light(inst)
	inst.entity:AddLight()
	inst.Light:SetRadius(1)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.4)
    inst.Light:SetColour(0/255, 0/255, 255/255)
	inst.Light:Enable(true)
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
	
    inst.entity:AddDynamicShadow()
    inst.DynamicShadow:SetSize( .5, .25 )
	inst.Transform:SetScale(.5,.5,.5)

    anim:SetBank("foxfire")
    anim:SetBuild("foxfire")
    anim:PlayAnimation("level1", true)

    MakeInventoryPhysics(inst)
--[[
    inst:AddComponent("propagator")
    inst.components.propagator.heatoutput = 15
    inst.components.propagator.spreading = false
    inst.components.propagator:StartUpdating()
]]
    inst:AddComponent("heater")
    inst.components.heater.heat = 20

    local light = inst.entity:AddLight()
    light:SetColour(20/255, 20/255, 200/255)
    light:Enable(false)

    inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
	inst.SoundEmitter:PlaySound("dontstarve/common/campfire", "loop")

    inst.init_time = 15
    inst.task = inst:DoPeriodicTask(0.1, fox_light)
    inst.death = inst:DoTaskInTime(inst.init_time, kill_foxfire)

    inst.OnLoad = onload
    inst.OnSave = onsave

    return inst
end
	
return Prefab( "common/foxfire", fn, assets)