local DFV_SHOWDUR = not(GetModConfigData("DFV_PercentReplace")=="default")
local DFV_FUELEDSET = GetModConfigData("DFV_FueledSettings")
local show_damage = (GetModConfigData("DFV_ShowDamage")=="default")
local show_uses = (GetModConfigData("DFV_ShowUses")=="default")
local show_temp = (GetModConfigData("DFV_ShowTemperature")=="default")
local show_insul = (GetModConfigData("DFV_ShowInsulation")=="default")
local show_acond = (GetModConfigData("DFV_ShowACondition")=="default")
local show_adef = (GetModConfigData("DFV_ShowADefence")=="default")
local show_atype = (GetModConfigData("DFV_ShowAType")=="default")
local require = GLOBAL.require

local Text = require "widgets/text" 
local ItemTile = require "widgets/itemtile"
 
local ItemTile_GetDescriptionString_base = ItemTile.GetDescriptionString or function() return "" end

-- Icon update on temp change
--if DFV_SHOWDUR then
	local function ItemTileConstruct(self, invitem)
	if DFV_SHOWDUR then
		self.inst:ListenForEvent("temperaturedelta",
				function(invitem, data)
					self:SetPercent(0) -- trash value
				end, invitem)
	end
		self.true_percent = 1
		self.tooltip_mod_loaded = 1
	function TimeString(percent, max_time)
		local str = ""
		if DFV_FUELEDSET == "both" or DFV_FUELEDSET == "default" then
			local minutes_left = math.floor((max_time * percent) / 60)
			local seconds_left = math.floor(max_time * percent - minutes_left * 60)
			local zero = ""
			if seconds_left < 10 then
				zero = "0"
			end
			str = "\n" .. minutes_left .. ":" .. zero .. seconds_left
		end
		if DFV_FUELEDSET == "both" or DFV_FUELEDSET == "seg" then
					local total_segments = math.floor(((max_time * percent) / (TUNING.TOTAL_DAY_TIME / 16))*10)/10
					if total_segments > 16 then
						local days = math.floor(total_segments/16)
						local segments = math.floor((total_segments - days*16)*10)/10
						str = str .. "\n" .. days .. " Days ".. segments .. " Segments"
					else
						str = str .. "\n" .. total_segments .. " Segments"
					end
				end
		return str
	end
	
	function SmallTimeString(percent, max_time)
		local str = ""
		if DFV_FUELEDSET == "both" or DFV_FUELEDSET == "default" then
			local minutes_left = math.floor((max_time * percent) / 60)
			local seconds_left = math.floor(max_time * percent - minutes_left * 60)
			local zero = ""
			if seconds_left < 10 then
				zero = "0"
			end
			str = minutes_left .. ":" .. zero .. seconds_left
		end
		return str
	end
	
	function ArmorString(percent,max_cond, def)
		local str = ""
			if show_acond then
					str = str .. "\n" .. "Condition " .. math.floor(percent*max_cond*10)/10
			end
			if show_adef then
				str = str .. "\n" .. "Damage reduction " .. def * 100 .. "%"
			end
		return str
	end
	end
	AddClassPostConstruct("widgets/itemtile", ItemTileConstruct)

function ItemTile:GetDescriptionString()

    local str = ItemTile_GetDescriptionString_base(self)
    if self.item ~= nil and self.item:IsValid() then 

			if self.item.components.weapon ~= nil and show_damage then
				str = str .. "\n" .. "Damage " .. self.item.components.weapon.damage
			end
			if self.item.components.finiteuses ~= nil and show_uses then
				str = str .. "\n" .. "Uses left " .. self.item.components.finiteuses:GetUses()
			end 
			if self.item.components.temperature ~= nil and show_temp then
				str = str .. "\n" .. math.floor(self.item.components.temperature.current*10)/10 .. "\176C"
			end
			if self.item.components.fueled ~= nil then
				if self.item.name == "Thermal Stone" then
					str = str .. "\n" .. self.item.components.fueled:GetPercent() * TUNING.HEATROCK_NUMUSES .. " durability"
				--else
				--	str = str .. "\n" .. self.item.components.fueled.currentfuel .. " fuel"
				--end
				else
				if DFV_FUELEDSET == "both" or DFV_FUELEDSET == "default" then
					local minutes_left = math.floor((self.item.components.fueled.currentfuel / self.item.components.fueled.rate) / 60)
					local seconds_left = math.floor(self.item.components.fueled.currentfuel - minutes_left * 60)
					local zero = ""
					if seconds_left < 10 then
						zero = "0"
					end
					str = str .. "\n" .. minutes_left .. ":" .. zero .. seconds_left
				end
				if DFV_FUELEDSET == "both" or DFV_FUELEDSET == "seg" then
					local total_segments = math.floor(((self.item.components.fueled.currentfuel / self.item.components.fueled.rate) / (TUNING.TOTAL_DAY_TIME / 16))*10)/10
					if total_segments > 16 then
						local days = math.floor(total_segments/16)
						local segments = math.floor((total_segments - days*16)*10)/10
						str = str .. "\n" .. days .. " Days ".. segments .. " Segments"
					else
						str = str .. "\n" .. total_segments .. " Segments"
					end
				end
				end
			end
			if self.item.components.armor ~= nil then
				if self.item.components.armor.condition ~= nil and show_acond then
					str = str .. "\n" .. "Condition " .. math.floor(self.item.components.armor.condition)
				end
				if self.item.components.armor.tags ~= nil and show_atype then
					for k,v in pairs(self.item.components.armor.tags) do
						str = str .. "\n" .. "Shields " .. v .. " damage"
					end
				end
				if self.item.components.armor.absorb_percent ~= nil and show_adef then
					str = str .. "\n" .. "Damage reduction " .. self.item.components.armor.absorb_percent * 100 .. "%"
				end
			end
			if self.item.components.insulator ~= nil and show_insul then
				str = str .. "\n" .. math.floor(self.item.components.insulator.insulation) .. " insulation"
			end
		end
    return str
	end


function ItemTile:SetPercent(percent)
	self.true_percent = percent
	if not self.percent then
        self.percent = self:AddChild(Text(GLOBAL.NUMBERFONT, 42))
        self.percent:SetPosition(5,-32+15,0)
    end
		if self.item.components.finiteuses ~= nil and DFV_SHOWDUR then
			self.percent:SetString( self.item.components.finiteuses:GetUses())
		elseif self.item.components.armor ~= nil and DFV_SHOWDUR then
			if self.item.components.armor.condition ~= nil then
				self.percent:SetString( math.floor(self.item.components.armor.condition))
			end
		elseif self.item.components.temperature ~= nil and DFV_SHOWDUR then
				self.percent:SetString(math.floor(self.item.components.temperature.current + .5) .. "\176C")
		elseif self.item.components.fueled ~= nil and DFV_FUELEDSET ~= "seg" and DFV_SHOWDUR then
			local minutes_left = math.floor((self.item.components.fueled.currentfuel / self.item.components.fueled.rate) / 60)
			local seconds_left = math.floor(self.item.components.fueled.currentfuel - minutes_left * 60)
			local zero = ""
			if seconds_left < 10 then
				zero = "0"
			end
			self.percent:SetString(  minutes_left .. ":" .. zero .. seconds_left)
		else
			local val_to_show = percent*100
			if val_to_show > 0 and val_to_show < 1 then
				val_to_show = 1
			end
			self.percent:SetString(string.format("%2.0f%%", val_to_show))
		end
end

	
	