modimport ("scripts/tuning_musha.lua")
modimport ("scripts/musha_play.lua")

local LEVELS = GetModConfigData("mushalevel")
local SKILLS = GetModConfigData("mushaskill")
local VALKYRIE = GetModConfigData("valkyriec")
local LIGHTNING = GetModConfigData("powerattack")
local SHIELD = GetModConfigData("shielda")
local Shadow = GetModConfigData("bunsin")
local Dogs = GetModConfigData("dogs")
local YAMCHO = GetModConfigData("commandyamche")
local MEAT = GetModConfigData("monstermeat")
local Mbadge = GetModConfigData("mushabadge")
local Cgems = GetModConfigData("craftgems")
local Frostone = GetModConfigData("frostseries")
local Smart = GetModConfigData("smartmusha")
local Difficult = GetModConfigData("difficultover")
local Hide = GetModConfigData("hidecast")
local ACTIONS = GLOBAL.ACTIONS
ACTIONS.ADDFUEL.priority = 4

local require = GLOBAL.require
local SpawnPrefab = GLOBAL.SpawnPrefab

local RECIPETABS = GLOBAL.RECIPETABS
local Recipe = GLOBAL.Recipe
local Ingredient = GLOBAL.Ingredient
local ACTIONS = GLOBAL.ACTIONS
TECH = GLOBAL.TECH


PrefabFiles = {
	"musha",
          "musha_small",
          "musha_egg",
          "musha_egg1",
          "musha_egg2",
          "musha_egg3",
          "musha_eggs1",
          "musha_eggs2",
          "musha_eggs3",
          "musha_egg8",
     	"frosthammer",
          "broken_frosthammer",
          "frostback",
          "hat_mbunny",
          "hat_mphoenix",
          "hat_mcrown",
          "hat_mprincess",
          "ghosthound",
          "ghosthound2",
          "armor_mushaa",
          "armor_mushab",
	"books",
	"shock_fx2",
	"glowdust",
	"mushasword",
	"mushasword_base",
	"mushasword_frost",
	"mushasword2",
	"mushasword3",
	"mushasword4",
	"musha_flute",
	"cristal",
	"forcefieldfxx",
	"exp",
	"exp1000",
	"shadowmusha",
	"tentacle_frost",
}


local function Mushaintro(inst)
    if GLOBAL.GetPlayer().prefab == "musha" then
     inst.components.maxwelltalker.speeches.SANDBOX_1 =
        {
            appearsound = "dontstarve/maxwell/appear_adventure",
	    voice = "dontstarve/maxwell/talk_LP_world2",
	appearanim = "appear2",
	idleanim= "idle2_loop",
	dialogpreanim = "dialog2_pre",
	dialoganim="dialog2_loop",
	dialogpostanim = "dialog2_pst",
	disappearanim = "disappear2",
            disableplayer = true,
            skippable = true,
            {
                string = "~ӭݹ",
                wait = 3,
                anim = nil,
                sound = nil,
            },
            {
                string = "...κ.",
                wait = 3,
                anim = nil,
                sound = nil,
            },
            {
                string = "ԽӴ,.",
                wait = 3,
                anim = nil,
                sound = nil,
            },
            {
                string = "Ҫע!ԭס񲢲ȥ.",
                wait = 3,
                anim = nil,
                sound = nil,
            },
            {
                string = "ҿɲϣκ...",
                wait = 3,
                anim = dialog2_loop,
                sound = nil,
            },
	}

    end
end

AddPrefabPostInit("maxwellintro", Mushaintro)


Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/musha.tex" ),
    Asset( "IMAGE", "images/selectscreen_portraits/musha.tex" ),
    Asset( "IMAGE", "images/selectscreen_portraits/musha_silho.tex" ),
    Asset( "IMAGE", "bigportraits/musha.tex" ),
	Asset("IMAGE", "images/musha.tex"),
	Asset("IMAGE", "images/mushas.tex"),
        Asset( "ANIM", "anim/musha_battle.zip"),
        Asset( "ANIM", "anim/musha.zip"),
        Asset( "ANIM", "anim/musha_h.zip"),
        Asset( "ANIM", "anim/musha_normal.zip"),
    Asset( "ANIM", "anim/musha_hunger.zip"),
    Asset("ANIM", "anim/musha_egg8.zip"),
    Asset("ANIM", "anim/musha_egg.zip"),
    Asset("ANIM", "anim/musha_egg1.zip"),
    Asset("ANIM", "anim/musha_egg2.zip"),
    Asset("ANIM", "anim/musha_egg3.zip"),
    Asset("ANIM", "anim/musha_eggs1.zip"),
    Asset("ANIM", "anim/musha_eggs2.zip"),
    Asset("ANIM", "anim/musha_eggs3.zip"),
    Asset("ANIM", "anim/musha_ice.zip"),
    Asset("ANIM", "anim/musha_small.zip"),
    Asset("ANIM", "anim/musha_teen.zip"),
    Asset("ANIM", "anim/musha_tall.zip"),
    Asset("ANIM", "anim/musha_tall2.zip"),
    Asset("ANIM", "anim/musha_tall3.zip"),
    Asset("ANIM", "anim/musha_tall4.zip"),
    Asset("ANIM", "anim/musha_tall5.zip"),
    Asset("ANIM", "anim/frosthammer.zip"),
    Asset("ANIM", "anim/swap_frosthammer.zip"),
    Asset("ANIM", "anim/broken_frosthammer.zip"),
    Asset("ANIM", "anim/swap_frostback.zip"),
    Asset("ANIM", "anim/swap_frostpocket.zip"),
    Asset("ANIM", "anim/hat_mbunny.zip"),
    Asset("ANIM", "anim/hat_mbunny2.zip"),
    Asset("ANIM", "anim/hat_mphoenix.zip"),
    Asset("ANIM", "anim/hat_mphoenix2.zip"),
    Asset("ANIM", "anim/hat_mcrown.zip"),
    Asset("ANIM", "anim/hat_mprincess.zip"),
    Asset("ANIM", "anim/ghosthound.zip"),
    Asset("ANIM", "anim/armor_mushaa.zip"),
    Asset("ANIM", "anim/armor_mushab.zip"),
    Asset("ANIM", "anim/ui_chest_yamche0.zip"),
    Asset("ANIM", "anim/ui_chest_yamche1.zip"),
    Asset("ANIM", "anim/ui_chest_yamche2.zip"),
    Asset("ANIM", "anim/hat_yamche.zip"),
    Asset("ANIM", "anim/ui_frostsmall.zip"),
    Asset("ANIM", "anim/ui_chest_frosthammer.zip"),
    Asset("ANIM", "anim/ui_chest_frosthammer2.zip"),
    Asset("ANIM", "anim/ui_mushab_2x3.zip"),
    Asset("ANIM", "anim/shock_fx2.zip"),
    Asset("ANIM", "anim/forcefieldx.zip"),
    Asset("ANIM", "anim/glowdust.zip"),
    Asset("ANIM", "anim/cristal.zip"),
    Asset("ANIM", "anim/exp.zip"),
    Asset("ANIM", "anim/musha_flute.zip"),
    Asset("ANIM", "anim/mushasword_base.zip"),
    Asset("ANIM", "anim/mushasword_frost.zip"),
    Asset("ANIM", "anim/mushasword.zip"),
    Asset("ANIM", "anim/mushasword2.zip"),
    Asset("ANIM", "anim/mushasword3.zip"),
    Asset("ANIM", "anim/mushasword4.zip"),
    Asset("ANIM", "anim/swap_mushasword_base.zip"),
    Asset("ANIM", "anim/swap_mushasword_frost1.zip"),
    Asset("ANIM", "anim/swap_mushasword_frost2.zip"),
    Asset("ANIM", "anim/swap_mushasword_frost3.zip"),
    Asset("ANIM", "anim/swap_mushasword.zip"),
    Asset("ANIM", "anim/swap_mushasword2.zip"),
    Asset("ANIM", "anim/swap_mushasword3.zip"),
    Asset("ANIM", "anim/swap_mushasword4.zip"),
    Asset("ANIM", "anim/tentacle_frost.zip"),

	Asset("IMAGE", "images/inventoryimages/musha_egg.tex"),
	Asset("IMAGE", "images/inventoryimages/musha_egg1.tex"),
	Asset("IMAGE", "images/inventoryimages/musha_egg2.tex"),
	Asset("IMAGE", "images/inventoryimages/musha_egg3.tex"),
	Asset("IMAGE", "images/inventoryimages/musha_eggs1.tex"),
	Asset("IMAGE", "images/inventoryimages/musha_eggs2.tex"),
	Asset("IMAGE", "images/inventoryimages/musha_eggs3.tex"),
	Asset("IMAGE", "images/inventoryimages/musha_egg_cracked.tex"),
	Asset("IMAGE", "images/inventoryimages/musha_egg_cracked1.tex"),
	Asset("IMAGE", "images/inventoryimages/musha_egg_cracked2.tex"),
	Asset("IMAGE", "images/inventoryimages/musha_egg_cracked3.tex"),
	Asset("IMAGE", "images/inventoryimages/musha_egg_crackeds1.tex"),
	Asset("IMAGE", "images/inventoryimages/musha_egg_crackeds2.tex"),
	Asset("IMAGE", "images/inventoryimages/musha_egg_crackeds3.tex"),
	Asset("IMAGE", "images/inventoryimages/musha_egg_cooked.tex"),

	Asset("IMAGE", "images/inventoryimages/musha_egg8.tex"),
	Asset("IMAGE", "images/inventoryimages/musha_egg_cracked8.tex"),

	Asset("IMAGE", "images/inventoryimages/musha_small.tex"),
	Asset("IMAGE", "images/inventoryimages/musha_teen.tex"),
	Asset("IMAGE", "images/inventoryimages/musha_tall.tex"),
	Asset("IMAGE", "images/inventoryimages/frosthammer.tex"),
	Asset("IMAGE", "images/inventoryimages/broken_frosthammer.tex"),
	Asset("IMAGE", "images/inventoryimages/frostback.tex"),
	Asset("IMAGE", "images/inventoryimages/hat_mbunny.tex"),
	Asset("IMAGE", "images/inventoryimages/hat_mphoenix.tex"),
	Asset("IMAGE", "images/inventoryimages/hat_mcrown.tex"),
	Asset("IMAGE", "images/inventoryimages/hat_mprincess.tex"),
	Asset("IMAGE", "images/inventoryimages/armor_mushaa.tex"),
	Asset("IMAGE", "images/inventoryimages/armor_mushab.tex"),
	Asset("IMAGE", "images/inventoryimages/musha_flute.tex"),
	Asset("IMAGE", "images/inventoryimages/mushasword_base.tex"),
	Asset("IMAGE", "images/inventoryimages/mushasword_frost.tex"),
	Asset("IMAGE", "images/inventoryimages/mushasword.tex"),
	Asset("IMAGE", "images/inventoryimages/mushasword2.tex"),
	Asset("IMAGE", "images/inventoryimages/mushasword3.tex"),
	Asset("IMAGE", "images/inventoryimages/mushasword4.tex"),
	Asset("IMAGE", "images/inventoryimages/blade_b.tex"),
	Asset("IMAGE", "images/inventoryimages/blade_1.tex"),
	Asset("IMAGE", "images/inventoryimages/blade_2.tex"),
	Asset("IMAGE", "images/inventoryimages/blade_3.tex"),
	Asset("IMAGE", "images/inventoryimages/blade_4.tex"),
	Asset("IMAGE", "images/inventoryimages/blade_f.tex"),
	Asset("IMAGE", "images/inventoryimages/glowdust.tex"),
	Asset("IMAGE", "images/inventoryimages/cristal.tex"),
	Asset("IMAGE", "images/inventoryimages/exp.tex"),


	Asset("ATLAS", "images/musha.xml"),
	Asset("ATLAS", "images/mushas.xml"),
	Asset( "ATLAS", "images/saveslot_portraits/musha.xml" ),
    Asset( "ATLAS", "images/selectscreen_portraits/musha.xml" ),
    Asset( "ATLAS", "images/selectscreen_portraits/musha_silho.xml" ),
    Asset( "ATLAS", "bigportraits/musha.xml" ),
	Asset("ATLAS", "images/inventoryimages/frosthammer.xml"),
	Asset("ATLAS", "images/inventoryimages/broken_frosthammer.xml"),
	Asset("ATLAS", "images/inventoryimages/frostback.xml"),
	Asset("ATLAS", "images/inventoryimages/hat_mbunny.xml"),
	Asset("ATLAS", "images/inventoryimages/hat_mphoenix.xml"),
	Asset("ATLAS", "images/inventoryimages/hat_mcrown.xml"),
	Asset("ATLAS", "images/inventoryimages/hat_mprincess.xml"),
	Asset("ATLAS", "images/inventoryimages/armor_mushaa.xml"),
	Asset("ATLAS", "images/inventoryimages/armor_mushab.xml"),
	Asset("ATLAS", "images/inventoryimages/musha_flute.xml"),
	Asset("ATLAS", "images/inventoryimages/mushasword_base.xml"),
	Asset("ATLAS", "images/inventoryimages/mushasword_frost.xml"),
	Asset("ATLAS", "images/inventoryimages/mushasword.xml"),
	Asset("ATLAS", "images/inventoryimages/mushasword2.xml"),
	Asset("ATLAS", "images/inventoryimages/mushasword3.xml"),
	Asset("ATLAS", "images/inventoryimages/mushasword4.xml"),
	Asset("ATLAS", "images/inventoryimages/blade_b.xml"),
	Asset("ATLAS", "images/inventoryimages/blade_1.xml"),
	Asset("ATLAS", "images/inventoryimages/blade_2.xml"),
	Asset("ATLAS", "images/inventoryimages/blade_3.xml"),
	Asset("ATLAS", "images/inventoryimages/blade_4.xml"),

	Asset("ATLAS", "images/inventoryimages/musha_egg8.xml"),
	Asset("ATLAS", "images/inventoryimages/musha_egg_cracked8.xml"),

	Asset("ATLAS", "images/inventoryimages/musha_egg.xml"),
	Asset("ATLAS", "images/inventoryimages/musha_egg1.xml"),
	Asset("ATLAS", "images/inventoryimages/musha_egg2.xml"),
	Asset("ATLAS", "images/inventoryimages/musha_egg3.xml"),
	Asset("ATLAS", "images/inventoryimages/musha_egg_cracked.xml"),
	Asset("ATLAS", "images/inventoryimages/musha_egg_cracked1.xml"),
	Asset("ATLAS", "images/inventoryimages/musha_egg_cracked2.xml"),
	Asset("ATLAS", "images/inventoryimages/musha_egg_cracked3.xml"),
	Asset("ATLAS", "images/inventoryimages/musha_eggs1.xml"),
	Asset("ATLAS", "images/inventoryimages/musha_eggs2.xml"),
	Asset("ATLAS", "images/inventoryimages/musha_eggs3.xml"),
	Asset("ATLAS", "images/inventoryimages/musha_egg_cracked.xml"),
	Asset("ATLAS", "images/inventoryimages/musha_egg_crackeds1.xml"),
	Asset("ATLAS", "images/inventoryimages/musha_egg_crackeds2.xml"),
	Asset("ATLAS", "images/inventoryimages/musha_egg_crackeds3.xml"),
	Asset("ATLAS", "images/inventoryimages/musha_egg_cooked.xml"),
	Asset("ATLAS", "images/inventoryimages/musha_small.xml"),
	Asset("ATLAS", "images/inventoryimages/musha_teen.xml"),
	Asset("ATLAS", "images/inventoryimages/musha_tall.xml"),
	Asset("ATLAS", "images/inventoryimages/glowdust.xml"),
	Asset("ATLAS", "images/inventoryimages/cristal.xml"),
	Asset("ATLAS", "images/inventoryimages/exp.xml"),

}


function mushaPostInit(musha)
--matarial

local bushhat = Ingredient( "bushhat", 1)
local ruinshat = Ingredient( "ruinshat", 1)
local armorruins = Ingredient( "armorruins", 1)
local amulet = Ingredient( "amulet", 1)
local butterfly10 = Ingredient( "butterfly", 10)
local butterfly8 = Ingredient( "butterfly", 8)
local butterfly6 = Ingredient( "butterfly", 6)
local bee5 = Ingredient( "bee", 5)
local bee4 = Ingredient( "bee", 4)
local papyrus2 = Ingredient( "papyrus", 2)
local beefaloh = Ingredient( "beefalohat", 1)
local walrustusk = Ingredient( "walrus_tusk", 2)
local eyes = Ingredient( "deerclops_eyeball", 2)

local princess = Ingredient( "hat_mprincess", 1)
princess.atlas = "images/inventoryimages/hat_mprincess.xml"

local armoraa = Ingredient( "armor_mushaa", 1)
armoraa.atlas = "images/inventoryimages/armor_mushaa.xml"

local glowdusts = Ingredient( "glowdust", 1)
glowdusts.atlas = "images/inventoryimages/glowdust.xml"
local dust2 = Ingredient( "glowdust", 2)
dust2.atlas = "images/inventoryimages/glowdust.xml"
local dust3 = Ingredient( "glowdust", 3)
dust3.atlas = "images/inventoryimages/glowdust.xml"
local dust4 = Ingredient( "glowdust", 4)
dust4.atlas = "images/inventoryimages/glowdust.xml"
local dust6 = Ingredient( "glowdust", 6)
dust6.atlas = "images/inventoryimages/glowdust.xml"
local dust10 = Ingredient( "glowdust", 10)
dust10.atlas = "images/inventoryimages/glowdust.xml"

local broken = Ingredient( "broken_frosthammer", 1)
broken.atlas = "images/inventoryimages/broken_frosthammer.xml"

local frosta = Ingredient( "frosthammer", 1)
frosta.atlas = "images/inventoryimages/frosthammer.xml"

local meggs = Ingredient( "musha_egg", 1)
meggs.atlas = "images/inventoryimages/musha_egg.xml"

local bladeb = Ingredient( "mushasword_base", 1)
bladeb.atlas = "images/inventoryimages/mushasword_base.xml"
local blade1 = Ingredient( "mushasword", 1)
blade1.atlas = "images/inventoryimages/mushasword.xml"
local blade2 = Ingredient( "mushasword2", 1)
blade2.atlas = "images/inventoryimages/mushasword2.xml"

local crystal = Ingredient( "cristal", 1)
crystal.atlas = "images/inventoryimages/cristal.xml"
local crystal6 = Ingredient( "cristal", 6)
crystal6.atlas = "images/inventoryimages/cristal.xml"
local crystal10 = Ingredient( "cristal", 10)
crystal10.atlas = "images/inventoryimages/cristal.xml"


--dust

 local glowdust = GLOBAL.Recipe( "glowdust", {Ingredient("wormlight", 1), Ingredient("berries", 5) }, RECIPETABS.REFINE, {SCIENCE=0})
	glowdust.atlas = "images/inventoryimages/glowdust.xml"

--exp
--[[
 local exp = GLOBAL.Recipe( "exp", {Ingredient("goldnugget", 4),}, RECIPETABS.REFINE, {SCIENCE=0})
	exp.atlas = "images/inventoryimages/exp.xml"]]

--cristal

 local cristal = GLOBAL.Recipe( "cristal", {dust2, Ingredient("bluegem", 2)}, RECIPETABS.REFINE, {SCIENCE=0})
	cristal.atlas = "images/inventoryimages/cristal.xml"

--horn

 local musha_flute = GLOBAL.Recipe( "musha_flute", {dust6, Ingredient("horn", 1), Ingredient("spidergland", 20)},  RECIPETABS.MAGIC, {SCIENCE=0})
	musha_flute.atlas = "images/inventoryimages/musha_flute.xml"


--phoenix weapon

 local mushasword = GLOBAL.Recipe( "mushasword", { bladeb, glowdusts, Ingredient("feather_robin", 2), Ingredient("goldnugget", 10) }, RECIPETABS.WAR, {SCIENCE=0})
mushasword.atlas = "images/inventoryimages/mushasword.xml"
 local mushasword2 = GLOBAL.Recipe( "mushasword2", { blade1,  dust6, Ingredient("redgem", 6), Ingredient("goldnugget", 20) }, RECIPETABS.WAR, {SCIENCE=0})
mushasword2.atlas = "images/inventoryimages/mushasword2.xml"
 local mushasword3 = GLOBAL.Recipe( "mushasword3", { blade2,  dust10, Ingredient("redgem", 30), Ingredient("goldnugget", 80) }, RECIPETABS.WAR, {SCIENCE=0})
mushasword3.atlas = "images/inventoryimages/mushasword3.xml"
 local mushasword4 = GLOBAL.Recipe( "mushasword4", { blade2, Ingredient("redgem", 30), Ingredient("greengem", 8), Ingredient("nightmarefuel", 40) }, RECIPETABS.WAR, {SCIENCE=0})
mushasword4.atlas = "images/inventoryimages/mushasword4.xml"

 local mushasword_base = GLOBAL.Recipe( "mushasword_base", { Ingredient("redgem", 12), dust10}, RECIPETABS.REFINE, {SCIENCE=0})
mushasword_base.atlas = "images/inventoryimages/mushasword_base.xml"

--frost heart

 local frosthammer = GLOBAL.Recipe( "frosthammer", { broken, Ingredient("livinglog", 15), Ingredient("bluegem", 30), Ingredient("gears", 4)}, RECIPETABS.WAR, {SCIENCE=0})
frosthammer.atlas = "images/inventoryimages/frosthammer.xml"

 local mushasword_frost = GLOBAL.Recipe( "mushasword_frost", { bladeb, broken,  dust3 }, RECIPETABS.WAR, {SCIENCE=0})
mushasword_frost.atlas = "images/inventoryimages/mushasword_frost.xml"

 local frostback= GLOBAL.Recipe( "frostback", { broken, butterfly8, bee4, Ingredient("bluegem", 5) }, RECIPETABS.WAR, {SCIENCE=0})
frostback.atlas = "images/inventoryimages/frostback.xml"

 local broken_frosthammer = GLOBAL.Recipe( "broken_frosthammer", { eyes, crystal10, butterfly10, Ingredient("gears", 4) }, RECIPETABS.REFINE, {SCIENCE=0})
broken_frosthammer.atlas = "images/inventoryimages/broken_frosthammer.xml"


--convert gem

--egg

--
 local musha_egg = GLOBAL.Recipe( "musha_egg", { dust10, Ingredient("redgem", 60), Ingredient("bluegem", 40), Ingredient("greengem", 30) },  RECIPETABS.MAGIC, {SCIENCE=0})
	musha_egg.atlas = "images/inventoryimages/musha_egg.xml"
--
 local musha_eggs1 = GLOBAL.Recipe( "musha_eggs1", {meggs, glowdusts 	},  RECIPETABS.MAGIC, {SCIENCE=0})
	musha_eggs1.atlas = "images/inventoryimages/musha_eggs1.xml"
 local musha_eggs2 = GLOBAL.Recipe( "musha_eggs2", { meggs, Ingredient("redgem", 1), glowdusts },  RECIPETABS.MAGIC, {SCIENCE=0})
	musha_eggs2.atlas = "images/inventoryimages/musha_eggs2.xml"
 local musha_eggs3 = GLOBAL.Recipe( "musha_eggs3", { meggs, Ingredient("redgem", 2), dust2 },  RECIPETABS.MAGIC, {SCIENCE=0})
	musha_eggs3.atlas = "images/inventoryimages/musha_eggs3.xml"

--[[
	musha_eggs3.atlas = "images/inventoryimages/musha_eggs3.xml"
 local musha_egg1 = GLOBAL.Recipe( "musha_egg1", {meggs, Ingredient("redgem", 12), Ingredient("purplegem", 8), dust3 },  RECIPETABS.MAGIC, {SCIENCE=0})
	musha_egg1.atlas = "images/inventoryimages/musha_egg1.xml"
 local musha_egg2 = GLOBAL.Recipe( "musha_egg2", { meggs, Ingredient("redgem", 10), Ingredient("purplegem", 10), dust4 },  RECIPETABS.MAGIC, {SCIENCE=0})
	musha_egg2.atlas = "images/inventoryimages/musha_egg2.xml"
 local musha_egg3 = GLOBAL.Recipe( "musha_egg3", { meggs, Ingredient("redgem", 20), Ingredient("purplegem", 20), dust10 },  RECIPETABS.MAGIC, {SCIENCE=0})
	musha_egg3.atlas = "images/inventoryimages/musha_egg3.xml"
]]--


--hat

 local hat_mbunny = GLOBAL.Recipe( "hat_mbunny", {walrustusk, Ingredient("dug_grass", 8), Ingredient("manrabbit_tail", 10), Ingredient("bluegem", 4)  }, RECIPETABS.DRESS, {SCIENCE=0})
	hat_mbunny.atlas = "images/inventoryimages/hat_mbunny.xml"
 local hat_mprincess = GLOBAL.Recipe( "hat_mprincess", {amulet, crystal, Ingredient("goldnugget", 15), Ingredient("purplegem", 5) },  RECIPETABS.DRESS, {SCIENCE=0})
	hat_mprincess.atlas = "images/inventoryimages/hat_mprincess.xml"
 local hat_mcrown = GLOBAL.Recipe( "hat_mcrown", {princess, dust10,Ingredient("thulecite", 20), Ingredient("orangegem", 6) }, RECIPETABS.DRESS, {SCIENCE=0})
	hat_mcrown.atlas = "images/inventoryimages/hat_mcrown.xml"

 local hat_mphoenix = GLOBAL.Recipe( "hat_mphoenix", {princess, blade2, Ingredient("goldnugget", 80), Ingredient("thulecite", 60) }, RECIPETABS.DRESS, {SCIENCE=0})
	hat_mphoenix.atlas = "images/inventoryimages/hat_mphoenix.xml"

--armor

 local armor_mushaa = GLOBAL.Recipe( "armor_mushaa", {amulet, Ingredient("goldnugget", 40), Ingredient("thulecite", 20) }, RECIPETABS.WAR, {SCIENCE=0})
	armor_mushaa.atlas = "images/inventoryimages/armor_mushaa.xml"

 local armor_mushab = GLOBAL.Recipe( "armor_mushab", {armoraa, Ingredient("greengem", 8), Ingredient("orangegem", 8), Ingredient("purplegem", 20)}, RECIPETABS.WAR, {SCIENCE=0})
	armor_mushab.atlas = "images/inventoryimages/armor_mushab.xml"


end

AddSimPostInit(function(inst)
        if inst.prefab == "musha" then
                mushaPostInit(inst)
        end
end)

--GetPlayer = GLOBAL.GetPlayer

table.insert(GLOBAL.CHARACTER_GENDERS.FEMALE, "musha")

local STRINGS = GLOBAL.STRINGS

-----------------------------
GLOBAL.STRINGS.CHARACTER_TITLES.musha = "musha"
GLOBAL.STRINGS.CHARACTER_NAMES.musha = "musha"
GLOBAL.STRINGS.CHARACTER_DESCRIPTIONS.musha = "musha"
GLOBAL.STRINGS.CHARACTER_QUOTES.musha = "\"A full belly is the mother of all happiness.\""

STRINGS.NAMES.MUSHA_EGG = "˵"
STRINGS.NAMES.MUSHA_EGG_CRACKED = "˵"
STRINGS.NAMES.MUSHA_EGGS1 = "˵(2)"
STRINGS.NAMES.MUSHA_EGG_CRACKEDS1 = "˵"
STRINGS.NAMES.MUSHA_EGGS2 = "˵(3)"
STRINGS.NAMES.MUSHA_EGG_CRACKEDS2 = "˵"
STRINGS.NAMES.MUSHA_EGGS3 = "˵(4)"
STRINGS.NAMES.MUSHA_EGG_CRACKEDS3 = "˵"
STRINGS.NAMES.MUSHA_EGG1 = "˵(5)"
STRINGS.NAMES.MUSHA_EGG_CRACKED1 = "˵"
STRINGS.NAMES.MUSHA_EGG2 = "˵(6)"
STRINGS.NAMES.MUSHA_EGG_CRACKED2 = "˵"
STRINGS.NAMES.MUSHA_EGG3 = "˵(7)"
STRINGS.NAMES.MUSHA_EGG_CRACKED3 = "˵"
STRINGS.NAMES.MUSHA_EGG8 = "˵(8)"
STRINGS.NAMES.MUSHA_EGG_CRACKED8 = "˵"

STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_EGG_CRACKED = "! (1)"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_EGG_CRACKEDS1 = "! (2)"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_EGG_CRACKEDS2 = "! (3)"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_EGG_CRACKEDS3 = "! (4)"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_EGG_CRACKED1 = "! (5)"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_EGG_CRACKED2 = "! (6)"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_EGG_CRACKED3 = "! (7)"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_EGG_CRACKED8 = "! (8)"


STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_SMALL = "ȼ [1] һ :[1]\nսָ: (Y)\nŶ,ÿɰŶ!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TEEN = "ȼ [2] һ :[20]\nսָ: (Y)\n˻ôɰ!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TEENR1 = "ȼ [2] һ :[20]\nսָ: (Y)\n˻ôɰ!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TEENR2 = "ȼ [2] һ :[20]\nսָ: (Y)\n˻ôɰ!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TEENR3 = "ȼ [2] һ :[20]\nսָ: (Y)\n˻ôɰ!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TEENR4 = "ȼ [2] һ :[20]\nսָ: (Y)\n˻ôɰ!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TEENICE = "ȼ [2] һ :[20]\nսָ: (Y)\n˻ôɰ!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALL = "ȼ [3] һ :[50]\nսָ: (Y)\nҮ!ĳɳ"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALLR1 = "ȼ [3] һ :[50]\nսָ: (Y)\nҮ!ĳɳ"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALLR2 = "ȼ [3] һ :[50]\nսָ: (Y)\nҮ!ĳɳ"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALLR3 = "ȼ [3] һ :[50]\nսָ: (Y)\nҮ!ĳɳ"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALLR4 = "ȼ [3] һ :[50]\nսָ: (Y)\nҮ!ĳɳ"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALLRICE = "ȼ [3] һ :[50]\nսָ: (Y)\nҮ!ĳɳ"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALL2 = "ȼ [4] һ :[100]\nսָ: (Y)\nܺһͬս.."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALLRR1 = "ȼ [4] һ :[100]\nսָ: (Y)\nܺһͬս.."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALLRR2 = "ȼ [4] һ :[100]\nսָ: (Y)\nܺһͬս.."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALLRR3 = "ȼ [4] һ :[100]\nսָ: (Y)\nܺһͬս.."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALLRR4 = "ȼ [4] һ :[100]\nսָ: (Y)\nܺһͬս.."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALLRR5 = "ȼ [4] һ :[100]\nսָ: (Y)\nܺһͬս.."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALLRRICE = "ȼ [4] һ :[100]\nսָ: (Y)\nܺһͬս.."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALL3 = "ȼ [5] һ :[300]\nսָ: (Y)\nǴ?"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALLRRR1 = "ȼ [5] һ :[300]\nսָ: (Y)\nǴ?"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALLRRR2 = "ȼ [5] һ :[300]\nսָ: (Y)\nǴ?"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALLRRR3 = "ȼ [5] һ :[300]\nսָ: (Y)\nǴ?"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALLRRR4 = "ȼ [5] һ :[300]\nսָ: (Y)\nǴ?"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALLRRR5 = "ȼ [5] һ :[300]\nսָ: (Y)\nǴ?"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALLRRRICE = "ȼ [5] һ :[300]\nսָ: (Y)\n Yamche!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALL4 = "ȼ [6] һ :[400]\nսָ: (Y)\nŶ!!÷ǳǳĴ."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALLRRRR1 = "ȼ [6] һ :[400]\nսָ: (Y)\nŶ!!÷ǳǳĴ."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALLRRRR2 = "ȼ [6] һ :[400]\nսָ: (Y)\nŶ!!÷ǳǳĴ."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALLRRRR3 = "ȼ [6] һ :[400]\nսָ: (Y)\nŶ!!÷ǳǳĴ."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALLRRRR4 = "ȼ [6] һ :[400]\nսָ: (Y)\nŶ!!÷ǳǳĴ."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALLRRRR5 = "ȼ [6] һ :[400]\nսָ: (Y)\nŶ!!÷ǳǳĴ."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALLRRRR6 = "ȼ [6] һ :[400]\nսָ: (Y)\nŶ!!÷ǳǳĴ."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALLRRRRICE = "ȼ [6] һ :[400]\nսָ: (Y)\nŶ!!÷ǳǳĴ."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALL5 = "ȼ [7] һ :[500]\nսָ: (Y)\nһǿĻ!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALLRRRRR1 = "ȼ [7] һ :[500]\nսָ: (Y)\nһǿĻ!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALLRRRRR2 = "ȼ [7] һ :[500]\nսָ: (Y)\nһǿĻ!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALLRRRRR3 = "ȼ [7] һ :[500]\nսָ: (Y)\nһǿĻ!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALLRRRRR4 = "ȼ [7] һ :[500]\nսָ: (Y)\nһǿĻ!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALLRRRRR5 = "ȼ [7] һ :[500]\nսָ: (Y)\nһǿĻ!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALLRRRRR6 = "ȼ [7] һ :[500]\nսָ: (Y)\nһǿĻ!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_TALLRRRRRICE = "ȼ [7] һ :[500]\nսָ: (Y)\nһǿĻ!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_RP1 = "ȼ [8]\nսָ: (Y) \n Ұ!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_RP2 = "ȼ [8]\nսָ: (Y) \n Ұ!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_RP3 = "ȼ [8]\nսָ: (Y) \n Ұ!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_RP4 = "ȼ [8]\nսָ: (Y) \n Ұ!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_RP5 = "ȼ [8]\nսָ: (Y) \n Ұ!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_RP6 = "ȼ [8]\nսָ: (Y) \n Ұ!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_RP7 = "ȼ [8]\nսָ: (Y) \n Ұ!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_RPICE = "ȼ [8]\nսָ: (Y) \n Ұ!"

STRINGS.NAMES.GHOSTHOUND = "Ȯ"
STRINGS.NAMES.GHOSTHOUND2 = "СȮ"
STRINGS.NAMES.SHADOWMUSHA = "MushaӰ"
STRINGS.NAMES.TENTACLE_FROST = "Ĵ"

STRINGS.RECIPE_DESC.MUSHA_EGG = "˵"
STRINGS.RECIPE_DESC.MUSHA_EGGS1 = "2˵. ٷ"
STRINGS.RECIPE_DESC.MUSHA_EGGS2 = "3˵. ٷ"
STRINGS.RECIPE_DESC.MUSHA_EGGS3 = "4˵. ٷ"
STRINGS.RECIPE_DESC.MUSHA_EGG1 = "5˵. ٷ"
STRINGS.RECIPE_DESC.MUSHA_EGG2 = "6˵. ٷ"
STRINGS.RECIPE_DESC.MUSHA_EGG3 = "7˵. ٷ"
STRINGS.RECIPE_DESC.MUSHA_EGG8 = "8˵."

STRINGS.RECIPE_DESC.REDGEM = "ʯ"
STRINGS.RECIPE_DESC.BLUEGEM = "ʯ" 
STRINGS.RECIPE_DESC.ROCKS = "       ֵ  ʯ ͷ" 
STRINGS.NAMES.ROCKS = "ʯ"

STRINGS.NAMES.REDGEM = "챦ʯ"
STRINGS.NAMES.REDGEM2 = "챦ʯ"
STRINGS.NAMES.BLUEGEM = "ʯ" 
STRINGS.NAMES.BLUEGEM2 = "ʯ" 

STRINGS.NAMES.MUSHASWORD_BASE = "ƵĽ"
STRINGS.NAMES.MUSHASWORD = "˽I"
STRINGS.NAMES.MUSHASWORD2 = "˽II"
STRINGS.NAMES.MUSHASWORD3 = "˽III"
STRINGS.NAMES.MUSHASWORD4 = "˸"
STRINGS.NAMES.MUSHASWORD_FROST = "˪˽"

STRINGS.RECIPE_DESC.MUSHASWORD_BASE = "Ƶķ˽, ⹥: ((G))"
STRINGS.RECIPE_DESC.MUSHASWORD = "湥(1), ⹥ : ((G))"
STRINGS.RECIPE_DESC.MUSHASWORD2 = "湥(2), ⹥ : ((G))"
STRINGS.RECIPE_DESC.MUSHASWORD3 = "湥(3), ⹥ : ((G))"
STRINGS.RECIPE_DESC.MUSHASWORD4 = "湥(2), ⹥ : ((G))"
STRINGS.RECIPE_DESC.MUSHASWORD_FROST = "ɳɳ, ⹥ : ((G))"

STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHASWORD_BASE = "ܿĽ!\n⹥ : ((G))"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHASWORD_BASE = "ǰ޺ð! \n⹥ : ((G))"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHASWORD = "Ǻܷ..ǰѺý\n⹥ : ((G))"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHASWORD2 = "ܷ!ǿв! \n⹥ : ((G))"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHASWORD3 = "ǿķ֮! \n⹥ : ((G))"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHASWORD4 = "ǿĸ! ǿMusha! \n⹥ : ((G))"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHASWORD_FROST = "ɳ!ҵĽ! \n⹥ : ((G))"

STRINGS.NAMES.MUSHA_FLUTE = "˶̵"
STRINGS.RECIPE_DESC.MUSHA_FLUTE = "     ͬ  250HP "

STRINGS.NAMES.GLOWDUST = "֮"
STRINGS.RECIPE_DESC.GLOWDUST = "ķĩ"

STRINGS.NAMES.CRISTAL = "ˮ"
STRINGS.RECIPE_DESC.CRISTAL = "ȼ, Yamche => Ӧȼĵ"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.CRISTAL = "ˮ!"

STRINGS.NAMES.EXP = ""
STRINGS.CHARACTERS.GENERIC.DESCRIBE.EXP = " [] ľ!"
STRINGS.NAMES.EXP1000CHEAT = "׵ľ"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.EXP1000CHEAT = "׵ľ!"
STRINGS.RECIPE_DESC.EXP = ", ޸ [ ɳɳĵ ] "
STRINGS.RECIPE_DESC.EXP10 = "Ӿ 10"
STRINGS.RECIPE_DESC.EXP50 = "Ӿ 50"
STRINGS.RECIPE_DESC.EXP100 = "Ӿ 100"

STRINGS.NAMES.FROSTHAMMER = "˪֮"
STRINGS.RECIPE_DESC.FROSTHAMMER = "ɳɳ, , ⹥: ((G))"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.FROSTHAMMER = "ִƯĻ. \n⹥: ((G))"

STRINGS.NAMES.FROSTBACK = "˪ս"
STRINGS.RECIPE_DESC.FROSTBACK = "ɳɳ, "
STRINGS.CHARACTERS.GENERIC.DESCRIBE.FROSTBACK = "ϲĻҿ"


STRINGS.NAMES.BROKEN_FROSTHAMMER = "˪֮"
--STRINGS.NAMES.BROKEN = "˪֮"
STRINGS.RECIPE_DESC.BROKEN_FROSTHAMMER = "ɳɳ, "
--STRINGS.RECIPE_DESC.BROKEN = " ˪ս       "
STRINGS.CHARACTERS.GENERIC.DESCRIBE.BROKEN_FROSTHAMMER = "˪"

STRINGS.NAMES.HAT_MPHOENIX = "ͷ"
STRINGS.RECIPE_DESC.HAT_MPHOENIX = "ɳɳ,   ж   (Ҽ) "
STRINGS.CHARACTERS.GENERIC.DESCRIBE.HAT_MPHOENIX = "Ů !"
STRINGS.NAMES.HAT_MPRINCESS = "鹫Ļʹ"
STRINGS.RECIPE_DESC.HAT_MPRINCESS = "  ,  ,  ɫ =  "
STRINGS.CHARACTERS.GENERIC.DESCRIBE.HAT_MPRINCESS = "Ǿ鹫!"
STRINGS.NAMES.HAT_MCROWN = "ŮĻʹ"
STRINGS.RECIPE_DESC.HAT_MCROWN = "  ,   ,    "
STRINGS.CHARACTERS.GENERIC.DESCRIBE.HAT_MCROWN = "ǾŮ!!"
STRINGS.NAMES.HAT_MBUNNY = "ñ"
STRINGS.RECIPE_DESC.HAT_MBUNNY = "  ,   ж   Ŀ  (Ҽ)"

STRINGS.CHARACTERS.GENERIC.DESCRIBE.HAT_MBUNNY = ""
STRINGS.NAMES.ARMOR_MUSHAA = "MushaĿ"
STRINGS.RECIPE_DESC.ARMOR_MUSHAA = "   ,  "
STRINGS.CHARACTERS.GENERIC.DESCRIBE.ARMOR_MUSHAA = "ҵ."
STRINGS.NAMES.ARMOR_MUSHAB = "Ŀ"
STRINGS.RECIPE_DESC.ARMOR_MUSHAB = "  ,    ,    "
STRINGS.CHARACTERS.GENERIC.DESCRIBE.ARMOR_MUSHAB = "!!һ" 

STRINGS.PHOENIXS=
{
    --random
    "Yamche",
    "Brave Yamche",
    "Cuty Yamche",
    "Owl Yamche",
    "Sunny Yamche",
    "Moon Yamche",
    "Seoul Yamche",
    "Suri Yamche",
    "Vilja Yamche",
    "Sunny Yamche",
    "Sunnyholic",
    "Musha Yamche",
    "Mellisa Yamche",
    "Lidia Yamche ",
    "Battleborn Yamche ",
    "Grey Yamche",
    "Sky Yamche",
    "Lucia Yamche",
    "Khajit Yamche",
    "Pig Yamche",
    "Mjoll Yamche",
    "Lioness Yamche",
    "Muiri Yamche",
    "Ysolda Yamche",
    "Rayya Yamche",
    "Falkas Yamche",
    "Vilkas Yamche",
    "Aela Yamche",
    "Huter Yamche",
    "Huntress Yamche",
    "Queen Yamche",
    "Fire Yamche",
    "Cicero Yamche",
    "Top Yamche",
    "Lina Yamche",
    "Totoro Yamche",
    "Yu-na Yamche",
    "Winter Yamche",
    "White Yamche",
    "Mellisa Yamche",
    "Riften Yamche",
    "Dawnstar Yamche",
    "Windhelm Yamche",
    "Pho Yamche",
    "Sneaky Yamche",
    "Kiwis Yamche",
    "Coco Yamche",
    "Moon Yamche",
    "Pizza Yamche",
    "Sugar Yamche",
    "Orc Yamche",
    "Elf Yamche",
    "Knight Yamche",
    "Lich Yamche",
    "Azeroth Yamche",
    "Tauren Yamche",
    "Troll Yamche",
    "Thrall Yamche",
    "Narugar Yamche",
    "Yancook Yamche",
    "Tirano Yamche",
    "Honey Yamche",
    "Isis Yamche",
    "Bosom Yamche",
    "Esmeralda Yamche",
    "Pluvia Yamche",
	"Doraemon Yamche",
	"Dooly Yamche",
	"Apple Yamche",
	"IU Yamche",
    "Gandalf Yamche",
    "Frodo Yamche",
    "Sam Yamche",
    "Regolas Yamche",
    "Gimli Yamche",
    "Boromir Yamche",

	
    --Orizinal
    "Wilxon Yamche",
    "Willo Yamche",
    "Wolfkong Yamche",
    "Wenil Yamche",
    "WX79 Yamche",
    "Wickerbi Yamche",
    "Woorie Yamche",
    "Wex Yamche",
    "Maximus Yamche",
    "Wigfreedom Yamche",
    "Webbers Yamche",
}

------------------------------


ACTIONS.STAYORDER = GLOBAL.Action(2, true, true)
ACTIONS.STAYORDER.fn = function(act)
local targ = act.target
	if targ and targ.components.staycommand then
		act.doer.components.locomotor:Stop()
		act.doer.components.talker:Say(GLOBAL.GetString(act.doer.prefab, "ANNOUNCE_STAYORDER"))
		targ.components.combat:GiveUp()
		targ.components.staycommand:SetStaying(true)
		targ.components.staycommand:RememberStayPos("stayspot", GLOBAL.Point(targ.Transform:GetWorldPosition())) 
	return true
	end
end
ACTIONS.STAYORDER.str = STRINGS.ACTIONS.STAYORDER
ACTIONS.STAYORDER.id = "STAYORDER"
ACTIONS.STAYORDER_CANCEL = GLOBAL.Action(2, true, true)
ACTIONS.STAYORDER_CANCEL.fn = function(act)
	local targ = act.target
	if targ and targ.components.staycommand then
	act.doer.components.locomotor:Stop()
		act.doer.components.talker:Say(GLOBAL.GetString(act.doer.prefab, "ANNOUNCE_STAYORDER_CANCEL"))
		targ.components.staycommand:SetStaying(false)

		return true
	end
end

if Hide == "enable" then
ACTIONS.BLINK.str = STRINGS.ACTIONS.BLINK 
ACTIONS.BLINK.id = "BLINK"
ACTIONS.CASTSPELL.str = STRINGS.ACTIONS.CASTSPELL
ACTIONS.CASTSPELL.id = "CASTSPELL"

STRINGS.ACTIONS.BLINK = ""
STRINGS.ACTIONS.CASTSPELL = ""
end

ACTIONS.STAYORDER_CANCEL.str = STRINGS.ACTIONS.STAYORDER_CANCEL
ACTIONS.STAYORDER_CANCEL.id = "STAYORDER_CANCEL"

STRINGS.ACTIONS.STAYORDER = ""
STRINGS.ACTIONS.STAYORDER_CANCEL = ""
STRINGS.CHARACTERS.GENERIC.ANNOUNCE_STAYORDER = "."
STRINGS.CHARACTERS.GENERIC.ANNOUNCE_STAYORDER_CANCEL = "."


------working DIALOGUE---
STRINGS.CHARACTERS.MUSHA =require "speech_musha"
--STRINGS.CHARACTERS.MUSHA =require "speech_willow"


function arms(inst)
        inst:AddTag("arm")
end
AddPrefabPostInit("tentacle_pillar_arm", arms)


------------
AddMinimapAtlas("images/musha.xml")
AddMinimapAtlas("images/mushas.xml")
AddMinimapAtlas("images/inventoryimages/musha_egg8.xml")
AddMinimapAtlas("images/inventoryimages/musha_egg_cracked8.xml")
AddMinimapAtlas("images/inventoryimages/musha_egg.xml")
AddMinimapAtlas("images/inventoryimages/musha_egg_cracked.xml")
AddMinimapAtlas("images/inventoryimages/musha_egg1.xml")
AddMinimapAtlas("images/inventoryimages/musha_egg_cracked1.xml")
AddMinimapAtlas("images/inventoryimages/musha_egg2.xml")
AddMinimapAtlas("images/inventoryimages/musha_egg_cracked2.xml")
AddMinimapAtlas("images/inventoryimages/musha_egg3.xml")
AddMinimapAtlas("images/inventoryimages/musha_egg_cracked3.xml")
AddMinimapAtlas("images/inventoryimages/musha_eggs1.xml")
AddMinimapAtlas("images/inventoryimages/musha_egg_crackeds1.xml")
AddMinimapAtlas("images/inventoryimages/musha_eggs2.xml")
AddMinimapAtlas("images/inventoryimages/musha_egg_crackeds2.xml")
AddMinimapAtlas("images/inventoryimages/musha_eggs3.xml")
AddMinimapAtlas("images/inventoryimages/musha_egg_crackeds3.xml")
AddMinimapAtlas("images/inventoryimages/musha_small.xml")
AddMinimapAtlas("images/inventoryimages/musha_teen.xml")
AddMinimapAtlas("images/inventoryimages/musha_tall.xml")
AddMinimapAtlas("images/inventoryimages/frosthammer.xml")
AddMinimapAtlas("images/inventoryimages/frostback.xml")
AddMinimapAtlas("images/inventoryimages/broken_frosthammer.xml")
AddMinimapAtlas("images/inventoryimages/mushasword_base.xml")
AddMinimapAtlas("images/inventoryimages/mushasword.xml")
AddMinimapAtlas("images/inventoryimages/mushasword2.xml")
AddMinimapAtlas("images/inventoryimages/mushasword3.xml")
AddMinimapAtlas("images/inventoryimages/mushasword4.xml")
AddMinimapAtlas("images/inventoryimages/blade_f.xml")
AddMinimapAtlas("images/inventoryimages/blade_b.xml")
AddMinimapAtlas("images/inventoryimages/blade_1.xml")
AddMinimapAtlas("images/inventoryimages/blade_2.xml")
AddMinimapAtlas("images/inventoryimages/blade_3.xml")
AddMinimapAtlas("images/inventoryimages/blade_4.xml")
AddMinimapAtlas("images/inventoryimages/cristal.xml")
AddMinimapAtlas("images/inventoryimages/exp.xml")

-----------

--level?
-- KEY_C
level_info = function() 
	local player = GLOBAL.GetPlayer()
	local max_exp = 99997000
	local exp = math.min(player.level, max_exp)
	player.components.talker:Say("[һ: ] \n ǰ ".. (player.level))
	player:AddTag("levelinfo") 
			if player.level <5 then
player.components.talker:Say("ȼ 1 \nһ :[5]\n ǰ ".. (player.level))
			elseif player.level >=5 and player.level <9  then
player.components.talker:Say("ȼ 2 \nһ :[10]\n ǰ ".. (player.level))
			elseif player.level >=10 and player.level <29  then
player.components.talker:Say("ȼ 3 \nһ :[30]\n ǰ ".. (player.level))
			elseif player.level >=30 and player.level <49  then
player.components.talker:Say("ȼ 4 \nһ :[50]\n ǰ ".. (player.level))
			elseif player.level >=50 and player.level <79  then
player.components.talker:Say("ȼ 5 \nһ :[80]\n ǰ ".. (player.level))
			elseif player.level >=80 and player.level <124  then
player.components.talker:Say("ȼ 6 \nһ :[125]\n ǰ ".. (player.level))
			elseif player.level >=125 and player.level <199  then
player.components.talker:Say("ȼ 7 \nһ :[200]\n ǰ ".. (player.level))
			elseif player.level >=200 and player.level <339  then
player.components.talker:Say("ȼ 8 \nһ :[340]\n ǰ ".. (player.level))
			elseif player.level >=340 and player.level <429  then
player.components.talker:Say("ȼ 9 \nһ :[430]\n ǰ ".. (player.level))
			elseif player.level >=430 and player.level <529  then
player.components.talker:Say("ȼ 10 \nһ :[530]\n ǰ ".. (player.level))
			elseif player.level >=530 and player.level <639  then
player.components.talker:Say("ȼ 11 \nһ :[640]\n ǰ ".. (player.level))
			elseif player.level >=640 and player.level <759  then
player.components.talker:Say("ȼ 12 \nһ :[760]\n ǰ ".. (player.level))
			elseif player.level >=760 and player.level <889  then
player.components.talker:Say("ȼ 13 \nһ :[890]\n ǰ ".. (player.level))
			elseif player.level >=890 and player.level <1029  then
player.components.talker:Say("ȼ 14 \nһ :[1030]\n ǰ ".. (player.level))
			elseif player.level >=1030 and player.level <1179  then
player.components.talker:Say("ȼ 15 \nһ :[1180]\n ǰ ".. (player.level))
			elseif player.level >=1180 and player.level <1339  then
player.components.talker:Say("ȼ 16 \nһ :[1340]\n ǰ ".. (player.level))
			elseif player.level >=1340 and player.level <1509  then
player.components.talker:Say("ȼ 17 \nһ :[1510]\n ǰ ".. (player.level))
			elseif player.level >=1510 and player.level <1689  then
player.components.talker:Say("ȼ 18 \nһ :[1690]\n ǰ ".. (player.level))
			elseif player.level >=1690 and player.level <1879  then
player.components.talker:Say("ȼ 19 \nһ :[1880]\n ǰ ".. (player.level))
			elseif player.level >=1880 and player.level <2079  then
player.components.talker:Say("ȼ 20 \nһ :[2080]\n ǰ ".. (player.level))
			elseif player.level >=2080 and player.level <2289  then
player.components.talker:Say("ȼ 21 \nһ :[2289]\n ǰ ".. (player.level))
			elseif player.level >=2290 and player.level <2499  then
player.components.talker:Say("ȼ 22 \nһ :[2500]\n ǰ ".. (player.level))
			elseif player.level >=2500 and player.level <2849  then
player.components.talker:Say("ȼ 23 \nһ :[2850]\n ǰ ".. (player.level))
			elseif player.level >=2850 and player.level <3199  then
player.components.talker:Say("ȼ 24 \nһ :[3200]\n ǰ ".. (player.level))
			elseif player.level >=3200 and player.level <3699  then
player.components.talker:Say("ȼ 25 \nһ :[3700]\n ǰ ".. (player.level))
			elseif player.level >=3700 and player.level <4199  then
player.components.talker:Say("ȼ 26 \nһ :[4200]\n ǰ ".. (player.level))
			elseif player.level >=4200 and player.level <4699  then
player.components.talker:Say("ȼ 27 \nһ :[4700]\n ǰ ".. (player.level))
			elseif player.level >=4700 and player.level <5499 then
player.components.talker:Say("ȼ 28 \nһ :[5500]\n ǰ ".. (player.level))
			elseif player.level >=5500 and player.level <6999 then
player.components.talker:Say("ȼ 29 \nһ :[7000]\n ǰ ".. (player.level))
			elseif player.level >=7000  then
player.components.talker:Say("ȼ 30 \n[]\n ǰ ".. (player.level))
end
end

--config SKILL hotkey 
if LEVELS == "R" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_R, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		level_info()

	end
	end
end)
end
if LEVELS == "T" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_T, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		level_info()

	end
	end
end)
end
if LEVELS == "Y" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_Y, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		level_info()

	end
	end
end)
end
if LEVELS == "U" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_U, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		level_info()

	end
	end
end)
end
if LEVELS == "G" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_G, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		level_info()

	end
	end
end)
end
if LEVELS == "H" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_H, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		level_info()

	end
	end
end)
end
if LEVELS == "J" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_J, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		level_info()

	end
	end
end)
end
if LEVELS == "Z" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_Z, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		level_info()

	end
	end
end)
end
if LEVELS == "X" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_X, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		level_info()

	end
	end
end)
end
if LEVELS == "C" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_C, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		level_info()

	end
	end
end)
end
if LEVELS == "V" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_V, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		level_info()

	end
	end
end)
end
if LEVELS == "B" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_B, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		level_info()

	end
	end
end)
end
if LEVELS == "N" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_N, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		level_info()

	end
	end
end)
end

---skill?
--default key = X
-----------
skill_info = function() 
	local player = GLOBAL.GetPlayer()
	local max_exp = 99997000
	local exp = math.min(player.level, max_exp)
	--player.components.talker:Say("[һ: ] \n ǰ ".. (player.level))
			if player.level >=0 and player.level <=4 then
	player.components.talker:Say("[ǰ] \n\nȮ [J]")
			elseif player.level >4 and player.level <10 then
	player.components.talker:Say("[ǰ] \n\nȮ [J]\n [1/3]\n绤 [1/4] \n\n")
			elseif player.level >10 and player.level <30  then
	player.components.talker:Say("[ǰ] \n\nȮ [J]\n [1/3]\nŮ״̬ [V] \n绤 [1/4] \n\n")
			elseif player.level >=30 and player.level <50  then
	player.components.talker:Say("[ǰ] \n\nȮ [J]\n [1/3]\nŮ״̬ [V] \n绤 [1/4] \nһ [1/4] \n\n")
			elseif player.level >=50 and player.level <80  then
	player.components.talker:Say("[ǰ] \n\nȮ [J]\n [1/3]\nŮ״̬ [V] \n绤 [1/4] \n繥 [1/2] \nһ [1/4] \n\n")
			elseif player.level >=80 and player.level <124  then
	player.components.talker:Say("[ǰ] \n\nȮ [J]\n [1/3]\nŮ״̬ [V] \n绤 [1/4] \nС[1/2] \n繥 [1/2] \nһ [1/4] \n\n")
			elseif player.level >=125 and player.level <200  then
	player.components.talker:Say("[ǰ] \n\nȮ [J]\n [1/3]\nŮ״̬ [V] \n״̬ [1/1] \n绤 [1/4] \nС[1/2] \n繥 [1/2] \nһ [1/4] \n\n")
			elseif player.level >=200 and player.level <340  then
	player.components.talker:Say("[ǰ] \n\nȮ [J]\n [1/3]\nŮ״̬ [V] \n״̬ [1/1] \n绤 [1/4] \n滤 [1/4] \nС[1/2] \n繥 [1/2] \nһ [1/4] \n\n")
			elseif player.level >=340 and player.level <430  then
	player.components.talker:Say("[ǰ] \n\nȮ [J]\n [1/3]\nŮ״̬ [V] \n״̬ [1/1] \n绤 [1/4] \n滤 [1/4] \nѪظ [1/4] \nС[1/2] \n繥 [1/2] \nһ [1/4]\n\n")
			elseif player.level >=430 and player.level <530  then
	player.components.talker:Say("[ǰ] \n\nȮ [J]\n [1/3]\nŮ״̬ [V] \n״̬ [1/1] \n绤 [1/4] \n滤 [1/4] \nѪظ [1/4] \nС[1/2] \n繥 [1/2] \nһ [1/4] \n [1/3] \nṥ [1/4] \n\n")
			elseif player.level >=530 and player.level <640  then
	player.components.talker:Say("[ǰ] \n\nȮ [J]\n [1/3]\nŮ״̬ [V] \n״̬ [1/1] \n绤 [1/4] \n滤 [1/4] \nѪظ [1/4] \nС[1/2] \n繥 [1/2] \nһ [2/4] \n [1/3] \nṥ [1/4] \n\n")
			elseif player.level >=640 and player.level <760  then
	player.components.talker:Say("[ǰ] \n\nȮ [J]\n [1/3]\nŮ״̬ [V] \n״̬ [1/1] \n绤 [1/4] \n滤 [1/4] \nѪظ [1/4] \nС[1/2] \n繥 [1/2] \nһ [3/4] \n [1/3] \nṥ [1/4] \n\n")
			elseif player.level >=760 and player.level <890  then
	player.components.talker:Say("[ǰ] \n\nȮ [J]\n [1/3]\nŮ״̬ [V] \n״̬ [1/1] \n绤 [1/4] \n滤 [1/4] \nѪظ [1/4] \nС[1/2] \n繥 [1/2] \nһ [4/4] \n [1/3] \nṥ [1/4] \n\n")
			elseif player.level >=890 and player.level <1030  then
	player.components.talker:Say("[ǰ] \n\nȮ [J]\n [1/3]\nŮ״̬ [V] \n״̬ [1/1] \n绤 [2/4] \n滤 [1/4] \nѪظ [1/4] \nС[1/2] \n繥 [1/2] \nһ [4/4] \n [1/3] \nṥ [1/4] \n\n")
			elseif player.level >=1030 and player.level <1180  then
	player.components.talker:Say("[ǰ] \n\nȮ [J]\n [1/3]\nŮ״̬ [V] \n״̬ [1/1] \n绤 [3/4] \n滤 [1/4] \nѪظ [1/4] \nС[1/2] \n繥 [1/2] \nһ [4/4] \n [1/3] \nṥ [1/4] \n\n")
			elseif player.level >=1180 and player.level <1340  then
	player.components.talker:Say("[ǰ] \n\nȮ [J]\n [1/3]\nŮ״̬ [V] \n״̬ [1/1] \n绤 [4/4] \n滤 [1/4] \nѪظ [1/4] \nС[1/2] \n繥 [1/2] \nһ [4/4] \n [1/3] \nṥ [1/4] \n\n")
			elseif player.level >=1340 and player.level <1510  then
	player.components.talker:Say("[ǰ] \n\nȮ [J]\n [1/3]\nŮ״̬ [V] \n״̬ [1/1] \n绤 [4/4] \n滤 [1/4] \nѪظ [1/4] \nС[2/2] \n繥 [1/2] \nһ [4/4] \n [1/3] \nṥ [1/4] \n\n")
			elseif player.level >=1510 and player.level <7690  then
	player.components.talker:Say("[ǰ] \n\nȮ [J]\n [1/3]\nŮ״̬ [V] \n״̬ [1/1] \n绤 [4/4] \n滤 [1/4] \nѪظ [1/4] \nС[2/2] \n繥 [1/2] \nһ [4/4] \n [1/3] \nṥ [2/4] \n\n")
			elseif player.level >=1690 and player.level <1880  then
	player.components.talker:Say("[ǰ] \n\nȮ [J]\n [1/3]\nŮ״̬ [V] \n״̬ [1/1] \n绤 [4/4] \n滤 [1/4] \nѪظ [1/4] \nС[2/2] \n繥 [1/2] \nһ [4/4] \n [1/3] \nṥ [3/4] \n\n")
			elseif player.level >=1880 and player.level <2080  then
	player.components.talker:Say("[ǰ] \n\nȮ [J]\n [1/3]\nŮ״̬ [V] \n״̬ [1/1] \n绤 [4/4] \n滤 [1/4] \nѪظ [1/4] \nС[2/2] \n繥 [1/2] \nһ [4/4] \n [1/3] \nṥ [4/4] \n\n")
			elseif player.level >=2080 and player.level <2290  then
	player.components.talker:Say("[ǰ] \n\nȮ [J]\n [1/3]\nŮ״̬ [V] \n״̬ [1/1] \n绤 [4/4] \n滤 [1/4] \nѪظ [2/4] \nС[2/2] \n繥 [1/2] \nһ [4/4] \n [1/3] \nṥ [4/4] \n\n")
			elseif player.level >=2290 and player.level <2500  then
	player.components.talker:Say("[ǰ] \n\nȮ [J]\n [1/3]\nŮ״̬ [V] \n״̬ [1/1] \n绤 [4/4] \n滤 [1/4] \nѪظ [3/4] \nС[2/2] \n繥 [1/2] \nһ [4/4] \n [1/3] \nṥ [4/4] \n\n")
			elseif player.level >=2500 and player.level <2850  then
	player.components.talker:Say("[ǰ] \n\nȮ [J]\n [1/3]\nŮ״̬ [V] \n״̬ [1/1] \n绤 [4/4] \n滤 [2/4] \nѪظ [3/4] \nС[2/2] \n繥 [1/2] \nһ [4/4] \n [2/3] \nṥ [4/4] \n\n")
			elseif player.level >=2850 and player.level <3200  then
	player.components.talker:Say("[ǰ] \n\nȮ [J]\n [1/3]\nŮ״̬ [V] \n״̬ [1/1] \n绤 [4/4] \n滤 [3/4] \nѪظ [3/4] \nС[2/2] \n繥 [1/2] \nһ [4/4] \n [2/3] \nṥ [4/4] \n\n")
			elseif player.level >=3200 and player.level <3700  then
	player.components.talker:Say("[ǰ] \n\nȮ [J]\n [1/3]\nŮ״̬ [V] \n״̬ [1/1] \n绤 [4/4] \n滤 [4/4] \nѪظ [3/4] \nС[2/2] \n繥 [1/2] \nһ [4/4] \n [2/3] \nṥ [4/4] \n\n")
			elseif player.level >=3700 and player.level <4200  then
	player.components.talker:Say("[ǰ] \n\nȮ [J]\n [2/3]\nŮ״̬ [V] \n״̬ [1/1] \n绤 [4/4] \n滤 [4/4] \nѪظ [3/4] \nС[2/2] \n繥 [1/2] \nһ [4/4] \n [2/3] \nṥ [4/4] \n\n")
			elseif player.level >=4200 and player.level <4700  then
	player.components.talker:Say("[ǰ] \n\nȮ [J]\n [3/3]\nŮ״̬ [V] \n״̬ [1/1] \n绤 [4/4] \n滤 [4/4] \nѪظ [3/4] \nС[2/2] \n繥 [1/2] \nһ [4/4] \n [2/3] \nṥ [4/4] \n\n")
			elseif player.level >=4700 and player.level <5500 then
	player.components.talker:Say("[ǰ] \n\nȮ [J]\n [3/3]\nŮ״̬ [V] \n״̬ [1/1] \n绤 [4/4] \n滤 [4/4] \nѪظ [3/4] \nС[2/2] \n繥 [1/2] \nһ [4/4] \n [2/3] \nṥ [4/4] \n񱩻 [1/1] \n\n")
			elseif player.level >=5500 and player.level <7000 then
	player.components.talker:Say("[ǰ] \n\nȮ [J]\n [3/3]\nŮ״̬ [V] \n״̬ [1/1] \n绤 [4/4] \n滤 [4/4] \nѪظ [4/4] \nС[2/2] \n繥 [1/2] \nһ [4/4] \n [2/3] \nṥ [4/4] \n񱩻 [1/1] \n\n")
			elseif player.level >=7000  then
	player.components.talker:Say("[ǰ] \n\nȮ [J]\n [3/3]\nŮ״̬ [V] \n״̬ [1/1] \n绤 [4/4] \n滤 [4/4] \nѪظ [4/4] \nС[2/2] \n繥 [2/2] \nһ [4/4] \n [3/3] \nṥ [4/4] \n񱩻 [1/1] \nӰ [H] \n\n")
end
end

--config SKILL hotkey 
if SKILLS == "R" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_R, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_info()

	end
	end
end)
end
if SKILLS == "T" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_T, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_info()

	end
	end
end)
end
if SKILLS == "Y" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_Y, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_info()

	end
	end
end)
end
if SKILLS == "U" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_U, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_info()

	end
	end
end)
end
if SKILLS == "G" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_G, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_info()

	end
	end
end)
end
if SKILLS == "H" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_H, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_info()

	end
	end
end)
end
if SKILLS == "J" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_J, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_info()

	end
	end
end)
end
if SKILLS == "Z" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_Z, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_info()

	end
	end
end)
end
if SKILLS == "X" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_X, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_info()

	end
	end
end)
end
if SKILLS == "C" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_C, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_info()

	end
	end
end)
end
if SKILLS == "V" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_V, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_info()

	end
	end
end)
end
if SKILLS == "B" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_B, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_info()

	end
	end
end)
end
if SKILLS == "N" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_N, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_info()

	end
	end
end)
end


----active skill -lightning

skill_lightning = function() 
	local player = GLOBAL.GetPlayer()

	if player:HasTag("Valkyrieh") and player:HasTag("lightningo1") and not player:HasTag("lightningblue1") and not player:HasTag("frosthammer") and not player:HasTag("phoenixblade") and player.components.sanity.current >= 30 then
	player.components.talker:Say("[繥]")
		player:AddTag("lightningblue1")
	player.components.combat:SetRange(9)
	player.Light:Enable(true)
player.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )
player.Light:Enable(true)
player:RemoveTag("lightningo1") 

	elseif player:HasTag("Valkyrieh") and player:HasTag("lightningo2") and not player:HasTag("lightningblue2") and not player:HasTag("frosthammer") and not player:HasTag("phoenixblade") and player.components.sanity.current >= 30 then

	player.components.talker:Say("[繥]")
		player:AddTag("lightningblue2")
	player.components.combat:SetRange(9)
	player.Light:Enable(true)
player.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )
player.Light:Enable(true)
player:RemoveTag("lightningo2") 

----
	elseif player:HasTag("Valkyrieh") and player:HasTag("lightningo1") and not player:HasTag("lightningblue1") and player:HasTag("frosthammer") and not player:HasTag("frosta") and player.components.sanity.current >= 30 then
	player.components.talker:Say("[˪]")
		player:AddTag("lightningblue1")
		player:AddTag("frosta")
	player.components.combat:SetRange(9)
	player.Light:Enable(true)
player.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )
player.Light:Enable(true)
player:RemoveTag("lightningo2") 

	elseif player:HasTag("Valkyrieh") and player:HasTag("lightningo2") and not player:HasTag("lightningblue2") and player:HasTag("frosthammer") and not player:HasTag("frosta") and player.components.sanity.current >= 30 then
	player.components.talker:Say("[˪]")
		player:AddTag("lightningblue2")
		player:AddTag("frosta")
	player.components.combat:SetRange(9)
	player.Light:Enable(true)
player.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )
player.Light:Enable(true)
player:RemoveTag("lightningo2") 

----
	elseif player:HasTag("Valkyrieh") and player:HasTag("lightningo1") and not player:HasTag("lightningblue1") and player:HasTag("phoenixblade") and not player:HasTag("framea") and player.components.sanity.current >= 30 then
	player.components.talker:Say("[湥]")
		player:AddTag("lightningblue1")
		player:AddTag("framea")
	player.components.combat:SetRange(9)
	player.Light:Enable(true)
player.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )
player:RemoveTag("lightningo2") 

	elseif player:HasTag("Valkyrieh") and player:HasTag("lightningo2") and not player:HasTag("lightningblue2") and player:HasTag("phoenixblade") and not player:HasTag("framea") and player.components.sanity.current >= 30 then
	player.components.talker:Say("[湥]")
		player:AddTag("lightningblue2")
		player:AddTag("framea")
	player.components.combat:SetRange(9)
	player.Light:Enable(true)
player.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )
player:RemoveTag("lightningo2") 

----
	elseif player:HasTag("Valkyrieh") and player.components.sanity.current < 30 then
	player.components.talker:Say("û㹻 [SAN] !")

	elseif player:HasTag("Valkyrieh") and not player:HasTag("lightningo1") and player:HasTag("lightningblue1") then
	player.components.talker:Say("繥׼!")

	elseif player:HasTag("Valkyrieh") and not player:HasTag("lightningo2") and player:HasTag("lightningblue2") then
	player.components.talker:Say("繥׼!")

	elseif player:HasTag("Valkyrieh") and not player:HasTag("lightningo1") and not player:HasTag("lightningblue1") and not player:HasTag("lightningo2") and not player:HasTag("lightningblue2") then
	player.components.talker:Say("û㹻..")

elseif not player:HasTag("Valkyrieh") and not player:HasTag("frosthammer") and not player:HasTag("phoenixblade") then
	player.components.talker:Say("[繥]ֻŮ״̬ʹ..")

------
elseif player:HasTag("frosthammer") and not player:HasTag("frosta") and not player:HasTag("Valkyrieh") and player.components.sanity.current > 20 then
		player:AddTag("frosta")
	player.components.talker:Say("˪֮!!")

elseif player:HasTag("frosthammer") and not player:HasTag("frosta") and not player:HasTag("Valkyrieh") and player.components.sanity.current < 20 then
	player.components.talker:Say("û㹻 [SAN]..")

elseif player:HasTag("frosthammer") and not player:HasTag("Valkyrieh") and player:HasTag("frosta") then
	player.components.talker:Say("˪֮׼!!")

elseif player:HasTag("frosthammer") and player:HasTag("Valkyrieh") and player:HasTag("frosta") and not player:HasTag("lightningblue1") and not player:HasTag("lightningblue2") then
	player.components.talker:Say("˪֮׼!!")

------
elseif player:HasTag("phoenixblade") and not player:HasTag("framea") and not player:HasTag("Valkyrieh") and player.components.sanity.current > 20 then
		player:AddTag("framea")
	player.components.talker:Say("˽!!")

elseif player:HasTag("phoenixblade") and not player:HasTag("framea") and not player:HasTag("Valkyrieh") and player.components.sanity.current < 20 then
	player.components.talker:Say("û㹻 [SAN]..")

elseif player:HasTag("phoenixblade") and not player:HasTag("Valkyrieh") and player:HasTag("framea") then
	player.components.talker:Say("֮׼!!")

elseif player:HasTag("phoenixblade") and not player:HasTag("Valkyrieh") and player:HasTag("framea") and not player:HasTag("lightningblue1") and not player:HasTag("lightningblue2") then
	player.components.talker:Say("֮׼!!")

end
end

--config SPECIAL ATTACK hotkey 
if LIGHTNING == "R" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_R, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_lightning()

	end
	end
end)
end
if LIGHTNING == "T" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_T, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_lightning()

	end
	end
end)
end
if LIGHTNING == "Y" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_Y, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_lightning()

	end
	end
end)
end
if LIGHTNING == "U" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_U, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_lightning()

	end
	end
end)
end
if LIGHTNING == "G" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_G, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_lightning()

	end
	end
end)
end
if LIGHTNING == "H" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_H, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_lightning()

	end
	end
end)
end
if LIGHTNING == "J" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_J, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_lightning()

	end
	end
end)
end
if LIGHTNING == "Z" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_Z, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_lightning()

	end
	end
end)
end
if LIGHTNING == "X" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_X, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_lightning()

	end
	end
end)
end
if LIGHTNING == "C" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_C, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_lightning()

	end
	end
end)
end
if LIGHTNING == "V" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_V, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_lightning()

	end
	end
end)
end
if LIGHTNING == "B" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_B, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_lightning()

	end
	end
end)
end
if LIGHTNING == "N" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_N, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_lightning()

	end
	end
end)
end


----active skill -shield
--default key = T

skill_cure = function() 
	local player = GLOBAL.GetPlayer()

if player:HasTag("cure0") and not player:HasTag("cure1") and not player:HasTag("cure2") and player:HasTag("cureoo0") and not player:HasTag("shieldon") and not player.components.health:IsDead() then

	--player.components.talker:Say("[]")
		player:AddTag("cureo0")
		player:AddTag("frameon1")
		player:AddTag("frameon2")
		player:AddTag("frameon3")
		player:AddTag("frameon4")

elseif player:HasTag("cure1") and not player:HasTag("cure0") and not player:HasTag("cure2") and player:HasTag("cureoo1") and not player:HasTag("shieldon") and not player.components.health:IsDead() then

	--player.components.talker:Say("[]")
		player:AddTag("cureo1")
		player:AddTag("frameon1")
		player:AddTag("frameon2")
		player:AddTag("frameon3")
		player:AddTag("frameon4")

elseif player:HasTag("cure2") and not player:HasTag("cure0") and not player:HasTag("cure1") and player:HasTag("cureoo2") and not player:HasTag("shieldon") and not player.components.health:IsDead() then

	--player.components.talker:Say("[]")
		player:AddTag("cureo2")
		player:AddTag("frameon1")
		player:AddTag("frameon2")
		player:AddTag("frameon3")
		player:AddTag("frameon4")

elseif player:HasTag("cure0") and not player:HasTag("cure1") and not player:HasTag("cure2") and not player:HasTag("cureoo0") then
	player.components.talker:Say("û㹻..")
elseif player:HasTag("cure1") and not player:HasTag("cure0") and not player:HasTag("cure2") and not player:HasTag("cureoo1") then
	player.components.talker:Say("û㹻..")
elseif player:HasTag("cure2") and not player:HasTag("cure0") and not player:HasTag("cure1") and not player:HasTag("cureoo2") then
	player.components.talker:Say("û㹻..")

elseif player:HasTag("shieldon") then
	player.components.talker:Say("׼!")

elseif not player:HasTag("cure0") and not player:HasTag("cure1") and not player:HasTag("cure2")  then
	player.components.talker:Say("Mushaûѧ..")

end
if player:HasTag("cureo0") or player:HasTag("cureo1") or player:HasTag("cureo2") and not player.components.health:IsDead() then
	if player:HasTag("hpregen1") then
	player.components.health:StartRegen(1, 0.5)

	elseif player:HasTag("hpregen2") then
	player.components.health:StartRegen(1, 0.25)

	elseif player:HasTag("hpregen3") then
	player.components.health:StartRegen(2, 0.25)

	elseif player:HasTag("hpregen4") then
	player.components.health:StartRegen(3, 0.25)

end
end
end

--config SHIELD hotkey 
if SHIELD == "R" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_R, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_cure()

	end
	end
end)
end
if SHIELD == "T" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_T, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_cure()

	end
	end
end)
end
if SHIELD == "Y" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_Y, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_cure()

	end
	end
end)
end
if SHIELD == "U" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_U, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_cure()

	end
	end
end)
end
if SHIELD == "G" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_G, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_cure()

	end
	end
end)
end
if SHIELD == "H" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_H, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_cure()

	end
	end
end)
end
if SHIELD == "J" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_J, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_cure()

	end
	end
end)
end
if SHIELD == "Z" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_Z, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_cure()

	end
	end
end)
end
if SHIELD == "X" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_X, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_cure()

	end
	end
end)
end
if SHIELD == "C" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_C, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_cure()

	end
	end
end)
end
if SHIELD == "V" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_V, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_cure()

	end
	end
end)
end
if SHIELD == "B" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_B, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_cure()

	end
	end
end)
end
if SHIELD == "N" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_N, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_cure()

	end
	end
end)
end

----active skill -Valkyrie
--default key = V

skill_valkyrie = function() 
	local player = GLOBAL.GetPlayer()

if player:HasTag("valkyrie") and not player:HasTag("valkyrieh") and not player:HasTag("berserks") and not player:HasTag("fberserk") then
		player:AddTag("Valkyrieh")
		player:RemoveTag("Valkyriech2")
		--player.components.talker:Say("Ůս !!")

elseif player:HasTag("valkyrie") and player:HasTag("valkyrieh") and not player:HasTag("berserks") and not player:HasTag("fberserk") then
		player:AddTag("Valkyriech2")
		player:RemoveTag("Valkyrieh")
		--player.components.talker:Say("")

elseif not player:HasTag("valkyrie") then
		player:RemoveTag("Valkyrieh")
	player.components.talker:Say("Mushaָ֪о..")
elseif player:HasTag("berserks") and not player:HasTag("fberserk") then
	player.components.talker:Say("Krrrrrr..?")
		player:RemoveTag("Valkyrieh")
elseif player:HasTag("fberserk") and not player:HasTag("berserks") then
	player.components.talker:Say("Grrrrrr..?")
		player:RemoveTag("Valkyrieh")

end
end


--config Valkyrie hotkey 
if VALKYRIE == "R" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_R, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_valkyrie()

	end
	end
end)
end
if VALKYRIE == "T" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_T, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_valkyrie()

	end
	end
end)
end
if VALKYRIE == "Y" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_Y, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_valkyrie()

	end
	end
end)
end
if VALKYRIE == "U" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_U, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_valkyrie()

	end
	end
end)
end
if VALKYRIE == "G" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_G, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_valkyrie()

	end
	end
end)
end
if VALKYRIE == "H" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_H, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_valkyrie()

	end
	end
end)
end
if VALKYRIE == "J" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_J, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_valkyrie()

	end
	end
end)
end
if VALKYRIE == "Z" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_Z, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_valkyrie()

	end
	end
end)
end
if VALKYRIE == "X" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_X, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_valkyrie()

	end
	end
end)
end
if VALKYRIE == "C" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_C, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_valkyrie()

	end
	end
end)
end
if VALKYRIE == "V" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_V, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_valkyrie()

	end
	end
end)
end
if VALKYRIE == "B" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_B, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_valkyrie()

	end
	end
end)
end
if VALKYRIE == "N" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_N, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_valkyrie()

	end
	end
end)
end


----active battle command yamche 
--default key = Y

follow_yamche = function() 
	local player = GLOBAL.GetPlayer()

    if  player:HasTag("yamche") and not player:HasTag("fightn") and not player:HasTag("berserks") and not player:HasTag("fberserk") then
		player:AddTag("fightn")
		player:AddTag("turns")
		player.components.talker:Say("Yamche, !")

elseif player:HasTag("yamche") and player:HasTag("fightn") then
		player:RemoveTag("fightn")
		player:AddTag("turns")
		player.components.talker:Say("Yamche, ս!")

elseif player:HasTag("yamche") and not player:HasTag("fightn") and player:HasTag("berserks") then
		player:AddTag("fightn")
		player:AddTag("turns")
		player.components.talker:Say("!, Krrr !")

elseif player:HasTag("yamche") and not player:HasTag("fightn") and player:HasTag("ferserk") then
		player:AddTag("fightn")
		player:AddTag("turns")
		player.components.talker:Say("!, Krrr !")

elseif not player:HasTag("yamche") then
	player.components.talker:Say("ҵYamche, ̫Զ..")

end
end

--config yamche hotkey 
if YAMCHO == "R" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_R, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		follow_yamche()

	end
	end
end)
end
if YAMCHO == "T" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_T, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		follow_yamche()

	end
	end
end)
end
if YAMCHO == "Y" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_Y, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		follow_yamche()

	end
	end
end)
end
if YAMCHO == "U" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_U, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		follow_yamche()

	end
	end
end)
end
if YAMCHO == "G" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_G, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		follow_yamche()

	end
	end
end)
end
if YAMCHO == "H" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_H, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		follow_yamche()

	end
	end
end)
end
if YAMCHO == "J" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_J, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		follow_yamche()

	end
	end
end)
end
if YAMCHO == "Z" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_Z, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		follow_yamche()

	end
	end
end)
end
if YAMCHO == "X" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_X, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		follow_yamche()

	end
	end
end)
end
if YAMCHO == "C" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_C, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		follow_yamche()

	end
	end
end)
end
if YAMCHO == "V" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_V, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		follow_yamche()

	end
	end
end)
end
if YAMCHO == "B" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_B, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		follow_yamche()

	end
	end
end)
end
if YAMCHO == "N" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_N, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		follow_yamche()

	end
	end
end)
end

----active shadows skill
--default key = H

skill_shadow= function() 
	local player = GLOBAL.GetPlayer()
    if player.level >= 7003 and not player:HasTag("valkyrieh") and player.components.sanity:GetMaxSanity() >= 50 and player.components.health.currenthealth >= 40 and player:HasTag("shadowb") and not player:HasTag("shadows") then
		player:AddTag("shadows")
		player.components.talker:Say("Ӱ! \n[](-2)")

elseif player.level < 7003 and not player:HasTag("valkyrieh") and player.components.sanity:GetMaxSanity() >= 50 and player:HasTag("shadowb") then
	player.components.talker:Say("û㹻 []..")

elseif player.level >= 7003 and not player:HasTag("valkyrieh") and player.components.sanity:GetMaxSanity() < 50 and player.components.health.currenthealth >= 40 and player:HasTag("shadowb") then
	player.components.talker:Say("û㹻 [SAN]..")

elseif player.level >= 7003 and not player:HasTag("valkyrieh") and player.components.sanity:GetMaxSanity() > 50 and player.components.health.currenthealth < 40 and player:HasTag("shadowb") then
	player.components.talker:Say("û㹻 [Ѫ]..")

elseif not player:HasTag("valkyrieh") and not player:HasTag("shadowb") then
	player.components.talker:Say("(Ӱ) 30")

--backstab
	elseif not player:HasTag("backstab1") and not player:HasTag("backstab2") and not player:HasTag("backstab3") then
	player.components.talker:Say("[](1/3) 10")
	elseif player:HasTag("backstab1") and not player:HasTag("sneaka") and player.components.sanity.current <= 80 then
	player.components.talker:Say("û㹻[SAN]..")
	elseif player:HasTag("backstab2") and not player:HasTag("sneaka") and player.components.sanity.current <= 160 then
	player.components.talker:Say("û㹻[SAN]..")
	elseif player:HasTag("backstab3") and not player:HasTag("sneaka") and player.components.sanity.current <= 240 then
	player.components.talker:Say("û㹻[SAN]..")

elseif player:HasTag("valkyrieh") and player:HasTag("backstab1") and not player:HasTag("sneaka") and not player.sg:HasStateTag("attack") and not player.sg:HasStateTag("moving") and player.components.sanity:GetMaxSanity() > 60 then
		player:AddTag("sneaka")
  player:AddTag("notarget")
	player.components.talker:Say("Ӱ !")
	player.components.colourtweener:StartTween({0.1,0.1,0.1,1}, 0)
	local fx = SpawnPrefab("statue_transition_2")
        fx.entity:SetParent(player.entity)
	fx.Transform:SetScale(1.2, 1.2, 1.2)
        fx.Transform:SetPosition(0, 0, 0)
   --	player.components.sanityaura.penalty = 80
   -- 	player.components.sanity:RecalculatePenalty()
         player.components.sanity:DoDelta(-80)

elseif player:HasTag("backstab1")  and player:HasTag("sneaka") then
		player:RemoveTag("sneaka")
  player:RemoveTag("hide")
        player:RemoveTag("notarget")
	player.components.talker:Say(" !")
	player.components.colourtweener:StartTween({1,1,1,1}, 0)
	local fx = SpawnPrefab("statue_transition_2")
        fx.entity:SetParent(player.entity)
	fx.Transform:SetScale(1.2, 1.2, 1.2)
        fx.Transform:SetPosition(0, 0, 0)
--	player.components.sanityaura.penalty = 0
 --   	player.components.sanity:RecalculatePenalty()
         player.components.sanity:DoDelta(80)

elseif player:HasTag("valkyrieh") and player:HasTag("backstab2") and not player:HasTag("sneaka") and not player.sg:HasStateTag("attack") and not player.sg:HasStateTag("moving") and player.components.sanity:GetMaxSanity() > 60 then

		player:AddTag("sneaka")
        player:AddTag("notarget")
	player.components.talker:Say("Ӱ !")
	player.components.colourtweener:StartTween({0.1,0.1,0.1,1}, 0)
	local fx = SpawnPrefab("statue_transition_2")
        fx.entity:SetParent(player.entity)
	fx.Transform:SetScale(1.2, 1.2, 1.2)
        fx.Transform:SetPosition(0, 0, 0)
         player.components.sanity:DoDelta(-160)

elseif player:HasTag("backstab2") and player:HasTag("sneaka") then
		player:RemoveTag("sneaka")
        player:RemoveTag("notarget")
	player.components.talker:Say(" !")
	player.components.colourtweener:StartTween({1,1,1,1}, 0)
	local fx = SpawnPrefab("statue_transition_2")
        fx.entity:SetParent(player.entity)
	fx.Transform:SetScale(1.2, 1.2, 1.2)
        fx.Transform:SetPosition(0, 0, 0)
         player.components.sanity:DoDelta(160)

elseif player:HasTag("valkyrieh") and player:HasTag("backstab3") and not player:HasTag("sneaka") and not player.sg:HasStateTag("attack") and not player.sg:HasStateTag("moving") and player.components.sanity:GetMaxSanity() > 60 then

		player:AddTag("sneaka")
        player:AddTag("notarget")
	player.components.talker:Say("Ӱ !")
	player.components.colourtweener:StartTween({0.1,0.1,0.1,1}, 0)
	local fx = SpawnPrefab("statue_transition_2")
        fx.entity:SetParent(player.entity)
	fx.Transform:SetScale(1.2, 1.2, 1.2)
        fx.Transform:SetPosition(0, 0, 0)
         player.components.sanity:DoDelta(-240)

elseif player:HasTag("backstab3")  and player:HasTag("sneaka") then
		player:RemoveTag("sneaka")
        player:RemoveTag("notarget")
	player.components.talker:Say(" !")
	player.components.colourtweener:StartTween({1,1,1,1}, 0)
	local fx = SpawnPrefab("statue_transition_2")
        fx.entity:SetParent(player.entity)
	fx.Transform:SetScale(1.2, 1.2, 1.2)
        fx.Transform:SetPosition(0, 0, 0)
         player.components.sanity:DoDelta(240)

end
end

if Shadow== "R" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_R, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_shadow()

	end
	end
end)
end
if Shadow== "T" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_T, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_shadow()

	end
	end
end)
end
if Shadow == "Y" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_Y, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_shadow()

	end
	end
end)
end
if Shadow == "U" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_U, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_shadow()

	end
	end
end)
end
if Shadow == "G" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_G, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_shadow()

	end
	end
end)
end
if Shadow == "H" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_H, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_shadow()

	end
	end
end)
end
if Shadow == "J" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_J, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_shadow()

	end
	end
end)
end
if Shadow == "Z" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_Z, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_shadow()

	end
	end
end)
end
if Shadow == "X" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_X, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_shadow()

	end
	end
end)
end
if Shadow == "C" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_C, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_shadow()

	end
	end
end)
end
if Shadow == "V" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_V, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_shadow()

	end
	end
end)
end
if Shadow == "B" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_B, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_shadow()

	end
	end
end)
end
if Shadow == "N" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_N, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_shadow()

	end
	end
end)
end

----active dog skill
--default key = J

skill_dogs= function() 
	local player = GLOBAL.GetPlayer()

    if player.components.health.currenthealth >= 40 and player:HasTag("ghoundb") and not player:HasTag("ghound") and not player:HasTag("ghounds") then
		player:AddTag("ghound")
		player.components.talker:Say("ԶŵĹ!")

elseif player:HasTag("ghounds") then
		player.components.talker:Say("ѾٻȮ..")

elseif player.components.health.currenthealth < 40 and player:HasTag("ghoundb") then
	player.components.talker:Say("û㹻 [Ѫ]..")

elseif not player:HasTag("ghoundb") then
	player.components.talker:Say("? ?..")

end
end
if Dogs == "R" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_R, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_dogs()

	end
	end
end)
end
if Dogs == "T" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_T, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_dogs()

	end
	end
end)
end
if Dogs == "Y" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_Y, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_dogs()

	end
	end
end)
end
if Dogs == "U" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_U, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_dogs()

	end
	end
end)
end
if Dogs == "G" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_G, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_dogs()

	end
	end
end)
end
if Dogs == "H" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_H, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_dogs()

	end
	end
end)
end
if Dogs == "J" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_J, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_dogs()

	end
	end
end)
end
if Dogs == "Z" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_Z, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_dogs()

	end
	end
end)
end
if Dogs == "X" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_X, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_dogs()

	end
	end
end)
end
if Dogs == "C" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_C, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_dogs()

	end
	end
end)
end
if Dogs == "V" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_V, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_dogs()

	end
	end
end)
end
if Dogs == "B" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_B, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_dogs()

	end
	end
end)
end
if Dogs == "N" then
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_N, function()
	local player = GLOBAL.GetPlayer()
	if player and player:HasTag("musha") then
		local TheInput = GLOBAL.TheInput

	if not GLOBAL.IsPaused() and not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) then
   
		skill_dogs()

	end
	end
end)
end


function gruefix(inst)
        inst:AddTag("gruef")
end

AddPrefabPostInit("grue", gruefix)

-------------comfortable DLC and ORIZINAL

function DLC(inst)
	--local player = GLOBAL.GetPlayer()
if GLOBAL.IsDLCEnabled(GLOBAL.REIGN_OF_GIANTS)then
      --  player:AddTag("DLC")
        inst:AddTag("DLC")

end
end
AddPrefabPostInit("musha", DLC)
AddPrefabPostInit("hat_mbunny", DLC)
--AddPrefabPostInit("musha_small", DLC)

function DLC_water(inst)
if GLOBAL.IsDLCEnabled(GLOBAL.REIGN_OF_GIANTS)then

    inst:AddComponent("waterproofer")
    inst.components.waterproofer.effectiveness = 0
    inst:AddComponent("insulator")
    inst.components.insulator:SetInsulation(TUNING.INSULATION_MED)
    inst.components.insulator:SetSummer()
end
end

function DLC_water2(inst)
if GLOBAL.IsDLCEnabled(GLOBAL.REIGN_OF_GIANTS)then

    inst:AddComponent("waterproofer")
    inst.components.waterproofer.effectiveness = 0
    inst:AddComponent("insulator")
    inst.components.insulator:SetInsulation(TUNING.INSULATION_MED)
end
end

function DLC_water3(inst)
if GLOBAL.IsDLCEnabled(GLOBAL.REIGN_OF_GIANTS)then

    inst:AddComponent("waterproofer")
    inst.components.waterproofer.effectiveness = 0
end
end

AddPrefabPostInit("frostback", DLC_water)
AddPrefabPostInit("broken_frosthammer", DLC_water)
AddPrefabPostInit("mushasword_frost", DLC_water)
AddPrefabPostInit("frosthammer", DLC_water)

AddPrefabPostInit("mushasword", DLC_water2)
AddPrefabPostInit("mushasword2", DLC_water2)
AddPrefabPostInit("mushasword3", DLC_water2)
AddPrefabPostInit("mushasword4", DLC_water2)

AddPrefabPostInit("armor_mushab", DLC_water2)

AddPrefabPostInit("hat_mphoenix", DLC_water3)
AddPrefabPostInit("hat_mprincess", DLC_water3)
AddPrefabPostInit("hat_mcrown", DLC_water3)



-------------comfortable RPG HUD
local RPGActive = 0
for _, moddir in ipairs(GLOBAL.KnownModIndex:GetModsToLoad()) do
    if GLOBAL.KnownModIndex:GetModInfo(moddir).name == "RPG HUD" then
		RPGActive = 1
    end
end

if RPGActive == 1 then
-- frostback
local function frostbackpostinit(inst)
	inst.components.equippable.equipslot = GLOBAL.EQUIPSLOTS.PACK
	--inst.components.inventoryitem.cangoincontainer = false		-- storable = true // non storable = false
	inst:AddTag("nonpotatable")

end

AddPrefabPostInit("frostback", frostbackpostinit)
AddPrefabPostInit("broken_frosthammer", frostbackpostinit)

end

-------------comfortable Sort Inventory
local SORTActive = 0
for _, moddir in ipairs(GLOBAL.KnownModIndex:GetModsToLoad()) do
    if GLOBAL.KnownModIndex:GetModInfo(moddir).name == "Sort Inventory" then
		SORTActive = 1
    end
end

if SORTActive == 1 then
-- frostback
local function armorsortpostinit(inst)
inst.components.container.type = "pack"
end

AddPrefabPostInit("armor_mushaa", armorsortpostinit)
AddPrefabPostInit("armor_mushab", armorsortpostinit)

end

-------yamche floating badge 

local function Yamchebadge ( inst )

	inst:DoTaskInTime( 0, function() 
		local controls = inst.HUD.controls
	local YamcheStatusDisplays = require "widgets/yamchestatusdisplays"
	controls.YamcheStatus = controls:AddChild(YamcheStatusDisplays(inst))
		controls.YamcheStatus:SetPosition(0, -250, 0)
	end)	
end
AddSimPostInit( Yamchebadge )

-------musha floating badge 

local function Mushabadge ( inst )

	inst:DoTaskInTime( 0, function() 
		local controls = inst.HUD.controls
	local MushaStatusDisplays = require "widgets/mushastatusdisplays"
	controls.MushaStatus = controls:AddChild(MushaStatusDisplays(inst))
		controls.MushaStatus:SetPosition(0, 0, 0)
	end)	
end
AddSimPostInit( Mushabadge )

-------items floating badge 

local function Itembadge( inst )

	inst:DoTaskInTime( 0, function() 
		local controls = inst.HUD.controls
	local ItemStatusDisplays = require "widgets/itemstatusdisplays"
	controls.ItemStatus = controls:AddChild(ItemStatusDisplays(inst))
		controls.ItemStatus:SetPosition(0, 0, 0)
	end)	
end
AddSimPostInit( Itembadge)

-------------

AddModCharacter("musha")

local function Monsterfood_veasy(inst)
	local player = GLOBAL.GetPlayer()
	local fooditem = inst.prefab
if tostring(fooditem)=="monsterlasagna" and player:HasTag("musha") then
inst.components.edible.hungervalue=inst.components.edible.hungervalue * 1.75	
inst.components.edible.sanityvalue=inst.components.edible.sanityvalue * -2
inst.components.edible.healthvalue=inst.components.edible.healthvalue * -1.5
elseif tostring(fooditem)=="monstermeat_dried" and player:HasTag("musha") then
inst.components.edible.hungervalue=inst.components.edible.hungervalue * 1.5	
inst.components.edible.sanityvalue=inst.components.edible.sanityvalue * -2	
inst.components.edible.healthvalue=inst.components.edible.healthvalue * -1	
elseif tostring(fooditem)=="cookedmonstermeat" and player:HasTag("musha") then
inst.components.edible.hungervalue=inst.components.edible.hungervalue * 1.5	
inst.components.edible.sanityvalue=inst.components.edible.sanityvalue * -1
inst.components.edible.healthvalue=inst.components.edible.healthvalue * -1	
	else 
	end
end
local function Monsterfood_easy(inst)
	local player = GLOBAL.GetPlayer()
	local fooditem = inst.prefab
if tostring(fooditem)=="monsterlasagna" and player:HasTag("musha") then
inst.components.edible.hungervalue=inst.components.edible.hungervalue * 1.5	
inst.components.edible.sanityvalue=inst.components.edible.sanityvalue * -1.5
inst.components.edible.healthvalue=inst.components.edible.healthvalue * -0.75
elseif tostring(fooditem)=="monstermeat_dried" and player:HasTag("musha") then
inst.components.edible.sanityvalue=inst.components.edible.sanityvalue * -1.25	
inst.components.edible.healthvalue=inst.components.edible.healthvalue * -.5	
elseif tostring(fooditem)=="cookedmonstermeat" and player:HasTag("musha") then
inst.components.edible.sanityvalue=inst.components.edible.sanityvalue * -0.5
inst.components.edible.healthvalue=inst.components.edible.healthvalue * 0
	else 
	end
end
local function Monsterfood_moderato(inst)
	local player = GLOBAL.GetPlayer()
	local fooditem = inst.prefab
if tostring(fooditem)=="monsterlasagna" and player:HasTag("musha") then
inst.components.edible.hungervalue=inst.components.edible.hungervalue * 1	
inst.components.edible.sanityvalue=inst.components.edible.sanityvalue * -1.25
inst.components.edible.healthvalue=inst.components.edible.healthvalue * -0.5
elseif tostring(fooditem)=="monstermeat_dried" and player:HasTag("musha") then
inst.components.edible.sanityvalue=inst.components.edible.sanityvalue * -1	
--inst.components.edible.healthvalue=inst.components.edible.healthvalue * 1
elseif tostring(fooditem)=="cookedmonstermeat" and player:HasTag("musha") then
inst.components.edible.sanityvalue=inst.components.edible.sanityvalue * -0
inst.components.edible.healthvalue=inst.components.edible.healthvalue * 2	
	else 
	end
end
local function Monsterfood_hard(inst)
	local player = GLOBAL.GetPlayer()
	local fooditem = inst.prefab
if tostring(fooditem)=="monsterlasagna" and player:HasTag("musha") then
inst.components.edible.hungervalue=inst.components.edible.hungervalue * 0.75	
inst.components.edible.sanityvalue=inst.components.edible.sanityvalue * -1
inst.components.edible.healthvalue=inst.components.edible.healthvalue * -0.25
elseif tostring(fooditem)=="monstermeat_dried" and player:HasTag("musha") then
inst.components.edible.sanityvalue=inst.components.edible.sanityvalue * -0.5	
--inst.components.edible.healthvalue=inst.components.edible.healthvalue * 1
elseif tostring(fooditem)=="cookedmonstermeat" and player:HasTag("musha") then
--inst.components.edible.sanityvalue=inst.components.edible.sanityvalue * -0
inst.components.edible.healthvalue=inst.components.edible.healthvalue * 2.5	
	else 
	end
end
local function Monsterfood_vhard(inst)
	local player = GLOBAL.GetPlayer()
	local fooditem = inst.prefab
if tostring(fooditem)=="monsterlasagna" and player:HasTag("musha") then
inst.components.edible.hungervalue=inst.components.edible.hungervalue * 0.5	
inst.components.edible.sanityvalue=inst.components.edible.sanityvalue * -0.5
--inst.components.edible.healthvalue=inst.components.edible.healthvalue * -0.25
elseif tostring(fooditem)=="monstermeat_dried" and player:HasTag("musha") then
inst.components.edible.sanityvalue=inst.components.edible.sanityvalue * -0.25	
inst.components.edible.healthvalue=inst.components.edible.healthvalue * 1.5
elseif tostring(fooditem)=="cookedmonstermeat" and player:HasTag("musha") then
--inst.components.edible.sanityvalue=inst.components.edible.sanityvalue * 1.5
inst.components.edible.healthvalue=inst.components.edible.healthvalue * 2.5	
	else 
	end
end

function mushabadge_on(inst)
 	inst:AddTag("mushab")
end
function mushabadge_valkyrie(inst)
 	inst:AddTag("mushabv")
end
function mushabadge_off(inst)
 	inst:RemoveTag("mushab")
 	inst:RemoveTag("mushabv")
end

if Mbadge == "always" then
AddPrefabPostInit("musha", mushabadge_on)
end
if Mbadge == "valkyrie" then
AddPrefabPostInit("musha", mushabadge_valkyrie)
end
if Mbadge == "off" then
AddPrefabPostInit("musha", mushabadge_off)
end

function spoiled(inst)
 	inst:AddTag("spoiled")
end

AddPrefabPostInit("spoiled_food",spoiled)
AddPrefabPostInit("spoiledfood",spoiled)
AddPrefabPostInit("rottenegg",spoiled)
AddPrefabPostInit("wetgoop",spoiled)


--elemental
local function elemental( inst )
    inst:AddComponent("fuel")
    --inst.components.fuel.fuelvalue = TUNING.SMALL_FUEL
    inst.components.fuel.fuelvalue = TUNING.MED_LARGE_FUEL
    inst.components.fuel.fueltype = "CHEMICAL"

end

AddPrefabPostInit("rocks",elemental)
AddPrefabPostInit("goldnugget",elemental)
AddPrefabPostInit("flint",elemental)

--convert gem

function gem_purple(inst)
local glowdusts = Ingredient( "glowdust", 1)
glowdusts.atlas = "images/inventoryimages/glowdust.xml"
Recipe("redgem", {Ingredient( "purplegem",1),glowdusts,}, RECIPETABS.REFINE, {SCIENCE=0})
Recipe("bluegem", {Ingredient( "purplegem",1),glowdusts, }, RECIPETABS.REFINE, {SCIENCE=0})
end

function gem_color(inst)
local glowdusts = Ingredient( "glowdust", 1)
glowdusts.atlas = "images/inventoryimages/glowdust.xml"
Recipe("redgem", {Ingredient( "bluegem",1),glowdusts,}, RECIPETABS.REFINE, {SCIENCE=0})
Recipe("bluegem", {Ingredient( "redgem",1),glowdusts, }, RECIPETABS.REFINE, {SCIENCE=0})
end

function gem_craft(inst)
local dust2 = Ingredient( "glowdust", 2)
dust2.atlas = "images/inventoryimages/glowdust.xml"
Recipe("redgem", {Ingredient("goldnugget", 6), Ingredient("feather_robin", 12) ,dust2, }, RECIPETABS.REFINE, {SCIENCE=0})
Recipe("bluegem",{Ingredient("goldnugget", 6), Ingredient("feather_robin_winter", 12) ,dust2, }, RECIPETABS.REFINE, {SCIENCE=0})
end

function gem_ecraft(inst)
local glowdusts = Ingredient( "glowdust", 1)
glowdusts.atlas = "images/inventoryimages/glowdust.xml"
Recipe("redgem", {Ingredient("goldnugget", 3), Ingredient("feather_robin", 6) ,glowdusts, }, RECIPETABS.REFINE, {SCIENCE=0})
Recipe("bluegem",{Ingredient("goldnugget", 3), Ingredient("feather_robin_winter", 6) ,glowdusts, }, RECIPETABS.REFINE, {SCIENCE=0})
end


if Cgems == "purple" then
AddPrefabPostInit("musha",gem_purple)
end
if Cgems == "color" then
AddPrefabPostInit("musha",gem_color)
end
if Cgems == "craft" then
AddPrefabPostInit("musha",gem_craft)
end
if Cgems == "ecraft" then
AddPrefabPostInit("musha",gem_ecraft)
end

--rocks
function rockss(inst)
Recipe("rocks", {Ingredient( "goldnugget",1),}, RECIPETABS.REFINE, {SCIENCE=0})

end
AddPrefabPostInit("musha",rockss)

function disable(inst)
        inst:AddTag("tstone")
        inst:AddTag("tstoneback")
        inst:AddTag("tstonehammer")
end
function enable(inst)
end
function frostback(inst)
        inst:AddTag("tstone")
        inst:AddTag("tstonehammer")
end
function frosthammer(inst)
        inst:AddTag("tstone")
        inst:AddTag("tstoneback")
end
function frostheart(inst)
        inst:AddTag("tstonehammer")
        inst:AddTag("tstoneback")
end

if Frostone == "disable" then
AddPrefabPostInit("heatrock", disable)
end
if Frostone == "enable" then
AddPrefabPostInit("heatrock", enable)
end
if Frostone == "frostback" then
AddPrefabPostInit("heatrock", frostback)
end
if Frostone == "frosthammer" then
AddPrefabPostInit("heatrock", frosthammer)
end
if Frostone == "frostheart" then
AddPrefabPostInit("heatrock", frostheart)
end

function musha_verysmart(inst)
inst.components.builder.science_bonus = 2
end
function musha_smart(inst)
inst.components.builder.science_bonus = 1
end
function musha_normal(inst)
inst.components.builder.science_bonus = 0
end

if Smart == "verysmart" then
AddPrefabPostInit("musha", musha_verysmart)
end
if Smart == "smart" then
AddPrefabPostInit("musha", musha_smart)
end
if Smart == "normal" then
AddPrefabPostInit("musha", musha_normal)
end

function giants_1x(inst)
  inst:AddTag("giant1x")
end
function deerclops_2x(inst)
    inst.components.health:SetMaxHealth(TUNING.DEERCLOPS_HEALTH*3)
    inst.components.combat:SetDefaultDamage(TUNING.DEERCLOPS_DAMAGE*2)
    inst.components.combat:SetAttackPeriod(2.75)
  inst:AddTag("giant2x")
end
function bearger_2x(inst)
    inst.components.health:SetMaxHealth(TUNING.BEARGER_HEALTH*3)
    inst.components.combat:SetDefaultDamage(TUNING.DEERCLOPS_DAMAGE*2)
    inst.components.combat:SetAttackPeriod(2.75)
  inst:AddTag("giant2x")
end
function dragonfly_2x(inst)
    inst.components.health:SetMaxHealth(TUNING.DRAGONFLY_HEALTH*3)
    inst.components.combat:SetDefaultDamage(TUNING.DEERCLOPS_DAMAGE*2)
    inst.components.combat:SetAttackPeriod(2.25)
  inst:AddTag("giant2x")
end
function moose_2x(inst)
    inst.components.health:SetMaxHealth(TUNING.MOOSE_HEALTH*3)
    inst.components.combat:SetDefaultDamage(TUNING.DEERCLOPS_DAMAGE*2)
    inst.components.combat:SetAttackPeriod(2.75)
  inst:AddTag("giant2x")
end
function mossling_2x(inst)
    inst.components.health:SetMaxHealth(TUNING.MOSSLING_HEALTH*2.5)
    inst.components.combat:SetDefaultDamage(TUNING.DEERCLOPS_DAMAGE*1.5)
  inst:AddTag("small_giant2x")
end
function deerclops_3x(inst)
    inst.components.health:SetMaxHealth(TUNING.DEERCLOPS_HEALTH*4.5)
    inst.components.combat:SetDefaultDamage(TUNING.DEERCLOPS_DAMAGE*2.5)
    inst.components.combat:SetAttackPeriod(2.6)
  inst:AddTag("giant3x")
end
function bearger_3x(inst)
    inst.components.health:SetMaxHealth(TUNING.BEARGER_HEALTH*4.5)
    inst.components.combat:SetDefaultDamage(TUNING.BEARGER_DAMAGE*2.5)
    inst.components.combat:SetRange(TUNING.BEARGER_ATTACK_RANGE, TUNING.BEARGER_MELEE_RANGE)
    inst.components.combat:SetAttackPeriod(2.6)
  inst:AddTag("giant3x")
end
function dragonfly_3x(inst)
    inst.components.health:SetMaxHealth(TUNING.DRAGONFLY_HEALTH*4.5)
    inst.components.combat:SetDefaultDamage(TUNING.DRAGONFLY_DAMAGE*2.5)
    inst.components.combat:SetAttackPeriod(2.1)
  inst:AddTag("giant3x")
end
function moose_3x(inst)
    inst.components.health:SetMaxHealth(TUNING.MOOSE_HEALTH*4.5)
    inst.components.combat:SetDefaultDamage(TUNING.MOOSE_DAMAGE*2.5)
    inst.components.combat:SetAttackPeriod(2.6)
   inst:AddTag("giant3x")
end
function mossling_3x(inst)
    inst.components.health:SetMaxHealth(TUNING.MOSSLING_HEALTH*3.5)
    inst.components.combat:SetDefaultDamage(TUNING.MOSSLING_DAMAGE*2.5)
   inst:AddTag("small_giant3x")
end
function deerclops_4x(inst)
    inst.components.health:SetMaxHealth(TUNING.DEERCLOPS_HEALTH*6)
    inst.components.combat:SetDefaultDamage(TUNING.DEERCLOPS_DAMAGE*3)
 --   inst.components.combat:SetAreaDamage(TUNING.DEERCLOPS_AOE_RANGE, TUNING.DEERCLOPS_AOE_SCALE)
    inst.components.combat:SetAttackPeriod(2.3)
   inst:AddTag("giant4x")
end
function bearger_4x(inst)
    inst.components.health:SetMaxHealth(TUNING.BEARGER_HEALTH*6)
    inst.components.combat:SetDefaultDamage(TUNING.BEARGER_DAMAGE*3)
    inst.components.combat:SetRange(TUNING.BEARGER_ATTACK_RANGE, TUNING.BEARGER_MELEE_RANGE)
 --   inst.components.combat:SetAreaDamage(6, 0.8)
    inst.components.combat:SetAttackPeriod(2.3)
   inst:AddTag("giant4x")
end
function dragonfly_4x(inst)
    inst.components.health:SetMaxHealth(TUNING.DRAGONFLY_HEALTH*6)
    inst.components.combat:SetDefaultDamage(TUNING.DRAGONFLY_DAMAGE*3)
   -- inst.components.combat:SetAreaDamage(6, 0.8)
    inst.components.combat:SetAttackPeriod(1.8)
   inst:AddTag("giant4x")
end
function moose_4x(inst)
    inst.components.health:SetMaxHealth(TUNING.MOOSE_HEALTH*6)
    inst.components.combat:SetDefaultDamage(TUNING.MOOSE_DAMAGE*3)
    inst.components.combat:SetAttackPeriod(2.3)
    inst:AddTag("giant4x")
end
function mossling_4x(inst)
    inst.components.health:SetMaxHealth(TUNING.MOSSLING_HEALTH*5)
    inst.components.combat:SetDefaultDamage(TUNING.MOSSLING_DAMAGE*3)
    inst:AddTag("small_giant4x")
end

------------
function nspider_1x(inst)
    inst:AddTag("spider1x")
end
function nspider_2x(inst)
    inst.components.health:SetMaxHealth(TUNING.SPIDER_HEALTH*2)
    inst:AddTag("spider2x")
end
function wspider_2x(inst)
    inst.components.health:SetMaxHealth(TUNING.SPIDER_WARRIOR_HEALTH*2)
    inst:AddTag("spider2x")
end
function qspider_2x(inst)
    inst.components.health:SetMaxHealth(TUNING.SPIDERQUEEN_HEALTH*2)
    inst:AddTag("small_giant2x")
end
function chspider_2x(inst)
    inst.components.health:SetMaxHealth(TUNING.SPIDER_HIDER_HEALTH*2)
    inst:AddTag("spider2x")
end
function csspider_2x(inst)
    inst.components.health:SetMaxHealth(TUNING.SPIDER_SPITTER_HEALTH*2)
    inst:AddTag("spider2x")
end
function cdspider_2x(inst)
    inst.components.health:SetMaxHealth(TUNING.SPIDER_WARRIOR_HEALTH*2)
     inst:AddTag("spider2x")
end
function nspider_3x(inst)
    inst.components.health:SetMaxHealth(TUNING.SPIDER_HEALTH*3)
    inst.components.combat:SetDefaultDamage(TUNING.SPIDER_DAMAGE*1.5)
    inst.components.combat:SetAttackPeriod(2.75)
     inst:AddTag("spider3x")
end
function wspider_3x(inst)
    inst.components.health:SetMaxHealth(TUNING.SPIDER_WARRIOR_HEALTH*3)
    inst.components.combat:SetDefaultDamage(TUNING.SPIDER_WARRIOR_DAMAGE*1.5)
    inst.components.combat:SetAttackPeriod(3.75 + math.random()*2)
     inst:AddTag("spider3x")
end
function qspider_3x(inst)
    inst.components.health:SetMaxHealth(TUNING.SPIDERQUEEN_HEALTH*3)
    inst.components.combat:SetDefaultDamage(TUNING.SPIDERQUEEN_DAMAGE*1.5)
    inst.components.combat:SetAttackPeriod(2.75)
     inst:AddTag("small_giant3x")
end
function chspider_3x(inst)
    inst.components.health:SetMaxHealth(TUNING.SPIDER_HIDER_HEALTH*3)
    inst.components.combat:SetDefaultDamage(TUNING.SPIDER_HIDER_DAMAGE*1.5)
    inst.components.combat:SetAttackPeriod(2.75)
     inst:AddTag("spider3x")
end
function csspider_3x(inst)
    inst.components.health:SetMaxHealth(TUNING.SPIDER_SPITTER_HEALTH*3)
    inst.components.combat:SetDefaultDamage(TUNING.SPIDER_SPITTER_DAMAGE_MELEE*1.5)
    inst.components.combat:SetAttackPeriod(4.75 + math.random()*2)
     inst:AddTag("spider3x")
end
function cdspider_3x(inst)
    inst.components.health:SetMaxHealth(TUNING.SPIDER_WARRIOR_HEALTH*3)
    inst.components.combat:SetDefaultDamage(TUNING.SPIDER_WARRIOR_DAMAGE*1.5)
    inst.components.combat:SetAttackPeriod(2.75 + math.random()*2)
     inst:AddTag("spider3x")
end
function nspider_4x(inst)
    inst.components.health:SetMaxHealth(TUNING.SPIDER_HEALTH*4)
    inst.components.combat:SetDefaultDamage(TUNING.SPIDER_DAMAGE*2)
    inst.components.combat:SetAttackPeriod(2.5)
     inst:AddTag("spider4x")
end
function wspider_4x(inst)
    inst.components.health:SetMaxHealth(TUNING.SPIDER_WARRIOR_HEALTH*4)
    inst.components.combat:SetDefaultDamage(TUNING.SPIDER_WARRIOR_DAMAGE*2)
    inst.components.combat:SetAttackPeriod(3.5 + math.random()*2)
     inst:AddTag("spider4x")
end
function qspider_4x(inst)
    inst.components.health:SetMaxHealth(TUNING.SPIDERQUEEN_HEALTH*4)
    inst.components.combat:SetDefaultDamage(TUNING.SPIDERQUEEN_DAMAGE*2)
    inst.components.combat:SetAttackPeriod(2.5)
     inst:AddTag("small_giant4x")
end
function chspider_4x(inst)
    inst.components.health:SetMaxHealth(TUNING.SPIDER_HIDER_HEALTH*4)
    inst.components.combat:SetDefaultDamage(TUNING.SPIDER_HIDER_DAMAGE*2)
    inst.components.combat:SetAttackPeriod(2.5)
     inst:AddTag("spider4x")
end
function csspider_4x(inst)
    inst.components.health:SetMaxHealth(TUNING.SPIDER_SPITTER_HEALTH*4)
    inst.components.combat:SetDefaultDamage(TUNING.SPIDER_SPITTER_DAMAGE_MELEE*2)
    inst.components.combat:SetAttackPeriod(4.5 + math.random()*2)
        inst:AddTag("spider4x")
end
function cdspider_4x(inst)
    inst.components.health:SetMaxHealth(TUNING.SPIDER_WARRIOR_HEALTH*4)
    inst.components.combat:SetDefaultDamage(TUNING.SPIDER_WARRIOR_DAMAGE*2)
    inst.components.combat:SetAttackPeriod(3.5 + math.random()*2)
        inst:AddTag("spider4x")
end
------
function hound_1x(inst)
        inst:AddTag("hound1x")
end
function nhound_2x(inst)
    inst.components.health:SetMaxHealth(TUNING.HOUND_HEALTH*2)
        inst:AddTag("hound2x")
end
function fhound_2x(inst)
    inst.components.health:SetMaxHealth(TUNING.FIREHOUND_HEALTH*2)
        inst:AddTag("hound2x")
end
function ihound_2x(inst)
    inst.components.health:SetMaxHealth(TUNING.ICEHOUND_HEALTH*2)
        inst:AddTag("hound2x")
end
function warg_2x(inst)
    inst.components.health:SetMaxHealth(TUNING.WARG_HEALTH*2)
        inst:AddTag("small_giant2x")
end

function nhound_3x(inst)
    inst.components.health:SetMaxHealth(TUNING.HOUND_HEALTH*3)
    inst.components.combat:SetDefaultDamage(TUNING.HOUND_DAMAGE*1.5)
    inst.components.combat:SetAttackPeriod(1.75)
        inst:AddTag("hound3x")
end
function fhound_3x(inst)
    inst.components.health:SetMaxHealth(TUNING.FIREHOUND_HEALTH*3)
    inst.components.combat:SetDefaultDamage(TUNING.FIREHOUND_DAMAGE*1.5)
    inst.components.combat:SetAttackPeriod(1.75)
        inst:AddTag("hound3x")
end
function ihound_3x(inst)
    inst.components.health:SetMaxHealth(TUNING.ICEHOUND_HEALTH*3)
    inst.components.combat:SetDefaultDamage(TUNING.ICEHOUND_DAMAGE*1.5)
    inst.components.combat:SetAttackPeriod(1.75)
        inst:AddTag("hound3x")
end
function warg_3x(inst)
    inst.components.health:SetMaxHealth(TUNING.WARG_HEALTH*3)
    inst.components.combat:SetDefaultDamage(TUNING.WARG_DAMAGE*1.5)
    inst.components.combat:SetAttackPeriod(2.75)
        inst:AddTag("small_giant3x")
end

function nhound_4x(inst)
    inst.components.health:SetMaxHealth(TUNING.HOUND_HEALTH*4)
    inst.components.combat:SetDefaultDamage(TUNING.HOUND_DAMAGE*2)
    inst.components.combat:SetAttackPeriod(1.5)
        inst:AddTag("hound4x")
end
function fhound_4x(inst)
    inst.components.health:SetMaxHealth(TUNING.FIREHOUND_HEALTH*4)
    inst.components.combat:SetDefaultDamage(TUNING.FIREHOUND_DAMAGE*2)
    inst.components.combat:SetAttackPeriod(1.5)
        inst:AddTag("hound4x")
end
function ihound_4x(inst)
    inst.components.health:SetMaxHealth(TUNING.ICEHOUND_HEALTH*4)
    inst.components.combat:SetDefaultDamage(TUNING.ICEHOUND_DAMAGE*2)
    inst.components.combat:SetAttackPeriod(1.5)
        inst:AddTag("hound4x")
end
function warg_4x(inst)
    inst.components.health:SetMaxHealth(TUNING.WARG_HEALTH*4)
    inst.components.combat:SetDefaultDamage(TUNING.WARG_DAMAGE*2)
    inst.components.combat:SetAttackPeriod(2.5)
        inst:AddTag("small_giant4x")
end
function tentacle_1x(inst)
        inst:AddTag("spider1x")
end
function tentacle_2x(inst)
    inst.components.health:SetMaxHealth(TUNING.TENTACLE_HEALTH*2)
    inst.components.combat:SetDefaultDamage(TUNING.TENTACLE_DAMAGE*1.5)
        inst:AddTag("spider2x")
end
function tentacle_3x(inst)
    inst.components.health:SetMaxHealth(TUNING.TENTACLE_HEALTH*3)
    inst.components.combat:SetDefaultDamage(TUNING.TENTACLE_DAMAGE*2)
        inst:AddTag("spider3x")
end
function tentacle_4x(inst)
    inst.components.health:SetMaxHealth(TUNING.TENTACLE_HEALTH*4)
    inst.components.combat:SetDefaultDamage(TUNING.TENTACLE_DAMAGE*2.5)
        inst:AddTag("spider4x")
end
function rook_1x(inst)
        inst:AddTag("spider1x")
end
function rook_2x(inst)
    inst.components.health:SetMaxHealth(TUNING.ROOK_HEALTH*2)
    inst.components.combat:SetDefaultDamage(TUNING.ROOK_DAMAGE*1.5)
        inst:AddTag("spider2x")
end
function rook_3x(inst)
    inst.components.health:SetMaxHealth(TUNING.ROOK_HEALTH*3)
    inst.components.combat:SetDefaultDamage(TUNING.ROOK_DAMAGE*2)
        inst:AddTag("spider3x")
end
function rook_4x(inst)
    inst.components.health:SetMaxHealth(TUNING.ROOK_HEALTH*4)
    inst.components.combat:SetDefaultDamage(TUNING.ROOK_DAMAGE*3)
        inst:AddTag("spider4x")
end
function minotaur_1x(inst)
        inst:AddTag("spider1x")
end
function minotaur_2x(inst)
    inst.components.health:SetMaxHealth(TUNING.MINOTAUR_HEALTH*2)
    inst.components.combat:SetDefaultDamage(TUNING.MINOTAUR_DAMAGE*1.5)
        inst:AddTag("spider2x")
end
function minotaur_3x(inst)
    inst.components.health:SetMaxHealth(TUNING.MINOTAUR_HEALTH*3)
    inst.components.combat:SetDefaultDamage(TUNING.MINOTAUR_DAMAGE*2)
        inst:AddTag("spider3x")
end
function minotaur_4x(inst)
    inst.components.health:SetMaxHealth(TUNING.MINOTAUR_HEALTH*4)
    inst.components.combat:SetDefaultDamage(TUNING.MINOTAUR_DAMAGE*2.5)
        inst:AddTag("spider4x")
end
function bishop_1x(inst)
        inst:AddTag("spider1x")
end
function bishop_2x(inst)
    inst.components.health:SetMaxHealth(TUNING.BISHOP_HEALTH*2)
    inst.components.combat:SetDefaultDamage(TUNING.BISHOP_DAMAGE*1.2)
        inst:AddTag("spider2x")
end
function bishop_3x(inst)
    inst.components.health:SetMaxHealth(TUNING.BISHOP_HEALTH*3)
    inst.components.combat:SetDefaultDamage(TUNING.BISHOP_DAMAGE*1.6)
        inst:AddTag("spider3x")
end
function bishop_4x(inst)
    inst.components.health:SetMaxHealth(TUNING.BISHOP_HEALTH*4)
    inst.components.combat:SetDefaultDamage(TUNING.BISHOP_DAMAGE*2)
        inst:AddTag("spider4x")
end
function tallbird_1x(inst)
        inst:AddTag("spider1x")
end
function tallbird_2x(inst)
    inst.components.health:SetMaxHealth(TUNING.TALLBIRD_HEALTH*2)
        inst:AddTag("spider2x")
end
function tallbird_3x(inst)
    inst.components.health:SetMaxHealth(TUNING.TALLBIRD_HEALTH*3)
    inst.components.combat:SetDefaultDamage(TUNING.TALLBIRD_DAMAGE*1.5)
    inst.components.combat:SetAttackPeriod(1.75)
        inst:AddTag("spider3x")
end
function tallbird_4x(inst)
    inst.components.health:SetMaxHealth(TUNING.TALLBIRD_HEALTH*4)
    inst.components.combat:SetDefaultDamage(TUNING.TALLBIRD_DAMAGE*2)
    inst.components.combat:SetAttackPeriod(1.5)
        inst:AddTag("spider4x")
end
function leif_1x(inst)
        inst:AddTag("small_giant1x")
    inst.components.health:SetMaxHealth(TUNING.LEIF_HEALTH)
end
function leif_2x(inst)
        inst:AddTag("small_giant2x")
    inst.components.health:SetMaxHealth(TUNING.LEIF_HEALTH*2)
end
function leif_3x(inst)
        inst:AddTag("small_giant3x")
    inst.components.health:SetMaxHealth(TUNING.LEIF_HEALTH*3)
    inst.components.combat:SetDefaultDamage(TUNING.LEIF_DAMAGE*1.5)
end
function leif_4x(inst)
        inst:AddTag("small_giant4x")
    inst.components.health:SetMaxHealth(TUNING.LEIF_HEALTH*4)
    inst.components.combat:SetDefaultDamage(TUNING.LEIF_DAMAGE*2)
end
function birchnutdrake_1x(inst)
        inst:AddTag("spider1x")
    inst.components.health:SetMaxHealth(50)
end
function birchnutdrake_2x(inst)
        inst:AddTag("spider2x")
    inst.components.health:SetMaxHealth(100)
end
function birchnutdrake_3x(inst)
        inst:AddTag("spider3x")
    inst.components.health:SetMaxHealth(150)
    inst.components.combat:SetDefaultDamage(10)
end
function birchnutdrake_4x(inst)
        inst:AddTag("spider4x")
    inst.components.health:SetMaxHealth(200)
    inst.components.combat:SetDefaultDamage(15)
end
function merm_1x(inst)
        inst:AddTag("spider1x")
    inst.components.health:SetMaxHealth(TUNING.MERM_HEALTH)
end
function merm_2x(inst)
        inst:AddTag("spider2x")
    inst.components.health:SetMaxHealth(TUNING.MERM_HEALTH*2)
end
function merm_3x(inst)
        inst:AddTag("spider3x")
    inst.components.health:SetMaxHealth(TUNING.MERM_HEALTH*3)
    inst.components.combat:SetDefaultDamage(TUNING.MERM_DAMAGE*1.5)
end
function merm_4x(inst)
        inst:AddTag("spider4x")
    inst.components.health:SetMaxHealth(TUNING.MERM_HEALTH*4)
    inst.components.combat:SetDefaultDamage(TUNING.MERM_DAMAGE*2)
end
function bat_1x(inst)
        inst:AddTag("spider1x")
    inst.components.health:SetMaxHealth(TUNING.BAT_HEALTH)
end
function bat_2x(inst)
        inst:AddTag("spider2x")
    inst.components.health:SetMaxHealth(TUNING.BAT_HEALTH*2)
end
function bat_3x(inst)
        inst:AddTag("spider3x")
    inst.components.health:SetMaxHealth(TUNING.BAT_HEALTH*3)
    inst.components.combat:SetDefaultDamage(TUNING.BAT_DAMAGE*1.5)
end
function bat_4x(inst)
        inst:AddTag("spider4x")
    inst.components.health:SetMaxHealth(TUNING.BAT_HEALTH*4)
    inst.components.combat:SetDefaultDamage(TUNING.BAT_DAMAGE*2)
end
function monkey_1x(inst)
        inst:AddTag("spider1x")
    inst.components.health:SetMaxHealth(TUNING.MONKEY_HEALTH)
end
function monkey_2x(inst)
        inst:AddTag("spider2x")
    inst.components.health:SetMaxHealth(TUNING.MONKEY_HEALTH*2)
end
function monkey_3x(inst)
        inst:AddTag("spider3x")
    inst.components.health:SetMaxHealth(TUNING.MONKEY_HEALTH*3)
end
function monkey_4x(inst)
        inst:AddTag("spider4x")
    inst.components.health:SetMaxHealth(TUNING.MONKEY_HEALTH*4)
end
function walus_1x(inst)
        inst:AddTag("spider1x")
    inst.components.health:SetMaxHealth(TUNING.WALRUS_HEALTH)
end
function walus_2x(inst)
        inst:AddTag("spider2x")
    inst.components.health:SetMaxHealth(TUNING.WALRUS_HEALTH*2)
end
function walus_3x(inst)
        inst:AddTag("spider3x")
    inst.components.health:SetMaxHealth(TUNING.WALRUS_HEALTH*3)
    inst.components.locomotor.runspeed = 6
    inst.components.locomotor.walkspeed = 2
end
function walus_4x(inst)
        inst:AddTag("spider4x")
    inst.components.health:SetMaxHealth(TUNING.WALRUS_HEALTH*4)
    inst.components.locomotor.runspeed = 8
    inst.components.locomotor.walkspeed = 2
end
function eyeplant_1x(inst)
end
function eyeplant_2x(inst)
        inst:AddTag("spider1x")
    inst.components.health:SetMaxHealth(TUNING.EYEPLANT_HEALTH*2)
end
function eyeplant_3x(inst)
        inst:AddTag("spider1x")
    inst.components.health:SetMaxHealth(TUNING.EYEPLANT_HEALTH*3)
    inst.components.combat:SetDefaultDamage(TUNING.EYEPLANT_DAMAGE*1.5)
end
function eyeplant_4x(inst)
        inst:AddTag("spider2x")
    inst.components.health:SetMaxHealth(TUNING.EYEPLANT_HEALTH*4)
    inst.components.combat:SetDefaultDamage(TUNING.EYEPLANT_DAMAGE*2)
end

function stat_hellh(inst)
        inst:AddTag("hellh")
 	inst.components.combat.damagemultiplier = .5
	inst.components.health:SetMaxHealth(40)
inst:AddTag("helld")
end
function stat_hardcoreh(inst)
        inst:AddTag("hardcoreh")
 	inst.components.combat.damagemultiplier = .6
	inst.components.health:SetMaxHealth(40)
inst:AddTag("hardcored")
end
function stat_hardh(inst)
        inst:AddTag("hardh")
 	inst.components.combat.damagemultiplier = .7
	inst.components.health:SetMaxHealth(50)
inst:AddTag("hardd")
end
function stat_normalh(inst)
        inst:AddTag("normalh")
 	inst.components.combat.damagemultiplier = TUNING.WENDY_DAMAGE_MULT
	inst.components.health:SetMaxHealth(60)
inst:AddTag("normald")
end
function stat_easyh(inst)
	inst.components.health:SetMaxHealth(75)
        inst:AddTag("easyh")
 	inst.components.combat.damagemultiplier = 1
inst:AddTag("easyd")
end
function stat_veasyh(inst)
 	inst.components.combat.damagemultiplier = 1.5
inst:AddTag("easyd")
	inst.components.health:SetMaxHealth(100)
        inst:AddTag("veasyh")
end

-------difficult option
if Difficult == "easyh" then
for k, fooditem in pairs(TUNING.MUSHA_FOODS) do
    AddPrefabPostInit(fooditem, Monsterfood_easy)
AddPrefabPostInit("musha", stat_easyh)
end
end
if Difficult == "veasyh" then
for k, fooditem in pairs(TUNING.MUSHA_FOODS) do
    AddPrefabPostInit(fooditem, Monsterfood_veasy)
AddPrefabPostInit("musha", stat_veasyh)
end
end
if Difficult == "monster1x" then
AddPrefabPostInit("deerclops", giants_1x)
AddPrefabPostInit("bearger", giants_1x)
AddPrefabPostInit("dragonfly", giants_1x)
AddPrefabPostInit("moose", giants_1x)
AddPrefabPostInit("mossling", giants_1x)
AddPrefabPostInit("spider", nspider_1x)
AddPrefabPostInit("spider_warrior", spider_1x)
AddPrefabPostInit("spiderqueen", spider_1x)
AddPrefabPostInit("spider_hider", spider_1x)
AddPrefabPostInit("spider_spitter", spider_1x)
AddPrefabPostInit("spider_dropper", spider_1x)
AddPrefabPostInit("hound", hound_1x)
AddPrefabPostInit("firehound", hound_1x)
AddPrefabPostInit("icehound", hound_1x)
AddPrefabPostInit("warg", hound_1x)
AddPrefabPostInit("tentacle", tentacle_1x)
AddPrefabPostInit("rook", rook_1x)
AddPrefabPostInit("minotaur", minotaur_1x)
AddPrefabPostInit("bishop", bishop_1x)
AddPrefabPostInit("tallbird", tallbird_1x)
AddPrefabPostInit("leif", leif_1x)
AddPrefabPostInit("merm", merm_1x)
AddPrefabPostInit("birchnutdrake", birchnutdrake_1x)
AddPrefabPostInit("bat", bat_1x)
AddPrefabPostInit("walus", walus_1x)
AddPrefabPostInit("monkey", monkey_1x)
AddPrefabPostInit("eyeplant", eyeplant_1x)
for k, fooditem in pairs(TUNING.MUSHA_FOODS) do
    AddPrefabPostInit(fooditem, Monsterfood_moderato)
AddPrefabPostInit("musha", stat_normalh)
end
end
if Difficult == "monster2x" then
AddPrefabPostInit("deerclops", deerclops_2x)
AddPrefabPostInit("bearger", bearger_2x)
AddPrefabPostInit("dragonfly", dragonfly_2x)
AddPrefabPostInit("moose", moose_2x)
AddPrefabPostInit("mossling", mossling_2x)
AddPrefabPostInit("spider", nspider_2x)
AddPrefabPostInit("spider_warrior", wspider_2x)
AddPrefabPostInit("spiderqueen", qspider_2x)
AddPrefabPostInit("spider_hider", chspider_2x)
AddPrefabPostInit("spider_spitter", csspider_2x)
AddPrefabPostInit("spider_dropper", cdspider_2x)
AddPrefabPostInit("hound", nhound_2x)
AddPrefabPostInit("firehound", fhound_2x)
AddPrefabPostInit("icehound", ihound_2x)
AddPrefabPostInit("warg", warg_2x)
AddPrefabPostInit("tentacle", tentacle_2x)
AddPrefabPostInit("rook", rook_2x)
AddPrefabPostInit("minotaur", minotaur_2x)
AddPrefabPostInit("bishop", bishop_2x)
AddPrefabPostInit("tallbird", tallbird_2x)
AddPrefabPostInit("leif", leif_2x)
AddPrefabPostInit("merm", merm_2x)
AddPrefabPostInit("birchnutdrake", birchnutdrake_2x)
AddPrefabPostInit("bat", bat_2x)
AddPrefabPostInit("walus", walus_2x)
AddPrefabPostInit("monkey", monkey_2x)
AddPrefabPostInit("eyeplant", eyeplant_2x)
for k, fooditem in pairs(TUNING.MUSHA_FOODS) do
    AddPrefabPostInit(fooditem, Monsterfood_hard)
AddPrefabPostInit("musha", stat_hardh)
end
end
if Difficult == "monster3x" then
AddPrefabPostInit("deerclops", deerclops_3x)
AddPrefabPostInit("bearger", bearger_3x)
AddPrefabPostInit("dragonfly", dragonfly_3x)
AddPrefabPostInit("moose", moose_3x)
AddPrefabPostInit("mossling", mossling_3x)
AddPrefabPostInit("spider", nspider_3x)
AddPrefabPostInit("spider_warrior", wspider_3x)
AddPrefabPostInit("spiderqueen", qspider_3x)
AddPrefabPostInit("spider_hider", chspider_3x)
AddPrefabPostInit("spider_spitter", csspider_3x)
AddPrefabPostInit("spider_dropper", cdspider_3x)
AddPrefabPostInit("hound", nhound_3x)
AddPrefabPostInit("firehound", fhound_3x)
AddPrefabPostInit("icehound", ihound_3x)
AddPrefabPostInit("warg", warg_3x)
AddPrefabPostInit("tentacle", tentacle_3x)
AddPrefabPostInit("rook", rook_3x)
AddPrefabPostInit("minotaur", minotaur_3x)
AddPrefabPostInit("bishop", bishop_3x)
AddPrefabPostInit("tallbird", tallbird_3x)
AddPrefabPostInit("leif", leif_3x)
AddPrefabPostInit("merm", merm_3x)
AddPrefabPostInit("birchnutdrake", birchnutdrake_3x)
AddPrefabPostInit("bat", bat_3x)
AddPrefabPostInit("walus", walus_3x)
AddPrefabPostInit("monkey", monkey_3x)
AddPrefabPostInit("eyeplant", eyeplant_3x)
for k, fooditem in pairs(TUNING.MUSHA_FOODS) do
    AddPrefabPostInit(fooditem, Monsterfood_hard)
AddPrefabPostInit("musha", stat_hardcoreh)
end
end
if Difficult == "monster4x" then
AddPrefabPostInit("deerclops", deerclops_4x)
AddPrefabPostInit("bearger", bearger_4x)
AddPrefabPostInit("dragonfly", dragonfly_4x)
AddPrefabPostInit("moose", moose_4x)
AddPrefabPostInit("mossling", mossling_4x)
AddPrefabPostInit("spider", nspider_4x)
AddPrefabPostInit("spider_warrior", wspider_4x)
AddPrefabPostInit("spiderqueen", qspider_4x)
AddPrefabPostInit("spider_hider", chspider_4x)
AddPrefabPostInit("spider_spitter", csspider_4x)
AddPrefabPostInit("spider_dropper", cdspider_4x)
AddPrefabPostInit("hound", nhound_4x)
AddPrefabPostInit("firehound", fhound_4x)
AddPrefabPostInit("icehound", ihound_4x)
AddPrefabPostInit("warg", warg_4x)
AddPrefabPostInit("tentacle", tentacle_4x)
AddPrefabPostInit("rook", rook_4x)
AddPrefabPostInit("minotaur", minotaur_4x)
AddPrefabPostInit("bishop", bishop_4x)
AddPrefabPostInit("tallbird", tallbird_4x)
AddPrefabPostInit("leif", leif_4x)
AddPrefabPostInit("merm", merm_4x)
AddPrefabPostInit("birchnutdrake", birchnutdrake_4x)
AddPrefabPostInit("bat", bat_4x)
AddPrefabPostInit("walus", walus_4x)
AddPrefabPostInit("monkey", monkey_4x)
AddPrefabPostInit("eyeplant", eyeplant_4x)
for k, fooditem in pairs(TUNING.MUSHA_FOODS) do
    AddPrefabPostInit(fooditem, Monsterfood_vhard)
AddPrefabPostInit("musha", stat_hellh)
end
end
-------
