require "brains/shadowmushabrain"
require "stategraphs/SGshadowmusha"

local assets = 
{
    Asset("ANIM", "anim/musha_h.zip"),
	Asset("SOUND", "sound/maxwell.fsb"),
	Asset("SOUND", "sound/willow.fsb"),    
	Asset("ANIM", "anim/swap_pickaxe.zip"),
	Asset("ANIM", "anim/swap_axe.zip"),
	Asset("ANIM", "anim/swap_nightmaresword.zip"),
}

local prefabs = 
{

}

local items =
{
	AXE = "swap_axe",
	PICK = "swap_pickaxe",
    SWORD = "swap_nightmaresword"

}

local function onkilll(inst, data)
local tynychance = 0.05
local smallllchance = 0.1
local smallchance = 0.2
local normalchance = 0.3
local largechance = 0.7
local player = GetPlayer()
	if data.cause == inst.prefab and not data.inst:HasTag("companion") then
                if math.random() < normalchance and data.inst:HasTag("prey") then
        			player.level = player.level + 1
	player.components.talker:Say(" [](+1) \n".. (player.level))
	--levelexp(player)	
	elseif math.random() < largechance and not data.inst:HasTag("prey") and not data.inst:HasTag("eyeplant") and not data.inst:HasTag("insect") then
    				player.level = player.level + 1
	player.components.talker:Say(" [](+1) \n".. (player.level))
	elseif math.random() < tynychance and data.inst:HasTag("insect") then
    				player.level = player.level + 1
	player.components.talker:Say(" [](+1) \n".. (player.level))
	elseif math.random() < smallllchance and data.inst:HasTag("eyeplant") then
    				player.level = player.level + 1
	player.components.talker:Say(" [](+1) \n".. (player.level))
	elseif math.random() < smallllchance and data.inst:HasTag("arm") then
    				player.level = player.level + 1
	player.components.talker:Say(" [](+1) \n".. (player.level))

    			 end
		          end
			end

local function ondeath(inst)
local dropchance1 = 0.15
local dropchance2 = 0.4
local dropchance3 = 0.7
	inst.components.sanityaura.penalty = 0
	local player = GetPlayer()
	if player then
		player.components.sanity:RecalculatePenalty()

 if inst:HasTag("b1") and math.random() < dropchance1 then
local poo = SpawnPrefab("nightmarefuel")
poo.Transform:SetPosition(inst.Transform:GetWorldPosition())	
 elseif inst:HasTag("b1") and math.random() < dropchance1 then
local poo = SpawnPrefab("beardhair")
poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
 elseif inst:HasTag("b2") and math.random() < dropchance2 then
local poo = SpawnPrefab("beardhair")
poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
 elseif inst:HasTag("b2") and math.random() < dropchance2 then
local poo = SpawnPrefab("beardhair")
poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
 elseif inst:HasTag("b3") and math.random() < dropchance3 then
local poo = SpawnPrefab("beardhair")
poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
 elseif inst:HasTag("b3") and math.random() < dropchance3 then
local poo = SpawnPrefab("beardhair")
poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
 elseif inst:HasTag("b3") and math.random() < dropchance2 then
local poo = SpawnPrefab("exp")
poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		

end
end
end

local function EquipItem(inst, item)
	if item then
	    inst.AnimState:OverrideSymbol("swap_object", item, item)
	    inst.AnimState:Show("ARM_carry") 
	    inst.AnimState:Hide("ARM_normal")
	end
end

local function die(inst)
	inst.components.health:Kill()
end

local function resume(inst, time)
    if inst.death then
        inst.death:Cancel()
        inst.death = nil
    end
    inst.death = inst:DoTaskInTime(time, die)
end

local function onsave(inst, data)
    data.timeleft = (inst.lifetime - inst:GetTimeAlive())
end

local function KeepTarget(isnt, target)
    return target and target:IsValid()
end

local function onload(inst, data)
    if data.timeleft then
        inst.lifetime = data.timeleft
        if inst.lifetime > 0 then
            resume(inst, inst.lifetime)
        else
            die(inst)
        end
    end
end

local function entitydeathfn(inst, data)
    if data.inst:HasTag("player") then
        inst:DoTaskInTime(math.random(), function() inst.components.health:Kill() end)
    end
end

local function OnHitfreeze(inst, data)
local other = data.target
   local pos = other:GetPosition()
    if other and other.components.freezable then
        other.components.freezable:AddColdness(0.1)
        other.components.freezable:SpawnShatterFX()
elseif other and other:HasTag("musha") then
	inst.components.combat:SetTarget(nil)
inst.components.combat:GiveUp()
    end
    if other.components.burnable and other.components.burnable:IsBurning() then
        other.components.burnable:Extinguish()
    end
end

-------------

local function dead(inst, data)
if inst.components.hunger:GetPercent() < 1 and inst.components.hunger:GetPercent() >= 0.9 then
    inst.Transform:SetScale(0.8, 0.8, 0.8)
	inst.components.health:StartRegen(1, 1)
    inst.components.combat:SetDefaultDamage(60)

elseif inst.components.hunger:GetPercent() < 0.9 and inst.components.hunger:GetPercent() >= 0.8 then
    inst.Transform:SetScale(0.75, 0.75, 0.75)
	inst.components.health:StartRegen(1, 2)
    inst.components.combat:SetDefaultDamage(55)

elseif inst.components.hunger:GetPercent() < 0.8 and inst.components.hunger:GetPercent() >= 0.7 then
    inst.Transform:SetScale(0.7, 0.7, 0.7)
	inst.components.health:StartRegen(1, 2.5)
    inst.components.combat:SetDefaultDamage(50)

elseif inst.components.hunger:GetPercent() < 0.7 and inst.components.hunger:GetPercent() >= 0.6 then
    inst.Transform:SetScale(0.65, 0.65, 0.65)
	inst.components.health:StartRegen(1, 3)
    inst.components.combat:SetDefaultDamage(45)

elseif inst.components.hunger:GetPercent() < 0.6 and inst.components.hunger:GetPercent() >= 0.5 then
    inst.Transform:SetScale(0.6, 0.6, 0.6)
	inst.components.health:StartRegen(1, 3.5)
    inst.components.combat:SetDefaultDamage(40)

elseif inst.components.hunger:GetPercent() < 0.5 and inst.components.hunger:GetPercent() >= 0.1 then
    inst.Transform:SetScale(0.55, 0.55, 0.55)
	inst.components.health:StartRegen(1, 4)
    inst.components.combat:SetDefaultDamage(35)
    inst:AddTag("b1")

elseif inst.components.hunger:GetPercent() < 0.1 and inst.components.hunger.current > 0 then
    inst.Transform:SetScale(0.5, 0.5, 0.5)
	inst.components.health:StartRegen(1, 5)
    inst.components.combat:SetDefaultDamage(30)
    inst:AddTag("b2")
    inst:RemoveTag("b1")

elseif inst.components.hunger.current == 0 then
	inst.components.health:StartRegen(0, 0)
    inst:AddTag("b3")
    inst:RemoveTag("b1")
    inst:RemoveTag("b2")
            die(inst)

end
end

local function close(inst)
local player = GetPlayer()

--player:AddTag("yamche") 
inst:AddTag("closea") 
inst:RemoveTag("fara") 
	inst.components.locomotor.walkspeed = 4
    inst.components.locomotor.runspeed = 6
player.components.leader:AddFollower(inst)
    if player:HasTag("houndmound") then
 inst:AddTag("houndmound") 
    elseif not player:HasTag("houndmound") then
inst:RemoveTag("houndmound") 
elseif inst:HasTag("animal") then
            die(inst)

end
end

local function far(inst)
local player = GetPlayer()
--player:RemoveTag("turns") 

--player:RemoveTag("yamche") 
inst:RemoveTag("closea") 
inst:AddTag("fara") 
	inst.components.locomotor.walkspeed = 8
    inst.components.locomotor.runspeed = 10
inst.components.combat:GiveUp()
if inst:HasTag("animal") then
--inst.components.follower:SetLeader(nil)
            die(inst)

end
end

local function fn()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	local sound = inst.entity:AddSoundEmitter()

	inst.Transform:SetFourFaced(inst)

	MakeGhostPhysics(inst, 1, .5)

	anim:SetBank("wilson")
	anim:SetBuild("musha_h")
	anim:PlayAnimation("idle")

    anim:Hide("ARM_carry")
    anim:Hide("hat")
    anim:Hide("hat_hair")

    inst:AddTag("scarytoprey")
    --inst:AddTag("NOCLICK")
    inst:AddTag("yamcheb")
    inst:AddTag("character")
inst:AddTag("companion")
    inst:AddTag("noauradamage")
    inst.Transform:SetScale(0.8, 0.8, 0.8)

	inst:AddComponent("colourtweener")
	inst.components.colourtweener:StartTween({1,1,1,.7}, 0)
    --inst.Transform:SetScale(0.7, 0.7, 0.7)

	inst:AddComponent("locomotor")
    --inst.components.locomotor:SetSlowMultiplier( 0.6 )

    inst.components.locomotor.pathcaps = { ignorecreep = true }
   -- inst.components.locomotor.runspeed = TUNING.SHADOWWAXWELL_SPEED

    inst:AddComponent("combat")
    inst.components.combat.playerdamagepercent = 0
    inst.components.combat.hiteffectsymbol = "torso"
    -- inst.components.combat:SetRetargetFunction(1, Retarget)
    inst.components.combat:SetKeepTargetFunction(KeepTarget)
    inst.components.combat:SetAttackPeriod(TUNING.SHADOWWAXWELL_ATTACK_PERIOD)
    inst.components.combat:SetRange(2, 3)
    inst.components.combat:SetDefaultDamage(TUNING.SHADOWWAXWELL_DAMAGE)
--40
    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(200)
inst.components.health.nofadeout = true
 inst:ListenForEvent("death", ondeath)
    inst:AddComponent("hunger")
	inst.components.hunger:SetMax(2000)

	inst:AddComponent("inventory")
   inst.components.inventory.dropondeath = false
local player = GetPlayer()

   inst:AddComponent("sanityaura")
    inst.components.sanityaura.penalty = 20
        player.components.sanity:RecalculatePenalty()

--------------------
        inst:AddComponent("playerprox")
    inst.components.playerprox:SetDist(7, 7)
    inst.components.playerprox:SetOnPlayerNear(close)
    inst.components.playerprox:SetOnPlayerFar(far)
-------------------
-------
 if ACTIONS.STAYORDER~= nil then
    inst:AddComponent("staycommand")
    	end
-------

    inst.items = items
    inst.equipfn = EquipItem

 --   inst.lifetime = TUNING.SHADOWWAXWELL_LIFETIME
--    inst.death = inst:DoTaskInTime(inst.lifetime, die)

   -- inst.OnSave = onsave
   -- inst.OnLoad = onload

inst:ListenForEvent("hungerdelta", dead)
    inst:ListenForEvent("entity_death", function(wrld, data) onkilll(inst, data) end, GetWorld())
    inst:ListenForEvent("onhitother", OnHitfreeze)


    EquipItem(inst)

    inst:ListenForEvent("entity_death", function(world, data) entitydeathfn(inst, data) end, GetWorld())

    inst:AddComponent("follower")

	--local brain = require"brains/shadowwaxwellbrain"
	local brain = require"brains/shadowmushabrain"
	inst:SetBrain(brain)
	inst:SetStateGraph("SGshadowmusha")


	return inst
end

return Prefab("common/shadowmusha", fn, assets, prefabs)