local RPGArmor = Class(function(self, inst)
    	self.inst = inst
	self.currenttype = "notset"
	self.discovered = false
	self.hasexecuted = false
	self.renamed = false
	self.modifier = nil
	self.inst:DoTaskInTime(0.001, function() self:BuildType() end)
	self.possiblevariations = { 	"durable",
					"fireproof",
					"cozy",
					"dapperness",
					"selfrepairing",
					"healing",
					"fasting",
					"traveller",
					"telelocating",
					"brilliant",
					--curses
					"hungry",
					"slowpoke",
					"insomniac",
					"entombing",
					"telelocating",

					}
	self.functiontree = {}
	self.functiontree.durable = {}
	self.functiontree.durable.modtype = "passivemod"
	self.functiontree.durable.passivemod = self.durablepassivemod
	self.functiontree.fireproof = {}
	self.functiontree.fireproof.modtype = "equipmod"
	self.functiontree.fireproof.onequip = self.fireproofonequip
	self.functiontree.fireproof.onunequip = self.fireproofonunequip
	self.functiontree.cozy = {}
	self.functiontree.cozy.modtype = "passivemod"
	self.functiontree.cozy.passivemod = self.cozypassivemod
	self.functiontree.dapperness = {}
	self.functiontree.dapperness.modtype = "passivemod"
	self.functiontree.dapperness.passivemod = self.dappernesspassivemod
	self.functiontree.selfrepairing = {}
	self.functiontree.selfrepairing.modtype = "passivemod"
	self.functiontree.selfrepairing.passivemod = self.selfrepairingpassivemod
	self.functiontree.healing = {}
	self.functiontree.healing.modtype = "equipmod"
	self.functiontree.healing.onequip = self.healingonequip
	self.functiontree.healing.onunequip = self.healingonunequip
	self.functiontree.healing.tertiary = self.periodichealing
	self.functiontree.fasting = {}
	self.functiontree.fasting.modtype = "equipmod"
	self.functiontree.fasting.onequip = self.fastingonequip
	self.functiontree.fasting.onunequip = self.fastingonunequip
	self.functiontree.hungry = {}
	self.functiontree.hungry.modtype = "equipmod"
	self.functiontree.hungry.onequip = self.hungryonequip
	self.functiontree.hungry.onunequip = self.hungryonunequip
	self.functiontree.slowpoke = {}
	self.functiontree.slowpoke.modtype = "passivemod"
	self.functiontree.slowpoke.passivemod = self.slowpokepassivemod
	self.functiontree.traveller = {}
	self.functiontree.traveller.modtype = "passivemod"
	self.functiontree.traveller.passivemod = self.travellerpassivemod
	self.functiontree.brilliant = {}
	self.functiontree.brilliant.modtype = "equipmod"
	self.functiontree.brilliant.onequip = self.brilliantonequip
	self.functiontree.brilliant.onunequip = self.brilliantonunequip
	self.functiontree.insomniac = {}
	self.functiontree.insomniac.modtype = "equipmod"
	self.functiontree.insomniac.onequip = self.insomniaconequip
	self.functiontree.insomniac.onunequip = self.insomniaconunequip
	self.functiontree.entombing = {}
	self.functiontree.entombing.modtype = "listener"
	self.functiontree.entombing.listener = self.entombinglistener
	self.functiontree.telelocating = {}
	self.functiontree.telelocating.modtype = "listener"
	self.functiontree.telelocating.listener = self.telelocatinglistener
	self.inst:AddTag("unidentified")
end)

function RPGArmor:BuildType()
	if self.currenttype == "notset" then
		if math.random(100) > 80 then
			self.currenttype = self.possiblevariations[math.random(#self.possiblevariations)]
		else
			self.currenttype = "nonmagic"
		end
		if self.inst.ignorerpgeffects and self.inst.ignorerpgeffects == true then
			self.currenttype = "nonmagic"
		end
	end
	if self.currenttype ~= "nonmagic" then
		-- unequip all rpgarmor items before modifying their unequip and equip actions
		if self.inst.components.inventoryitem.owner ~= nil then
			local owner = self.inst.components.inventoryitem.owner
			if owner.components.inventory and owner.components.inventory.equipslots then
				for k,v in pairs (owner.components.inventory.equipslots) do
		            		if v.components.rpgarmor and v.components.equippable:IsEquipped() == true and self.inst == v then
						v.components.equippable:Unequip(owner, v.components.equippable.equipslot)
						-- yes, this next bit is fucking lazy. sue me
						self.inst:DoTaskInTime(0.001, function() 
							v.components.equippable:Equip(owner, v.components.equippable.equipslot)
						end)
					end
		            	end  
			end
	        end
		if self.functiontree[self.currenttype].modtype == "equipmod" then
			local oldonequip = self.inst.components.equippable.onequipfn
			self.inst.components.equippable:SetOnEquip(function(inst, owner)
				self.functiontree[self.currenttype].onequip(self, inst, owner)
				oldonequip(inst, owner)	
			end)
			local oldonunequip = self.inst.components.equippable.onunequipfn
			self.inst.components.equippable:SetOnUnequip(function(inst, owner)
				self.functiontree[self.currenttype].onunequip(self, inst, owner)
				oldonunequip(inst, owner)	
			end)
		end
		if self.functiontree[self.currenttype].modtype == "listener" then
			local oldonequip = self.inst.components.equippable.onequipfn
			self.inst.components.equippable:SetOnEquip(function(inst, owner)
				self.inst:ListenForEvent("attacked", self.functiontree[self.currenttype].listener, owner)
				oldonequip(inst, owner)	
			end)
			local oldonunequip = self.inst.components.equippable.onunequipfn
			self.inst.components.equippable:SetOnUnequip(function(inst, owner)
				self.inst:RemoveEventCallback("attacked", self.functiontree[self.currenttype].listener, owner)
				oldonunequip(inst, owner)			
			end)
		end
		if self.functiontree[self.currenttype].modtype == "passivemod" then
			self.functiontree[self.currenttype].passivemod(self, self.inst)
		end
		self.inst.originalnamepremod = self.inst.name
		if self.discovered == true and not self.renamed then			
			self.inst.components.named:SetName(STRINGS.RPGITEMS.ARMOR.NAMES[self.currenttype] .. " ".. self.inst.originalnamepremod)
			self.renamed = true
		elseif not self.renamed then		
			self.inst.components.named:SetName(self.inst.originalnamepremod .. " (?)")
			self.renamed = true
		end
	end

	
end	

function RPGArmor:OnSave()
	return { renamed = self.renamed, currenttype = self.currenttype, discovered = self.discovered, hasexecuted = self.hasexecuted, modifier = self.modifier }
end

function RPGArmor:OnLoad(data)
	self.currenttype = data.currenttype
	self.discovered = data.discovered
	self.hasexecuted = data.hasexecuted
	self.modifier = data.modifier
	self.renamed =  data.renamed
	if self.discovered then		
		self.inst:RemoveTag("unidentified")
	elseif self.currenttype ~= "nonmagic" then
		self.inst:AddTag("unidentified")
	end
end

function RPGArmor:ReturnString()
	if self.discovered == false and self.currenttype ~= "nonmagic" then
		return "\n" .. STRINGS.RPGITEMS.undiscovered
	elseif self.discovered == true and self.currenttype ~= "nonmagic" then
		return "\n" .. STRINGS.RPGITEMS.ARMOR[self.currenttype]
	end
	return nil
end

--durable
function RPGArmor:durablepassivemod(inst)
	if inst.components.rpgarmor.modifier == nil then
		inst.components.rpgarmor.modifier = math.random(2,8)/10
	end

	if inst.components.rpgarmor.hasexecuted == false then
		inst.components.rpgarmor.hasexecuted = true
		if inst.components.finiteuses then
			inst.components.finiteuses:SetUses(inst.components.finiteuses.current * (1+inst.components.rpgarmor.modifier))
		end
	end

	if inst.components.finiteuses then
		inst.components.finiteuses.total = inst.components.finiteuses.total * (1+inst.components.rpgarmor.modifier)
		--update ui through event (lazymode)
		inst.components.finiteuses:SetUses(inst.components.finiteuses.current)
		
	end
end

--fireproof
function RPGArmor:fireproofonequip(inst, owner)
	if  owner.components.health then
		owner.components.health.fire_damage_scale = owner.components.health.fire_damage_scale - 0.33
		if owner.components.health.fire_damage_scale < 0 then
			owner.components.health.fire_damage_scale = 0
		end
	end
end

function RPGArmor:fireproofonunequip(inst, owner)
	if  owner.components.health then
		owner.components.health.fire_damage_scale = owner.components.health.fire_damage_scale + 0.33
	end
end

--cozy
function RPGArmor:cozypassivemod(inst)
	if not inst.components.insulator then
		inst:AddComponent("insulator")
		inst.components.insulator.insulation = TUNING.INSULATION_SMALL
	else
		inst.components.insulator.insulation = inst.components.insulator.insulation + TUNING.INSULATION_SMALL
	end
end

--dapperness
function RPGArmor:dappernesspassivemod(inst)

	
	if inst.components.equippable then
		inst.components.equippable.dapperness = inst.components.equippable.dapperness + TUNING.DAPPERNESS_TINY

	elseif inst.components.dapperness then

		if not inst.components.dapperness then
			inst:AddComponent("dapperness")
			inst.components.dapperness.dapperness = TUNING.DAPPERNESS_TINY
		else
			inst.components.dapperness.dapperness = inst.components.dapperness.dapperness + TUNING.DAPPERNESS_TINY
		end
	end

end

--selfrepairing
function RPGArmor:selfrepairingpassivemod(inst)
	if inst.components.armor then
		inst:DoPeriodicTask(20, function()
			local modvariable = inst.components.armor.condition +1
			if modvariable > inst.components.armor.maxcondition then
				modvariable = inst.components.armor.condition
			end
		
			inst.components.armor:SetCondition(modvariable)
		end)
	elseif inst.components.fueled and inst.components.fueled.fueltype == "USAGE" then
		inst:DoPeriodicTask(20, function()
			inst.components.fueled:DoDelta(5)			
		end)
	end
end

--healing
function RPGArmor:healingonequip(inst, owner)
	inst.task2 = inst:DoPeriodicTask(20, function() inst.components.rpgarmor.periodichealing(self, inst, owner) end)
end

function RPGArmor:healingonunequip(inst, owner)
	if inst.task2 then inst.task2:Cancel() inst.task2 = nil end
end

function RPGArmor:periodichealing(inst, owner)
	if owner and owner.components.health then 
		owner.components.health:DoDelta(1)
	end
end

--fasting
function RPGArmor:fastingonequip(inst, owner)
	if owner and owner.components.hunger then 
		owner.components.hunger.burnrate = owner.components.hunger.burnrate * 0.8
	end
end

function RPGArmor:fastingonunequip(inst, owner)
	if owner and owner.components.hunger then 
		owner.components.hunger.burnrate = owner.components.hunger.burnrate * 1.25
	end
end

--hungry
function RPGArmor:hungryonequip(inst, owner)
	if owner and owner.components.hunger then 
		owner.components.hunger.burnrate = owner.components.hunger.burnrate * 1.20
	end
end

function RPGArmor:hungryonunequip(inst, owner)
	if owner and owner.components.hunger then 
		owner.components.hunger.burnrate = owner.components.hunger.burnrate * (5/6)
	end
end

--traveller
function RPGArmor:travellerpassivemod(inst)
	if inst.components.equippable.walkspeedmult then
		inst.components.equippable.walkspeedmult = inst.components.equippable.walkspeedmult + 0.10
	else
		inst.components.equippable.walkspeedmult = 1.10
	end
end

--slowpoke
function RPGArmor:slowpokepassivemod(inst)
	if inst.components.equippable.walkspeedmult then
		inst.components.equippable.walkspeedmult = inst.components.equippable.walkspeedmult - 0.10
	else
		inst.components.equippable.walkspeedmult = 0.9
	end
end


--brilliant
function RPGArmor:brilliantonequip(inst, owner)
	if owner and owner.components.builder then
		owner.components.builder.science_bonus = owner.components.builder.science_bonus + 1
	end
end

function RPGArmor:brilliantonunequip(inst, owner)
	if owner and owner.components.builder then
		owner.components.builder.science_bonus = owner.components.builder.science_bonus - 1
	end
end

--insomniac (deal with pre-equip and stack)
function RPGArmor:insomniaconequip(inst, owner)
	if owner and owner:HasTag("insomniac") then
		owner:AddTag("insomniacFAKE")
	else
		owner:AddTag("insomniac")
	end
end

function RPGArmor:insomniaconunequip(inst, owner)
	if owner and owner:HasTag("insomniacFAKE") then
		owner:RemoveTag("insomniacFAKE")
	else
		owner:RemoveTag("insomniac")
	end
end

--entombing
function RPGArmor:entombinglistener(data)
	if math.random(100) > 95 then
		if data and data.attacker and data.attacker.components.freezable then
			data.attacker.components.freezable:AddColdness(4, 2)
	        	data.attacker.components.freezable:SpawnShatterFX()
		end
		if data and data.attacker and data.attacker.components.burnable and data.attacker.components.burnable:IsBurning() then
			data.attacker.components.burnable:Extinguish()
		end
	end
end

--telelocating
local function repetitionteleport(inst)
	local x2, y2, z2 = inst.Transform:GetWorldPosition()
	local x, y, z = inst.Transform:GetWorldPosition()
	x = x+math.random(-20, 20)
	z = z+math.random(-20, 20)
	inst.Transform:SetPosition(x,y,z)
	if not inst:IsOnValidGround() then
		inst.Transform:SetPosition(x2,y2,z2)
		repetitionteleport(inst)
	end
end

function RPGArmor:telelocatinglistener(data)
	if math.random(100) > 95 then
		if data and data.attacker and data.attacker then
			local fx = SpawnPrefab("die_fx")
        		fx.Transform:SetPosition(data.attacker.Transform:GetWorldPosition())
			repetitionteleport(data.attacker)
		end
	end
end



return RPGArmor
