local RPGWeapon = Class(function(self, inst)
    	self.inst = inst
	self.currenttype = "notset"
	self.discovered = false
	self.hasexecuted = false
	self.renamed = false
	self.modifier = nil
	self.inst:DoTaskInTime(0.01, function() self:BuildType() end)
	self.possiblevariations = { 	"igniter",
					"lifesteal",
					"freezer",
					"shrinker",
					"vorpal",
					"blessed",
					"sharp",
					"durable",
					"terrifying",
					"poisoning",
					"selfrepairing",
					-- curses
					"slippery",
					"disappearing",
					"thorny"
					}
--	self.monsterscales = {
--		babybeefalo = 0.7,
--		bat = 0.8,
--		bunnyman = 1.25,
--		deerclops = 1.65,
--		shadowtentacle = 0.5,
--		walrus = 1.5,
--	}
	self.functiontree = {}
	self.functiontree.igniter = {}
	self.functiontree.igniter.modtype = "listener"
	self.functiontree.igniter.listener = self.igniterlistener
	self.functiontree.freezer = {}
	self.functiontree.freezer.modtype = "listener"
	self.functiontree.freezer.listener = self.freezerlistener
	self.functiontree.lifesteal = {}
	self.functiontree.lifesteal.modtype = "listener"
	self.functiontree.lifesteal.listener = self.lifesteallistener
	self.functiontree.shrinker = {}
	self.functiontree.shrinker.modtype = "listener"
	self.functiontree.shrinker.listener = self.shrinkerlistener
	self.functiontree.vorpal = {}
	self.functiontree.vorpal.modtype = "listener"
	self.functiontree.vorpal.listener = self.vorpallistener
	self.functiontree.blessed = {}
	self.functiontree.blessed.modtype = "passivemod"
	self.functiontree.blessed.passivemod = self.blessedpassivemod
	self.functiontree.sharp = {}
	self.functiontree.sharp.modtype = "passivemod"
	self.functiontree.sharp.passivemod = self.sharppassivemod
	self.functiontree.durable = {}
	self.functiontree.durable.modtype = "passivemod"
	self.functiontree.durable.passivemod = self.durablepassivemod
	self.functiontree.terrifying = {}
	self.functiontree.terrifying.modtype = "listener"
	self.functiontree.terrifying.listener = self.terrifyinglistener
	self.functiontree.poisoning = {}
	self.functiontree.poisoning.modtype = "listener"
	self.functiontree.poisoning.listener = self.poisoninglistener
	self.functiontree.slippery = {}
	self.functiontree.slippery.modtype = "listener"
	self.functiontree.slippery.listener = self.slipperylistener
	self.functiontree.disappearing = {}
	self.functiontree.disappearing.modtype = "listener"
	self.functiontree.disappearing.listener = self.disappearinglistener
	self.functiontree.thorny = {}
	self.functiontree.thorny.modtype = "listener"
	self.functiontree.thorny.listener = self.thornylistener
	self.functiontree.selfrepairing = {}
	self.functiontree.selfrepairing.modtype = "passivemod"
	self.functiontree.selfrepairing.passivemod = self.selfrepairingpassivemod
	self.inst:AddTag("unidentified")
end)

function RPGWeapon:BuildType()
	if self.currenttype == "notset" then
		if math.random(100) > 80 then
			self.currenttype = self.possiblevariations[math.random(#self.possiblevariations)]
		else
			self.currenttype = "nonmagic"
		end
		if self.inst.ignorerpgeffects and self.inst.ignorerpgeffects == true then
			self.currenttype = "nonmagic"
		end
	end
	if self.currenttype ~= "nonmagic" then
		if self.functiontree[self.currenttype].modtype == "listener" then
			local oldonequip = self.inst.components.equippable.onequipfn
			self.inst.components.equippable:SetOnEquip(function(inst, owner)
				self.inst:ListenForEvent("onhitother", self.functiontree[self.currenttype].listener, owner)
				oldonequip(inst, owner)	
			end)
			local oldonunequip = self.inst.components.equippable.onunequipfn
			self.inst.components.equippable:SetOnUnequip(function(inst, owner)
				self.inst:RemoveEventCallback("onhitother", self.functiontree[self.currenttype].listener, owner)
				oldonunequip(inst, owner)			
			end)
		end
		if self.inst.components.inventoryitem.owner ~= nil then
			local owner = self.inst.components.inventoryitem.owner
			if owner.components.inventory and owner.components.inventory.equipslots then
				for k,v in pairs (owner.components.inventory.equipslots) do
	            			if v.components.rpgweapon and self.inst == v then
						v.components.equippable:Unequip(owner, v.components.equippable.equipslot)
						v.components.equippable:Equip(owner, v.components.equippable.equipslot)
					end
	            		end        
	        	end
		end
		if self.functiontree[self.currenttype].modtype == "passivemod" then
			self.functiontree[self.currenttype].passivemod(self, self.inst)
		end
		self.inst.originalnamepremod = self.inst.name
		if self.discovered == true and not self.renamed then			
			self.inst.components.named:SetName(STRINGS.RPGITEMS.WEAPONS.NAMES[self.currenttype] .. " ".. self.inst.originalnamepremod)
			self.renamed = true
		elseif not self.renamed then		
			self.inst.components.named:SetName(self.inst.originalnamepremod .. " (?)")
			self.renamed = true
		end
	end

	
end	

function RPGWeapon:OnSave()
	return {renamed = self.renamed, currenttype = self.currenttype, discovered = self.discovered, hasexecuted = self.hasexecuted, modifier = self.modifier }
end

function RPGWeapon:OnLoad(data)
	self.currenttype = data.currenttype
	self.discovered = data.discovered
	self.hasexecuted = data.hasexecuted
	self.modifier = data.modifier
	self.renamed = data.renamed
	if self.discovered then
		self.inst:RemoveTag("unidentified")
	elseif self.currenttype ~= "nonmagic" then
		self.inst:AddTag("unidentified")
	end

end

function RPGWeapon:ReturnString()
	if self.discovered == false and self.currenttype ~= "nonmagic" then
		return "\n" .. STRINGS.RPGITEMS.undiscovered
	elseif self.discovered == true and self.currenttype ~= "nonmagic" then
		return "\n" .. STRINGS.RPGITEMS.WEAPONS[self.currenttype]
	end
	return nil
end

-- igniter
function RPGWeapon:igniterlistener(data)
	local modifiervariable = 3
 	for k,v in pairs (self.components.inventory.equipslots) do
            	if v.components.rpgweapon then
                	modifiervariable = modifiervariable + v.components.weapon.damage / 20
            	end        
        end

	if data.target and math.random(100) >= 97-modifiervariable then
		local target = data.target 
		local fx = SpawnPrefab("explode_small")
        	fx.Transform:SetPosition(target.Transform:GetWorldPosition())
		if target.components.burnable and not target.components.burnable:IsBurning() then
        		if target.components.freezable and target.components.freezable:IsFrozen() then           
        	    		target.components.freezable:Unfreeze()            
        		else            
        	    		target.components.burnable:Ignite()
		    		target.components.burnable:SetBurnTime(modifiervariable)
        		end   
    		end
		if target.components.freezable then
			target.components.freezable:AddColdness(-1)
        		if target.components.freezable:IsFrozen() then
            			target.components.freezable:Unfreeze()            
        		end
    		end
	end
end

-- freezer
function RPGWeapon:freezerlistener(data)
	local modifiervariable = 2
 	for k,v in pairs (self.components.inventory.equipslots) do
            	if v.components.rpgweapon then
                	modifiervariable = modifiervariable + v.components.weapon.damage / 20
            	end        
        end
	if data.target and math.random(100) >= 97-modifiervariable then
		local target = data.target 
    		if target.components.freezable then
        		target.components.freezable:AddColdness(4, modifiervariable)
        		target.components.freezable:SpawnShatterFX()
    		end
   		if target.components.burnable and target.components.burnable:IsBurning() then
        		target.components.burnable:Extinguish()
    		end
	end
end

-- lifesteal
function RPGWeapon:lifesteallistener(data)
	local modifiervariable = 2
     	for k,v in pairs (self.components.inventory.equipslots) do
            	if v.components.rpgweapon then
                	modifiervariable = modifiervariable + v.components.weapon.damage / 20
            	end        
        end
	if self.components.health then
		self.components.health:DoDelta(modifiervariable)
	end
end

-- shrinker
function RPGWeapon:shrinkerlistener(data)
	local modifiervariable = 0.6
	local procvariable = 0.6
	local monsterscales = nil
     	for k,v in pairs (self.components.inventory.equipslots) do
            	if v.components.rpgweapon then
                	modifiervariable = modifiervariable - v.components.weapon.damage / 280
			procvariable = procvariable + v.components.weapon.damage / 280
--			monsterscales = v.components.rpgweapon.monsterscales
            	end        
        end
	if data.target and math.random(100) >= 1-procvariable*3 then

		local target = data.target
		local fx = SpawnPrefab("sparklefx")
--      	fx.Transform:SetPosition(target.Transform:GetWorldPosition())
--		if monsterscales[target.prefab] then
--			modifiervariable = modifiervariable * monsterscales[target.prefab]
--		end
--		target.Transform:SetScale(modifiervariable,modifiervariable,modifiervariable)
		if target.components.locomotor then
			target.components.locomotor.walkspeed = modifiervariable*target.components.locomotor.walkspeed
    			target.components.locomotor.runspeed = modifiervariable*target.components.locomotor.runspeed
			target:DoTaskInTime(3+modifiervariable*3, function() 
--				if monsterscales[target.prefab] then
--					target.Transform:SetScale(monsterscales[target.prefab],monsterscales[target.prefab],monsterscales[target.prefab])
--				else
--					target.Transform:SetScale(1,1,1)
--				end
				target.components.locomotor.walkspeed = target.components.locomotor.walkspeed/modifiervariable
    				target.components.locomotor.runspeed = target.components.locomotor.runspeed/modifiervariable
			end)
		end
	end
end

-- vorpal
function RPGWeapon:vorpallistener(data)
	local modifiervariable = 0
     	for k,v in pairs (self.components.inventory.equipslots) do
            	if v.components.rpgweapon then
                	modifiervariable = modifiervariable + v.components.weapon.damage / 20
            	end        
        end

	if data.target and math.random(100) >= 99-modifiervariable and data.target.components.health then
		local fx = SpawnPrefab("splash_ocean")
        	fx.Transform:SetPosition(data.target.Transform:GetWorldPosition())
		data.target.components.health:DoDelta(-5000)
	end
end

--blessed
function RPGWeapon:blessedpassivemod(inst)
	inst.components.weapon.damage = inst.components.weapon.damage * 1.25
end

--sharp
function RPGWeapon:sharppassivemod(inst)
	inst.components.weapon.damage = inst.components.weapon.damage * 1.10
end

--durable
function RPGWeapon:durablepassivemod(inst)
	if inst.components.rpgweapon.modifier == nil then
		inst.components.rpgweapon.modifier = math.random(2,8)/10
	end

	if inst.components.rpgweapon.hasexecuted == false then
		inst.components.rpgweapon.hasexecuted = true
		if inst.components.finiteuses then
			inst.components.finiteuses:SetUses(inst.components.finiteuses.current * (1+inst.components.rpgweapon.modifier))
		end
	end

	if inst.components.finiteuses then
		inst.components.finiteuses.total = inst.components.finiteuses.total * (1+inst.components.rpgweapon.modifier)
		--update ui through event (lazymode)
		inst.components.finiteuses:SetUses(inst.components.finiteuses.current)
		
	end
end

-- terrifying
function RPGWeapon:terrifyinglistener(data)
	local modifiervariable = 0.6
     	for k,v in pairs (self.components.inventory.equipslots) do
            	if v.components.rpgweapon then
                	modifiervariable = modifiervariable + v.components.weapon.damage / 280
            	end        
        end
	if data.target and math.random(100) >= 95-modifiervariable*3 then

		local target = data.target
		local fx = SpawnPrefab("maxwell_smoke")
        	fx.Transform:SetPosition(target.Transform:GetWorldPosition())
		if target.components.health then
			target.components.health.takingfiredamage = true
			target:DoTaskInTime(3+modifiervariable*3, function() 
				target.components.health.takingfiredamage = false
			end)
		end
	end
end

-- poisoning
function RPGWeapon:poisoninglistener(data)
	local modifiervariable = 0
     	for k,v in pairs (self.components.inventory.equipslots) do
            	if v.components.rpgweapon then
                	modifiervariable = modifiervariable + v.components.weapon.damage
            	end        
        end
	if data.target and math.random(100) >= 95 then
		local target = data.target
		local fx = SpawnPrefab("poison_smoke")
        	fx.Transform:SetPosition(target.Transform:GetWorldPosition())
		if target.components.health then
			target:DoTaskInTime(3, function() target.components.health:DoDelta(-(modifiervariable/3)) end)
			target:DoTaskInTime(6, function() target.components.health:DoDelta(-(modifiervariable/3)) end)
			target:DoTaskInTime(9, function() target.components.health:DoDelta(-(modifiervariable/3)) end)
		end
	end
end

-- slippery
function RPGWeapon:slipperylistener(data)
     	for k,v in pairs (self.components.inventory.equipslots) do
            	if v.components.rpgweapon and math.random(100) >= 95 then 
                	self.components.inventory:DropItem(v)
			local fx = SpawnPrefab("small_puff")
        		fx.Transform:SetPosition(self.Transform:GetWorldPosition())	
            	end        
        end
end

-- disappearing
function RPGWeapon:disappearinglistener(data)
     	for k,v in pairs (self.components.inventory.equipslots) do
            	if v.components.rpgweapon and math.random(100) >= 99 then 
                	self.components.inventory:DropItem(v)
			v:Remove()
			local fx = SpawnPrefab("small_puff")
        		fx.Transform:SetPosition(self.Transform:GetWorldPosition())
            	end        
        end
end

-- thorny
function RPGWeapon:thornylistener(data)
     	for k,v in pairs (self.components.inventory.equipslots) do
            	if v.components.rpgweapon then 
			if self.components.health then
                		self.components.health:DoDelta(-1)
			end
            	end        
        end
end

--selfrepairing
function RPGWeapon:selfrepairingpassivemod(inst)
	if inst.components.finiteuses then
		inst:DoPeriodicTask(20, function()
			local modvariable = inst.components.finiteuses.current +1
			if modvariable > inst.components.finiteuses.total then
				modvariable = inst.components.finiteuses.current
			end
		
			inst.components.finiteuses:SetUses(modvariable)
		end)
	end
end

return RPGWeapon
