local assets=
{
	Asset("ANIM", "anim/magnifyin.zip"),
	Asset("ATLAS", "images/inventoryimages/magnifyingglass.xml"),
}

local function onfinished(inst)
	inst:Remove()
end


local function onsewn(inst, target, doer)
	if doer.SoundEmitter then
		doer.SoundEmitter:PlaySound("dontstarve/HUD/repair_clothing")
	end
end

local function fn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    inst.entity:AddNetwork()
    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("nightmaresword")
    inst.AnimState:SetBuild("magnifyin")
    inst.AnimState:PlayAnimation("idle")
    
    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
    
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(TUNING.SEWINGKIT_USES)
    inst.components.finiteuses:SetUses(TUNING.SEWINGKIT_USES)
    inst.components.finiteuses:SetOnFinished( onfinished )

    inst:AddComponent("magnifyidentify")
    
    
    
    
    
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/magnifyingglass.xml"

    return inst
end

return Prefab( "common/inventory/magnifyingglass", fn, assets) 


