
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {


        Asset( "ANIM", "anim/tomoya.zip" ),
        Asset( "ANIM", "anim/ghost_tomoya_build.zip" ),
	Asset( "ANIM", "anim/clannad_light.zip" ),
}
local prefabs = {}
local start_inv = {
	"clannad_light",
}




local function applyupgrades(inst)

	local max_upgrades = 13
	local upgrades = math.min(inst.level, max_upgrades)

	local hunger_percent = inst.components.hunger:GetPercent()
	local health_percent = inst.components.health:GetPercent()
	local sanity_percent = inst.components.sanity:GetPercent()

	inst.components.hunger.max = math.ceil (100 + upgrades / 0.13)
	inst.components.health.maxhealth = math.ceil (100 + upgrades / 0.065)
	inst.components.sanity.max = math.ceil (100 + upgrades / 0.13)
	
	inst.components.locomotor.walkspeed =  math.ceil (6 + upgrades / 5)
	inst.components.locomotor.runspeed = math.ceil (5 + upgrades / 3)
	
	
	inst.components.talker:Say("Level : ".. (inst.level))
	
	if inst.level >12 then
		inst.components.talker:Say("da n go da i ka zo ku!")
	end

	inst.components.hunger:SetPercent(hunger_percent)
	inst.components.health:SetPercent(health_percent)
	inst.components.sanity:SetPercent(sanity_percent)

end

local function oneat(inst, food)
	
	if food and food.components.edible and food.prefab == "clannad_light" then
		--give an upgrade!
		inst.level = inst.level + 1
		applyupgrades(inst)	
	end
end

local function onpreload(inst, data)
	if data then
		if data.level then
			inst.level = data.level
			applyupgrades(inst)
			--re-set these from the save data, because of load-order clipping issues
			if data.health and data.health.health then inst.components.health.currenthealth = data.health.health end
			if data.hunger and data.hunger.hunger then inst.components.hunger.current = data.hunger.hunger end
			if data.sanity and data.sanity.current then inst.components.sanity.current = data.sanity.current end
			inst.components.health:DoDelta(0)
			inst.components.hunger:DoDelta(0)
			inst.components.sanity:DoDelta(0)
		end
	end
end

local function onsave(inst, data)
	data.level = inst.level
	data.charge_time = inst.charge_time
end

-- This initializes for both clients and the host
local common_postinit = function(inst) 
	-- choose which sounds this character will play
	inst.soundsname = "willow"

	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "tomoya.tex" )
end

-- This initializes for the host only
local master_postinit = function(inst)

	inst.level = 0
	inst.components.eater:SetOnEatFn(oneat)
	applyupgrades(inst)
	-- Stats	
	inst.components.health:SetMaxHealth(100)
	inst.components.hunger:SetMax(100)
	inst.components.sanity:SetMax(100)
	inst.components.locomotor.walkspeed = 6
	inst.components.locomotor.runspeed = 5
	inst.components.combat.damagemultiplier = 1
	--inst.components.sanity.dapperness = 1
	inst.components.health.fire_damage_scale = 0
	inst.components.health.absorb = 0.8
	inst.components.temperature.mintemp = 10
	inst.components.temperature.maxtemp = 20
	inst.OnSave = onsave
	inst.OnPreLoad = onpreload
end
return MakePlayerCharacter("tomoya", prefabs, assets, common_postinit, master_postinit, start_inv)
