--[[
 -- @Description:
 -- Hello , DiaoSi ~ ( or not ? ) ,glad you saw my comment
 -- If you think my mod is okay , you can sponsor my breakfast by a tiny amount donation  ($_$)
 -- paypal:td1madao@163.com     alipay:td1madao@163.com
 -- If any question ,Please email me
 -- What's more ,don't modify and republish my mods . 3Q for cooperation
 -- What's more ,don't modify and republish my mods . 3Q for cooperation
 -- What's more ,don't modify and republish my mods . 3Q for cooperation
 -- @version 1.0.0
 -- @author td1madao
 -- @email td1madao@163.com
 -- @qq 360810498
 -- @date 16/8/6
 ]]
local TD = TD.td1madao.rivendst
local Rivendst_global_anim = Class(function(self, inst)
    self.inst = inst
    self.common_speed = net_float(inst.GUID, "td1madao.rivendst.common_speed", "td1madao_rivendst_common_speed")
    self.common_rotation = net_float(inst.GUID, "td1madao.rivendst.common_rotation", "td1madao_rivendst_common_rotation")
    self.common_anim = {}
    self.common_anim.animQ1 = 1
    self.common_anim.animQ2 = 2
    self.common_anim.animQ3 = 3
    self.common_anim.animW = 4
    self.common_anim.animE = 5
    self.common_anim.animR2 = 6
    self.anim_all = net_smallbyte(inst.GUID, "td1madao.rivendst.anim_all", "td1madao_rivendst_anim_all")
    self.inst:ListenForEvent("td1madao_rivendst_anim_all", function()
        local animId = self.anim_all:value()
        local common_animLen = table.td1madao_entLen(self.common_anim)
        animId = math.mod(animId, common_animLen)
        if animId == 0 then
            animId = common_animLen
        end
        local name = self:common_getAnimName(animId)
        if name ~= "nil" and self["cast" .. name] then
            self["cast" .. name](self)
        end
    end)
end)

function Rivendst_global_anim:server_setByAnimNum(name)
    if not name or not TD.isServer() then
        return
    end
    local num = self:common_getAnimNum(name)
    local oldNum = self.anim_all:value()
    if num ~= -1 then
        if num == oldNum then
            num = num + table.td1madao_entLen(self.common_anim)
        end
        self.anim_all:set(num)
    end
end

function Rivendst_global_anim:common_getAnimNum(name)
    if not name then
        return -1
    end
    return self.common_anim[name] or -1
end

function Rivendst_global_anim:common_getAnimName(num)
    if not num then
        return "nil"
    end
    local common_anim = self.common_anim
    for k, v in pairs(common_anim) do
        if k and common_anim[k] and common_anim[k] == num then
            return k
        end
    end
    return "nil"
end

function Rivendst_global_anim:common_getSpeed()
    local name = "common_speed"
    if name and self[name] then
        return self[name]:value()
    end
    return 1
end

function Rivendst_global_anim:common_getRotation()
    local name = "common_rotation"
    if name and self[name] then
        return self[name]:value()
    end
    return 1
end

function Rivendst_global_anim:server_set(name, val)
    if name and val ~= nil and self[name] then
        self[name]:set(val)
    end
end

function Rivendst_global_anim:server_revert(name)
    if not name or not self[name] or not TD.isServer() then
        return
    end
    local val = not self[name]:value()
    self[name]:set(val)
end

function Rivendst_global_anim:castanimQ1()
    local player = self.inst
    TD.stopMove(player)
    self.inst.Transform:SetRotation(self:common_getRotation())
    TD.anim(player, 1 * FRAMES, "atk", function()
        local speed = self:common_getSpeed()
        if player.Physics.SetMotorVelOverride ~= nil then
            player.Physics:SetMotorVelOverride(.35 * speed, 0, 0)
        end
    end)
    TD.anim(player, 10 * FRAMES, nil, nil, true)
end

function Rivendst_global_anim:castanimQ2()
    local player = self.inst
    TD.stopMove(player)
    self.inst.Transform:SetRotation(self:common_getRotation())
    TD.anim(player, 1 * FRAMES, "shovel_pre", function()
        local speed = self:common_getSpeed()
        if player.Physics.SetMotorVelOverride ~= nil then
            player.Physics:SetMotorVelOverride(.35 * speed, 0, 0)
        end
    end)
    TD.anim(player, 5 * FRAMES, "shovel_loop")
    TD.anim(player, 10 * FRAMES, nil, nil, true)
end

function Rivendst_global_anim:castanimQ3()
    local player = self.inst
    TD.stopMove(player)
    self.inst.Transform:SetRotation(self:common_getRotation())
    TD.anim(player, 5 * FRAMES, "jump", function()
        local speed = self:common_getSpeed()
        if player.Physics.SetMotorVelOverride ~= nil then
            player.Physics:SetMotorVelOverride(.35 * speed, 0, 0)
        end
    end)
    TD.anim(player, 12 * FRAMES, "atk")
    TD.anim(player, 20 * FRAMES, nil, nil, true)
end

function Rivendst_global_anim:castanimW()
    local player = self.inst
    TD.stopMove(player)
    TD.anim(player, 1 * FRAMES, "atk")
    TD.anim(player, 9 * FRAMES, nil, nil, true)
end

function Rivendst_global_anim:castanimE()
    local player = self.inst
    TD.stopMove(player)
    self.inst.Transform:SetRotation(self:common_getRotation())
    TD.anim(player, 1 * FRAMES, "shovel_pre", function()
        local speed = self:common_getSpeed()
        if player.Physics.SetMotorVelOverride ~= nil then
            player.Physics:SetMotorVelOverride(.35 * speed, 0, 0)
        end
    end)
    TD.anim(player, 5 * FRAMES, "shovel_loop")
    TD.anim(player, 10 * FRAMES, nil, nil, true)
end

function Rivendst_global_anim:castanimR2()
    local player = self.inst
    TD.stopMove(player)
    self.inst.Transform:SetRotation(self:common_getRotation())
    TD.anim(player, 1 * FRAMES, "atk")
    TD.anim(player, 6 * FRAMES, "jump", function()
        local speed = self:common_getSpeed()
        if player.Physics.SetMotorVelOverride ~= nil then
            player.Physics:SetMotorVelOverride(.3 * speed, 0, 0)
        end
    end)
    TD.anim(player, 12 * FRAMES, "shovel_pre")
    TD.anim(player, 18 * FRAMES, "atk")
    TD.anim(player, 21 * FRAMES, nil, nil, true, true)
    TD.anim(player, 28 * FRAMES, nil, nil, true)
end

return Rivendst_global_anim