--[[
 -- @Description:
 -- Hello , DiaoSi ~ ( or not ? ) ,glad you saw my comment
 -- If you think my mod is okay , you can sponsor my breakfast by a tiny amount donation  ($_$)
 -- paypal:td1madao@163.com     alipay:td1madao@163.com
 -- If any question ,Please email me
 -- What's more ,don't modify and republish my mods . 3Q for cooperation
 -- What's more ,don't modify and republish my mods . 3Q for cooperation
 -- What's more ,don't modify and republish my mods . 3Q for cooperation
 -- @version 1.0.0
 -- @author td1madao
 -- @email td1madao@163.com
 -- @qq 360810498
 -- @date 16/8/6
 ]]
local TD = TD.td1madao.rivendst
local Rivendst_server_lv_manager = Class(function(self, inst)
    TD.see()
    self.inst = inst
    self.expBase = MADAO.RIVENDST_EXP_BASE
    self.expRaise = MADAO.RIVENDST_EXP_RAISE
    self.exp = 0
    self.level = 1
end)

function Rivendst_server_lv_manager:OnSave()
    return
    {
        exp = self.exp or 0,
        level = self.level or 1,
    }
end

function Rivendst_server_lv_manager:OnLoad(data)
    if data ~= nil and self.inst then
        self.exp = data.exp or 0
        self.level = data.level or 1
    end
    self:loadFn()
end

function Rivendst_server_lv_manager:loadFn()
    local syn = TD.getC(self.inst, "rivendst_common_synchronizer")
    syn:server_set("level", 999)
    syn:server_set("exp", 999)
    TD.getC(self.inst, "rivendst_common_task_manager"):player_task(0.1, function()
        syn:server_set("level", 999)
        syn:server_set("exp", 999)
    end, "td1madao_rivendst_syn_level_and_exp_task")
    TD.getC(self.inst, "rivendst_common_task_manager"):player_task(0.5, function()
        syn:server_set("level", self.level)
        syn:server_set("exp", self.exp)
        self:server_refresh_player_attri()
    end, "td1madao_rivendst_syn_level_and_exp_task")
end

function Rivendst_server_lv_manager:server_getExp(num)
    if not num then
        return
    end
    local leveluped = false
    self.exp = self.exp + num
    local need = math.ceil(math.pow(self.expRaise, (self.level - 1)) * self.expBase)
    while self.exp >= need do
        self.exp = self.exp - need
        self.level = self.level + 1
        need = math.pow(self.expRaise, (self.level - 1)) * self.expBase
        leveluped = true
    end
    if leveluped then
        TD.color(TD.below(self.inst, "statue_transition"), 0, .5, 1).Transform:SetScale(2, 2, 2)
        TD.color(TD.below(self.inst, "explode_small"), .5, 1, 1).Transform:SetScale(2, 2, 2)
        self:server_refresh_player_attri()
        self:server_synchronize()
    else
        self:server_synchronize(true)
    end
end

function Rivendst_server_lv_manager:server_synchronize(expOnly)
    local syn = TD.getC(self.inst, "rivendst_common_synchronizer")
    if not expOnly then
        syn:server_set("level", self.level)
    end
    syn:server_set("exp", self.exp)
end

function Rivendst_server_lv_manager:server_refresh_player_attri()
    self.inst.components.hunger.max = math.ceil(MADAO.RIVENDST_MAX_HUNGER + MADAO.RIVENDST_MAX_HUNGER_RAISE * self.level)
    self.inst.components.health.maxhealth = math.ceil(MADAO.RIVENDST_MAX_HEALTH + MADAO.RIVENDST_MAX_HEALTH_RAISE * self.level)
    self.inst.components.sanity.max = math.ceil(MADAO.RIVENDST_MAX_SANITY + MADAO.RIVENDST_MAX_SANITY_RAISE * self.level)
    if self.inst.components.hunger.current > self.inst.components.hunger.max then
        self.inst.components.hunger.current = self.inst.components.hunger.max
    end
    if self.inst.components.health.currenthealth > self.inst.components.health.maxhealth then
        self.inst.components.health.currenthealth = self.inst.components.health.maxhealth
    end
    if self.inst.components.sanity.current > self.inst.components.sanity.max then
        self.inst.components.sanity.current = self.inst.components.sanity.max
    end
end

return Rivendst_server_lv_manager