--[[
 -- @Description:
 -- Hello , DiaoSi ~ ( or not ? ) ,glad you saw my comment
 -- If you think my mod is okay , you can sponsor my breakfast by a tiny amount donation  ($_$)
 -- paypal:td1madao@163.com     alipay:td1madao@163.com
 -- If any question ,Please email me
 -- What's more ,don't modify and republish my mods . 3Q for cooperation
 -- What's more ,don't modify and republish my mods . 3Q for cooperation
 -- What's more ,don't modify and republish my mods . 3Q for cooperation
 -- @version 1.0.0
 -- @author td1madao
 -- @email td1madao@163.com
 -- @qq 360810498
 -- @date 16/8/6
 ]]
local TD = TD.td1madao.rivendst
local assets = {
    Asset("ANIM", "anim/rivendizzy.zip"),
    Asset("ANIM", "anim/rivenq.zip"),
    Asset("ANIM", "anim/rivenw.zip"),
    Asset("ANIM", "anim/rivenr.zip"),
    Asset("ANIM", "anim/rivendst_shield.zip"),
}
local function common(build, bank, fn)
    local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
    inst.AnimState:SetBuild(build)
    inst.AnimState:SetBank(bank or build)
    if fn then
        fn(inst)
    end
    inst.entity:SetPristine()
    inst.persists = false
    return inst
end

return Prefab("rivendizzy", function()
    local inst = common("rivendizzy")
    inst.AnimState:PlayAnimation("idle")
    if not TheWorld.ismastersim then
        return inst
    end
    inst:DoTaskInTime(1.5, function() TD.remove(inst) end)
    return inst
end, assets),
Prefab("rivenq1", function()
    local inst = common("rivenq")
    inst.AnimState:SetMultColour(0, 1, 0, 1)
    inst.Transform:SetScale(3, 3, 3)
    local matran = math.random()
    if matran < 0.5 then
        inst.AnimState:PlayAnimation("Q1", false)
    else
        inst.AnimState:PlayAnimation("Q2", false)
    end
    if not TheWorld.ismastersim then
        return inst
    end
    if matran < 0.5 then
        inst:DoTaskInTime(0.17, function() TD.remove(inst) end)
    else
        inst:DoTaskInTime(0.22, function() TD.remove(inst) end)
    end
    return inst
end, assets),
Prefab("rivenq2", function()
    local inst = common("rivenq")
    inst.Transform:SetScale(5, 5, 5)
    inst.AnimState:PlayAnimation("Q3", false)
    if not TheWorld.ismastersim then
        return inst
    end
    inst:DoTaskInTime(0.28, function() TD.remove(inst) end)
    return inst
end, assets),
Prefab("rivenr", function()
    local inst = common("rivenr", nil, function(inst)
        inst.Transform:SetFourFaced()
        MakeInventoryPhysics(inst)
        RemovePhysicsColliders(inst)
    end)
    inst.Transform:SetScale(5, 5, 5)
    inst.AnimState:PlayAnimation("idle", false)
    if not TheWorld.ismastersim then
        return inst
    end
    inst:AddComponent("locomotor")
    inst.components.locomotor.runspeed = 7
    inst:DoTaskInTime(3, function() TD.remove(inst) end)
    return inst
end, assets),
Prefab("rivenw", function()
    local inst = common("rivenw")
    inst.AnimState:PlayAnimation("rivenw_play", false)
    inst.AnimState:SetLayer(LAYER_BACKGROUND)
    inst.AnimState:SetSortOrder(3)
    if not TheWorld.ismastersim then
        return inst
    end
    inst:DoTaskInTime(2, function() TD.remove(inst) end)
    return inst
end, assets),
Prefab("rivendst_shield", function()
    local inst = common("rivendst_shield", "rivendst_shield", function(inst)
        inst.Transform:SetScale(2.5, 2.5, 2.5)
    end)
    inst.AnimState:PlayAnimation("idle", true)
    if not TheWorld.ismastersim then
        return inst
    end
    inst:DoTaskInTime(2.5, function() TD.remove(inst) end)
    return inst
end, assets)