--[[
 -- @Description:
 -- Hello , DiaoSi ~ ( or not ? ) ,glad you saw my comment
 -- If you think my mod is okay , you can sponsor my breakfast by a tiny amount donation  ($_$)
 -- paypal:td1madao@163.com     alipay:td1madao@163.com
 -- If any question ,Please email me
 -- What's more ,don't modify and republish my mods . 3Q for cooperation
 -- What's more ,don't modify and republish my mods . 3Q for cooperation
 -- What's more ,don't modify and republish my mods . 3Q for cooperation
 -- @version 1.0.0
 -- @author td1madao
 -- @email td1madao@163.com
 -- @qq 360810498
 -- @date 16/8/6
 ]]
local assets =
{
    Asset("ANIM", "anim/rivensword.zip"),
    Asset("ANIM", "anim/swap_rivensword.zip"),
    Asset("ATLAS", "images/rivensword.xml"),
    Asset("IMAGE", "images/rivensword.tex"),
}
local TD = TD.td1madao.rivendst
local prefabs =
{}
local function OnEquip(inst, owner)
    if owner and TD.getC(owner, "rivendst_common_synchronizer"):server_get("rivenRtwice") then
        owner.AnimState:OverrideSymbol("swap_object", "swap_rivensword", "rivensword2")
        inst.components.weapon:SetRange(2)
    else
        owner.AnimState:OverrideSymbol("swap_object", "swap_rivensword", "rivensword1")
        inst.components.weapon:SetRange(nil)
    end
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
end

local function OnUnequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end

local function fn()
    local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddNetwork()
    local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    anim:SetBank("rivensword")
    anim:SetBuild("rivensword")
    inst:AddTag("sharp")
    inst:AddTag("rivendstsword")
    anim:PlayAnimation("idle")
    inst.entity:SetPristine()
    inst.persists = true
    if not TheWorld.ismastersim then
        return inst
    end
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(34)
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "rivensword"
    inst.components.inventoryitem.atlasname = "images/rivensword.xml"
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(OnEquip)
    inst.components.equippable:SetOnUnequip(OnUnequip)
    return inst
end

return Prefab("common/inventory/rivendstsword", fn, assets, prefabs)