--[[
 -- @Description:
 -- Hello , DiaoSi ~ ( or not ? ) ,glad you saw my comment
 -- If you think my mod is okay , you can sponsor my breakfast by a tiny amount donation  ($_$)
 -- paypal:td1madao@163.com     alipay:td1madao@163.com
 -- If any question ,Please email me
 -- What's more ,don't modify and republish my mods . 3Q for cooperation
 -- What's more ,don't modify and republish my mods . 3Q for cooperation
 -- What's more ,don't modify and republish my mods . 3Q for cooperation
 -- @version 1.0.0
 -- @author td1madao
 -- @email td1madao@163.com
 -- @qq 360810498
 -- @date 16/8/6
 ]]
local TD = TD.td1madao.rivendst
local Button = require "widgets/button"
local Image = require "widgets/image"
local Text = require "widgets/text"
local ImageButton = require "widgets/imagebutton"
local Rivendstskillbar = Class(Button, function(self, atlas, normal_tex, x, y, clickable, tag, player, clickFn)
    Button._ctor(self, "Rivendstskillbar")
    if not player then
        return
    end
    if clickable and tag then
        self.image = self:AddChild(ImageButton(atlas, normal_tex))
        if clickFn then
            self.image:SetOnClick(clickFn)
        end
    else
        self.image = self:AddChild(Image(atlas, normal_tex))
    end
    self.text0 = self:AddChild(Text(NUMBERFONT, 40))
    self.clickable = clickable
    local perioder = TD.getC(player, "rivendst_common_perioder")
    if clickable and tag and player.td1madaoRivendstSkillWidgetBase then
        local xscale, yscale, zscale = player.td1madaoRivendstSkillWidgetBase:GetScale():Get()
        local function refresh(first)
            local buffer = perioder.buffer
            if not buffer.scale and not buffer.scale2 then
                local scr_w, scr_h = TheSim:GetScreenSize()
                local scale = (scr_w / 1366)
                buffer.scale = scale
                buffer.scale2 = scr_h / 706 / scale
            end
            local scale = buffer.scale
            local scale2 = buffer.scale2
            if perioder.bak.scale == scale and perioder.bak.scale2 == scale2 then
                return
            end
            if first then
                scale = 1
                xscale = 1
                yscale = 1
                zscale = 1
            end
            if not buffer.scale2 then
                buffer.scale2 = 1
            end
            self.image:SetScale(xscale, yscale, zscale)
            local offset = (buffer.scale2 - 1) * (150 / (MADAO.RIVENDST_UI_X_END - MADAO.RIVENDST_UI_X_START) * (x - MADAO.RIVENDST_UI_X_START) - 50) -- offset = 100->V  -50->Z
            self.image:SetPosition(((x + offset) * xscale * scale), y * yscale * scale, 0)
            self:SetPosition(((x + offset + 4) * xscale * scale), y * yscale * scale, 0)
            self.text0:MoveToFront()
        end
        perioder:common_addTask("td1madao_rivendst_widget_refresh_" .. tag, refresh, 1)
        self.image:SetScaleMode(SCALEMODE_PROPORTIONAL)
        self:SetScaleMode(SCALEMODE_PROPORTIONAL)
        refresh(true)
    else
        player.td1madaoRivendstSkillWidgetBase = self
        local function refresh(first)
            local buffer = perioder.buffer
            if not buffer.scale and not buffer.scale2 then
                local scr_w, scr_h = TheSim:GetScreenSize()
                local scale = (scr_w / 1366)
                buffer.scale = scale
                buffer.scale2 = scr_h / 706 / scale
            end
            local scale = buffer.scale
            local scale2 = buffer.scale2
            if perioder.bak.scale == scale and perioder.bak.scale2 == scale2 then
                return
            end
            if first then
                scale = 1
            end
            if not buffer.scale2 then
                buffer.scale2 = 1
            end
            self:SetPosition((x + 4) * scale, y * scale, 0)
            self.image:SetPosition(x * scale, y * scale, 0)
        end

        perioder:common_addTask("td1madao_rivendst_widget_refresh_base", refresh, 1)
        self.image:SetScaleMode(SCALEMODE_PROPORTIONAL)
        self:SetScaleMode(SCALEMODE_PROPORTIONAL)
        refresh(true)
    end
    self.text0:SetVAlign(ANCHOR_MIDDLE)
    self.text0:SetHAlign(ANCHOR_MIDDLE)
    self.image:SetVAnchor(ANCHOR_BOTTOM)
    self.image:SetHAnchor(ANCHOR_LEFT)
    self.text0:SetColour({ 0, 1, 0, 1 })
    self.text0:SetString("")
    self.text0:MoveToFront()
end)
function Rivendstskillbar:setTint(a, b, c, d)
    if self.clickable then
        self.image.image:SetTint(a, b, c, d)
    else
        self.image:SetTint(a, b, c, d)
    end
end

function Rivendstskillbar:setColour(a, b, c, d)
    self.text0:SetColour({ a, b, c, d })
end

function Rivendstskillbar:setString(str)
    self.text0:SetString(str)
    self.text0:MoveToFront()
end

function Rivendstskillbar:flush()
    self.text0:MoveToFront()
end


return Rivendstskillbar





