-- require "prefabutil"

local assets=
{
	Asset("ATLAS", "images/inventoryimages/wooddoor.xml"),
    Asset("IMAGE", "images/inventoryimages/wooddoor.tex"),
	Asset("ATLAS", "images/inventoryimages/haydoor.xml"),
    Asset("IMAGE", "images/inventoryimages/haydoor.tex"),
	Asset("ATLAS", "images/inventoryimages/stonedoor.xml"),
    Asset("IMAGE", "images/inventoryimages/stonedoor.tex"),
	Asset("ATLAS", "images/inventoryimages/ruindoor.xml"),
    Asset("IMAGE", "images/inventoryimages/ruindoor.tex"),
	Asset("ATLAS", "images/inventoryimages/limestonedoor.xml"),
    Asset("IMAGE", "images/inventoryimages/limestonedoor.tex"),
	Asset("ATLAS", "images/inventoryimages/limestonewall.xml"),
    Asset("IMAGE", "images/inventoryimages/limestonewall.tex"),
	Asset("ATLAS", "images/inventoryimages/moonrockdoor.xml"),
    Asset("IMAGE", "images/inventoryimages/moonrockdoor.tex"),
	Asset("ATLAS", "images/inventoryimages/moonrockwall.xml"),
    Asset("IMAGE", "images/inventoryimages/moonrockwall.tex"),
	Asset("ANIM", "anim/dyc_wall.zip"),
	Asset("ANIM", "anim/dyc_wall_wood.zip"),
	Asset("ANIM", "anim/dyc_wall_hay.zip"),
	Asset("ANIM", "anim/dyc_wall_stone.zip"),
	Asset("ANIM", "anim/dyc_wall_ruins.zip"),
	Asset("ANIM", "anim/dyc_wall_limestone.zip"),
	Asset("ANIM", "anim/dyc_wall_moonrock.zip"),
}

local prefabs =
{
	"collapse_small",
}


local function makeobstacle(inst)
	-- print('makeobstacle superwall.lua')
	
	inst.Physics:SetCollisionGroup(COLLISION.OBSTACLES)	
	inst.Physics:ClearCollisionMask()
	inst.Physics:SetMass(0)
	inst.Physics:CollidesWith(COLLISION.ITEMS)
	inst.Physics:CollidesWith(COLLISION.CHARACTERS)
	inst.Physics:SetActive(true)
	local ground = GetWorld()
	if ground then
	    local pt = Point(inst.Transform:GetWorldPosition())
	    ground.Pathfinder:AddWall(pt.x, pt.y, pt.z)
	end
end

local function clearobstacle(inst)
		
	inst:DoTaskInTime(2*FRAMES, function() inst.Physics:SetActive(false) end)
	local ground = GetWorld()
	if ground then
	    local pt = Point(inst.Transform:GetWorldPosition())
	    ground.Pathfinder:RemoveWall(pt.x, pt.y, pt.z)
	end
end

local function getwallanim_dyc (inst)
	
	local wallpercent=inst.wallpercent
	-- if inst.dlc==2 then
		if wallpercent>=1 then
			return "fullA"
		elseif wallpercent>=0.75 then
			return "threequarter"
		elseif wallpercent>=0.5 then
			return "half"
		elseif wallpercent>=0.25 then
			return "onequarter"
		elseif wallpercent>=0 then
			return "broken"
		end
		return "broken"
	-- else
		-- if wallpercent>=1 then
			-- return "1"
		-- elseif wallpercent>=0.75 then
			-- return "3_4"
		-- elseif wallpercent>=0.5 then
			-- return "1_2"
		-- elseif wallpercent>=0.25 then
			-- return "1_4"
		-- elseif wallpercent>=0 then
			-- return "0"
		-- end
		-- return "0"
	-- end
	
end

local function updatewallphysics (inst)
	if inst.doorstate and inst.components.workable.workleft>0 then
		makeobstacle(inst)
	else 
		clearobstacle(inst)
	end
end

local function quantizeposition(pt)
	local retval = Vector3(math.floor(pt.x)+.5, 0, math.floor(pt.z)+.5)
	return retval
end 

local function ondeploywall(inst, pt, deployer)
	--inst.SoundEmitter:PlaySound("dontstarve/creatures/spider/spider_egg_sack")
	local wall = SpawnPrefab(inst.deployprefab) 
	
	if wall then 
		pt = quantizeposition(pt)
		wall.Physics:SetCollides(false)
		wall.Physics:Teleport(pt.x, pt.y, pt.z) 
		wall.Physics:SetCollides(true)
		inst.components.stackable:Get():Remove()

		local ground = GetWorld()
		if ground then
		    ground.Pathfinder:AddWall(pt.x, pt.y, pt.z)
		end
	end 		
end

local function onhammered(inst, worker)
	if not inst.islastworkvalid then
		return
	end
	
	if inst.loot then
		local num_loots = 1
		for k = 1, num_loots do
			inst.components.lootdropper:SpawnLootPrefab(inst.loot)
		end
	end
		
	SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
		
	if inst.destroysound then
		inst.SoundEmitter:PlaySound(inst.destroysound)		
	end
		
	inst:Remove()
end

local function test_wall(inst, pt)
	local tiletype = GetGroundTypeAtPosition(pt)
	local ground_OK = false
	if inst.dlc==2 then
		ground_OK = tiletype ~= GROUND.IMPASSABLE and not GetWorld().Map:IsWater(tiletype)
	else
		ground_OK = tiletype ~= GROUND.IMPASSABLE
	end
	
	if ground_OK then
		local ents = TheSim:FindEntities(pt.x,pt.y,pt.z, 2, nil, {"NOBLOCK", "player", "FX", "INLIMBO", "DECOR"}) 

		for k, v in pairs(ents) do
			if v ~= inst and v.entity:IsValid() and v.entity:IsVisible() and not v.components.placer and v.parent == nil then
				local dsq = distsq( Vector3(v.Transform:GetWorldPosition()), pt)
				if v:HasTag("wall") then
					if dsq < .1 then return false end
				else
					if  dsq< 1 then return false end
				end
			end
		end
		
		if inst.dlc==2 then
			local playerPos = GetPlayer():GetPosition()
			local xDiff = playerPos.x - pt.x 
			local zDiff = playerPos.z - pt.z 
			local dsq = xDiff * xDiff + zDiff * zDiff
			if dsq < .5 then 
				return false 
			end 
		end

		return true

	end
	return false	
end



local function onhealthchange(inst, old_percent, new_percent)
	inst.components.health.currenthealth = inst.components.health.maxhealth
	new_percent=1
	if old_percent <= 0 and new_percent > 0 then makeobstacle(inst) end
	if old_percent > 0 and new_percent <= 0 then clearobstacle(inst) end

	local anim_to_play = getwallanim_dyc(inst)
	if inst.wallpercent==0 then
		inst.AnimState:PlayAnimation(anim_to_play)		
	else
		inst.AnimState:PlayAnimation(anim_to_play.."_hit")		
		inst.AnimState:PushAnimation(anim_to_play, false)
	end
	
end

local function dooritemfn()

		local inst = CreateEntity()
		inst:AddTag("wallbuilder")
		
		inst.dlc=0
		if IsDLCEnabled(REIGN_OF_GIANTS) then
			inst.dlc=1
		elseif SaveGameIndex:IsModeShipwrecked() then
			inst.dlc=2
		end
		
		inst.entity:AddTransform()
		inst.entity:AddAnimState()
		MakeInventoryPhysics(inst)

		inst:AddComponent("stackable")
		inst.components.stackable.maxsize = 999

		inst:AddComponent("inspectable")
		inst:AddComponent("inventoryitem")
		
		inst:AddComponent("deployable")
		inst.components.deployable.ondeploy = ondeploywall
		inst.components.deployable.test = test_wall
		inst.components.deployable.min_spacing = 0
		if inst.dlc==2 then
			inst.components.deployable:SetQuantizeFunction(quantizeposition)
			inst.components.deployable.deploydistance = 1.5
		end
		
		
		return inst
end

local function onhit(inst)
	if inst.destroysound then
		inst.SoundEmitter:PlaySound(inst.destroysound)		
	end
	if inst.wallpercent>inst.components.workable.workleft/inst.iniworkleft then 
		inst.wallpercent=inst.components.workable.workleft/inst.iniworkleft
	end
	if inst.wallpercent<0 then 
		inst.wallpercent=0
	end
	local anim_to_play = getwallanim_dyc(inst)
	if inst.wallpercent==0 then
		inst.AnimState:PlayAnimation(anim_to_play)		
	else
		inst.AnimState:PlayAnimation(anim_to_play.."_hit")		
		inst.AnimState:PushAnimation(anim_to_play, false)
	end
	

end

local function onwork(inst,worker,workleft)
	
	local hashammer=false
	if worker.components.inventory then
		for k,v in pairs(worker.components.inventory.equipslots) do
			if v.components.tool and v.components.tool:CanDoAction(ACTIONS.HAMMER) then
				hashammer=true
				break
			end
		end
	end
	if TUNING.DYC_SUPERWALL_BOSSRES==true then
		if not hashammer then
			inst.islastworkvalid=false
			inst.components.workable.destroyed=false
			inst.components.workable.workleft=inst.workleft
		else
			inst.islastworkvalid=true
			onhit(inst)
			inst.workleft=inst.workleft-0.25*inst.iniworkleft
			inst.components.workable.workleft=inst.workleft
		end
	else
		inst.islastworkvalid=true
		onhit(inst)
		if not hashammer then
			inst.workleft=inst.components.workable.workleft
		else
			inst.workleft=inst.workleft-0.25*inst.iniworkleft
			inst.components.workable.workleft=inst.workleft
		end
	end
end

local function onattacked(inst,attacker,damage)
	onhit(inst)
	if TUNING.DYC_SUPERWALL_REBOUNDDAMAGE>0 and attacker.components.combat then
		-- print(attacker.name.."attacked"..inst.name)
		attacker.components.combat:GetAttacked(inst,TUNING.DYC_SUPERWALL_REBOUNDDAMAGE,nil)
	end

end


local function onload(inst, data)
	--print("superwall - onload")
	if inst.components.workable.workleft<0.25*inst.iniworkleft or inst.components.workable.workleft>inst.iniworkleft then
		inst.components.workable.workleft=inst.iniworkleft
	end
	inst.workleft=inst.components.workable.workleft
	inst.wallpercent=inst.components.workable.workleft/inst.iniworkleft
	inst.AnimState:PlayAnimation(getwallanim_dyc(inst))
	updatewallphysics(inst)
end

local function onremoveentity(inst)
	inst.doortask:Cancel()
	inst.doortask2:Cancel()
	clearobstacle(inst)
end


local function update_door (inst)
	local opendoor = false
	local player = inst.wallowner
	local playerpos = Vector3(player.Transform:GetWorldPosition())
	local instpos = Vector3(inst.Transform:GetWorldPosition())
	local distance = playerpos:Dist(instpos)
	-- print(distance)
	
	if distance<TUNING.DYC_SUPERWALL_DOORDETECTRANGE then
		opendoor=true
	end
	
	if  TUNING.DYC_SUPERWALL_COMPANION==true and GetWorld().dyc_superwall_companions~=nil then
		for k,v in pairs(GetWorld().dyc_superwall_companions) do
			local pos = Vector3(v.Transform:GetWorldPosition())
			local distance = pos:Dist(instpos)
			if distance<TUNING.DYC_SUPERWALL_DOORDETECTRANGE then
				opendoor=true
				break
			end
		end
	end
	
	if opendoor==true then
		inst.doorchanging=-1
	else
		inst.doorchanging=1
	end
end

local function update_door2 (inst)
	if inst.doorchanging<0 and inst.wallpercent>0 then
		inst.wallpercent = inst.wallpercent-0.25
		if inst.wallpercent<=0 then
			inst.wallpercent=0
			inst.doorstate=false
			updatewallphysics(inst)
		end
		inst.AnimState:PlayAnimation(getwallanim_dyc(inst))
	elseif inst.doorchanging>0 and inst.wallpercent<inst.components.workable.workleft/inst.iniworkleft then
		inst.wallpercent = inst.wallpercent+0.25
		if inst.wallpercent>=inst.components.workable.workleft/inst.iniworkleft then
			inst.wallpercent=inst.components.workable.workleft/inst.iniworkleft
			inst.doorstate=true
			updatewallphysics(inst)
		end
		inst.AnimState:PlayAnimation(getwallanim_dyc(inst))
	end
end

local function doorfn () 
		local inst = CreateEntity()
		local trans = inst.entity:AddTransform()
		
		inst.wallowner=GetPlayer()
		inst.doorstate=true
		inst.doorchanging=1
		inst.wallpercent=1
		inst.iniworkleft=4
		inst.workleft=inst.iniworkleft
		inst.islastworkvalid=false
		inst.dlc=0
		if IsDLCEnabled(REIGN_OF_GIANTS) then
			inst.dlc=1
		elseif SaveGameIndex:IsModeShipwrecked() then
			inst.dlc=2
		end
		
		inst.entity:AddAnimState()
		inst.entity:AddSoundEmitter()
		-- if inst.dlc==2 then
			trans:SetEightFaced()
		-- end
		--trans:SetScale(1.3,1.3,1.3)
		inst:AddTag("wall")
		inst:AddTag("floodblocker")
		MakeObstaclePhysics(inst, .5)    
		inst.entity:SetCanSleep(false)
		
		inst:AddComponent("inspectable")
		inst:AddComponent("lootdropper")
		
		inst:AddComponent("combat")
		inst.components.combat.onhitfn = onattacked
		
		inst:AddComponent("health")
		inst.components.health.ondelta = onhealthchange
		inst.components.health.nofadeout = true
		inst.components.health.canheal = false
		inst:AddTag("noauradamage")

		inst:AddComponent("workable")
		inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
		inst.components.workable:SetWorkLeft(inst.iniworkleft)
		inst.components.workable:SetOnFinishCallback(onhammered)
		inst.components.workable:SetOnWorkCallback(onwork) 	
		inst.components.workable.savestate=true
		
	    inst.OnLoad = onload
	    inst.OnRemoveEntity = onremoveentity
		
		inst.doortask = inst:DoPeriodicTask(0.25, function() update_door(inst) end)
		inst.doortask2 = inst:DoPeriodicTask(2*FRAMES, function() update_door2(inst) end)
		
		MakeSnowCovered(inst)
		
		return inst
end

local function wooddooritem () 
	local inst = dooritemfn()
	
	inst.deployprefab="dyc_door_wood"
	
	inst.AnimState:SetBank("wall")
	inst.AnimState:SetBuild("dyc_wall_wood")
	inst.AnimState:PlayAnimation("idle")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/wooddoor.xml"
	inst.components.inventoryitem.imagename = "wooddoor"
	
	inst.components.deployable.placer = "dyc_door_wood_placer"
	
	return inst
end

local function wooddoor () 
	local inst = doorfn()
	
	inst.buildsound="dontstarve/common/place_structure_wood"
	inst.destroysound="dontstarve/common/destroy_wood"
	inst.loot="log"
	
	inst.AnimState:SetBank("wall")
	inst.AnimState:SetBuild("dyc_wall_wood")
	inst.AnimState:PlayAnimation("fullA", false)
	inst.SoundEmitter:PlaySound(inst.buildsound)
	inst:AddTag("wood")
	inst.components.health:SetMaxHealth(1000)
	inst.components.health.currenthealth = 1000
    
	return inst
end

local function haydooritem () 
	local inst = dooritemfn()
	
	inst.deployprefab="dyc_door_hay"
	
	inst.AnimState:SetBank("wall")
	inst.AnimState:SetBuild("dyc_wall_hay")
	inst.AnimState:PlayAnimation("idle")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/haydoor.xml"
	inst.components.inventoryitem.imagename = "haydoor"
	
	inst.components.deployable.placer = "dyc_door_hay_placer"
	
	return inst
end

local function haydoor () 
	local inst = doorfn()
	
	inst.buildsound="dontstarve/common/place_structure_straw"
	inst.destroysound="dontstarve/common/destroy_straw"
	inst.loot="cutgrass"
	
	inst.AnimState:SetBank("wall")
	inst.AnimState:SetBuild("dyc_wall_hay")
	inst.AnimState:PlayAnimation("fullA", false)
	inst.SoundEmitter:PlaySound(inst.buildsound)
	inst:AddTag("grass")
	inst.components.health:SetMaxHealth(1000)
	inst.components.health.currenthealth = 1000
    
	return inst
end

local function stonedooritem () 
	local inst = dooritemfn()
	
	inst.deployprefab="dyc_door_stone"
	
	inst.AnimState:SetBank("wall")
	inst.AnimState:SetBuild("dyc_wall_stone")
	inst.AnimState:PlayAnimation("idle")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/stonedoor.xml"
	inst.components.inventoryitem.imagename = "stonedoor"
	
	inst.components.deployable.placer = "dyc_door_stone_placer"
	
	return inst
end

local function stonedoor () 
	local inst = doorfn()
	
	inst.buildsound="dontstarve/common/place_structure_stone"
	inst.destroysound="dontstarve/common/destroy_stone"
	inst.loot="rocks"
	
	inst.AnimState:SetBank("wall")
	inst.AnimState:SetBuild("dyc_wall_stone")
	inst.AnimState:PlayAnimation("fullA", false)
	inst.SoundEmitter:PlaySound(inst.buildsound)
	inst:AddTag("stone")
	inst.components.health:SetMaxHealth(1000)
	inst.components.health.currenthealth = 1000
    
	return inst
end

local function ruindooritem () 
	local inst = dooritemfn()
	
	inst.deployprefab="dyc_door_ruin"
	
	inst.AnimState:SetBank("wall")
	inst.AnimState:SetBuild("dyc_wall_ruins")
	inst.AnimState:PlayAnimation("idle")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/ruindoor.xml"
	inst.components.inventoryitem.imagename = "ruindoor"
	
	inst.components.deployable.placer = "dyc_door_ruin_placer"
	
	return inst
end

local function ruindoor () 
	local inst = doorfn()
	
	inst.buildsound="dontstarve/common/place_structure_stone"
	inst.destroysound="dontstarve/common/destroy_stone"
	inst.loot="thulecite_pieces"
	
	inst.AnimState:SetBank("wall")
	inst.AnimState:SetBuild("dyc_wall_ruins")
	inst.AnimState:PlayAnimation("fullA", false)
	inst.SoundEmitter:PlaySound(inst.buildsound)
	inst:AddTag("stone")
	inst:AddTag("ruins")
	inst.components.health:SetMaxHealth(1000)
	inst.components.health.currenthealth = 1000
    
	return inst
end

local function limestonedooritem () 
	local inst = dooritemfn()
	
	inst.deployprefab="dyc_door_limestone"
	
	inst.AnimState:SetBank("wall")
	inst.AnimState:SetBuild("dyc_wall_limestone")
	inst.AnimState:PlayAnimation("idle")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/limestonedoor.xml"
	inst.components.inventoryitem.imagename = "limestonedoor"
	
	inst.components.deployable.placer = "dyc_door_limestone_placer"
	
	return inst
end

local function limestonedoor () 
	local inst = doorfn()
	
	inst.buildsound="dontstarve/common/place_structure_stone"
	inst.destroysound="dontstarve/common/destroy_stone"
	inst.loot="rocks"
	
	inst.AnimState:SetBank("wall")
	inst.AnimState:SetBuild("dyc_wall_limestone")
	inst.AnimState:PlayAnimation("fullA", false)
	inst.SoundEmitter:PlaySound(inst.buildsound)
	inst:AddTag("stone")
	inst.components.health:SetMaxHealth(1000)
	inst.components.health.currenthealth = 1000
    
	return inst
end

local function moonrockdooritem () 
	local inst = dooritemfn()
	
	inst.deployprefab="dyc_door_moonrock"
	
	inst.AnimState:SetBank("wall")
	inst.AnimState:SetBuild("dyc_wall_moonrock")
	inst.AnimState:PlayAnimation("idle")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/moonrockdoor.xml"
	inst.components.inventoryitem.imagename = "moonrockdoor"
	
	inst.components.deployable.placer = "dyc_door_moonrock_placer"
	
	return inst
end

local function moonrockdoor () 
	local inst = doorfn()
	
	inst.buildsound="dontstarve/common/place_structure_stone"
	inst.destroysound="dontstarve/common/destroy_stone"
	inst.loot="rocks"
	
	inst.AnimState:SetBank("wall")
	inst.AnimState:SetBuild("dyc_wall_moonrock")
	inst.AnimState:PlayAnimation("fullA", false)
	inst.SoundEmitter:PlaySound(inst.buildsound)
	inst:AddTag("stone")
	inst:AddTag("moonrock")
	inst.components.health:SetMaxHealth(1000)
	inst.components.health.currenthealth = 1000
    
	return inst
end
-- ===============================walls=====================================================
local function woodwallitem () 
	local inst = wooddooritem()
	inst.deployprefab="dyc_wall_wood"
	inst.components.inventoryitem.atlasname = "images/inventoryimages.xml"
	inst.components.inventoryitem.imagename = "wall_wood_item"
	return inst
end

local function woodwall () 
	local inst = wooddoor()
	inst.doortask:Cancel()
	inst.doortask2:Cancel()
	return inst
end

local function haywallitem () 
	local inst = haydooritem()
	inst.deployprefab="dyc_wall_hay"
	inst.components.inventoryitem.atlasname = "images/inventoryimages.xml"
	inst.components.inventoryitem.imagename = "wall_hay_item"
	return inst
end

local function haywall () 
	local inst = haydoor()
	inst.doortask:Cancel()
	inst.doortask2:Cancel()
	return inst
end

local function stonewallitem () 
	local inst = stonedooritem()
	inst.deployprefab="dyc_wall_stone"
	inst.components.inventoryitem.atlasname = "images/inventoryimages.xml"
	inst.components.inventoryitem.imagename = "wall_stone_item"
	return inst
end

local function stonewall () 
	local inst = stonedoor()
	inst.doortask:Cancel()
	inst.doortask2:Cancel()
	return inst
end

local function ruinwallitem () 
	local inst = ruindooritem()
	inst.deployprefab="dyc_wall_ruin"
	inst.components.inventoryitem.atlasname = "images/inventoryimages.xml"
	inst.components.inventoryitem.imagename = "wall_ruins_item"
	return inst
end

local function ruinwall () 
	local inst = ruindoor()
	inst.doortask:Cancel()
	inst.doortask2:Cancel()
	return inst
end

local function limestonewallitem () 
	local inst = limestonedooritem()
	inst.deployprefab="dyc_wall_limestone"
	inst.components.inventoryitem.atlasname = "images/inventoryimages/limestonewall.xml"
	inst.components.inventoryitem.imagename = "limestonewall"
	return inst
end

local function limestonewall () 
	local inst = limestonedoor()
	inst.doortask:Cancel()
	inst.doortask2:Cancel()
	return inst
end

local function moonrockwallitem () 
	local inst = moonrockdooritem()
	inst.deployprefab="dyc_wall_moonrock"
	inst.components.inventoryitem.atlasname = "images/inventoryimages/moonrockwall.xml"
	inst.components.inventoryitem.imagename = "moonrockwall"
	return inst
end

local function moonrockwall () 
	local inst = moonrockdoor()
	inst.doortask:Cancel()
	inst.doortask2:Cancel()
	return inst
end

local function DYCMakePlacer(name, bank, build, anim, onground, snap, metersnap, scale, snap_to_flood, fixedcameraoffset, facing, hide_on_invalid)
	
	local function fn(Sim)
		local inst = CreateEntity()
		inst.entity:AddTransform()
		inst.entity:AddAnimState()
		inst.AnimState:SetBank(bank)
		inst.AnimState:SetBuild(build)
		inst.AnimState:PlayAnimation(anim, true)
        inst.AnimState:SetLightOverride(1)


        if facing == "two" then
            inst.Transform:SetTwoFaced()
        elseif facing == "four" then
            inst.Transform:SetFourFaced()
        elseif facing == "six" then
            inst.Transform:SetSixFaced()
        elseif facing == "eight" then
            inst.Transform:SetEightFaced()
        end
		
		inst:AddComponent("placer")
		inst.persists = false
		inst.components.placer.snaptogrid = snap
		inst.components.placer.snap_to_meters = metersnap
		inst.components.placer.snap_to_flood= snap_to_flood
		inst.components.placer.fixedcameraoffset = fixedcameraoffset
		inst.components.placer.hide_on_invalid = hide_on_invalid


		scale = scale or 1 
		inst.Transform:SetScale(scale, scale, scale)
		

		if onground then
			inst.AnimState:SetOrientation( ANIM_ORIENTATION.OnGround)
		end
		
		return inst
	end
	
	return Prefab(name, fn)
end

return 
Prefab( "common/dyc_wall_moonrock", moonrockwall, assets, prefabs),
Prefab( "common/dyc_wall_moonrock_item", moonrockwallitem, assets, prefabs),
Prefab( "common/dyc_wall_limestone", limestonewall, assets, prefabs),
Prefab( "common/dyc_wall_limestone_item", limestonewallitem, assets, prefabs),
Prefab( "common/dyc_wall_ruin", ruinwall, assets, prefabs),
Prefab( "common/dyc_wall_ruin_item", ruinwallitem, assets, prefabs),
Prefab( "common/dyc_wall_stone", stonewall, assets, prefabs),
Prefab( "common/dyc_wall_stone_item", stonewallitem, assets, prefabs),
Prefab( "common/dyc_wall_hay", haywall, assets, prefabs),
Prefab( "common/dyc_wall_hay_item", haywallitem, assets, prefabs),
Prefab( "common/dyc_wall_wood", woodwall, assets, prefabs),
Prefab( "common/dyc_wall_wood_item", woodwallitem, assets, prefabs),

Prefab( "common/dyc_door_moonrock", moonrockdoor, assets, prefabs),
Prefab( "common/dyc_door_moonrock_item", moonrockdooritem, assets, prefabs),
DYCMakePlacer("common/dyc_door_moonrock_placer", "wall", "dyc_wall_moonrock", "fullA", false, false, true, nil, nil, nil, "eight") ,
Prefab( "common/dyc_door_limestone", limestonedoor, assets, prefabs),
Prefab( "common/dyc_door_limestone_item", limestonedooritem, assets, prefabs),
DYCMakePlacer("common/dyc_door_limestone_placer", "wall", "dyc_wall_limestone", "fullA", false, false, true, nil, nil, nil, "eight") ,
Prefab( "common/dyc_door_ruin", ruindoor, assets, prefabs),
Prefab( "common/dyc_door_ruin_item", ruindooritem, assets, prefabs),
DYCMakePlacer("common/dyc_door_ruin_placer", "wall", "dyc_wall_ruins", "fullA", false, false, true, nil, nil, nil, "eight") ,
Prefab( "common/dyc_door_stone", stonedoor, assets, prefabs),
Prefab( "common/dyc_door_stone_item", stonedooritem, assets, prefabs),
DYCMakePlacer("common/dyc_door_stone_placer", "wall", "dyc_wall_stone", "fullA", false, false, true, nil, nil, nil, "eight") ,
Prefab( "common/dyc_door_hay", haydoor, assets, prefabs),
Prefab( "common/dyc_door_hay_item", haydooritem, assets, prefabs),
DYCMakePlacer("common/dyc_door_hay_placer", "wall", "dyc_wall_hay", "fullA", false, false, true, nil, nil, nil, "eight") ,
Prefab( "common/dyc_door_wood", wooddoor, assets, prefabs),
Prefab( "common/dyc_door_wood_item", wooddooritem, assets, prefabs),
DYCMakePlacer("common/dyc_door_wood_placer", "wall", "dyc_wall_wood", "fullA", false, false, true, nil, nil, nil, "eight") 

