
local assets=
{
    Asset("ANIM", "anim/black.zip"),
    Asset("ANIM", "anim/swap_black.zip"),
 
    Asset("ATLAS", "images/inventoryimages/black.xml"),
    Asset("IMAGE", "images/inventoryimages/black.tex"),
}

local function onattack_black(inst, attacker, target)

    if attacker and attacker.components.health then
        attacker.components.health:DoDelta(-0)
    end
	
    local atkfx = SpawnPrefab("explode_small")
    if atkfx then
	    local follower = atkfx.entity:AddFollower()
	    follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
    end
end

local function fn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
	
	inst.AnimState:SetBank("gemma")
    inst.AnimState:SetBuild("black")
    inst.AnimState:PlayAnimation("idle")
	
	if not TheWorld.ismastersim then
        return inst
    end
 
    local function OnEquip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_black", "swap_gemma")
        owner.AnimState:Show("ARM_carry")
        owner.AnimState:Hide("ARM_normal")
    end
 
    local function OnUnequip(inst, owner)
        owner.AnimState:Hide("ARM_carry")
        owner.AnimState:Show("ARM_normal")
    end
 
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.keepondeath = true
    inst.components.inventoryitem.imagename = "black"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/black.xml"
     
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
			
	inst:AddComponent("inspectable")
			
	inst:AddTag("shadow")
 	inst:AddComponent("weapon")
	inst.components.weapon:SetOnAttack(onattack_black)
    inst.components.weapon:SetDamage(350)
    inst.components.weapon:SetRange(24, 30)
	inst.components.weapon:SetProjectile("fire_projectile")

    return inst
	
end

STRINGS.NAMES.black = "Elphelt's First Love Pistol!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.black = "A dangerous weapon colored pink with cute accessories. Really?"
	
return  Prefab("common/inventory/black", fn, assets)