local TheSim = GLOBAL.TheSim
local Vector3 = GLOBAL.Vector3
local SpawnPrefab = GLOBAL.SpawnPrefab
local ProfileStatsAdd = GLOBAL.ProfileStatsAdd
local GetPlayer = GLOBAL.GetPlayer
local GetWorld = GLOBAL.GetWorld
local FRAMES = GLOBAL.FRAMES

local Fang_AUTO_FARM_HARVEST = GetModConfigData("Fang_AUTO_FARM_HARVEST") == "YES"
local Fang_AUTO_FARM_PLANT = GetModConfigData("Fang_AUTO_FARM_PLANT") == "YES"

local function CropComponentPostInit(self)	
	function self:Mature()
		if self.product_prefab and not self.matured then
			self.matured = true
			if self.onmatured then
				self.onmatured(self.inst)
			end
		
			-- MOD updated begin
			if Fang_AUTO_FARM_HARVEST then
				self:Harvest(GetPlayer()) 
			end
			-- MOD updated end
		end
	end
	function self:OnLoad(data)
		if data then
			self.product_prefab = data.prefab or self.product_prefab
			self.growthpercent = data.percent or self.growthpercent
			self.rate = data.rate or self.rate
			self.matured = data.matured or self.matured
			self.withered = data.withered or self.withered
		end
		
		if self.withered then
			self:MakeWithered()
		else
			self:DoGrow(0)
			if self.product_prefab and self.matured then
				self.inst.AnimState:PlayAnimation("grow_pst")
				if self.onmatured then
					self.onmatured(self.inst)
				end
				-- MOD updated begin
				if Fang_AUTO_FARM_HARVEST then
					self:Harvest(GetPlayer()) 
				end
				-- MOD updated end

			end
		end	
	end  		
end

AddComponentPostInit("crop", CropComponentPostInit)

local function PostFarmplotInit(inst)
	--print (inst.name.."PostFarmplotInit")
	
	local function CanPlant(item)
		if not item.components.plantable then
			return false
		end
		if not item.components.edible then
			return false
		end
		if not item.components.edible.foodtype == "SEEDS" then
			return false
		end
		return true
	end
	local function tryToPlant(inst)	
		if not Fang_AUTO_FARM_PLANT then
			--print "disable auto plant"
			return
		end
		if not inst.components.grower then
			--print "not grower"
			return
		end
		if not inst.components.grower:IsEmpty() then
			--print "has crops"
			return
		end		
		local toPlantSeed = GetPlayer().components.inventory:FindItem(function(item)
			return CanPlant(item)
		end)
		--print "have empty farmplot, trying plant"
		if toPlantSeed and inst.components.grower then
			--print (toPlantSeed.prefab)
			if inst.components.grower:PlantItem(SpawnPrefab(toPlantSeed.prefab)) then
				-- remove one item
				local num_left_to_find = 1;
				if toPlantSeed.components.stackable then
					if toPlantSeed.components.stackable.stacksize > num_left_to_find then
						toPlantSeed.components.stackable:SetStackSize(toPlantSeed.components.stackable.stacksize - num_left_to_find)
					else
						GetPlayer().components.inventory:RemoveItem(toPlantSeed, true):Remove()
					end
				else
					GetPlayer().components.inventory:RemoveItem(toPlantSeed):Remove()
				end	
			end
			

		end
	end	
	if Fang_AUTO_FARM_PLANT then
		inst:DoPeriodicTask(10, function() tryToPlant(inst) end)
	end

end
AddPrefabPostInit("slow_farmplot", PostFarmplotInit)
AddPrefabPostInit("fast_farmplot", PostFarmplotInit)

