--
GLOBAL.require "situyl_lib"

PrefabFiles = {
	"situyl",
	"situyl_zooms",
	"situyl_sword",
	"situyl_claw",
	"situyl_claw_rope",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/situyl.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/situyl.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/situyl.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/situyl.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/situyl_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/situyl_silho.xml" ),

    Asset( "IMAGE", "bigportraits/situyl.tex" ),
    Asset( "ATLAS", "bigportraits/situyl.xml" ),
	
	--Asset( "IMAGE", "images/map_icons/situyl.tex" ),
	--Asset( "ATLAS", "images/map_icons/situyl.xml" ),

}

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS
local FRAMES = GLOBAL.FRAMES
local Prefabs = GLOBAL.Prefabs
local GetPlayer = GLOBAL.GetPlayer()
local TUNING = GLOBAL.TUNING
local Recipe = GLOBAL.Recipe
local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local TECH = GLOBAL.TECH
local Remap = GLOBAL.Remap
local EQUIPSLOTS = GLOBAL.EQUIPSLOTS
local TimeEvent = GLOBAL.TimeEvent
local EventHandler = GLOBAL.EventHandler
local SpawnPrefab = GLOBAL.SpawnPrefab
local State = GLOBAL.State
local DEGREES = GLOBAL.DEGREES
local Vector3 = GLOBAL.Vector3
local ACTIONS = GLOBAL.ACTIONS
local Action = GLOBAL.Action
local ActionHandler = GLOBAL.ActionHandler
local GetTime = GLOBAL.GetTime
local TheSim = GLOBAL.TheSim
local IsDLCEnabled = GLOBAL.IsDLCEnabled
local GetSeasonManager = GLOBAL.GetSeasonManager
local GetWorld = GLOBAL.GetWorld
local CAPY_DLC = GLOBAL.CAPY_DLC
local GROUND = GLOBAL.GROUND
local ANIM_ORIENTATION = GLOBAL.ANIM_ORIENTATION
local tw_spawn = GLOBAL.tw_spawn
local tw_getforwardpos = GLOBAL.tw_getforwardpos
local ProfileStatsAdd = GLOBAL.ProfileStatsAdd

----ȡmod
local tw__ischstr = GLOBAL.tw__ischstr
TUNING.TW_ISCHSTR = GetModConfigData("Language")

local tw_isalive = GLOBAL.tw_isalive
local tw_checktag = GLOBAL.tw_checktag

-- The character select screen lines
STRINGS.CHARACTER_TITLES.situyl = tw__ischstr("˾ͽD, ", "SituDYueliang, Despicable Pirates")
STRINGS.CHARACTER_NAMES.situyl = "situyl"
STRINGS.CHARACTER_DESCRIPTIONS.situyl = tw__ischstr("*ˣ, Ͷצժǳ\n*С, ᾵һ֪\n*Īʳ, Ӫ", "*Has sword and claw hook craftrecipe\n*Can craft Zoomin/Zoomout Glass\n*Must keep balance of meat and veggie")
STRINGS.CHARACTER_QUOTES.situyl = tw__ischstr( "\", ˻ܼװ\"", "\"Dont make me angry\"")

-- Custom speech strings
STRINGS.CHARACTERS.SITUYL = require "speech_situyl"

-- Let the game know character is male, female, or robot
table.insert(GLOBAL.CHARACTER_GENDERS.MALE, "situyl")

--AddMinimapAtlas("images/map_icons/situyl.xml")
AddModCharacter("situyl")

-- Custom item name
--STRINGS.NAMES.EXAMPLEFLOATABLEITEM = "Floaty Thing"
--STRINGS.CHARACTERS.GENERIC.DESCRIBE.EXAMPLEFLOATABLEITEM = "I bet it can float."

--Ʒ
STRINGS.NAMES[string.upper("situyl_zoomin")] = tw__ischstr("Ŵ","Zoomin Glass")
STRINGS.RECIPE_DESC[string.upper("situyl_zoomin")] = tw__ischstr("Ŵ", "Magnify a creature")
STRINGS.CHARACTERS.GENERIC.DESCRIBE[string.upper("situyl_zoomin")]= tw__ischstr("ĴСƿ.", "All lives' scale are controlled by  me")

STRINGS.NAMES[string.upper("situyl_zoomout")] = tw__ischstr("С", "Zoomout Glass")
STRINGS.RECIPE_DESC[string.upper("situyl_zoomout")] = tw__ischstr("С", "Narrow a creature")
STRINGS.CHARACTERS.GENERIC.DESCRIBE[string.upper("situyl_zoomout")]= tw__ischstr("ĴСƿ.", "All lives' scale are controlled by  me")

STRINGS.NAMES[string.upper("situyl_sword")] = tw__ischstr("", "Western Sword")
STRINGS.RECIPE_DESC[string.upper("situyl_sword")] = tw__ischstr("ͨ", "Convenient sword")
STRINGS.CHARACTERS.GENERIC.DESCRIBE[string.upper("situyl_sword")]= tw__ischstr("ˣ, һʲô.", "ˣ, һʲô.")

STRINGS.NAMES[string.upper("situyl_claw")] = tw__ischstr("צ", "Claw Hook")
STRINGS.RECIPE_DESC[string.upper("situyl_claw")] = tw__ischstr("ץȡ,ʵ,͵Ϯ", "Grab, Hook, Sneak attack")
STRINGS.CHARACTERS.GENERIC.DESCRIBE[string.upper("situyl_claw")]= tw__ischstr("Ͷצժǳ, һʲô.", "Ͷצժǳ, һʲô.")

--䷽
RECIPETABS.SITUYL = {str = "SITUYL", sort = -1, icon = "situyltab.tex", icon_atlas = "images/situyltab.xml"}

local situyl_sword = Recipe( "situyl_sword", { Ingredient("goldnugget", 1), Ingredient("rocks", 2), Ingredient("flint", 2)}, RECIPETABS.SITUYL,  TECH.NONE )
situyl_sword.atlas = "images/situyl_sword.xml"

local situyl_claw = Recipe( "situyl_claw", { Ingredient("goldnugget", 2), Ingredient("rope", 2), Ingredient("silk", 4)}, RECIPETABS.SITUYL,  TECH.NONE )
situyl_claw.atlas = "images/situyl_claw.xml"

local situyl_zoomin = Recipe( "situyl_zoomin", { Ingredient("purplegem", 1), Ingredient("livinglog", 1), Ingredient("nightmarefuel", 2)}, RECIPETABS.SITUYL,  TECH.NONE )
situyl_zoomin.atlas = "images/situyl_zoomin.xml"

local situyl_zoomout = Recipe( "situyl_zoomout", { Ingredient("purplegem", 1), Ingredient("livinglog", 1), Ingredient("nightmarefuel", 2)}, RECIPETABS.SITUYL,  TECH.NONE )
situyl_zoomout.atlas = "images/situyl_zoomout.xml"

--ȼҪװȼ
ACTIONS.RUMMAGE.priority = -0.5

--UI
local veggie_meat = require("widgets/veggie_meat")
local function Addveggie_meat(self) 
	if self.owner and self.owner:HasTag("veggie_meat") then
		self.veggie_meat = self.status:AddChild(veggie_meat(self.owner))	
		--self.veggie_meat:SetPosition(-80,-40,0)
		self.veggie_meat:SetPosition(-120,-40,0)
		self.veggie_meat:SetScale(1,1,1)	
	end
end

AddClassPostConstruct("widgets/controls", Addveggie_meat)


--ƥŴСĹŴ-----------------------------
--
local tab = 
{
	[-2] = {scale = .5, dmg = .5, loot = 1},
	[-1] = {scale = .75, dmg = .75, loot = 1},
	[0] = {scale = 1, dmg = 1, loot = 1},
	[1] = {scale = 1.5, dmg = 2, loot = 2},
	[2] = {scale = 2, dmg = 3, loot = 3},
}
AddPrefabPostInitAny(function(inst)
	--if GLOBAL.GetPlayer():HasTag("situyl_zoom") then
		if inst.components.health and inst.components.combat and not inst:HasTag("player") then
		
			inst:AddComponent("situyl_zoom")
			inst.components.situyl_zoom:DoDelta(0)
			
			--
			--
			local old_CalcDamage = inst.components.combat.CalcDamage
			function inst.components.combat:CalcDamage(target, weapon, multiplier)
				local val = inst.components.situyl_zoom.current
				return tab[val]["dmg"] * old_CalcDamage(self, target, weapon, multiplier)
			end
			
			--
			local old_GetAttackRange = inst.components.combat.GetAttackRange
			function inst.components.combat:GetAttackRange()
				local val = inst.components.situyl_zoom.current
				return tab[val]["scale"] * old_GetAttackRange(self)
			end
			local old_GetHitRange = inst.components.combat.GetHitRange
			function inst.components.combat:GetHitRange()
				local val = inst.components.situyl_zoom.current
				return tab[val]["scale"] * old_GetHitRange(self)
			end
			
			--
			if inst.components.lootdropper then
				local old_DropLoot = inst.components.lootdropper.DropLoot
				function inst.components.lootdropper:DropLoot(pt, loots)
					local val = inst.components.situyl_zoom.current
					local lootmult = tab[val]["loot"]
					for k = 1, lootmult do
						old_DropLoot(self, pt, loots)
					end
				end
			end
			
		end
	--end
end)


local function mod_radius_mult(tar)
	if tar then
		if tar.components.situyl_zoom then
			return tab[tar.components.situyl_zoom.current]["scale"]
		elseif tar:HasTag("veggie_meat") then
			return Remap(tar.components.veggie_meat.current, 0, 100, .5, 1.5)
		end
	else
		return 1
	end
end

--սеİ뾶ж, ϱС
AddComponentPostInit("combat", function(cmp)
	
	function cmp:CalcHitRangeSq(target)
		target = target or self.target
		local range = self:GetHitRange() + (target.Physics and target.Physics:GetRadius() * mod_radius_mult(target) or 0)
		return range*range
	end
	
	function cmp:CanHitTarget(targ, weapon)
		local specialcase_target = false
		if targ and targ.components.burnable and (targ.components.burnable:IsSmoldering() or targ.components.burnable:IsBurning()) 
		  and self:GetWeapon() and self:GetWeapon():HasTag("extinguisher") then
			specialcase_target = true
		end
		if not specialcase_target and targ and targ.components.burnable and targ.components.burnable.canlight and not targ.components.burnable:IsBurning() and not targ:HasTag("burnt")
		  and self:GetWeapon() and self:GetWeapon():HasTag("rangedlighter") then
			specialcase_target = true
		end
		if self.inst and self.inst:IsValid() and targ and targ:IsValid() and not targ:IsInLimbo() and (specialcase_target or (targ.components.combat and targ.components.combat:CanBeAttacked(self.inst))) then
			local rangesq = self:CalcHitRangeSq(targ)
			if (specialcase_target or targ.components.combat) and self.inst:GetDistanceSqToInst(targ) <= rangesq then
				return true
			end
			if weapon and weapon.components.projectile then
				local range = weapon.components.projectile.hitdist + (targ.Physics and targ.Physics:GetRadius() * mod_radius_mult(target) or 0)
				if weapon:GetDistanceSqToInst(targ) < range*range then
					return true
				end
			end
		end
	end
	
	function cmp:CalcAttackRangeSq(target)
		target = target or self.target
		local range = self:GetAttackRange() + (target.Physics and target.Physics:GetRadius() * mod_radius_mult(target) or 0)
		return range*range
	end

	function cmp:CanAttackTarget(targ, weapon)
		if targ and targ:IsValid() and not targ:IsInLimbo() then
			local rangesq = self:CalcAttackRangeSq(targ)
			if targ.components.combat and self.inst:GetDistanceSqToInst(targ) <= rangesq then
				return true
			end
			if weapon and weapon.components.projectile then
				local range = weapon.components.projectile.hitdist + (targ.Physics and targ.Physics:GetRadius() * mod_radius_mult(target) or 0)
				if weapon:GetDistanceSqToInst(targ) < range*range then
					return true
				end
			end
		end
	end

end)

----

--󽣹״̬
local gj_t = 6
local jz_t = gj_t - 2

for k0 = 1, 2 do
	for k = 0, 4 do
		AddStategraphState("wilson"..(k0 == 1 and "" or "boating"), State{
			name = "situyl_sword_atk"..k,
			--tags = { "attack", "notalking", "abouttoattack", "busy" },
			onenter = function(inst)
				inst.AnimState:PlayAnimation("atk")
				
				if IsDLCEnabled(CAPY_DLC) then
					inst.SoundEmitter:PlaySound("dontstarve_DLC002/common/swordfish_sword")
				else
					inst.SoundEmitter:PlaySound("dontstarve/wilson/attack_weapon")
				end
				
				if k > 0 then
				
					local target_to_attack = nil
					--ѰĿ
					local atktab = {}
					local x,y,z = inst.Transform:GetWorldPosition()
					local ents = TheSim:FindEntities(x,y,z,9, nil, {"player"})
					for k, v in pairs(ents) do
						if tw_isalive(v) and not inst.components.combat:IsAlly(v) and inst.components.combat:CanHitTarget(v) then
							table.insert(atktab, v.GUID)
						end
					end
					
					--local randomGUID = #atktab > 0 and atktab[math.random(#atktab)] or nil
					
					--ӦһЩ
					if #atktab > 0 then
					
						--ѡȡ ĿĿԼ
						local atktab_targetme = {}
						for k, v in pairs(ents) do
							if table.contains(atktab, v.GUID) then
								if v.components.combat.target == inst then
									table.insert(atktab_targetme, v.GUID)
								end
							end
						end
						
						--Լѡȡڽ״̬
						if #atktab_targetme > 0 then
							
							--ѡڹ״̬
							for k, v in pairs(ents) do
								if table.contains(atktab_targetme, v.GUID) then
									if v.sg and v.sg:HasStateTag("attack") then
										target_to_attack = v.GUID
										break
									end
								end
							end
							
							--ѡһ
							if not target_to_attack then
								target_to_attack = atktab_targetme[math.random(#atktab_targetme)]
							end
						end
						
						if not target_to_attack then
							target_to_attack = atktab[math.random(#atktab)]
						end
						
						----ѡĿ
						for k, v in pairs(ents) do
							if v.GUID == target_to_attack then
								inst.components.combat.target = v
							end
						end
						
					end
					------
				end
				
				if inst.components.combat.target then
					inst.components.combat:BattleCry()
					if inst.components.combat.target and inst.components.combat.target:IsValid() then
						inst:FacePoint(Point(inst.components.combat.target.Transform:GetWorldPosition()))
					end
				end
				inst.sg.statemem.target = inst.components.combat.target
				inst.components.combat:StartAttack()
				inst.components.locomotor:Stop()
				
				tw_spawn(inst, "impact", nil, nil, 2, {tw_getforwardpos(inst, 1), 90}, nil, function(guy)
					guy.AnimState:SetOrientation( ANIM_ORIENTATION.OnGround )
				end)
				
				inst.sg:SetTimeout(gj_t*FRAMES)
			end,
			
			ontimeout = function(inst)
				inst.sg:GoToState( k > 3 and "idle" or "situyl_sword_atk"..(k+1) )
			end,
			
			timeline=
			{	
				TimeEvent(jz_t*FRAMES, function(inst)
					inst.components.combat:DoAttack(inst.sg.statemem.target)
				end), 
			},
		})
	end
end

--󽣵Ĳɼ״̬
--󽣵״̬
for k0 = 1, 2 do
	AddStategraphState("wilson"..(k0 == 1 and "" or "boating"), State{
		name = "situyl_sword_pick",
		tags = {"canrotate"},

		onenter = function(inst)
			if IsDLCEnabled(CAPY_DLC) then
				inst.SoundEmitter:PlaySound("dontstarve_DLC002/common/swordfish_sword")
			else
				inst.SoundEmitter:PlaySound("dontstarve/wilson/attack_weapon")
			end
			inst.AnimState:PlayAnimation("chop_loop") 
			inst.components.locomotor:Stop()
			
			tw_spawn(inst, "impact", nil, nil, 1.75, {tw_getforwardpos(inst, 1), 90}, nil, function(guy)
				guy.AnimState:SetOrientation( ANIM_ORIENTATION.OnGround )
			end)
			
			inst.sg:SetTimeout(5*FRAMES)
		end,

		ontimeout = function(inst)
			inst.sg:GoToState("idle") 
		end,

		timeline = 
		{
			TimeEvent(2*FRAMES, function(inst) inst:PerformBufferedAction() end),
			TimeEvent(3*FRAMES, function(inst) inst:PerformBufferedAction()
				local otherequipped = inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS)
				if otherequipped and otherequipped:HasTag("situyl_sword") then
					otherequipped.components.finiteuses:Use(.25)
				end
			end),
		},
		
	})
end

--󽣵Ľ״̬
for k0 = 1, 2 do
	AddStategraphPostInit("wilson"..(k0 == 1 and "" or "boating"), function(sg)
	
		--ȼܹ
		--[[
		local old_attack = sg.states["attack"].onenter
		sg.states["attack"].onenter = function(inst)
			local weapon = inst.components.combat:GetWeapon()
			local otherequipped = inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS)
			if (weapon and weapon:HasTag("situyl_sword")) or (otherequipped and otherequipped:HasTag("situyl_sword")) and inst:HasTag("situyl") then
				inst.sg:GoToState("situyl_sword_atk0")
				return
			end
			return old_attack(inst)
		end]]
		local old_doattack = sg.events["doattack"].fn
		sg.events["doattack"].fn = function(inst)
			local weapon = inst.components.combat:GetWeapon()
			local otherequipped = inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS)
			if (weapon and weapon:HasTag("situyl_sword")) or (otherequipped and otherequipped:HasTag("situyl_sword")) and inst:HasTag("situyl") then
				inst.sg:GoToState("situyl_sword_atk0")
			else
				return old_doattack(inst)
			end
		end
		
		--󽣲ɼactionhandler
		local old_pick = sg.actionhandlers[ACTIONS.PICK].deststate
		sg.actionhandlers[ACTIONS.PICK].deststate = function(inst, action)
			local weapon = inst.components.combat:GetWeapon()
			local otherequipped = inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS)
			
			local target = action.target
			local pref = target and target.prefab
			
			local is_situyl_sword = (weapon and weapon:HasTag("situyl_sword")) or (otherequipped and otherequipped:HasTag("situyl_sword"))
			local is_target = pref == "grass" or pref == "sapling" or pref == "reeds" or		--,֦,«έ
				pref == "flower_cave" or pref == "flower_cave_double" or pref == "flower_cave_triple"		--ֲ
				
            if action.target.components.pickable and is_situyl_sword and is_target then
                return "situyl_sword_pick"
			else
				return old_pick(inst, action)
            end
        end
		
	end)
end

--[[	˼·
--󽣵, ڿŲɼֲ
local SITUYL_SWORD_PICK 
SITUYL_SWORD_PICK = Action(0.5, false, false, 3, true)
SITUYL_SWORD_PICK.id = "SITUYL_SWORD_PICK"
SITUYL_SWORD_PICK.str = {
	SITUYL_SWORD_PICK_1 = tw__ischstr("","Cut"),
}
SITUYL_SWORD_PICK.strfn = function(act)
	local target = act.target
	if target then
		return "SITUYL_SWORD_PICK_1"
	end
end
SITUYL_SWORD_PICK.fn = function(act)
	local staff = act.invobject or act.doer.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS)
	if staff and staff:HasTag("situyl_sword") then
		if act.target.components.pickable and act.target.components.pickable.canbepicked then
			act.target.components.pickable:Pick(act.doer)
			return true
		end
	end
end

AddAction(SITUYL_SWORD_PICK)

--󽣵Ķ¼
for k0 = 1, 2 do
	AddStategraphActionHandler( "wilson"..(k0 == 1 and "" or "boating"), ActionHandler(SITUYL_SWORD_PICK, "situyl_sword_pick") )
end

]]
------------------------------------------------------------------------------------------------------

----צҼ, ɿˮץȡ

--צҼ
local SITUYL_CLAW
--if IsDLCEnabled(CAPY_DLC) then
	SITUYL_CLAW = Action(-0.5, false, true, 50, true)
--else
	--SITUYL_CLAW = Action(1, false, true, 30)
--end

SITUYL_CLAW.id = "SITUYL_CLAW"
SITUYL_CLAW.str = {
	SITUYL_CLAW_0 = tw__ischstr("ͷ","Release"),
	SITUYL_CLAW_1 = tw__ischstr("׽","Catch"),
	SITUYL_CLAW_2 = tw__ischstr("ɱ","Catch And Kill"),
	SITUYL_CLAW_3 = tw__ischstr("ק","Pull"),
	SITUYL_CLAW_4 = tw__ischstr("ץȡ","Grab"),
	SITUYL_CLAW_5 = tw__ischstr("Զ̲ɼ","Ranged Pick"),
	SITUYL_CLAW_6 = tw__ischstr("Զջ","Ranged Pick"),
	SITUYL_CLAW_7 = tw__ischstr("ס","Hook"),
	SITUYL_CLAW_8 = tw__ischstr("ס","Hook And Mount"),
}

SITUYL_CLAW.strfn = function(act)
	local claw = act.invobject or act.doer.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS)
	local target = act.target
	if target and claw then
		if not claw.components.container:IsEmpty() then
			return "SITUYL_CLAW_0"
		else
			if tw_isalive(target) and not ( target:HasTag("wall") or string.find(target.prefab, "wall") or string.find(target.prefab, "pillar") or string.find(target.prefab, "den") ) then
				--if target.prefab == "jellyfish_planted" then
				--	return "SITUYL_CLAW_0"
				if target.components.inventoryitem then
					return "SITUYL_CLAW_1"
				elseif target.components.lootdropper and target:HasTag("canbetrapped") then
					return "SITUYL_CLAW_2"
				elseif target.components.locomotor then
					return "SITUYL_CLAW_3"
				end
			
			elseif target.components.inventoryitem then
				return "SITUYL_CLAW_4"
			elseif target.components.pickable and target.components.pickable.canbepicked and target.prefab ~= "tumbleweed" then	
				return "SITUYL_CLAW_5"
			
			elseif target.components.harvest and target.components.harvest:CanBeHarvested() then
				return "SITUYL_CLAW_6"
			elseif target.components.crop and (target.components.crop.matured or target.components.crop.withered) then
				return "SITUYL_CLAW_6"
			elseif target.components.stewer and target.components.stewer.done then
				return "SITUYL_CLAW_6"
			elseif target.components.dryer and target.components.dryer:IsDone() then
				return "SITUYL_CLAW_6"
			elseif target.components.occupiable and target.components.occupiable:IsOccupied() then
				return "SITUYL_CLAW_6"
				
			elseif target.components.container and not target.components.health and string.find(target.prefab, "chest") and not target.components.drivable
				or target.prefab == "tumbleweed" 
				then
				return "SITUYL_CLAW_4"
				
			elseif target.components.drivable and target.components.drivable.driver == nil and target.components.drivable:CanDrive(owner) then
				return "SITUYL_CLAW_8"
			
			elseif target:HasTag("structure") or target:HasTag("tree") or string.find(target.prefab, "rock") or string.find(target.prefab, "reef") or target:HasTag("wall") or
					string.find(target.prefab, "wall") or string.find(target.prefab, "den") or string.find(target.prefab, "bush") or string.find(target.prefab, "pillar") or
					string.find(target.prefab, "basalt") or string.find(target.prefab, "statue") or string.find(target.prefab, "tree") or string.find(target.prefab, "barrel") or
					target.prefab == "firesuppressor" or target.prefab == "sandbag" or target.prefab == "telebase" or target.prefab == "gemsocket" or
					string.find(target.prefab, "nest")
				then
				return "SITUYL_CLAW_7"
				
			end
		end
	end
end
SITUYL_CLAW.fn = function(act)
	local staff = act.invobject or act.doer.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS)
	--local staff = act.doer.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS)
	if staff and staff.components.spellcaster_situyl_claw and staff.components.spellcaster_situyl_claw:CanCast(act.doer, act.target, act.pos) then
		staff.components.spellcaster_situyl_claw:CastSpell(act.target, act.pos)
		return true
	end
end

AddAction(SITUYL_CLAW)

--צĶ¼
for k0 = 1, 2 do
	AddStategraphActionHandler( "wilson"..(k0 == 1 and "" or "boating"), ActionHandler(SITUYL_CLAW, "situyl_claw") )
end

--צ״̬
for k0 = 1, 2 do
	AddStategraphState("wilson"..(k0 == 1 and "" or "boating"), State{
		name = "situyl_claw",
		tags = {"canrotate"},

		onenter = function(inst)
			
			if not inst:HasTag("situyl") then
				if inst.components.talker then
					local str = tw__ischstr("רĹצ, Ҳ", "I cannot use this claw")
					inst.components.talker:Say(str)
				end
				return
			end
			
			--inst.components.playercontroller:Enable(false)
			inst.AnimState:PlayAnimation("atk") 
			inst.components.locomotor:Stop()
		end,

		onexit = function(inst)
			--inst.components.playercontroller:Enable(true)
		end,

		timeline = 
		{
			TimeEvent(5*FRAMES, function(inst) inst:PerformBufferedAction() end),
		},

		events = {
			EventHandler("animover", function(inst)
				inst.sg:GoToState("idle") 
			end ),
		},
		
	})
end

--[[
--צROGļ castspellonenter
if not IsDLCEnabled(CAPY_DLC) then
	AddStategraphPostInit("wilson", function(sg)
		local old_castspell_onenter = sg.states["castspell_tornado"].onenter
		sg.states["castspell_tornado"].onenter = function(inst)
			local weapon = inst.components.combat:GetWeapon()
            local otherequipped = inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS)

            if (weapon and weapon:HasTag("situyl_claw")) or (otherequipped and otherequipped:HasTag("situyl_claw")) then
                inst.sg:GoToState("situyl_claw")
            else
				return old_castspell_onenter(inst)
			end
		end
	end)
end]]


--צĲɼ
if IsDLCEnabled(CAPY_DLC) then
	AddComponentPostInit("pickable", function(cmp)
		function cmp:Pick_situyl_claw(picker)
			if self.canbepicked and self.caninteractwith then
				if self.transplanted then
					if self.cycles_left ~= nil then
						self.cycles_left = self.cycles_left - 1
					end
				end
				if self.shouldwither then
					if self.protected_cycles ~= nil then
						self.protected_cycles = self.protected_cycles - 1
					end
				end
				local loot = nil
				if picker and picker.components.container and self.product then
					loot = SpawnPrefab(self.product)
					if loot then
						if self.numtoharvest > 1 and loot.components.stackable then
							loot.components.stackable:SetStackSize(self.numtoharvest)	            	
						end
						self.inst:ApplyInheritedMoisture(loot)
						picker:PushEvent("picksomething", {object = self.inst, loot= loot})
						picker.components.container:GiveItem(loot)
					end
				end
				if self.onpickedfn then
					self.onpickedfn(self.inst, picker, loot)
				end
				
				self.canbepicked = false
				self.hasbeenpicked = true
				
				if not self.paused and not self.withered and self.baseregentime and (self.cycles_left == nil or self.cycles_left > 0) then
					self.regentime = self.baseregentime * self:GetGrowthMod()
					self.task = self.inst:DoTaskInTime(self.regentime, OnRegen, "regen")
					self.targettime = GetTime() + self.regentime
				end
				self.inst:PushEvent("picked", {picker = picker, loot = loot, plant = self.inst})
			end
		end

	end)
else
	AddComponentPostInit("pickable", function(cmp)
		function cmp:Pick_situyl_claw(picker)
			if self.canbepicked and self.caninteractwith then
				if self.transplanted then
					if self.cycles_left ~= nil then
						self.cycles_left = self.cycles_left - 1
					end
				end

				if self.shouldwither then
					if self.protected_cycles ~= nil then
						self.protected_cycles = self.protected_cycles - 1
					end
				end
				
				local loot = nil
				if picker and picker.components.container and self.product then
					loot = SpawnPrefab(self.product)

					if loot then
						if self.numtoharvest > 1 and loot.components.stackable then
							loot.components.stackable:SetStackSize(self.numtoharvest)	            	
						end

						local targetMoisture = 0

						if self.inst.components.moisturelistener then
							targetMoisture = self.inst.components.moisturelistener:GetMoisture()
						elseif self.inst.components.moisture then
							targetMoisture = self.inst.components.moisture:GetMoisture()
						else
							targetMoisture = GetWorld().components.moisturemanager:GetWorldMoisture()
						end
						
						loot.targetMoisture = targetMoisture
						loot:DoTaskInTime(2*FRAMES, function()
							if loot.components.moisturelistener then 
								loot.components.moisturelistener.moisture = loot.targetMoisture
								loot.targetMoisture = nil
								loot.components.moisturelistener:DoUpdate()
							end
						end)

						picker:PushEvent("picksomething", {object = self.inst, loot= loot})
						picker.components.container:GiveItem(loot)
					end
				end
				
				if self.onpickedfn then
					self.onpickedfn(self.inst, picker, loot)
				end
				
				self.canbepicked = false
				self.hasbeenpicked = true
				
				if not self.paused and not self.withered and self.baseregentime and (self.cycles_left == nil or self.cycles_left > 0) then
					if GetSeasonManager():IsSpring() then self.regentime = self.baseregentime * TUNING.SPRING_GROWTH_MODIFIER end
					self.task = self.inst:DoTaskInTime(self.regentime, OnRegen, "regen")
					self.targettime = GetTime() + self.regentime
				end
				
				self.inst:PushEvent("picked", {picker = picker, loot = loot, plant = self.inst})
			end
		end
	end)

end

--[[ǰѷ ק
--ڷݵ, ΪpickableĲһ
AddPrefabPostInit("tumbleweed", function(inst)

	local function CheckGround(inst)
		if not inst:IsOnValidGround() then
			local fx = SpawnPrefab("splash_ocean")
			local pos = inst:GetPosition()
			fx.Transform:SetPosition(pos.x, pos.y, pos.z)
			-- Shut down all the possible tasks
			if inst.bouncepretask then
				inst.bouncepretask:Cancel()
				inst.bouncepretask = nil
			end
			if inst.bouncetask then
				inst.bouncetask:Cancel()
				inst.bouncetask = nil
			end
			if inst.restartmovementtask then
				inst.restartmovementtask:Cancel()
				inst.restartmovementtask = nil
			end
			if inst.bouncepst1 then
				inst.bouncepst1:Cancel()
				inst.bouncepst1 = nil
			end
			if inst.bouncepst2 then
				inst.bouncepst2:Cancel()
				inst.bouncepst2 = nil
			end
			-- And remove the tumbleweed
			inst:Remove()
		end
	end

	local function startmoving(inst)
		inst.AnimState:PushAnimation("move_loop", true)
		inst.bouncepretask = inst:DoTaskInTime(10*FRAMES, function(inst)
			inst.SoundEmitter:PlaySound("dontstarve_DLC001/common/tumbleweed_bounce")
			inst.bouncetask = inst:DoPeriodicTask(24*FRAMES, function(inst)
				inst.SoundEmitter:PlaySound("dontstarve_DLC001/common/tumbleweed_bounce")
				CheckGround(inst)
			end)
		end)
		inst.components.blowinwind:Start()
		inst:RemoveEventCallback("animover", startmoving, inst)
	end
	
	local old_onpickedfn = inst.components.pickable.onpickedfn
	inst.components.pickable.onpickedfn = function(inst, owner)
		if owner and owner.components.container and owner:HasTag("situyl_claw") then
			if inst.owner and inst.owner.components.childspawner then 
				inst:PushEvent("pickedup")
			end

			local item = nil
			for i, v in ipairs(inst.loot) do
				item = SpawnPrefab(v)
				item.Transform:SetPosition(inst.Transform:GetWorldPosition())
				if item.components.inventoryitem and item.components.inventoryitem.ondropfn then
					item.components.inventoryitem.ondropfn(item)
				end
				if inst.lootaggro[i] and item.components.combat and GetPlayer() then
					if not (GetPlayer():HasTag("spiderwhisperer") and item:HasTag("spider")) and not (GetPlayer():HasTag("monster") and item:HasTag("spider")) then
						item.components.combat:SuggestTarget(GetPlayer())
					end
				end
			end
			inst:RemoveEventCallback("animover", startmoving, inst)
			inst.AnimState:PlayAnimation("break")
			inst.DynamicShadow:Enable(false)
			inst:ListenForEvent("animover", function(inst) inst:Remove() end)
			return true
		else
			return old_onpickedfn(inst, owner)
		end
	end
end)]]
-------------------------------------------------------------------------------------

--צջ harvest
if IsDLCEnabled(CAPY_DLC) then
	AddComponentPostInit("harvestable", function(cmp)
		function cmp:Harvest_situyl_claw(picker)
			if self:CanBeHarvested() then
				local produce = self.produce
				self.produce = 0
				
				if self.onharvestfn then
					self.onharvestfn(self.inst, picker, produce)
				end
				
				if picker.components.container and self.product then
					picker:PushEvent("harvestsomething", {object = self.inst})
					for i = 1, produce, 1 do
						local loot = SpawnPrefab(self.product)
						if loot then
							self.inst:ApplyInheritedMoisture(loot)
							picker.components.container:GiveItem(loot)
						end
					end
				end
				self:StartGrowing()
				return true
			end
		end
	end)
else
	AddComponentPostInit("harvestable", function(cmp)
		function cmp:Harvest_situyl_claw(picker)
			if self:CanBeHarvested() then
				local produce = self.produce
				self.produce = 0
				
				if self.onharvestfn then
					self.onharvestfn(self.inst, picker, produce)
				end
				
				if picker.components.container and self.product then
					picker:PushEvent("harvestsomething", {object = self.inst})
					for i = 1, produce, 1 do
						local loot = SpawnPrefab(self.product)
						if loot then
							local targetMoisture = 0

							if self.inst.components.moisturelistener then
								targetMoisture = self.inst.components.moisturelistener:GetMoisture()
							elseif self.inst.components.moisture then
								targetMoisture = self.inst.components.moisture:GetMoisture()
							else
								targetMoisture = GetWorld().components.moisturemanager:GetWorldMoisture()
							end
							
							loot.targetMoisture = targetMoisture
							loot:DoTaskInTime(2*FRAMES, function()
								if loot.components.moisturelistener then 
									loot.components.moisturelistener.moisture = loot.targetMoisture
									loot.targetMoisture = nil
									loot.components.moisturelistener:DoUpdate()
								end
							end)
							picker.components.container:GiveItem(loot)
						end
					end
				end
				self:StartGrowing()
				return true
			end
		end
	end)
end

--צջ crop
if IsDLCEnabled(CAPY_DLC) then
	AddComponentPostInit("crop", function(cmp)
		function cmp:Harvest_situyl_claw(harvester)
			if self.matured or self.withered then
				local product = nil
				if self.grower and self.grower:HasTag("fire") or self.inst:HasTag("fire") then
					local temp = SpawnPrefab(self.product_prefab)
					if temp.components.cookable and temp.components.cookable.product then
						product = SpawnPrefab(temp.components.cookable.product)
					else
						product = SpawnPrefab("seeds_cooked")
					end
					temp:Remove()
				else
					product = SpawnPrefab(self.product_prefab)
				end

				if product then
					self.inst:ApplyInheritedMoisture(product)
				end
				harvester.components.container:GiveItem(product)
				ProfileStatsAdd("grown_"..product.prefab) 
				
				self.matured = false
				self.withered = false
				self.inst:RemoveTag("withered")
				self.growthpercent = 0
				self.product_prefab = nil

				if self.grower then
					self.grower.components.grower:RemoveCrop(self.inst)
					self.grower = nil
				end
				
				return true
			end
		end
	end)
else
	AddComponentPostInit("crop", function(cmp)
		function cmp:Harvest_situyl_claw(harvester)
			if self.matured or self.withered then
				local product = nil
				if self.grower and self.grower:HasTag("fire") or self.inst:HasTag("fire") then
					local temp = SpawnPrefab(self.product_prefab)
					if temp.components.cookable and temp.components.cookable.product then
						product = SpawnPrefab(temp.components.cookable.product)
					else
						product = SpawnPrefab("seeds_cooked")
					end
					temp:Remove()
				else
					product = SpawnPrefab(self.product_prefab)
				end

				if product then
					local targetMoisture = 0

					if self.inst.components.moisturelistener then
						targetMoisture = self.inst.components.moisturelistener:GetMoisture()
					elseif self.inst.components.moisture then
						targetMoisture = self.inst.components.moisture:GetMoisture()
					else
						targetMoisture = GetWorld().components.moisturemanager:GetWorldMoisture()
					end
					
					product.targetMoisture = targetMoisture
					product:DoTaskInTime(2*FRAMES, function()
						if product.components.moisturelistener then 
							product.components.moisturelistener.moisture = product.targetMoisture
							product.targetMoisture = nil
							product.components.moisturelistener:DoUpdate()
						end
					end)
				end
				harvester.components.container:GiveItem(product)
				ProfileStatsAdd("grown_"..product.prefab) 
				
				self.matured = false
				self.withered = false
				self.inst:RemoveTag("withered")
				self.growthpercent = 0
				self.product_prefab = nil
				
				if self.grower then
					self.grower.components.grower:RemoveCrop(self.inst)
					self.grower = nil
				end
				
				return true
			end
		end
	end)
end

--צջ stewer
if IsDLCEnabled(CAPY_DLC) then
	AddComponentPostInit("stewer", function(cmp)
		function cmp:Harvest_situyl_claw( harvester )
			if self.done then
				if self.onharvest then
					self.onharvest(self.inst)
				end
				self.done = nil
				if self.product then
					if harvester and harvester.components.container then
						local loot = nil
						if self.product ~= "spoiledfood" then
							loot = SpawnPrefab(self.product)

							if loot and loot.components.perishable then
								loot.components.perishable:SetPercent( self.product_spoilage)
								loot.components.perishable:LongUpdate(GetTime() - self.targettime)
								loot.components.perishable:StartPerishing()
							end
						else
							loot = SpawnPrefab("spoiled_food")
						end
						
						if loot then                    
							loot.targetMoisture = 0
							loot:DoTaskInTime(2*FRAMES, function()
								if loot.components.moisturelistener then 
									loot.components.moisturelistener.moisture = loot.targetMoisture
									loot.targetMoisture = nil
									loot.components.moisturelistener:DoUpdate()
								end
							end)
							harvester.components.container:GiveItem(loot)
						end
					end
					self.product = nil
					self.spoiltargettime = nil

					if self.spoiltask then 
						self.spoiltask:Cancel()
						self.spoiltask = nil
					end
				end
				
				if self.inst.components.container and not self.inst:HasTag("flooded") then		
					self.inst.components.container.canbeopened = true
				end
				
				return true
			end
		end
	end)
else
	AddComponentPostInit("stewer", function(cmp)
		function cmp:Harvest_situyl_claw( harvester )
			if self.done then
				if self.onharvest then
					self.onharvest(self.inst)
				end
				self.done = nil
				if self.product then
					if harvester and harvester.components.container then
						local loot = nil
						if self.product ~= "spoiledfood" then
							loot = SpawnPrefab(self.product)

							if loot.components.perishable then
								if self.spoiltargettime ~= nil then
									local spoilpercent = 1-(GetTime()-self.targettime)/(self.spoiltargettime-self.targettime)
									loot.components.perishable:SetPercent(self.product_spoilage * spoilpercent)
								end
								loot.components.perishable:StartPerishing()
							end
						else
							loot = SpawnPrefab("spoiled_food")
						end
						
						if loot then                    
							loot.targetMoisture = 0
							loot:DoTaskInTime(2*FRAMES, function()
								if loot.components.moisturelistener then 
									loot.components.moisturelistener.moisture = loot.targetMoisture
									loot.targetMoisture = nil
									loot.components.moisturelistener:DoUpdate()
								end
							end)
							harvester.components.container:GiveItem(loot)
						end
					end
					self.product = nil
					self.spoiltargettime = nil
					
					if self.spoiltask then 
						self.spoiltask:Cancel()
						self.spoiltask = nil
					end
				end
				
				if self.inst.components.container then		
					self.inst.components.container.canbeopened = true
				end
				
				return true
			end
		end
	end)
end

--צջ dryer
if IsDLCEnabled(CAPY_DLC) then
	AddComponentPostInit("dryer", function(cmp)
		function cmp:Harvest_situyl_claw( harvester )
			if self:IsDone() then
				if self.onharvest then
					self.onharvest(self.inst)
				end
				if self.product then
					if harvester and harvester.components.container then
						local loot = SpawnPrefab(self.product)
						if loot then
							if loot and loot.components.perishable then
								loot.components.perishable:SetPercent(1)
								if self.targettime then loot.components.perishable:LongUpdate(GetTime() - self.targettime) end
								loot.components.perishable:StartPerishing()
								if self.spoiltask then
									self.spoiltask:Cancel()
									self.spoiltask = nil
									self.spoiltargettime = nil
								end
							end

							self.inst:ApplyInheritedMoisture(loot)
							harvester.components.container:GiveItem(loot)
						end
					end
					self.product = nil
				end
				
				return true
			end
		end
	end)
else
	AddComponentPostInit("dryer", function(cmp)
		function cmp:Harvest_situyl_claw( harvester )
			if self:IsDone() then
				if self.onharvest then
					self.onharvest(self.inst)
				end
				if self.product then
					if harvester and harvester.components.container then
						local loot = SpawnPrefab(self.product)
						if loot then
							if loot and loot.components.perishable then
								local spoilpercent = 1-((GetTime()-self.targettime)/(self.spoiltargettime-self.targettime))
								loot.components.perishable:SetPercent(spoilpercent)
								loot.components.perishable:StartPerishing()
							end

							local targetMoisture = 0

							if self.inst.components.moisturelistener then
								targetMoisture = self.inst.components.moisturelistener:GetMoisture()
							elseif self.inst.components.moisture then
								targetMoisture = self.inst.components.moisture:GetMoisture()
							else
								targetMoisture = GetWorld().components.moisturemanager:GetWorldMoisture()
							end
							
							loot.targetMoisture = targetMoisture
							loot:DoTaskInTime(2*FRAMES, function()
								if loot.components.moisturelistener then 
									loot.components.moisturelistener.moisture = loot.targetMoisture
									loot.targetMoisture = nil
									loot.components.moisturelistener:DoUpdate()
								end
							end)
							harvester.components.container:GiveItem(loot)
						end
					end
					
					self.spoiltargettime = nil
					if self.spoiltask then
						self.spoiltask:Cancel()
						self.spoiltask = nil
					end
					
					self.product = nil
				end
				
				return true
			end
		end
	end)
end

--צջoccupiable, صռ , һ, ˲Ҫôд
--[[
if IsDLCEnabled(CAPY_DLC) then
	AddComponentPostInit("occupiable", function(cmp)
		function cmp:Harvest_situyl_claw()
			if self.occupant and self.occupant.components.inventoryitem then
				local occupant = self.occupant
				self.inst:RemoveEventCallback("perished", occupant.occupiableonperish, occupant)
				self.occupant = nil
				self.inst:RemoveChild(occupant)
				if self.onemptied then
					self.onemptied(self.inst)
				end
				occupant:ReturnToScene()
				return occupant
			end
		end
	end)
else
	AddComponentPostInit("occupiable", function(cmp)
		function cmp:Harvest_situyl_claw()
		
		end
	end)
end]]

--齨ĵ麯
AddComponentPostInit("container", function(cmp)
	function cmp:DropItem_situyl_claw(itemtodrop, wholestack)
		local item = self:RemoveItem(itemtodrop, wholestack)
		if item then 
			local pos = Vector3(self.inst.Transform:GetWorldPosition())
			item.Transform:SetPosition(pos:Get())
			if item.components.inventoryitem then
				item.components.inventoryitem:OnDropped(true)
			end
			self.inst:PushEvent("dropitem", {item = item})                  
		end
	end

end)

--޸
AddPrefabPostInit("tumbleweed", function(inst)

	local function CancelRunningTasks(inst)
		if inst.bouncepretask then
		   inst.bouncepretask:Cancel()
			inst.bouncepretask = nil
		end
		if inst.bouncetask then
			inst.bouncetask:Cancel()
			inst.bouncetask = nil
		end
		if inst.restartmovementtask then
			inst.restartmovementtask:Cancel()
			inst.restartmovementtask = nil
		end
		if inst.bouncepst1 then
		   inst.bouncepst1:Cancel()
			inst.bouncepst1 = nil
		end
		if inst.bouncepst2 then
			inst.bouncepst2:Cancel()
			inst.bouncepst2 = nil
		end
	end

	local function CheckGround(inst)
		if not inst:IsOnValidGround() then
			local fx = SpawnPrefab("splash_ocean")
			local pos = inst:GetPosition()
			fx.Transform:SetPosition(pos.x, pos.y, pos.z)
			-- Shut down all the possible tasks
			CancelRunningTasks(inst)
			-- And remove the tumbleweed
			inst:Remove()
		end
	end

	local function startmoving(inst)
		inst.AnimState:PushAnimation("move_loop", true)
		inst.bouncepretask = inst:DoTaskInTime(10*FRAMES, function(inst)
			inst.SoundEmitter:PlaySound("dontstarve_DLC001/common/tumbleweed_bounce")
			inst.bouncetask = inst:DoPeriodicTask(24*FRAMES, function(inst)
				inst.SoundEmitter:PlaySound("dontstarve_DLC001/common/tumbleweed_bounce")
				CheckGround(inst)
			end)
		end)
		inst.components.blowinwind:Start()
		inst:RemoveEventCallback("animover", startmoving, inst)
	end

	local function onpickup_tumbleweed(inst, owner)
		if inst == nil then
			return false
		else
			if owner and owner.components.inventory then
				if inst.owner and inst.owner.components.childspawner then 
					inst:PushEvent("pickedup")
				end

				--if inst and inst.Transform then
					local item = nil
					for i, v in ipairs(inst.loot) do
						item = SpawnPrefab(v)
						local x,y,z = inst.Transform:GetWorldPosition()
						if x and y and z then
							item.Transform:SetPosition(x,y,z)
							if item.components.inventoryitem and item.components.inventoryitem.ondropfn then
								item.components.inventoryitem.ondropfn(item)
							end
							if inst.lootaggro[i] and item.components.combat and GetPlayer() then
								if not (GetPlayer():HasTag("spiderwhisperer") and item:HasTag("spider")) and not (GetPlayer():HasTag("monster") and item:HasTag("spider")) then
									item.components.combat:SuggestTarget(GetPlayer())
								end
							end
						else
							item:Remove()
						end
					end
				--end
				
			end
			inst:RemoveEventCallback("animover", startmoving, inst)
			inst.AnimState:PlayAnimation("break")
			inst.DynamicShadow:Enable(false)
			inst:ListenForEvent("animover", function(inst) inst:Remove() end)
			return true --This makes the inventoryitem component not actually give the tumbleweed to the player
		end
	end
	
	inst.components.pickable.onpickedfn = onpickup_tumbleweed
end)

--޸ˮĸСbug
--[[
AddPrefabPostInit("jellyfish", function(inst)
	inst.components.inventoryitem:SetOnDroppedFn(nil)
	inst:ListenForEvent("ondropped", function(inst)
		local ground = GetWorld()
		local tile = GROUND.GRASS
		tile = inst:GetCurrentTileType()

		local onWater = ground.Map:IsWater(tile)

		if onWater then
		 
			local replacement = SpawnPrefab("jellyfish_planted")
			replacement.Transform:SetPosition(inst.Transform:GetWorldPosition())

			inst:Remove()
		else
			local replacement = SpawnPrefab("jellyfish_dead")
			replacement.Transform:SetPosition(inst.Transform:GetWorldPosition())
			replacement.AnimState:PlayAnimation("death_ground", true)
			replacement:DoTaskInTime(2.5, playDeadAnimation)
			replacement.shocktask = replacement:DoPeriodicTask(math.random() * 10 + 5, playshockanim)
			replacement:AddTag("stinger")
			inst:Remove()
		end
	end)
end)]]






