--
local tab = 
{
	[-2] = {scale = .5, dmg = .5, loot = 1},
	[-1] = {scale = .75, dmg = .75, loot = 1},
	[0] = {scale = 1, dmg = 1, loot = 1},
	[1] = {scale = 1.5, dmg = 2, loot = 2},
	[2] = {scale = 2, dmg = 3, loot = 3},
}

--
local situyl_zoom = Class(function(self, inst)
	self.inst = inst
	self.current = 0
	self.max = 2
	self.min = -2
	
	self.tab = tab
	
	self.origin_scale = nil
	self.origin_numRings = nil
	self.origin_damageRings = nil
	self.origin_maxhealth = nil
	
	--self.origin_damage = nil
	--self.origin_attackrange = nil
	--self.origin_hitrange = nil
end)

function situyl_zoom:Apply(delta)
	self:DoDelta(delta)
end

function situyl_zoom:DoDelta(delta)
	local val = self.current + delta
	if val >= self.max then
		self.current = self.max
	elseif val <= self.min then
		self.current = self.min
	else
		self.current = val
	end
	
	--self.inst:PushEvent("situyl_zoom_delta", {val = val})
	
	self.inst:DoTaskInTime(0, function()
		--ȡʼscale
		if self.origin_scale == nil then
			self.origin_scale = self.inst.Transform:GetScale()
		end
		--ıС
		local s = self.origin_scale * tab[self.current]["scale"]
		self.inst.Transform:SetScale(s, s, s)
		
		--[[
		--ı乥
		if self.origin_damage == nil then
			self.origin_damage = self.inst.components.combat.defaultdamage
		end
		self.inst.components.combat.defaultdamage = self.origin_damage * tab[self.current]["dmg"]
		
		--ı乥
		if self.origin_attackrange == nil then
			self.origin_attackrange = self.inst.components.combat.attackrange
		end
		self.inst.components.combat.attackrange = self.origin_attackrange * tab[self.current]["scale"]
		
		if self.origin_hitrange == nil then
			self.origin_hitrange = self.inst.components.combat.hitrange
		end
		self.inst.components.combat.hitrange = self.origin_hitrange * tab[self.current]["scale"]
		]]
		
		--ı
		if self.inst.components.groundpounder then
			if self.origin_numRings == nil then
				self.origin_numRings =  self.inst.components.groundpounder.numRings 
			end
			self.inst.components.groundpounder.numRings = math.ceil(self.origin_numRings * tab[self.current]["scale"])
			
			if self.origin_damageRings == nil then
				self.origin_damageRings = self.inst.components.groundpounder.damageRings 
			end
			self.inst.components.groundpounder.damageRings = math.ceil(self.origin_damageRings * tab[self.current]["scale"])
		end
		
		--ȡԭʼѪ
		if self.origin_maxhealth == nil then
			self.origin_maxhealth = self.inst.components.health.maxhealth
		end
		--ȡٷֱ
		local healthpercent = self.inst.components.health:GetPercent()
		--Ѫ
		self.inst.components.health.maxhealth = self.origin_maxhealth * tab[self.current]["dmg"]
		--õǰѪ
		self.inst.components.health:SetPercent(healthpercent)
		
		--[[
		--
		self.inst:ListenForEvent("death", function(inst, data)
			local lootnum = tab[self.current]["loot"]
			for k = 1, lootnum do
				if self.inst.components.lootdropper then
					self.inst.components.lootdropper:DropLoot(Vector3(self.inst.Transform:GetWorldPosition()))  
				end
			end
		end)]]
		
	end)
	
end

--浵
function situyl_zoom:OnSave()
	return 
	{
		current = self.current,
		max = self.max,
		min = self.min,
		
		origin_scale = self.origin_scale,
		origin_numRings = self.origin_numRings,
		origin_damageRings = self.origin_damageRings,
		origin_maxhealth = self.origin_maxhealth,
		
		--origin_damage = self.origin_damage,
		--origin_attackrange = self.origin_attackrange,
		--origin_hitrange = self.origin_hitrange,
	}
end
function situyl_zoom:OnLoad(data)
	if data then
		self.current = data.current
		self.max = data.max
		self.min = data.min
		
		self.origin_scale = data.origin_scale
		self.origin_numRings = data.origin_numRings
		self.origin_damageRings = data.origin_damageRings
		self.origin_maxhealth = data.origin_maxhealth
		
		--self.origin_damage = data.origin_damage
		--self.origin_attackrange = data.origin_attackrange
		--self.origin_hitrange = data.origin_hitrange
	end
end

return situyl_zoom