local spellcaster_situyl_claw_rog = Class(function(self, inst)
	self.inst = inst
	self.spell = nil
	self.spelltest = nil
	self.onspellcast = nil
	self.canusefrominventory = true
	self.canuseontargets = false
	self.canuseonpoint = false
end)

function spellcaster_situyl_claw_rog:SetSpellFn(fn)
	self.spell = fn
end

function spellcaster_situyl_claw_rog:SetSpellTestFn(fn)
	self.spelltest = fn
end

function spellcaster_situyl_claw_rog:SetOnSpellCastFn(fn)
	self.onspellcast = fn
end

function spellcaster_situyl_claw_rog:CastSpell(target, pos)
	if self.spell then
		self.spell(self.inst, target, pos)

		if self.onspellcast then
			self.onspellcast(self.inst, target, pos)
		end
	end
end

function spellcaster_situyl_claw_rog:CanCast(doer, target, pos)
	if self.spelltest then
		return self.spelltest(self.inst, doer, target, pos) and self.spell ~= nil
	end

	return self.spell ~= nil

end

function spellcaster_situyl_claw_rog:CollectInventoryActions(doer, actions)
	if self:CanCast(doer) and self.canusefrominventory then
		table.insert(actions, ACTIONS.SITUYL_CLAW)
	end
end

function spellcaster_situyl_claw_rog:CollectEquippedActions(doer, target, actions, right)
	if right and self:CanCast(doer, target) and self.canuseontargets then
		table.insert(actions, ACTIONS.SITUYL_CLAW)
	end
end

function spellcaster_situyl_claw_rog:CollectPointActions(doer, pos, actions, right)
    if right and self:CanCast(doer, nil, pos) and self.canuseonpoint then
		table.insert(actions, ACTIONS.SITUYL_CLAW)
	end
end

return spellcaster_situyl_claw_rog