
--
local veggie_meat = Class(function(self, inst)
	self.inst = inst
	self.current = 50
	self.max = 100
end)

function veggie_meat:DoDelta(delta)
	local oldval = self.current
	local val = self.current + delta
	if val >= self.max then
		self.current = self.max
	elseif val <= 0 then
		self.current = 0
	else
		self.current = val
	end
	local del = self.current - oldval
	self.inst:PushEvent("veggie_meat_delta", {val = self.current, oldval = oldval, delta = del})
end

--浵
function veggie_meat:OnSave()
	return 
	{
		current = self.current,
		max = self.max,
	}
end
function veggie_meat:OnLoad(data)
	if data then
		self.current = data.current
		self.max = data.max
	end
end

return veggie_meat