
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/situyl.zip" ),
		
		--Ӫֵ
		Asset( "ANIM", "anim/veggie_meat.zip" ),
		--
		Asset( "ATLAS", "images/situyltab.xml" ),
}
local prefabs = {
	
}

-- Custom starting items
local start_inv = {
	"situyl_sword", "situyl_claw", --"situyl_zoomin", "situyl_zoomout", 
}

local fn = function(inst)
	
	-- choose which sounds this character will play
	inst.soundsname = "maxwell"
	
	inst:AddTag("situyl")
	inst:AddTag("veggie_meat")

	-- Minimap icon
	--inst.MiniMapEntity:SetIcon( "situyl.tex" )
	inst.MiniMapEntity:SetIcon( "wilson.png" )
	
	-- Stats	
	inst.components.health:SetMaxHealth(88)
	inst.components.hunger:SetMax(88)
	inst.components.sanity:SetMax(88)
	
	-- Damage multiplier (optional)
    inst.components.combat.damagemultiplier = 1
	--inst.components.combat:AddDamageModifier("situyl", 0)
	
	-- Hunger rate (optional)
	inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
	
	-- Movement speed (optional)
	inst.components.locomotor.walkspeed = 4
	inst.components.locomotor.runspeed = 6
	
	inst.components.sanity.night_drain_mult = 1
    inst.components.sanity.neg_aura_mult = 1
	
	----Ӫֵ
	inst:AddComponent("veggie_meat")
	inst:DoTaskInTime(0, function() inst.components.veggie_meat:DoDelta(0) end)
	inst:ListenForEvent("oneat", function(inst,data)
		local food = data.food
		if food and food.components.edible then
			local delta = 0
			local hg = food.components.edible:GetHunger(inst)
			if hg > 0 then
				delta = hg / 20
				if food.components.edible.foodtype == "MEAT" then
					inst.components.veggie_meat:DoDelta( delta )
				else	--if food.components.edible.foodtype == "VEGGIE" then
					inst.components.veggie_meat:DoDelta( -delta )
				end
			end
		end
	end)
	
	--ʳ
	local old_CanEat = inst.components.eater.CanEat
	function inst.components.eater:CanEat(food)
		local foodtype = food.components.edible and food.components.edible.foodtype
		if foodtype == nil then return false end
		
		if food.prefab == "monstermeat" or food.prefab == "cookedmonstermeat" or food.prefab == "monstermeat_dried" or food.prefab == "monsterlasagna" then
			inst:DoTaskInTime(0, function() inst.components.talker:Say( tw__ischstr("ҲԹ", "I cannot eat monstermeat") ) end)
			return false
		elseif foodtype == "MEAT" and inst.components.veggie_meat.current >= 100 then
			inst:DoTaskInTime(0, function() inst.components.talker:Say( tw__ischstr("Ե̫, ٳ", "I cannot eat meat now") ) end)
			return false
		elseif foodtype ~= "MEAT" and inst.components.veggie_meat.current <= 0 then
			inst:DoTaskInTime(0, function() inst.components.talker:Say( tw__ischstr("ʳ, ֻܳ", "I cannot eat veggie now") ) end)
			return false
		else
			return old_CanEat(self, food)
		end
	end
	
	--άزӰٶȺͻ,Ϊڲ
	inst:ListenForEvent("veggie_meat_delta", function(inst,data)
		local oldval = data.oldval
		local val = data.val
		
		--͵ı仯
		local xz = Remap(val, 0, 100, .5, 1.5)
		--print(tostring(xz))
		--inst.AnimState:SetScale(xz,1,xz)
		
		local mass = Remap(val, 0, 100, 1, 149)
		--print(tostring(mass))
		inst.Physics:SetMass(mass)
		
		--
		local delta = data.delta
		if delta < 0 then
			if oldval >= 20 and val < 20 then
				inst.components.talker:Say("Ѿݳһ")
			elseif oldval >= 40 and val < 40 then 
				inst.components.talker:Say("ҿʼо·Ϳ")
			elseif oldval >= 60 and val < 60 then
				inst.components.talker:Say("ˬӢ˻ָ")
			elseif oldval >= 80 and val < 80 then
				inst.components.talker:Say("һ")
			end
		elseif delta > 0 then
			if oldval < 80 and val >= 80 then
				inst.components.talker:Say("Ѿܽʵ")
			elseif oldval < 60 and val >= 60 then 
				inst.components.talker:Say("ҿʼ")
			elseif oldval < 40 and val >= 40 then
				inst.components.talker:Say("ˬӢ˻ָ")
			elseif oldval < 20 and val >= 20 then
				inst.components.talker:Say("һ")
			end
		end
		
		--ͺ͹ԼƶٶȵӰ
		local damagemod = Remap(val, 0, 100, -.5, .5)
		if IsDLCEnabled(CAPY_DLC) then
			inst.components.combat:AddDamageModifier("situyl", damagemod)
		else
			inst.components.combat.damagemultiplier = 1 + damagemod
		end
		
		local speedmult = Remap(val, 0, 100, 1.5, .5)
		inst.components.locomotor.walkspeed = 4 * speedmult
		inst.components.locomotor.runspeed = 6 * speedmult
		
		if val > 50 then
			----ٶ
			--local speedmult = Remap(val, 100, 50, .5, 1)
			--print(tostring(speedmult))
			--inst.components.locomotor.walkspeed = 4 * speedmult
			--inst.components.locomotor.runspeed = 6 * speedmult
			
			--if IsDLCEnabled(CAPY_DLC) then
			--	inst.components.combat:AddDamageModifier("situyl", 0)
			--else
			--	inst.components.combat.damagemultiplier = 1
			--end
			
			----½
			local sanitymult = Remap(val, 100, 50, 2, 1)
			--print(tostring(sanitymult))
			inst.components.sanity.night_drain_mult = sanitymult
			inst.components.sanity.neg_aura_mult = sanitymult
			
			inst.components.combat:SetRange(2)
			
			----ٶ
			local hunger_rate = Remap(val, 50, 100, 0, 1)
			if IsDLCEnabled(CAPY_DLC) then
				inst.components.hunger:AddBurnRateModifier("situyl", hunger_rate)
			else
				inst.components.hunger:SetRate( (hunger_rate+1) * TUNING.WILSON_HUNGER_RATE)
			end
			
		else
			--inst.components.locomotor.walkspeed = 4
			--inst.components.locomotor.runspeed = 6
			
			----ⲻ
			--local damagemod = Remap(val, 0, 50, -.5, 0)
			--print(tostring(damagemod))
			--if IsDLCEnabled(CAPY_DLC) then
			--	inst.components.combat:AddDamageModifier("situyl", damagemod)
			--else
			--	inst.components.combat.damagemultiplier = 1 + damagemod
			--end
			
			inst.components.sanity.night_drain_mult = 1
			inst.components.sanity.neg_aura_mult = 1
			
			----˹Ͷ
			local range = Remap(val, 0, 50, .6, 2)
			inst.components.combat:SetRange(range)
			
			if IsDLCEnabled(CAPY_DLC) then
				inst.components.hunger:AddBurnRateModifier("situyl", 0)
			else
				inst.components.hunger:SetRate(1 * TUNING.WILSON_HUNGER_RATE)
			end
		end
		
	end)
	
	----ĺһҪдλ,ᷢɱbug
	--Ȳͻܵ౶˺
	local old_getattacked = inst.components.combat.GetAttacked
	function inst.components.combat:GetAttacked(attacker, damage, weapon, stimuli)
		local dmg = damage
		local val = inst.components.veggie_meat.current
		if val < 50 then
			local mult = Remap(val, 0, 50, 2, 1)
			--print(tostring(mult))
			dmg = dmg * mult
		end
		return old_getattacked(self, attacker, dmg, weapon, stimuli)
	end
	
	--Զκλ
	inst.components.catcher.catchdistance = 4
	function inst.components.catcher:ReadyToCatch()
		return true
	end
	
	--[[
	inst:ListenForEvent("death", function(inst, data)
		----ʧ
		if inst.situyl_claw_rope then
			inst.situyl_claw_rope:Remove()
			inst.situyl_claw_rope = nil
		end
	end)]]
	
	--Լȵı仯仯
	--local old_Physics_GetRadius = inst.Physics.GetRadius
	--[[ Physicsһuserdata value
	function inst.Physics:GetRadius()
		local xz = Remap(val, 0, 100, .5, 1.5)
		return xz * .5
	end]]
	
end

return MakePlayerCharacter("situyl", prefabs, assets, fn, start_inv)
