local assets =
{
	Asset("ANIM", "anim/situyl_claw_rope.zip"),
}

local function create_arm()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	
    inst.AnimState:SetBank("situyl_claw_rope")
    inst.AnimState:SetBuild("situyl_claw_rope")
	inst.AnimState:SetOrientation( ANIM_ORIENTATION.OnGround )
	--inst.AnimState:SetLayer( LAYER_BACKGROUND )
	--inst.AnimState:SetSortOrder( 3 )
	
    --inst.AnimState:PlayAnimation("idle", true)
	--inst.AnimState:Hide("rope-0")
	
	----Ӹ߶
	inst.offset_y = 1
	inst.offset_y2 = 1
	
	inst.persists = false
    
    inst:AddComponent("stretcher")
    inst.components.stretcher:SetRestingLength(4.35)
    inst.components.stretcher:SetWidthRatio(0)
	
	function inst.components.stretcher:OnUpdate(dt)
		--[[
		if self.inst.parent == GetPlayer() and tw_isalive(GetPlayer()) then
			self:SetStretchTarget(nil)
			self.inst:Remove()
			return
		end]]
	
		if not self.target then
			self:SetStretchTarget(nil)
			return
		end
		
		local targetpos = Vector3(self.target.Transform:GetWorldPosition() ) + Vector3(0, inst.offset_y2 or 0, 0)
		local mypos = Vector3(self.inst.Transform:GetWorldPosition() )
		local diff = targetpos - mypos
		
		self.inst:FacePoint(targetpos)
		local scale = diff:Length() / self.restinglength
		local widthscale = 1 + self.widthratio*(scale-1)
		self.inst.AnimState:SetScale(scale, widthscale)
	end

    return inst
end

return Prefab("common/situyl_claw_rope", create_arm, assets) 