local basic_assets =
{
	Asset("ANIM", "anim/situyl_sword.zip"),
	Asset("ANIM", "anim/situyl_sword_swap.zip"),
	Asset("ATLAS", "images/situyl_sword.xml"),
	
	--Ч
	--Asset("SOUNDPACKAGE", "sound/situyl_zoom.fev"),
    --Asset("SOUND", "sound/situyl_zoom.fsb"),
}

local function onfinished(inst)
	inst:Remove()
end

local function onequip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_object", "situyl_sword_swap", "situyl_sword_swap")
	owner.AnimState:Show("ARM_carry")
	owner.AnimState:Hide("ARM_normal")
	
	--[[
	inst.freezefn = function(attacked, data)
        tw_spawn(owner, "impact", nil, nil, 2, {tw_getforwardpos(owner, 1), 90}, nil, function(guy)
			guy.AnimState:SetOrientation( ANIM_ORIENTATION.OnGround )
		end)
    end

    inst:ListenForEvent("onattackother", inst.freezefn, owner)]]
end

local function onunequip(inst, owner)
	owner.AnimState:Hide("ARM_carry")
	owner.AnimState:Show("ARM_normal")
	
	--inst:RemoveEventCallback("onattackother", inst.freezefn, owner)
end

local function basicattack(inst, attacker, target)
	tw_spawn(target, "impact", nil, nil and target.components.combat.hiteffectsymbol, 2.5, {inst:GetPosition()})
	--tw_spawn(attacker, "impact", nil, nil, 2, {tw_getforwardpos(attacker, 1), 0}, nil, function(guy)
	--	guy.AnimState:SetOrientation( ANIM_ORIENTATION.OnGround )
	--end)
end

local function commonfn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()

	MakeInventoryPhysics(inst)
	--MakeInventoryFloatable(inst, "idle_water", "idle")

	inst:AddTag("sharp")

	inst:AddComponent("weapon")
	inst.components.weapon:SetDamage(25)
	inst.components.weapon:SetRange(1)
	--inst:AddComponent("tradable")

	-------
	--inst:AddComponent("tool")
	--inst.components.tool:SetAction(ACTIONS.SITUYL_SWORD_PICK)

	inst:AddComponent("finiteuses")
	inst.components.finiteuses:SetMaxUses(200)
	inst.components.finiteuses:SetUses(200)
	--inst.components.finiteuses:SetConsumption(ACTIONS.SITUYL_SWORD_PICK, .5)
	inst.components.finiteuses:SetOnFinished( onfinished )

	inst:AddComponent("inspectable")

	inst:AddComponent("equippable")
	inst.components.equippable:SetOnEquip( onequip )
	inst.components.equippable:SetOnUnequip( onunequip )
	
	--Ҽʩ
	--inst:AddComponent("spellcaster")
    --inst.components.spellcaster.canuseontargets = true
    --inst.components.spellcaster.canusefrominventory = false
    --inst.components.spellcaster:SetSpellTestFn(cantornado)
    --inst.components.spellcaster:SetSpellFn(spawntornado)
    --inst.components.spellcaster.castingstate = "castspell_tornado"
    --inst.components.spellcaster.actiontype = "SCIENCE"

	return inst
end

--
local function basicfn(Sim)
	local inst = commonfn(Sim)
	
	inst:AddTag("situyl_sword")

	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/situyl_sword.xml"
	inst.components.inventoryitem.imagename = "situyl_sword"

	inst.AnimState:SetBuild("situyl_sword")
	inst.AnimState:SetBank("situyl_sword")
	inst.AnimState:PlayAnimation("idle")
	--inst:AddTag("spear")
	if IsDLCEnabled(CAPY_DLC) then
		inst:AddComponent("floatable")
		inst.components.floatable.landanim = "idle" 
		inst.components.floatable.wateranim = "idle" 
	end
	
	inst.components.weapon:SetOnAttack(basicattack)
	--inst.components.spellcaster:SetSpellTestFn(cantornado)
    --inst.components.spellcaster:SetSpellFn(spawntornado)
	--inst.speartype = "spear"
	

	return inst
end

return Prefab( "common/inventory/situyl_sword", basicfn, basic_assets)

